/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.layer.symbol.species;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesSymbolImpl;

public class LayerTextSymbol
extends LayerSpeciesSymbolImpl
implements SBSymbol,
LayerSpeciesSymbol {
    public static final String CODENAME = "LAYER_TEXT";
    Rectangle2D.Double inner;
    Rectangle2D.Double a;
    Rectangle2D.Double af;
    Rectangle2D.Double rect = null;
    Point2D.Double[] points = new Point2D.Double[8];
    private PaintScheme painter = null;
    private int target_x;
    private int target_y;
    private boolean isExistTarget;
    private Color fontColor;
    public static final Color LayerTextDefaultColor = new Color(0, 0, 0, 255);
    int[] x = new int[3];
    int[] y = new int[3];

    @Override
    public void setTargetPosition(int x, int y) {
        this.target_x = x;
        this.target_y = y;
    }

    @Override
    public boolean isExistTarget() {
        return this.isExistTarget;
    }

    @Override
    public void setIsExistTarget(boolean b) {
        this.isExistTarget = b;
    }

    public LayerTextSymbol() {
        this.inner = new Rectangle2D.Double();
        this.a = new Rectangle2D.Double();
        this.af = new Rectangle2D.Double();
        this.rect = new Rectangle2D.Double();
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Point2D.Double();
            ++i;
        }
        this.fontColor = LayerTextDefaultColor;
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public int pointsSize() {
        return this.points.length;
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        return this.points;
    }

    private void calcPoints() {
        double cx = this.rect.x + this.rect.width / 2.0;
        double cy = this.rect.y + this.rect.height / 2.0;
        this.points[0].x = this.rect.x;
        this.points[0].y = this.rect.y;
        this.points[1].x = cx;
        this.points[1].y = this.rect.y;
        this.points[2].x = this.rect.x + this.rect.width;
        this.points[2].y = this.rect.y;
        this.points[3].x = this.rect.x + this.rect.width;
        this.points[3].y = cy;
        this.points[4].x = this.rect.x + this.rect.width;
        this.points[4].y = this.rect.y + this.rect.height;
        this.points[5].x = cx;
        this.points[5].y = this.rect.y + this.rect.height;
        this.points[6].x = this.rect.x;
        this.points[6].y = this.rect.y + this.rect.height;
        this.points[7].x = this.rect.x;
        this.points[7].y = cy;
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(70, 25);
    }

    @Override
    public boolean inShape(double x, double y, boolean isActive) {
        if (isActive) {
            return this.a.contains(x, y);
        }
        return this.inner.contains(x, y);
    }

    @Override
    public boolean inInner(double x, double y) {
        return this.inner.contains(x, y);
    }

    @Override
    public void setSymbolBounds(double x, double y, double w, double h) {
        this.inner.setFrame(x, y, w, h);
        this.a.setFrame(x - 0.0, y - 0.0, w + 0.0, h + 0.0);
        this.af.setFrame(x - 0.0, y - 0.0, w + 0.0, h + 0.0);
        this.rect.setFrame(x, y, w, h);
        this.calcPoints();
    }

    @Override
    public Rectangle2D.Double getSymbolBounds() {
        return new Rectangle2D.Double(this.inner.getX(), this.inner.getY(), this.inner.getWidth(), this.inner.getHeight());
    }

    @Override
    public Rectangle2D.Double getSymbolBounds2() {
        int param;
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        int i = 0;
        while (i < this.x.length) {
            param = this.x[i];
            if (minX == 0.0 && i == 0) {
                minX = param;
            } else if (minX > (double)param) {
                minX = param;
            }
            if (maxX < (double)param) {
                maxX = param;
            }
            ++i;
        }
        i = 0;
        while (i < this.y.length) {
            param = this.y[i];
            if (minY == 0.0 && i == 0) {
                minY = param;
            } else if (minY > (double)param) {
                minY = param;
            }
            if (maxY < (double)param) {
                maxY = param;
            }
            ++i;
        }
        Rectangle2D.Double temp = new Rectangle2D.Double(minX, minY, maxX, maxY);
        if (minX > (double)this.target_x) {
            minX = this.target_x;
        }
        if (minY > (double)this.target_y) {
            minY = this.target_y;
        }
        if (maxX < (double)this.target_x) {
            maxX = this.target_x;
        }
        if (maxY < (double)this.target_y) {
            maxY = this.target_y;
        }
        temp = GUtil.union(new Rectangle2D.Double(minX, minY, maxX, maxY), temp);
        return GUtil.union(new Rectangle2D.Double(this.inner.getX(), this.inner.getY(), this.inner.getWidth(), this.inner.getHeight()), temp);
    }

    @Override
    public Rectangle2D.Double getActiveSymbolBounds() {
        return new Rectangle2D.Double(this.a.getX(), this.a.getY(), this.a.getWidth(), this.a.getHeight());
    }

    @Override
    public void drawActiveEdge(Graphics2D g2) {
        g2.draw(this.a);
    }

    @Override
    public void fillActiveEdge(Graphics2D g2) {
        Composite c = g2.getComposite();
        AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
        g2.setComposite(ac);
        g2.fill(this.af);
        if (this.isExistTarget) {
            this.x[2] = this.target_x;
            this.y[2] = this.target_y;
            if ((int)this.points[0].y > this.target_y) {
                this.x[0] = (int)this.points[0].x;
                this.y[0] = (int)this.points[0].y;
                this.x[1] = (int)this.points[2].x;
                this.y[1] = (int)this.points[0].y;
            } else if ((int)this.points[0].y <= this.target_y && (int)this.points[0].x <= this.target_x && (int)this.points[4].y >= this.target_y) {
                this.x[0] = (int)this.points[2].x;
                this.y[0] = (int)this.points[0].y;
                this.x[1] = (int)this.points[2].x;
                this.y[1] = (int)this.points[4].y;
            } else if ((int)this.points[4].y < this.target_y) {
                this.x[0] = (int)this.points[0].x;
                this.y[0] = (int)this.points[4].y;
                this.x[1] = (int)this.points[2].x;
                this.y[1] = (int)this.points[4].y;
            } else {
                this.x[0] = (int)this.points[0].x;
                this.y[0] = (int)this.points[0].y;
                this.x[1] = (int)this.points[0].x;
                this.y[1] = (int)this.points[4].y;
            }
            g2.setColor(Color.white);
            g2.fillPolygon(this.x, this.y, 3);
            g2.setColor(Color.BLACK);
            g2.drawPolygon(this.x, this.y, 3);
        }
        g2.setComposite(c);
    }

    @Override
    public void drawInner(Graphics2D g2, int colorflg) {
        this.painter.fillPaint(g2, this.inner, colorflg);
        this.painter.drawDefaultColorEdge(g2, this.inner, colorflg);
        if (Preference.isDebug) {
            Rectangle2D.Double r = new Rectangle2D.Double();
            int i = 0;
            while (i < this.points.length) {
                r.setFrame(this.points[i].x - 1.0, this.points[i].y - 1.0, 2.0, 2.0);
                g2.fill(r);
                ++i;
            }
        }
    }

    @Override
    public void setPaintScheme(PaintScheme painter) {
        this.painter = painter;
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    @Override
    public Color getFontColor() {
        return this.fontColor;
    }

    @Override
    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    @Override
    public Point2D.Double getTargetPoint() {
        return new Point2D.Double(this.target_x, this.target_y);
    }
}

