/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.layer.symbol.species;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.ShapeUtil;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesSymbol;

public abstract class LayerSpeciesSymbolImpl
implements LayerSpeciesSymbol {
    protected static final double sin_225 = Math.sin(0.39269908169872414);
    protected static final double sin_45 = Math.sin(0.7853981633974483);
    protected static final double sin_675 = Math.sin(1.1780972450961724);

    public static Point2D.Double getCoordinatesOfLinkPositionByInternalIndex(Rectangle2D.Double r, int index) {
        double x = r.x;
        double y = r.y;
        double w = r.width;
        double h = r.height;
        Point2D.Double p = new Point2D.Double();
        switch (index) {
            case 0: {
                p.x = x;
                p.y = y;
                break;
            }
            case 1: {
                p.x = x + w / 4.0;
                p.y = y;
                break;
            }
            case 2: {
                p.x = x + w / 2.0;
                p.y = y;
                break;
            }
            case 3: {
                p.x = x + w * 3.0 / 4.0;
                p.y = y;
                break;
            }
            case 4: {
                p.x = x + w;
                p.y = y;
                break;
            }
            case 5: {
                p.x = x + w;
                p.y = y + h / 4.0;
                break;
            }
            case 6: {
                p.x = x + w;
                p.y = y + h / 2.0;
                break;
            }
            case 7: {
                p.x = x + w;
                p.y = y + 3.0 * h / 4.0;
                break;
            }
            case 8: {
                p.x = x + w;
                p.y = y + h;
                break;
            }
            case 9: {
                p.x = x + w * 3.0 / 4.0;
                p.y = y + h;
                break;
            }
            case 10: {
                p.x = x + w / 2.0;
                p.y = y + h;
                break;
            }
            case 11: {
                p.x = x + w / 4.0;
                p.y = y + h;
                break;
            }
            case 12: {
                p.x = x;
                p.y = y + h;
                break;
            }
            case 13: {
                p.x = x;
                p.y = y + 3.0 * h / 4.0;
                break;
            }
            case 14: {
                p.x = x;
                p.y = y + h / 2.0;
                break;
            }
            case 15: {
                p.x = x;
                p.y = y + h / 4.0;
            }
        }
        return p;
    }

    public Point2D.Double getCoordinatesOfLinkPositionByInternalIndex(int index) {
        return LayerSpeciesSymbolImpl.getCoordinatesOfLinkPositionByInternalIndex(this.getSymbolBounds(), index);
    }

    public static Point2D.Double[] setupLinkAnchorCoordStatic(Rectangle2D.Double r) {
        Point2D.Double[] array = new Point2D.Double[16];
        int i = 0;
        while (i < array.length) {
            array[i] = LayerSpeciesSymbolImpl.getCoordinatesOfLinkPositionByInternalIndex(r, i);
            ++i;
        }
        return array;
    }

    public static void drawLinkAnchorsStatic(Graphics2D g2, GLinkPositionInfo lpi, Point2D.Double[] anchorCoords, boolean drawOnlyActive) {
        int activeLinkAnchor = lpi == null ? 16 : lpi.getPosition();
        int index = ShapeUtil.translateGLinkPositionToIndex(activeLinkAnchor);
        ShapeUtil.drawLinkAnchorsWithIndexStatic(g2, index, anchorCoords, drawOnlyActive);
    }

    @Override
    public void drawLinkAnchors(Graphics2D g2, GLinkPositionInfo lpi, boolean drawOnlyActive) {
        Point2D.Double[] array = this.setupLinkAnchorCoord();
        LayerSpeciesSymbolImpl.drawLinkAnchorsStatic(g2, lpi, array, drawOnlyActive);
    }

    @Override
    public Point2D.Double[] setupLinkAnchorCoord() {
        Point2D.Double[] array = new Point2D.Double[16];
        int i = 0;
        while (i < array.length) {
            array[i] = this.getCoordinatesOfLinkPositionByInternalIndex(i);
            ++i;
        }
        return array;
    }

    @Override
    public final Point2D.Double getCoordinatesOfLinkPosition(GLinkPositionInfo lpi) {
        int ii = lpi.getPosition();
        if (ii != 16) {
            int index = ShapeUtil.translateGLinkPositionToIndex(ii);
            return this.getCoordinatesOfLinkPositionByInternalIndex(index);
        }
        throw new UnsupportedOperationException();
    }

    protected Point2D.Double meanPoint(Point2D.Double p1, Point2D.Double p2, double ratio) {
        double x = p1.x * ratio + p2.x * (1.0 - ratio);
        double y = p1.y * ratio + p2.y * (1.0 - ratio);
        return new Point2D.Double(x, y);
    }
}

