/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.layer.symbol.species;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.fric.graphics.draw.GBasicAtom;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GLinkedCurveAndLine;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.ClosedCompartmentAlias;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.OpenedCompartmentAlias;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesShape;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.layer.swing.LayerTextPopupMenu;
import jp.sbi.celldesigner.layer.symbol.species.LayerMonoSpeciesShape;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesShape;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesSymbol;
import jp.sbi.celldesigner.symbol.reaction.AddProduct;
import jp.sbi.celldesigner.symbol.reaction.AddReactant;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.celldesigner.symbol.reaction.StateTransition;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayerSpeciesAlias
extends GBasicAtom {
    private String sid = "tagId" + System.currentTimeMillis();
    private Object targetAlias = null;
    private String text = "";
    private int belong_layer_id = -1;
    private static final String SPECIES = "species";
    private static final String COMPARTMENT = "compartment";
    private static final String REACTION = "reaction";

    public String getSid() {
        return this.sid;
    }

    public void setSid(String id) {
        this.sid = id;
    }

    public int getBelong_layer_id() {
        return this.belong_layer_id;
    }

    public void setBelong_layer_id(int belong_layer_id) {
        this.belong_layer_id = belong_layer_id;
    }

    public Point2D.Double getDefaultSize() {
        LayerSpeciesSymbol symbol;
        GFramedShape shape = super.getGFramedShape();
        if (shape instanceof LayerMonoSpeciesShape && (symbol = ((LayerMonoSpeciesShape)shape).getSpeciesSymbol()) != null) {
            String code = ((SBSymbol)((Object)symbol)).getCode();
            Dimension d = (Dimension)Preference.defaultSpeciesSize.get(code);
            if (d == null) {
                d = symbol.defaultSize();
            }
            return new Point2D.Double(d.width, d.height);
        }
        return new Point2D.Double();
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        Rectangle2D.Double r = super.getRepaintBounds();
        LayerSpeciesShape shape = (LayerSpeciesShape)((Object)super.getGFramedShape());
        if (shape == null) {
            return r;
        }
        return GUtil.union(r, shape.getRepaintBounds());
    }

    @Override
    public Rectangle2D.Double getBoundsAsTarget() {
        Rectangle2D.Double r = this.getBounds();
        SpeciesShape shape = (SpeciesShape)((Object)super.getGFramedShape());
        if (shape instanceof LayerMonoSpeciesShape) {
            int linewidth = 2 + (int)((LayerMonoSpeciesShape)((Object)shape)).getLineWidth();
            r.x -= (double)(linewidth /= 2);
            r.y -= (double)linewidth;
            r.width += (double)(2 * linewidth);
            r.height += (double)(2 * linewidth);
        }
        return r;
    }

    @Override
    public Rectangle2D update() {
        ComplexSpeciesAlias parent;
        if (this.currentView == 1 && (parent = (ComplexSpeciesAlias)this.getContainer()) != null) {
            SpeciesSymbol pSymbol = ((MonoSpeciesShape)parent.getGFramedShape()).getSpeciesSymbol();
            Rectangle2D.Double psBounds = pSymbol.getSymbolBounds();
            this.setFramePosition(psBounds.x, psBounds.y);
            this.setFrameSize(psBounds.width, psBounds.height);
        }
        return super.update();
    }

    @Override
    public boolean popupAvailable() {
        return true;
    }

    @Override
    public void showPopup(MouseEvent e, double x, double y, GStructure structure) {
        LayerTextPopupMenu popup = LayerTextPopupMenu.getInstance();
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        ((LayerMonoSpeciesShape)this.framedShape).setNameImage(text);
    }

    public Object getTargetAlias() {
        return this.targetAlias;
    }

    public void setTargetAlias(Object targetAlias) {
        this.targetAlias = targetAlias;
    }

    public Rectangle2D updateLink() {
        double x = 0.0;
        double y = 0.0;
        double width = 0.0;
        double height = 0.0;
        if (this.targetAlias instanceof SpeciesAlias) {
            SpeciesAlias alias = (SpeciesAlias)this.targetAlias;
            MonoSpeciesShape mono = (MonoSpeciesShape)alias.getGFramedShape();
            x = mono.getFrameBounds().x;
            y = mono.getFrameBounds().y;
            width = mono.getFrameBounds().width;
            height = mono.getFrameBounds().height;
            ((LayerMonoSpeciesShape)this.framedShape).setTargetPosition((int)x + (int)(width / 2.0), (int)y + (int)(height / 2.0));
        } else if (this.targetAlias instanceof CompartmentAlias) {
            CompartmentAlias alias = (CompartmentAlias)this.targetAlias;
            if (alias instanceof ClosedCompartmentAlias) {
                ClosedCompartmentAlias cAlias = (ClosedCompartmentAlias)alias;
                x = cAlias.getFrameBounds().x;
                y = cAlias.getFrameBounds().y;
                width = cAlias.getFrameBounds().width;
                height = cAlias.getFrameBounds().height;
                ((LayerMonoSpeciesShape)this.framedShape).setTargetPosition((int)x + (int)(width / 2.0), (int)y + (int)(height / 2.0));
            } else if (alias instanceof OpenedCompartmentAlias) {
                OpenedCompartmentAlias cAlias = (OpenedCompartmentAlias)alias;
                x = cAlias.getBounds().x;
                y = cAlias.getBounds().y;
                width = cAlias.getBounds().width;
                height = cAlias.getBounds().height;
                ((LayerMonoSpeciesShape)this.framedShape).setTargetPosition((int)x + 20, (int)y + 20);
            }
        } else if (this.targetAlias instanceof ReactionLink) {
            ReactionLink link = (ReactionLink)this.targetAlias;
            Point2D.Double target = link.getTargetPoint();
            if (target != null) {
                ((LayerMonoSpeciesShape)this.framedShape).setTargetPosition((int)target.getX(), (int)target.getY());
            } else {
                GLinkedShape linkShape = ((ReactionLink)this.targetAlias).getGLinkedShape();
                Point2D.Double point = null;
                try {
                    if (linkShape instanceof GLinkedLine) {
                        if (linkShape instanceof StateTransition) {
                            StateTransition shape = (StateTransition)linkShape;
                            point = (Point2D.Double)shape.getLines()[shape.getOmittedShapeIndex()].targetPoint().clone();
                        } else if (linkShape instanceof AddReactant || linkShape instanceof AddProduct) {
                            point = ((GLinkedCurveAndLine)linkShape).getLinkPoint();
                        } else {
                            GLinkedLine shape = (GLinkedLine)linkShape;
                            point = (Point2D.Double)shape.targetPoint().clone();
                        }
                    } else if (linkShape instanceof GLinkedLineComplex3) {
                        GLinkedLineComplex3 shape = (GLinkedLineComplex3)linkShape;
                        point = (Point2D.Double)shape.getMidPoint().clone();
                    } else if (linkShape instanceof GLogicGate) {
                        GLogicGate shape = (GLogicGate)linkShape;
                        point = (Point2D.Double)shape.getHeaderPoint().getPosition().clone();
                    }
                }
                catch (Exception e) {
                    point = new Point2D.Double(x + width / 2.0, y + height / 2.0 + 10.0);
                }
                ((LayerMonoSpeciesShape)this.framedShape).setTargetPosition((int)point.x, (int)point.y);
            }
        }
        return ((LayerMonoSpeciesShape)this.framedShape).getSpeciesSymbol().getSymbolBounds2();
    }

    public String getTargetAliasType() {
        if (this.targetAlias instanceof SpeciesAlias) {
            return SPECIES;
        }
        if (this.targetAlias instanceof CompartmentAlias) {
            return COMPARTMENT;
        }
        if (this.targetAlias instanceof ReactionLink) {
            return REACTION;
        }
        return "";
    }

    public String getTargetAliasId() {
        if (this.targetAlias instanceof SpeciesAlias) {
            SpeciesAlias alias = (SpeciesAlias)this.targetAlias;
            return alias.getName();
        }
        if (this.targetAlias instanceof CompartmentAlias) {
            CompartmentAlias alias = (CompartmentAlias)this.targetAlias;
            if (alias instanceof ClosedCompartmentAlias) {
                ClosedCompartmentAlias cAlias = (ClosedCompartmentAlias)alias;
                return cAlias.getName();
            }
            if (alias instanceof OpenedCompartmentAlias) {
                OpenedCompartmentAlias cAlias = (OpenedCompartmentAlias)alias;
                return cAlias.getName();
            }
        } else if (this.targetAlias instanceof ReactionLink) {
            ReactionLink link = (ReactionLink)this.targetAlias;
            return link.getParentReaction().getId();
        }
        return "";
    }

    public Point2D.Double getTargetPoint() {
        return ((LayerMonoSpeciesShape)this.framedShape).getTargetPoint();
    }

    public String toSBML() {
        StringBuffer buf = new StringBuffer();
        Point2D.Double targetPoint = this.getTargetPoint();
        buf.append("<celldesigner:layerSpeciesAlias targetType=\"" + this.getTargetAliasType() + "\" targetId=\"" + this.getTargetAliasId() + "\" x=\"" + targetPoint.x + "\" y=\"" + targetPoint.y + "\">\n");
        buf.append("<celldesigner:layerNotes>\n");
        buf.append(String.valueOf(StringTool.toEscape(this.text)) + "\n");
        buf.append("</celldesigner:layerNotes>\n");
        Rectangle2D.Double bounds = ((LayerSpeciesShape)((Object)this.getGFramedShape())).getFrameBounds();
        buf.append("<celldesigner:bounds x=\"" + bounds.x + "\" y=\"" + bounds.y + "\" w=\"" + bounds.width + "\" h=\"" + bounds.height + "\"/>\n");
        LayerSpeciesSymbol symbol = ((LayerMonoSpeciesShape)this.getGFramedShape()).getSpeciesSymbol();
        buf.append("<celldesigner:paint color=\"" + Integer.toHexString(symbol.getFontColor().getRGB()) + "\"/>\n");
        buf.append("<celldesigner:font size=\"" + ((LayerMonoSpeciesShape)this.getGFramedShape()).getLayerTextFontSize() + "\"/>\n");
        buf.append("</celldesigner:layerSpeciesAlias>\n");
        return buf.toString();
    }

    public void readDOMTree(Element element, GStructure gStructure) {
        Point2D.Double targetPoint;
        block40: {
            String targetType;
            if (element == null) {
                return;
            }
            if (!element.hasChildNodes()) {
                return;
            }
            targetPoint = null;
            String targetX = element.getAttributeNS(null, "x");
            String targetY = element.getAttributeNS(null, "y");
            if (!"".equals(targetX) && !"".equals(targetY) && targetX != null && targetY != null) {
                try {
                    targetPoint = new Point2D.Double(Double.parseDouble(targetX), Double.parseDouble(targetY));
                }
                catch (Exception e) {
                    targetPoint = null;
                }
            }
            if (!(targetType = element.getAttributeNS(null, "targetType")).equals("")) {
                GElement gelement;
                String targetId = element.getAttributeNS(null, "targetId");
                if (targetType.equals(SPECIES)) {
                    Vector listOfComolex;
                    Vector listOfAtoms = new Vector();
                    Vector listOfAtoms1 = gStructure.getAtoms();
                    if (listOfAtoms1 != null && listOfAtoms1.size() > 0) {
                        listOfAtoms.addAll(listOfAtoms1);
                    }
                    if ((listOfComolex = gStructure.getContainableAtoms()) != null && listOfComolex.size() > 0) {
                        listOfAtoms.addAll(listOfComolex);
                    }
                    int i = 0;
                    while (i < listOfAtoms.size()) {
                        GElement gelement2 = (GElement)listOfAtoms.get(i);
                        if (gelement2.getName().equals(targetId)) {
                            this.targetAlias = gelement2;
                            break;
                        }
                        ++i;
                    }
                } else if (targetType.equals(COMPARTMENT)) {
                    Vector listOfContainers = gStructure.getContainers();
                    int i = 0;
                    while (i < listOfContainers.size()) {
                        gelement = (GElement)listOfContainers.get(i);
                        if (gelement.getName().equals(targetId)) {
                            this.targetAlias = gelement;
                            break;
                        }
                        ++i;
                    }
                } else if (targetType.equals(REACTION)) {
                    Vector listOfLinks = gStructure.getLinks();
                    int i = 0;
                    while (i < listOfLinks.size()) {
                        gelement = (ReactionLink)listOfLinks.get(i);
                        if (((ReactionLink)gelement).getParentReaction().getId().equals(targetId)) {
                            if (targetPoint == null) {
                                this.targetAlias = gelement;
                                break;
                            }
                            this.targetAlias = gelement;
                            int j = 0;
                            while (j < listOfLinks.size()) {
                                block41: {
                                    ReactionLink link = (ReactionLink)listOfLinks.elementAt(j);
                                    if (link.getGLinkedShape() instanceof AddProduct && link.inShape(targetPoint.x, targetPoint.y) && ((GLinkedLine)link.getGLinkedShape()).getStartTarget() == gelement) {
                                        this.targetAlias = link;
                                        break block40;
                                    }
                                    try {
                                        ReactionLink baseBaseLink;
                                        if (!(link.getTargetAt(1) instanceof ReactionLink)) break block41;
                                        ReactionLink baseLink = (ReactionLink)link.getTargetAt(1);
                                        if (baseLink.isBaseLink()) {
                                            if (baseLink != gelement) break block41;
                                            if (baseLink.isBaseLinkGate() && baseLink.inShape(targetPoint.x, targetPoint.y)) {
                                                this.targetAlias = baseLink;
                                                break block40;
                                            }
                                            if (!link.inShape(targetPoint.x, targetPoint.y)) break block41;
                                            this.targetAlias = link;
                                            break block40;
                                        }
                                        if (baseLink.getGLinkedShape() instanceof GLogicGate && (baseBaseLink = (ReactionLink)((GLogicGate)baseLink.getGLinkedShape()).getRealLine().getEndTarget()) == gelement && link.inShape(targetPoint.x, targetPoint.y)) {
                                            this.targetAlias = link;
                                        }
                                    }
                                    catch (Exception e) {}
                                    break block40;
                                }
                                ++j;
                            }
                            break;
                        }
                        ++i;
                    }
                }
            } else {
                targetPoint = null;
            }
        }
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        Node boundsNode = null;
        Node colorNode = null;
        Node notesNode = null;
        Node fontNode = null;
        int i = 0;
        while (i < childsize) {
            Node node = childlist.item(i);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                String localName = node.getLocalName();
                if (localName.equals("bounds")) {
                    boundsNode = node;
                } else if (localName.equals("paint")) {
                    colorNode = node;
                } else if (localName.equals("layerNotes")) {
                    notesNode = node;
                } else if (localName.equals("font")) {
                    fontNode = node;
                }
            }
            ++i;
        }
        Rectangle2D.Double readBounds = this.readBoundsDOMTree((Element)boundsNode);
        Color color = this.readColorDOMTree((Element)colorNode);
        LayerMonoSpeciesShape mono = new LayerMonoSpeciesShape("LAYER_TEXT");
        this.setGFramedShape(mono);
        LayerSpeciesSymbol symbol = mono.getSpeciesSymbol();
        symbol.setFontColor(color);
        mono.setColor(color);
        mono.setLayerTextFontSize(this.readFontDOMTree((Element)fontNode));
        this.setFrameSize(readBounds.width, readBounds.height);
        this.setFramePosition(readBounds.x, readBounds.y);
        if (notesNode != null) {
            String text = ((NodeImpl)notesNode).getTextContent();
            text = text.substring(1, text.length() - 1);
            this.setText(text);
        }
        mono.updateShape(readBounds.x, readBounds.y, readBounds.width, readBounds.height);
        if (targetPoint == null) {
            this.updateLink();
        } else {
            ((LayerMonoSpeciesShape)this.framedShape).setTargetPosition((int)targetPoint.x, (int)targetPoint.y);
        }
    }

    private Rectangle2D.Double readBoundsDOMTree(Element boundElement) {
        String str_x = boundElement.getAttributeNS(null, "x");
        String str_y = boundElement.getAttributeNS(null, "y");
        String str_w = boundElement.getAttributeNS(null, "w");
        String str_h = boundElement.getAttributeNS(null, "h");
        try {
            double x = Double.parseDouble(str_x);
            double y = Double.parseDouble(str_y);
            double w = Double.parseDouble(str_w);
            double h = Double.parseDouble(str_h);
            return new Rectangle2D.Double(x, y, w, h);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Color readColorDOMTree(Element colorElement) {
        String str_color = colorElement.getAttributeNS(null, "color");
        try {
            long l = Long.parseLong(str_color, 16);
            return new Color((int)l, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    private int readFontDOMTree(Element fontNode) {
        try {
            String strFSize = fontNode.getAttributeNS(null, "size");
            int i = Integer.valueOf(strFSize);
            return i;
        }
        catch (Exception e) {
            return 11;
        }
    }
}

