/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.layer.symbol.species;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import jp.fric.graphics.draw.GColoredShape;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GLinkHandlePoint;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.PaintScheme;
import jp.fric.graphics.draw.ShapeUtil;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.SpeciesShapePainting;
import jp.sbi.celldesigner.layer.swing.ExtendedNameImage;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesShape;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerTagSymbol;
import jp.sbi.celldesigner.symbol.color.SpeciesColorScheme;
import jp.sbi.celldesigner.symbol.species.Complex;
import jp.sbi.celldesigner.symbol.species.Degraded;
import jp.sbi.celldesigner.symbol.species.GeneralBrief;
import jp.sbi.celldesigner.symbol.species.IonChannel;

public class LayerMonoSpeciesShape
implements GFramedShape,
GColoredShape,
LayerSpeciesShape {
    protected int showLinkAnchorMode = 0;
    protected GLinkPositionInfo linkPositionInfo = null;
    private Color color = new Color(0, 0, 0);
    private Stroke stroke = new BasicStroke(1.0f, 0, 1);
    public static final Color residueColor = Color.BLACK;
    public static final Stroke residueStroke = new BasicStroke(1.0f, 0, 2);
    private PaintScheme painter = null;
    private ExtendedNameImage nameImage = new ExtendedNameImage();
    private LayerSpeciesSymbol symbol = null;
    private static final double HO = 6.0;
    private Rectangle2D.Double frameBounds = null;
    private Rectangle2D.Double repaintBounds = null;
    private Dimension nameImageSize = null;
    private Rectangle2D.Double nameImageBounds = null;
    private int currentView = 0;
    private static HashSet viewSet = null;
    private HashMap symbolReservoir = new HashMap();
    private HashMap strokeReservoir = new HashMap();
    private HashMap colorReservoir = new HashMap();
    private HashMap painterReservoir = new HashMap();
    protected GLinkHandlePoint sHandlePoint = new GLinkHandlePoint();
    String type;

    static {
        viewSet = new HashSet();
        viewSet.add(new Integer(0));
        viewSet.add(new Integer(1));
    }

    public int getLayerTextFontSize() {
        return this.nameImage.getLayerTextFontSize();
    }

    public void setLayerTextFontSize(int s) {
        this.nameImage.setLayerTextFontSize(s);
    }

    public LayerMonoSpeciesShape() {
    }

    public LayerMonoSpeciesShape(String type) {
        this.type = type;
        this.resetShape();
        this.buildPaintingsForType(type);
        this.buildShape();
        this.changeView(new Integer(0));
    }

    public LayerSpeciesSymbol getSpeciesSymbol() {
        return this.symbol;
    }

    public void buildPaintingsForType(String type) {
        Integer uInt = new Integer(0);
        this.colorReservoir.put(uInt, SpeciesColorScheme.getColor(type));
        BasicStroke st = new BasicStroke((float)SpeciesColorScheme.getLineWidth(type), 0, 1);
        this.strokeReservoir.put(uInt, st);
        this.painterReservoir.put(uInt, SpeciesColorScheme.getScheme(type));
        String briefType = SBFactory.getBriefViewType(type);
        Integer bInt = new Integer(1);
        this.colorReservoir.put(bInt, SpeciesColorScheme.getColor(briefType));
        BasicStroke bst = new BasicStroke((float)SpeciesColorScheme.getLineWidth(briefType), 0, 1);
        this.strokeReservoir.put(bInt, bst);
        this.painterReservoir.put(bInt, SpeciesColorScheme.getScheme(briefType));
    }

    private void buildShape() {
        Integer uInt = new Integer(0);
        Integer bInt = new Integer(1);
        String briefType = SBFactory.getBriefViewType(this.type);
        this.symbolReservoir.put(uInt, SBFactory.createSymbol(this.type));
        this.symbolReservoir.put(bInt, SBFactory.createSymbol(briefType));
    }

    private void rebuildShape() {
        Integer viewInt = new Integer(this.currentView);
        if (this.painter == null) {
            if (Preference.isDebug) {
                System.err.println("MonoSpeciesShape.rebuildShape() painter==null; " + this.type + " " + this);
            }
            this.painter = SpeciesColorScheme.getScheme(this.type);
            this.painter.setColor(this.color);
            this.painter.setStroke(this.stroke);
            this.painterReservoir.put(viewInt, this.painter);
        }
        this.symbol = (LayerSpeciesSymbol)((Object)SBFactory.createSymbol(this.type));
        this.symbol.setPaintScheme(this.painter);
        this.symbolReservoir.put(viewInt, this.symbol);
        this.nameImage.setSymbol(this.symbol);
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        if (this.symbol == null) {
            return this.repaintBounds;
        }
        return this.symbol.getSymbolBounds2();
    }

    @Override
    public Rectangle2D.Double getFrameBounds() {
        return this.frameBounds;
    }

    @Override
    public void resetShape() {
        this.symbol = null;
        this.symbolReservoir.put(new Integer(this.currentView), this.symbol);
        if (this.frameBounds != null) {
            this.updateShape(this.frameBounds.x, this.frameBounds.y, this.frameBounds.width, this.frameBounds.height);
        }
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        if (this.symbol == null) {
            return null;
        }
        return this.symbol.getEdgePoints();
    }

    public void resetNameImageSize() {
        this.nameImageSize = null;
        this.symbol = null;
    }

    @Override
    public Rectangle2D.Double updateShape(double x, double y, double w, double h) {
        if (this.symbol == null) {
            this.rebuildShape();
        }
        if (this.symbol == null) {
            return null;
        }
        this.frameBounds = new Rectangle2D.Double(x, y, w, h);
        Rectangle2D.Double symbolBounds = this.createSymbolBounds(x, y, w, h, 1);
        this.symbol.setSymbolBounds(symbolBounds.x, symbolBounds.y, symbolBounds.width, symbolBounds.height);
        this.nameImage.setSymbol(this.symbol);
        if (this.nameImageSize == null || this.nameImage.getString().length() == 0) {
            this.nameImageSize = this.nameImage.getNameImageSize();
        }
        if (this.nameImageSize != null && symbolBounds != null) {
            this.nameImageBounds = this.symbol instanceof IonChannel ? this.createLabelBounds(((IonChannel)((Object)this.symbol)).getLeftBounds(), this.nameImageSize) : this.createLabelBounds(symbolBounds, this.nameImageSize);
        }
        this.repaintBounds = symbolBounds;
        int linewidth = 2 + (int)((BasicStroke)this.stroke).getLineWidth();
        this.repaintBounds.x -= (double)(linewidth /= 2);
        this.repaintBounds.y -= (double)linewidth;
        this.repaintBounds.width += (double)(2 * linewidth);
        this.repaintBounds.height += (double)(2 * linewidth);
        if (this.nameImageBounds != null) {
            this.repaintBounds = GUtil.union(this.repaintBounds, this.nameImageBounds);
        }
        return (Rectangle2D.Double)this.repaintBounds.clone();
    }

    private Rectangle2D.Double createSymbolBounds(double x, double y, double w, double h, int homodimer) {
        return new Rectangle2D.Double(x, y, w - (double)(homodimer - 1) * 6.0, h - (double)(homodimer - 1) * 6.0);
    }

    private Rectangle2D.Double createLabelBounds(Rectangle2D.Double targetBounds, Dimension labelSize) {
        if (this.symbol == null) {
            return null;
        }
        double x = targetBounds.x + (targetBounds.width - (double)labelSize.width) / 2.0;
        double y = 0.0;
        y = this.symbol instanceof Complex ? targetBounds.y + targetBounds.height - (double)labelSize.height : targetBounds.y + (targetBounds.height - (double)labelSize.height) / 2.0;
        if (this.symbol instanceof LayerTagSymbol) {
            return new Rectangle2D.Double(targetBounds.x, targetBounds.y, targetBounds.width, targetBounds.height);
        }
        return new Rectangle2D.Double(x, y, labelSize.width, labelSize.height);
    }

    @Override
    public void drawShape(Graphics2D g2, int colorflg) {
        if (this.symbol == null) {
            return;
        }
        g2.setStroke(STROKE_ACTIVE);
        g2.setColor(Color.BLACK);
        if (!(this.symbol instanceof LayerTagSymbol)) {
            this.drawActiveEdge(g2);
        }
        g2.setColor(Color.white);
        this.fillActiveEdge(g2);
        this.sHandlePoint.draw(g2);
        this.drawInner(g2, colorflg);
        if (this.showLinkAnchorMode != 0) {
            boolean drawOnlyActive = this.showLinkAnchorMode == 2;
            this.drawLinkAnchors(g2, drawOnlyActive);
        }
    }

    protected Point2D.Double[] setupLinkAnchorCoord() {
        return this.symbol.setupLinkAnchorCoord();
    }

    protected void drawLinkAnchors(Graphics2D g2, GLinkPositionInfo lpi, boolean drawOnlyActive) {
        if (this.symbol != null) {
            this.symbol.drawLinkAnchors(g2, lpi, drawOnlyActive);
        }
    }

    private void drawLinkAnchors(Graphics2D g2, boolean drawOnlyActive) {
        this.drawLinkAnchors(g2, this.linkPositionInfo, drawOnlyActive);
    }

    protected void drawActiveEdge(Graphics2D g2) {
        if (this.symbol == null) {
            return;
        }
        this.symbol.drawActiveEdge(g2);
    }

    protected void fillActiveEdge(Graphics2D g2) {
        if (this.symbol == null) {
            return;
        }
        this.symbol.fillActiveEdge(g2);
    }

    protected void drawInner(Graphics2D g2, int colorflg) {
        if (this.symbol == null) {
            return;
        }
        if (this.symbol instanceof Degraded || this.symbol instanceof GeneralBrief) {
            return;
        }
        if (this.symbol instanceof LayerTagSymbol) {
            this.symbol.drawInner(g2, colorflg);
        }
        if (this.nameImageSize == null || this.nameImage.getString().length() == 0) {
            String name = "";
            this.nameImage.setString(name);
            this.nameImageSize = this.nameImage.draw(g2, 0, 0, false);
        }
        this.nameImageBounds = this.symbol instanceof IonChannel ? this.createLabelBounds(((IonChannel)((Object)this.symbol)).getLeftBounds(), this.nameImageSize) : this.createLabelBounds(this.symbol.getSymbolBounds(), this.nameImageSize);
        this.nameImage.draw(g2, (int)this.nameImageBounds.x, (int)this.nameImageBounds.y, true);
    }

    @Override
    public GFramedShape createCopy() {
        return (GFramedShape)((Object)this.duplicate());
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        this.colorReservoir.put(new Integer(this.currentView), color);
        if (this.painter != null) {
            this.painter.setColor(color);
            this.painterReservoir.put(new Integer(this.currentView), this.painter);
        }
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    @Override
    public void setPaintScheme(PaintScheme painterin) {
        this.painter = painterin;
        this.painter.setColor(this.color);
        this.painter.setStroke(this.stroke);
        this.painterReservoir.put(new Integer(this.currentView), this.painter);
        if (this.symbol != null) {
            this.symbol.setPaintScheme(this.painter);
            this.symbolReservoir.put(new Integer(this.currentView), this.symbol);
        }
    }

    @Override
    public double getLineWidth() {
        return ((BasicStroke)this.stroke).getLineWidth();
    }

    public void setLineWidth(double linewidth) {
        this.stroke = new BasicStroke((float)linewidth, 0, 1);
        this.strokeReservoir.put(new Integer(this.currentView), this.stroke);
        if (this.painter != null) {
            this.painter.setStroke(this.stroke);
            this.painterReservoir.put(new Integer(this.currentView), this.painter);
        }
    }

    public SpeciesShapePainting getSpeciesShapePainting() {
        return new SpeciesShapePainting(((BasicStroke)this.stroke).getLineWidth(), this.color, this.painter);
    }

    public void setSpeciesShapePainting(SpeciesShapePainting painting) {
        this.setLineWidth(painting.getLineWidth());
        this.setColor(painting.getColor());
        this.setPaintScheme(painting.getPaintScheme());
    }

    @Override
    public void showLinkAnchors(GLinkPositionInfo lpi, boolean drawOnlyActive) {
        this.showLinkAnchorMode = drawOnlyActive ? 2 : 1;
        this.linkPositionInfo = (GLinkPositionInfo)lpi.clone();
    }

    @Override
    public void hideLinkAnchors() {
        this.showLinkAnchorMode = 0;
        this.linkPositionInfo = null;
    }

    @Override
    public GLinkPositionInfo getPointedLinkPosition(double x, double y) {
        if (!this.repaintBounds.contains(x, y)) {
            return null;
        }
        Point2D.Double[] array = this.setupLinkAnchorCoord();
        return ShapeUtil.getNearLinkAnchorPosition(array, x, y);
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPosition(GLinkPositionInfo lpi) {
        return this.symbol.getCoordinatesOfLinkPosition(lpi);
    }

    private void changePaintingsForView(Integer viewInt) {
        this.color = (Color)this.colorReservoir.get(viewInt);
        this.stroke = (Stroke)this.strokeReservoir.get(viewInt);
        this.painter = (PaintScheme)this.painterReservoir.get(viewInt);
        if (this.painter != null) {
            this.painter.setColor(this.color);
            this.painter.setStroke(this.stroke);
        }
    }

    private void copyReservoirsTo(LayerMonoSpeciesShape copy) {
        if (this.symbol instanceof LayerTagSymbol) {
            for (Integer key : this.strokeReservoir.keySet()) {
                Stroke st = (Stroke)this.strokeReservoir.get(key);
                BasicStroke stcopy = new BasicStroke(((BasicStroke)st).getLineWidth(), 0, 1);
                copy.strokeReservoir.put(key, stcopy);
            }
            for (Integer key : this.colorReservoir.keySet()) {
                Color cl = (Color)this.colorReservoir.get(key);
                Color clcopy = new Color(cl.getRed(), cl.getGreen(), cl.getBlue(), cl.getAlpha());
                copy.colorReservoir.put(key, clcopy);
            }
            for (Integer key : this.painterReservoir.keySet()) {
                PaintScheme ps = (PaintScheme)this.painterReservoir.get(key);
                try {
                    PaintScheme pscopy = (PaintScheme)ps.getClass().newInstance();
                    copy.painterReservoir.put(key, pscopy);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            PaintScheme ps = this.getPaintScheme();
            try {
                PaintScheme pscopy = (PaintScheme)ps.getClass().newInstance();
                copy.setPaintScheme(pscopy);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setIDString(String id) {
        this.nameImage.setIDString(id);
    }

    public void setIDStringPosition(int x, int y) {
        this.nameImage.setId_x(x);
        this.nameImage.setId_y(y);
    }

    public void changeView(Integer viewInt) {
        this.currentView = viewInt;
        this.changePaintingsForView(viewInt);
        this.symbol = (LayerSpeciesSymbol)this.symbolReservoir.get(viewInt);
        if (this.symbol != null) {
            this.symbol.setPaintScheme(this.painter);
        }
    }

    @Override
    public boolean inShape(double x, double y) {
        if (this.symbol == null) {
            return false;
        }
        int homodimer = 1;
        int i = 0;
        while (i < homodimer) {
            boolean isIn = this.symbol.inShape(x - (double)i * 6.0, y - (double)i * 6.0, false);
            if (isIn) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Rectangle2D.Double setProperty(SpeciesProperty property) {
        return null;
    }

    public SpeciesProperty getProperty() {
        return null;
    }

    public void setActive(boolean isActive) {
    }

    public boolean isActive() {
        return false;
    }

    @Override
    public LayerSpeciesShape duplicate() {
        LayerMonoSpeciesShape mono = new LayerMonoSpeciesShape();
        this.copyReservoirsTo(mono);
        mono.type = "LAYER_TEXT".equals(this.type) || "TAG".equals(this.type) ? this.type : "LAYER_TEXT";
        if ("TAG".equals(mono.type)) {
            mono.changePaintingsForView(new Integer(this.currentView));
        }
        mono.setNameImage(this.nameImage.getString());
        return mono;
    }

    public void setNameImage(String text) {
        this.nameImage.setString(text);
    }

    public void setTargetPosition(int x, int y) {
        this.symbol.setTargetPosition(x, y);
        this.symbol.setIsExistTarget(true);
    }

    public void setIsExistTarget(boolean b) {
        this.symbol.setIsExistTarget(b);
    }

    public Point2D.Double getTargetPoint() {
        return this.symbol.getTargetPoint();
    }
}

