/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.layer.symbol.reaction;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedCreaseLine;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GLinkedStraightLine;
import jp.fric.graphics.draw.GStructure;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SBSymbolized;
import jp.sbi.celldesigner.layer.swing.LayerFreeLinkPopupMenu;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerFreeLineArrowSymbol;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerReactionSymbol;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerTagFreeLineSymbol;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayerReactionLink
extends GLink
implements SBSymbolized {
    private int reactantSize;
    private int ri;
    private int pi;
    private SBSymbol symbol = null;
    private String tmpInfo = "";
    private int belong_layer_id;

    public int getBelong_layer_id() {
        return this.belong_layer_id;
    }

    public void setBelong_layer_id(int belong_layer_id) {
        this.belong_layer_id = belong_layer_id;
    }

    public LayerReactionLink() {
        this.belong_layer_id = -1;
    }

    public LayerReactionLink(int reactantSize, int productSize) {
        super(reactantSize + productSize);
        this.reactantSize = reactantSize;
        this.ri = 0;
        this.pi = reactantSize;
        this.belong_layer_id = -1;
    }

    public void setSizes(int reactantSize, int productSize) {
        super.setTargetSize(reactantSize + productSize);
        this.reactantSize = reactantSize;
        this.ri = 0;
        this.pi = reactantSize;
    }

    public void setTmpInfo(String tmpInfo) {
        this.tmpInfo = tmpInfo;
    }

    public String getTmpInfo() {
        return this.tmpInfo;
    }

    @Override
    public void setSymbol(SBSymbol symbol) throws Exception {
        if (symbol instanceof LayerReactionSymbol) {
            super.setGLinkedShape((GLinkedShape)((Object)symbol));
        } else {
            throw new Exception("symbol must be LayerReactionSymbol, code=" + symbol.getCode());
        }
        this.symbol = symbol;
    }

    @Override
    public SBSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public void setGLinkedShape(GLinkedShape linkedShape) throws Exception {
        super.setGLinkedShape(linkedShape);
        this.symbol = (SBSymbol)((Object)linkedShape);
    }

    @Override
    public GElement createCopy() {
        LayerReactionLink link = new LayerReactionLink(1, 1);
        String CODENAME = null;
        CODENAME = this.getSymbol() instanceof LayerFreeLineArrowSymbol ? "LAYER_ARROW" : (this.getSymbol() instanceof LayerTagFreeLineSymbol ? "TAG_LINE" : "LAYER_LINE");
        try {
            SBSymbol symbol = SBFactory.createSymbol(CODENAME);
            link.setSymbol(symbol);
        }
        catch (Exception symbol) {
            // empty catch block
        }
        GLinkedCreaseLine thisShape = (GLinkedCreaseLine)this.getGLinkedShape();
        GLinkedStraightLine thisline = thisShape.getLines()[0];
        GLinkedCreaseLine copyShape = (GLinkedCreaseLine)link.getGLinkedShape();
        GLinkedStraightLine copyLine = copyShape.getLines()[0];
        copyShape.setColor(new Color(thisShape.getColor().getRGB()));
        copyShape.setLineWidth(thisShape.getLineWidth());
        ((LayerReactionSymbol)((Object)copyShape)).setIsDotted(((LayerReactionSymbol)((Object)thisShape)).isDotted());
        copyLine.setStartAndEndPoint((Point2D.Double)thisline.getStartPoint().clone(), (Point2D.Double)thisline.getEndPoint().clone());
        copyShape.getStartHandlePoint().setPosition(new Point2D.Double(thisline.getStartPoint().x, thisline.getStartPoint().y));
        copyShape.getEndHandlePoint().setPosition(new Point2D.Double(thisline.getEndPoint().x, thisline.getEndPoint().y));
        copyShape.getStartHandlePoint().update();
        copyShape.getEndHandlePoint().update();
        copyShape.getStartHandlePoint().setOwner(copyShape);
        copyShape.getEndHandlePoint().setOwner(copyShape);
        copyShape.updateLine();
        copyShape.updateShape();
        copyShape.setBounds(new Rectangle2D.Double(thisline.getStartPoint().x, thisline.getStartPoint().y, thisline.getEndPoint().x, thisline.getEndPoint().y));
        link.setHighlighted(false);
        return link;
    }

    @Override
    public boolean isLinkable(GLinkTarget elem, int index) {
        if (this.symbol == null) {
            return false;
        }
        if (this.symbol instanceof LayerReactionSymbol) {
            return ((LayerReactionSymbol)((Object)this.symbol)).isLinkable(elem, index);
        }
        return ((LayerReactionSymbol)((Object)this.symbol)).isLinkable(elem, index);
    }

    @Override
    public boolean popupAvailable() {
        return true;
    }

    @Override
    public void showPopup(MouseEvent e, double x, double y, GStructure structure) {
        LayerFreeLinkPopupMenu popup = LayerFreeLinkPopupMenu.getInstance();
        if (this.symbol instanceof LayerTagFreeLineSymbol) {
            return;
        }
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    public boolean isArrow() {
        return this.symbol instanceof LayerFreeLineArrowSymbol;
    }

    public String toSBML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<celldesigner:layerFreeLine isArrow=\"" + this.isArrow() + "\" isDotted = \"" + ((LayerReactionSymbol)((Object)this.symbol)).isDotted() + "\">\n");
        GLinkedCreaseLine shape = (GLinkedCreaseLine)this.getGLinkedShape();
        GLinkedStraightLine line = shape.getLines()[0];
        Point2D.Double startP = line.getStartPoint();
        Point2D.Double endP = line.getEndPoint();
        buf.append("<celldesigner:bounds sx=\"" + startP.x + "\" sy=\"" + startP.y + "\" ex=\"" + endP.x + "\" ey=\"" + endP.y + "\"/>\n");
        GLinkedShape colorShape = (GLinkedShape)((Object)this.getSymbol());
        buf.append("<celldesigner:line width=\"" + colorShape.getLineWidth() + "\" color=\"" + Integer.toHexString(colorShape.getColor().getRGB()) + "\"/>\n");
        buf.append("</celldesigner:layerFreeLine>\n");
        return buf.toString();
    }

    public void readDOMTree(Element element) {
        if (element == null) {
            return;
        }
        if (!element.hasChildNodes()) {
            return;
        }
        String targetType = element.getAttributeNS(null, "isArrow");
        String CODENAME = null;
        CODENAME = targetType.equals("true") ? "LAYER_ARROW" : "LAYER_LINE";
        try {
            SBSymbol symbol = SBFactory.createSymbol(CODENAME);
            this.setSymbol(symbol);
        }
        catch (Exception symbol) {
            // empty catch block
        }
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        Node boundsNode = null;
        Node paintNode = null;
        int i = 0;
        while (i < childsize) {
            Node node = childlist.item(i);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                String localName = node.getLocalName();
                if (localName.equals("bounds")) {
                    boundsNode = node;
                } else if (localName.equals("line")) {
                    paintNode = node;
                }
            }
            ++i;
        }
        Rectangle2D.Double readBounds = this.readBoundsDOMTree((Element)boundsNode);
        GLinkedCreaseLine shape = (GLinkedCreaseLine)this.getGLinkedShape();
        GLinkedStraightLine line = shape.getLines()[0];
        String str_color = ((Element)paintNode).getAttributeNS(null, "color");
        String str_width = ((Element)paintNode).getAttributeNS(null, "width");
        long l = Long.parseLong(str_color, 16);
        shape.setColor(new Color((int)l, true));
        shape.setLineWidth(Double.parseDouble(str_width));
        String isDotted = element.getAttributeNS(null, "isDotted");
        ((LayerReactionSymbol)((Object)this.symbol)).setIsDotted(Boolean.valueOf(isDotted));
        line.setStartAndEndPoint(new Point2D.Double(readBounds.x, readBounds.y), new Point2D.Double(readBounds.width, readBounds.height));
        shape.getStartHandlePoint().setPosition(new Point2D.Double(readBounds.x, readBounds.y));
        shape.getEndHandlePoint().setPosition(new Point2D.Double(readBounds.width, readBounds.height));
        shape.getStartHandlePoint().update();
        shape.getEndHandlePoint().update();
        shape.getStartHandlePoint().setOwner(shape);
        shape.getEndHandlePoint().setOwner(shape);
        shape.starttemp = new Point2D.Double(readBounds.x, readBounds.y);
        shape.endtemp = new Point2D.Double(readBounds.width, readBounds.height);
        shape.updateLine();
        shape.updateShape();
        shape.setBounds(new Rectangle2D.Double(readBounds.x, readBounds.y, readBounds.width, readBounds.height));
        this.setHighlighted(false);
    }

    private Rectangle2D.Double readBoundsDOMTree(Element boundElement) {
        String str_x = boundElement.getAttributeNS(null, "sx");
        String str_y = boundElement.getAttributeNS(null, "sy");
        String str_w = boundElement.getAttributeNS(null, "ex");
        String str_h = boundElement.getAttributeNS(null, "ey");
        try {
            double x = Double.parseDouble(str_x);
            double y = Double.parseDouble(str_y);
            double w = Double.parseDouble(str_w);
            double h = Double.parseDouble(str_h);
            return new Rectangle2D.Double(x, y, w, h);
        }
        catch (Exception e) {
            return null;
        }
    }
}

