/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.layer.symbol.reaction;

import java.awt.BasicStroke;
import java.util.Map;
import java.util.Vector;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineArrowShape;
import jp.fric.graphics.draw.GLinkedLineModificationShape;
import jp.fric.graphics.draw.GLinkedStraightLine;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerReactionSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesShape;

public class LayerFreeLineSymbol
extends LinkedCreaseLine
implements SBSymbol,
LayerReactionSymbol {
    public static final String CODENAME = "LAYER_LINE";
    private boolean isReversible = false;
    protected GLinkedLineArrowShape arrowShape1;
    protected GLinkedLineArrowShape arrowShape3;
    private boolean isDotted;
    public static BasicStroke STROKE_DOTTED = new BasicStroke(0.0f, 0, 0, 10.0f, LayerSpeciesShape.PATTERN_ACTIVE, 0.0f);
    public static BasicStroke STROKE_BASIC = new BasicStroke(0.0f, 1, 1);

    @Override
    protected void init1(int newCreaseLineNumber) {
        this.lines = new GLinkedStraightLine[newCreaseLineNumber];
        int i = 0;
        while (i < newCreaseLineNumber) {
            this.lines[i] = new GLinkedStraightLine();
            ++i;
        }
        this.arrowShape1 = new GLinkedLineArrowShape();
        this.arrowShape1.setType(1);
        this.arrowShape1.setReversed(true);
        this.arrowShape1.setVisible(false);
        this.lines[0].addModificationShape(this.arrowShape1);
        this.lines[0].setIsLayerLine(true);
        this.arrowShape3 = new GLinkedLineArrowShape();
        this.arrowShape3.setType(1);
        this.lines[newCreaseLineNumber - 1].addModificationShape(this.arrowShape3);
        this.arrowShape3.setVisible(false);
    }

    @Override
    protected void init2(int newCreaseLineNumber) {
        try {
            super.setLines(this.lines);
            super.setDefaultTargetLineIndex(newCreaseLineNumber / 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void setupNewLinesByAddPoint(Vector vec, int index, GLinkedStraightLine oldLine, GLinkedStraightLine newLine, Map paramMap) {
        for (GLinkedLineModificationShape m : vec) {
            if (m == this.arrowShape1) {
                oldLine.addModificationShape(m);
                continue;
            }
            if (m != this.arrowShape3) continue;
            newLine.addModificationShape(m);
        }
    }

    @Override
    public GLinkedLine createCopiedLine() {
        GLinkedLine line = super.createCopiedLine();
        return line;
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    public void setReversible(boolean isReversible) {
        if (isReversible) {
            this.arrowShape1.setVisible(true);
        } else {
            this.arrowShape1.setVisible(false);
        }
        this.isReversible = isReversible;
    }

    public boolean isReversible() {
        return this.isReversible;
    }

    @Override
    public int sourceSize() {
        return 1;
    }

    @Override
    public int destinationSize() {
        return 1;
    }

    @Override
    public boolean isLinkable(GLinkTarget elem, int index) {
        if (index == 0) {
            if (elem instanceof SpeciesAlias) {
                return true;
            }
        } else if (index == 1) {
            if (elem instanceof SpeciesAlias) {
                return true;
            }
            if (elem instanceof ReactionLink && ((ReactionLink)elem).isBaseLink()) {
                return true;
            }
        }
        return false;
    }

    private BasicStroke getStroke() {
        return null;
    }

    @Override
    public boolean isDotted() {
        return this.isDotted;
    }

    @Override
    public void setIsDotted(boolean isDotted) {
        if (isDotted) {
            this.lines[0].setStroke(STROKE_DOTTED);
        } else {
            this.lines[0].setStroke(STROKE_BASIC);
        }
        this.isDotted = isDotted;
    }
}

