/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.layer.symbol.compartment;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.ColorPaint;
import jp.fric.graphics.draw.GColoredShape;
import jp.fric.graphics.draw.GContainerShape;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.PaintScheme;
import jp.fric.graphics.draw.PaintSchemeFactory;
import jp.sbi.celldesigner.CompartmentShapePainting;
import jp.sbi.celldesigner.GUtil2;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerCompartmentSymbol;
import jp.sbi.celldesigner.symbol.color.CompartmentColorScheme;
import jp.sbi.celldesigner.symbol.compartment.Membrane;

public class LayerOvalSymbol
implements SBSymbol,
LayerCompartmentSymbol,
GFramedShape,
GContainerShape,
GColoredShape {
    public static final String CODENAME = "LAYER_OVAL";
    private Color color = new Color(0, 0, 0);
    private Color colorInner = new Color(0, 0, 0);
    private PaintScheme painter = null;
    private PaintScheme painterInner = null;
    private Membrane membrane = null;
    private double thickness = 3.0;
    private Stroke outerStroke = new BasicStroke(2.0f, 1, 1);
    private Stroke innerStroke = new BasicStroke(1.0f, 1, 1);
    private Ellipse2D ellipse = null;
    private Ellipse2D ellipseInner = null;
    private Point2D.Double[] points = new Point2D.Double[8];
    private Rectangle2D.Double rect = null;
    private Area membraneArea = null;
    private boolean bPaintInner = false;

    public LayerOvalSymbol() {
        this.color = CompartmentColorScheme.getColor(CODENAME);
        this.painter = CompartmentColorScheme.getScheme(CODENAME);
        this.setMembrane(CompartmentColorScheme.getMembrane(CODENAME));
        this.painter.setColor(this.color);
        this.initInnerPaintColor();
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Point2D.Double();
            ++i;
        }
    }

    @Override
    public String getCode() {
        return CODENAME;
    }

    @Override
    public double getThickness() {
        return this.thickness;
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public boolean inOutsideOfEdge(double x, double y) {
        if (this.ellipse == null) {
            return false;
        }
        return this.ellipse.contains(x, y);
    }

    @Override
    public boolean inInsideOfEdge(double x, double y) {
        if (this.ellipseInner == null) {
            return false;
        }
        return this.ellipseInner.contains(x, y);
    }

    @Override
    public boolean onEdge(double x, double y) {
        if (this.ellipse == null || this.ellipseInner == null) {
            return false;
        }
        return this.ellipse.contains(x, y);
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        return this.points;
    }

    @Override
    public boolean inShape(double x, double y) {
        if (this.ellipse == null) {
            return false;
        }
        return this.ellipse.contains(x, y);
    }

    @Override
    public Rectangle2D.Double updateShape(double x, double y, double width, double height) {
        if (this.ellipse == null) {
            this.ellipse = new Ellipse2D.Double();
            this.ellipseInner = new Ellipse2D.Double();
            this.rect = new Rectangle2D.Double();
        }
        this.ellipse.setFrame(x, y, width, height);
        this.rect.setFrame(x, y, width, height);
        double tw = (width - 4.0) / 2.0;
        double th = (height - 4.0) / 2.0;
        if (tw > this.thickness) {
            tw = this.thickness;
        }
        if (th > this.thickness) {
            th = this.thickness;
        }
        this.ellipseInner.setFrame(x + tw, y + th, width - tw * 2.0, height - th * 2.0);
        this.membraneArea = new Area(this.ellipse);
        this.membraneArea.subtract(new Area(this.ellipseInner));
        GUtil2.setEdgePoints(this.rect, this.ellipse, this.points);
        int linewidth = 2 + (int)((BasicStroke)this.outerStroke).getLineWidth();
        return new Rectangle2D.Double(x - (double)(linewidth /= 2), y - (double)linewidth, width + (double)(2 * linewidth), height + (double)(2 * linewidth));
    }

    @Override
    public void drawShape(Graphics2D g2, int colorflg) {
        if (this.ellipse != null) {
            this.painter.setStroke(this.outerStroke);
            if (this.isPaintInner()) {
                this.painterInner.fillPaint(g2, this.ellipse, colorflg);
            }
            this.painter.drawEdge(g2, this.ellipse, colorflg);
            if (Preference.isDebug) {
                Rectangle2D.Double r = new Rectangle2D.Double();
                int i = 0;
                while (i < this.points.length) {
                    r.setFrame(this.points[i].x - 1.0, this.points[i].y - 1.0, 4.0, 4.0);
                    g2.fill(r);
                    ++i;
                }
            }
        }
    }

    @Override
    public GFramedShape createCopy() {
        LayerOvalSymbol copy = new LayerOvalSymbol();
        copy.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
        copy.colorInner = new Color(this.colorInner.getRed(), this.colorInner.getGreen(), this.colorInner.getBlue(), this.colorInner.getAlpha());
        try {
            String scheme = PaintSchemeFactory.getName(this.painter.getCode());
            copy.painter = PaintSchemeFactory.create(scheme);
            copy.painter.setColor(copy.color);
        }
        catch (Exception e) {
            copy.painter = CompartmentColorScheme.getScheme(CODENAME);
        }
        try {
            String schemeInner = PaintSchemeFactory.getName(this.painterInner.getCode());
            copy.painterInner = PaintSchemeFactory.create(schemeInner);
            copy.painterInner.setColor(copy.colorInner);
        }
        catch (Exception e) {
            LayerOvalSymbol copy2 = new LayerOvalSymbol();
            copy.painterInner = copy2.getPaintScheme(true);
        }
        copy.bPaintInner = this.bPaintInner;
        return copy;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.setColor(color, false);
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.getPaintScheme(false);
    }

    @Override
    public void setPaintScheme(PaintScheme painterin) {
        this.setPaintScheme(painterin, false);
    }

    @Override
    public Membrane getMembrane() {
        return this.membrane;
    }

    @Override
    public void setMembrane(Membrane mem) {
        this.membrane = mem;
        this.thickness = this.membrane.getThickness();
        this.outerStroke = new BasicStroke((float)this.membrane.getOuterLineWidth(), 1, 1);
        this.innerStroke = new BasicStroke((float)this.membrane.getInnerLineWidth(), 1, 1);
    }

    @Override
    public CompartmentShapePainting getCompartmentShapePainting() {
        return this.getCompartmentShapePainting(false);
    }

    @Override
    public void setCompartmentShapePainting(CompartmentShapePainting painting) {
        this.setCompartmentShapePainting(painting, false);
    }

    @Override
    public void showLinkAnchors(GLinkPositionInfo lpi, boolean drawOnlyActive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void hideLinkAnchors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GLinkPositionInfo getPointedLinkPosition(double x, double y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPosition(GLinkPositionInfo lpi) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getLineWidth() {
        return ((BasicStroke)this.outerStroke).getLineWidth();
    }

    @Override
    public void setColor(Color color, boolean inner) {
        if (inner) {
            this.colorInner = color;
            if (this.painterInner != null) {
                this.painterInner.setColor(this.colorInner);
            }
        } else {
            this.color = color;
            if (this.painter != null) {
                this.painter.setColor(color);
            }
        }
    }

    @Override
    public void setPaintScheme(PaintScheme painterin, boolean inner) {
        if (inner) {
            this.painterInner = painterin;
            this.painterInner.setColor(this.colorInner);
        } else {
            this.painter = painterin;
            this.painter.setColor(this.color);
        }
    }

    @Override
    public CompartmentShapePainting getCompartmentShapePainting(boolean inner) {
        if (inner) {
            return new CompartmentShapePainting(this.membrane, this.colorInner, this.painterInner);
        }
        return new CompartmentShapePainting(this.membrane, this.color, this.painter);
    }

    @Override
    public boolean isPaintInner() {
        return this.bPaintInner;
    }

    @Override
    public void setPaintInnerFlg(boolean boo) {
        this.bPaintInner = boo;
    }

    @Override
    public Color getColor(boolean inner) {
        if (inner) {
            return this.colorInner;
        }
        return this.color;
    }

    @Override
    public PaintScheme getPaintScheme(boolean inner) {
        if (inner) {
            if (this.painterInner == null) {
                this.painterInner = CompartmentColorScheme.getScheme(CODENAME);
            }
            return this.painterInner;
        }
        if (this.painter == null) {
            this.painter = CompartmentColorScheme.getScheme(CODENAME);
        }
        return this.painter;
    }

    @Override
    public void setCompartmentShapePainting(CompartmentShapePainting painting, boolean inner) {
        if (!inner) {
            this.setMembrane(painting.getMembrane());
        }
        this.setColor(painting.getColor(), inner);
        this.setPaintScheme(painting.getPaintScheme(), inner);
    }

    @Override
    public void initInnerPaintColor() {
        this.setColor(Color.WHITE, true);
        this.setPaintScheme(new ColorPaint(), true);
    }
}

