/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.layer.symbol.compartment;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFramedContainer;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.PaintSchemeFactory;
import jp.sbi.celldesigner.CompartmentShapePainting;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.layer.swing.LayerSquarePopupMenu;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerCompartmentAlias;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerCompartmentSymbol;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerOvalSymbol;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerSquareSymbol;
import jp.sbi.celldesigner.symbol.compartment.Membrane;
import org.sbml.libsbml.Model;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayerClosedCompartmentAlias
extends GFramedContainer
implements LayerCompartmentAlias {
    private String compartmentName = "";
    private SBSymbol symbol = null;
    private Dimension nameImageSize = null;
    private Rectangle2D.Double nameImageBounds = null;
    private int belong_layer_id = -1;

    @Override
    public int getBelong_layer_id() {
        return this.belong_layer_id;
    }

    @Override
    public void setBelong_layer_id(int belong_layer_id) {
        this.belong_layer_id = belong_layer_id;
    }

    @Override
    public void setSymbol(SBSymbol symbol) throws Exception {
        if (symbol instanceof LayerCompartmentSymbol) {
            this.symbol = symbol;
            super.setGFramedShape((GFramedShape)((Object)symbol));
        } else {
            throw new Exception("symbol must be LayerCompartmentSymbol, code=" + symbol.getCode());
        }
    }

    @Override
    public SBSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public void setGFramedShape(GFramedShape framedShape) throws Exception {
        super.setGFramedShape(framedShape);
        this.symbol = (SBSymbol)((Object)framedShape);
    }

    @Override
    public GElement createCopy() {
        LayerClosedCompartmentAlias alias = (LayerClosedCompartmentAlias)super.createCopy();
        return alias;
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        return GUtil.union(super.getRepaintBounds(), this.nameImageBounds);
    }

    @Override
    public Rectangle2D update() {
        if (this.symbol == null) {
            return null;
        }
        Rectangle2D rtn = super.update();
        Object rtn2 = null;
        if (this.nameImageSize != null) {
            Rectangle2D.Double prev = this.nameImageBounds;
            this.nameImageBounds = this.createLabelBounds(super.getBounds(), this.nameImageSize);
            rtn2 = prev == null ? this.nameImageBounds : (prev.equals(this.nameImageBounds) ? null : GUtil.union(prev, this.nameImageBounds));
        }
        return GUtil.union(rtn, rtn2);
    }

    private Rectangle2D.Double createLabelBounds(Rectangle2D.Double myBounds, Dimension labelSize) {
        if (this.symbol == null) {
            return null;
        }
        double x = myBounds.x + (myBounds.width - (double)labelSize.width) / 2.0;
        double y = myBounds.y + myBounds.height - ((LayerCompartmentSymbol)((Object)this.symbol)).getThickness() - (double)labelSize.height;
        return new Rectangle2D.Double(x, y, labelSize.width, labelSize.height);
    }

    @Override
    public void draw(Graphics2D g2) {
        if (this.symbol == null) {
            return;
        }
        super.draw(g2);
    }

    @Override
    public void readDOMTree(Element element, Model model) {
    }

    public void readDOMTree(SBModel sbModel, Element element, Model model) {
    }

    @Override
    public void buildOutside(GStructure structure) {
        GContainer outsideAlias = structure.getOutside(this);
        if (outsideAlias != null) {
            GStructure.setContainerTarget(outsideAlias, this);
        }
    }

    private static void writePaintingDOMTree(StringBuffer buf, CompartmentShapePainting painting) {
        Membrane m = painting.getMembrane();
        buf.append("<celldesigner:doubleLine thickness=\"" + m.getThickness() + "\" outerWidth=\"" + m.getOuterLineWidth() + "\" innerWidth=\"" + m.getInnerLineWidth() + "\"/>\n");
        buf.append("<celldesigner:paint color=\"" + Integer.toHexString(painting.getColor().getRGB()) + "\" scheme=\"" + painting.getPaintScheme().getCode() + "\"/>\n");
    }

    @Override
    public boolean popupAvailable() {
        return true;
    }

    @Override
    public void showPopup(MouseEvent e, double x, double y, GStructure structure) {
        LayerSquarePopupMenu popup = LayerSquarePopupMenu.getInstance();
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    public String getType() {
        if (this.symbol instanceof LayerOvalSymbol) {
            return "Oval";
        }
        if (this.symbol instanceof LayerSquareSymbol) {
            return "Square";
        }
        return "";
    }

    @Override
    public String toSBML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<celldesigner:layerCompartmentAlias type=\"" + this.getType() + "\">\n");
        Rectangle2D.Double bounds = this.getFrameBounds();
        buf.append("<celldesigner:bounds x=\"" + bounds.x + "\" y=\"" + bounds.y + "\" w=\"" + bounds.width + "\" h=\"" + bounds.height + "\"/>\n");
        LayerCompartmentSymbol layerSymbol = (LayerCompartmentSymbol)((Object)this.getSymbol());
        CompartmentShapePainting shape = layerSymbol.getCompartmentShapePainting(false);
        CompartmentShapePainting shapeInner = layerSymbol.getCompartmentShapePainting(true);
        boolean innerdrawFlag = layerSymbol.isPaintInner();
        buf.append("<celldesigner:paint color=\"" + Integer.toHexString(shape.getColor().getRGB()) + "\" scheme=\"" + shape.getPaintScheme().getCode() + "\"/>\n");
        buf.append("<celldesigner:ispaint inner=\"" + String.valueOf(innerdrawFlag) + "\"/>\n");
        if (innerdrawFlag) {
            buf.append("<celldesigner:innerpaint color=\"" + Integer.toHexString(shapeInner.getColor().getRGB()) + "\" scheme=\"" + shapeInner.getPaintScheme().getCode() + "\"/>\n");
        }
        buf.append("</celldesigner:layerCompartmentAlias>\n");
        return buf.toString();
    }

    public void readDOMTree(Element element) {
        if (element == null) {
            return;
        }
        if (!element.hasChildNodes()) {
            return;
        }
        String type = element.getAttributeNS(null, "type");
        try {
            if (type.equals("Oval")) {
                LayerOvalSymbol ovalSymbol = (LayerOvalSymbol)SBFactory.createSymbol("LAYER_OVAL");
                this.setSymbol(ovalSymbol);
            } else if (type.equals("Square")) {
                LayerSquareSymbol squareSymbol = (LayerSquareSymbol)SBFactory.createSymbol("LAYER_SQUARE");
                this.setSymbol(squareSymbol);
            }
        }
        catch (Exception squareSymbol) {
            // empty catch block
        }
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        Node boundsNode = null;
        Node paintNode = null;
        Node paintInnerNode = null;
        Node ispaint = null;
        int i = 0;
        while (i < childsize) {
            Node node = childlist.item(i);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                String localName = node.getLocalName();
                if (localName.equals("bounds")) {
                    boundsNode = node;
                } else if (localName.equals("paint")) {
                    paintNode = node;
                } else if (localName.equals("innerpaint")) {
                    paintInnerNode = node;
                } else if (localName.equals("ispaint")) {
                    ispaint = node;
                }
            }
            ++i;
        }
        Rectangle2D.Double readBounds = this.readBoundsDOMTree((Element)boundsNode);
        this.setFramePosition(readBounds.x, readBounds.y);
        this.setFrameSize(readBounds.width, readBounds.height);
        String str_color = ((Element)paintNode).getAttributeNS(null, "color");
        String str_scheme = ((Element)paintNode).getAttributeNS(null, "scheme");
        String strIspaintInner = null;
        try {
            strIspaintInner = ((Element)ispaint).getAttributeNS(null, "inner");
        }
        catch (Exception e) {
            strIspaintInner = null;
        }
        boolean bPaintInner = false;
        if (strIspaintInner != null && strIspaintInner.trim().toLowerCase().equals("true")) {
            bPaintInner = true;
        }
        String str_colorInner = null;
        String str_schemeInner = null;
        if (bPaintInner) {
            str_colorInner = ((Element)paintInnerNode).getAttributeNS(null, "color");
            str_schemeInner = ((Element)paintInnerNode).getAttributeNS(null, "scheme");
        }
        long l = Long.parseLong(str_color, 16);
        LayerCompartmentSymbol layerSymbol = (LayerCompartmentSymbol)((Object)this.getSymbol());
        layerSymbol.setColor(new Color((int)l, true), false);
        layerSymbol.setPaintScheme(PaintSchemeFactory.createByCode(str_scheme), false);
        layerSymbol.setPaintInnerFlg(bPaintInner);
        if (bPaintInner) {
            long lInnercolor = Long.parseLong(str_colorInner, 16);
            layerSymbol.setColor(new Color((int)lInnercolor, true), true);
            layerSymbol.setPaintScheme(PaintSchemeFactory.createByCode(str_schemeInner), true);
        } else {
            layerSymbol.initInnerPaintColor();
        }
        Membrane m = new Membrane(1.0, 2.0, 1.0);
        ((LayerCompartmentSymbol)((Object)this.getSymbol())).setMembrane(m);
        this.update();
    }

    private Rectangle2D.Double readBoundsDOMTree(Element boundElement) {
        String str_x = boundElement.getAttributeNS(null, "x");
        String str_y = boundElement.getAttributeNS(null, "y");
        String str_w = boundElement.getAttributeNS(null, "w");
        String str_h = boundElement.getAttributeNS(null, "h");
        try {
            double x = Double.parseDouble(str_x);
            double y = Double.parseDouble(str_y);
            double w = Double.parseDouble(str_w);
            double h = Double.parseDouble(str_h);
            return new Rectangle2D.Double(x, y, w, h);
        }
        catch (Exception e) {
            return null;
        }
    }
}

