/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.layer.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jp.fric.graphics.draw.GMouseInterpreter;
import jp.fric.graphics.draw.GStructure;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.layer.LayerManager;
import jp.sbi.sbml.Notes;
import jp.sbi.sbml.SpecInfo;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.SBMLPanelLists;
import org.sbml.libsbml.SBase;

public class LayerTreePanel
extends JTree
implements KeyListener {
    GMouseInterpreter mouseInterpreter = null;
    SBMLPanelLists sbmlPanelLists = null;
    public static final String LAYER = "Layer";
    public static final String COMPARTMENT = "Compartments";
    public static final String SPECIES = "Species";
    public static final String REACTION = "Reactions";
    public static final String BASE = "base";
    TreePath compartmentPath = null;
    TreePath speciesPath = null;
    TreePath reactionPath = null;
    DefaultMutableTreeNode rootNode = null;
    DefaultMutableTreeNode baseNode = null;
    DefaultMutableTreeNode compartmentNode = null;
    DefaultMutableTreeNode speciesNode = null;
    DefaultMutableTreeNode reactionNode = null;
    boolean eventontree = true;
    boolean fromListEvent = false;
    Vector listOfRootNode = new Vector();
    private DefaultMutableTreeNode selectedNode;

    public LayerTreePanel(GMouseInterpreter mouseinterpreter) {
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new MyTreeCellRenderer1());
        this.mouseInterpreter = mouseinterpreter;
        this.rootNode = new DefaultMutableTreeNode(LAYER);
        this.baseNode = new DefaultMutableTreeNode(BASE);
        this.rootNode.add(this.baseNode);
        this.listOfRootNode.addElement(this.rootNode);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.expandRow(0);
        this.setModel(new DefaultTreeModel(this.rootNode));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                try {
                    if (MainWindow.getLastInstance().getCurrentModel().getUIType() == 2) {
                        return;
                    }
                }
                catch (Exception ex) {
                    return;
                }
                if (LayerTreePanel.this.getSelectionCount() > 1) {
                    return;
                }
                int selRow = LayerTreePanel.this.getRowForLocation(event.getX(), event.getY());
                LayerTreePanel.this.setSelectionRow(selRow);
                if ((event.getModifiers() & 4) != 0 && LayerTreePanel.this.getSelectionCount() > 0) {
                    LayerTreePanel.this.selectedNode = (DefaultMutableTreeNode)LayerTreePanel.this.getSelectionPath().getLastPathComponent();
                    if (LayerTreePanel.this.selectedNode.getUserObject() instanceof String || ((MyTreeLeafObject)LayerTreePanel.this.selectedNode.getUserObject()).obj instanceof SBModel) {
                        return;
                    }
                    LayerTreePanel.this.showMenu(event.getX(), event.getY());
                }
            }
        });
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.reload();
    }

    public void showMenu(int x, int y) {
        LayerManager m;
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem lock = new JMenuItem("Lock");
        lock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayerTreePanel.this.changeLockSelectedLayers();
            }
        });
        popupMenu.add(lock);
        JMenuItem inv = new JMenuItem("Invisible");
        inv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayerTreePanel.this.changeVisibleSelectedLayers();
            }
        });
        popupMenu.add(inv);
        JMenuItem mi = new JMenuItem("Delete Layer");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayerTreePanel.this.deleteSelectedLayers();
            }
        });
        popupMenu.add(mi);
        TreePath path = this.getSelectionPath();
        Object node = path.getLastPathComponent();
        if (node == this.getModel().getRoot()) {
            lock.setEnabled(false);
            inv.setEnabled(false);
            mi.setEnabled(false);
        }
        if ((m = (LayerManager)((MyTreeLeafObject)this.selectedNode.getUserObject()).obj).isLock()) {
            lock.setText("UnLock");
        }
        if (!m.isVisible()) {
            inv.setText("Visible");
        }
        popupMenu.show(this, x, y);
    }

    public void deleteSelectedLayers() {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.removeNodeFromParent(this.selectedNode);
        LayerManager m = (LayerManager)((MyTreeLeafObject)this.selectedNode.getUserObject()).obj;
        GStructure g = MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure();
        g.removeLayer(m);
    }

    public void changeLockSelectedLayers() {
        LayerManager m;
        m.setLock(!(m = (LayerManager)((MyTreeLeafObject)this.selectedNode.getUserObject()).obj).isLock());
        int[] selected = this.getSelectionRows();
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.reload();
        this.setSelectionRow(selected[0]);
    }

    public void changeVisibleSelectedLayers() {
        LayerManager m;
        m.setVisible(!(m = (LayerManager)((MyTreeLeafObject)this.selectedNode.getUserObject()).obj).isVisible());
        int[] selected = this.getSelectionRows();
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.reload();
        this.setSelectionRow(selected[0]);
    }

    public void removeNode(LayerManager removeLayer) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        int count = this.rootNode.getChildCount();
        int i = 0;
        while (i < count) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.rootNode.getChildAt(i);
            if (((MyTreeLeafObject)node.getUserObject()).obj == removeLayer) {
                model.removeNodeFromParent(node);
                break;
            }
            ++i;
        }
    }

    public void addNode(LayerManager newLayer, int index) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(newLayer.getName());
        MyTreeLeafObject obj = new MyTreeLeafObject(newLayer, newLayer.getName());
        node.setUserObject(obj);
        this.rootNode.insert(node, index);
        if (!(this.rootNode.getUserObject() instanceof MyTreeLeafObject)) {
            MyTreeLeafObject obj2 = new MyTreeLeafObject(MainWindow.getLastInstance().getCurrentModel().getSBModel(), LAYER);
            this.rootNode.setUserObject(obj2);
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.reload();
        this.addSelectionRow(1);
        MainWindow.getLastInstance().setLayerSymbolToolBarEnable(true);
    }

    /*
     * Unable to fully structure code
     */
    public LayerManager getSelectedLayer(Vector listOfLayer) {
        block5: {
            block6: {
                selected = this.getSelectionRows();
                selectedNode = null;
                try {
                    selectedNode = (DefaultMutableTreeNode)this.rootNode.getChildAt(selected[0] - 1);
                    break block5;
                }
                catch (Exception e) {
                    if (listOfLayer.size() <= 0) break block6;
                    i = 0;
                    ** while (i < listOfLayer.size())
                }
lbl-1000:
                // 1 sources

                {
                    if (((LayerManager)listOfLayer.get(i)).getId() != -99) {
                        return (LayerManager)listOfLayer.get(i);
                    }
                    ++i;
                    continue;
                }
            }
            return null;
        }
        if (selectedNode.getUserObject() instanceof String || MyTreeLeafObject.access$1((MyTreeLeafObject)selectedNode.getUserObject()) instanceof SBModel) {
            return null;
        }
        return LayerManager.getSelectedLayerManager(listOfLayer, MyTreeLeafObject.access$2((MyTreeLeafObject)selectedNode.getUserObject()));
    }

    public void setFromListEvent(boolean flg) {
        this.fromListEvent = flg;
    }

    public boolean isFromListEvent() {
        return this.fromListEvent;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.mouseInterpreter.setMultiSelectMode(false);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void setPanelLists(SBMLPanelLists sbmlPanelLists) {
        this.sbmlPanelLists = sbmlPanelLists;
    }

    public boolean isEventOnTree() {
        return this.eventontree;
    }

    public void setEventOnTree(boolean flg) {
        this.eventontree = flg;
    }

    public void createRootNode(GStructure g, SBModel sbModel) {
        boolean isExist = false;
        int i = 0;
        while (i < this.listOfRootNode.size()) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.listOfRootNode.get(i);
            if (!(root.getUserObject() instanceof String) && ((MyTreeLeafObject)root.getUserObject()).obj == sbModel) {
                isExist = true;
                break;
            }
            ++i;
        }
        if (!isExist) {
            this.rootNode = new DefaultMutableTreeNode(LAYER);
            MyTreeLeafObject obj2 = new MyTreeLeafObject(sbModel, LAYER);
            this.rootNode.setUserObject(obj2);
            if (g.getLayers().size() == 0) {
                return;
            }
            int i2 = g.getLayers().size();
            while (i2 > 0) {
                LayerManager m = (LayerManager)g.getLayers().get(--i2);
                if (m.getName().equals("LayerForTag")) continue;
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(m.getName());
                MyTreeLeafObject obj = new MyTreeLeafObject(m, m.getName());
                node.setUserObject(obj);
                this.rootNode.add(node);
            }
            this.baseNode = new DefaultMutableTreeNode(BASE);
            this.rootNode.add(this.baseNode);
            this.listOfRootNode.addElement(this.rootNode);
            this.setModel(new DefaultTreeModel(this.rootNode));
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            model.reload();
            this.eventontree = true;
            this.fromListEvent = false;
        }
    }

    public void setTreeNode() {
        if (MainWindow.getLastInstance().getCurrentModel() == null) {
            this.listOfRootNode = new Vector();
            this.rootNode = new DefaultMutableTreeNode(LAYER);
            this.baseNode = new DefaultMutableTreeNode(BASE);
            this.rootNode.add(this.baseNode);
            this.listOfRootNode.addElement(this.rootNode);
            this.putClientProperty("JTree.lineStyle", "Angled");
            this.expandRow(0);
            this.setModel(new DefaultTreeModel(this.rootNode));
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            model.reload();
        } else {
            GStructure g = MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure();
            boolean hit = false;
            int i = 0;
            while (i < this.listOfRootNode.size()) {
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.listOfRootNode.get(i);
                if (!(root.getUserObject() instanceof String) && ((MyTreeLeafObject)root.getUserObject()).obj == MainWindow.getLastInstance().getCurrentModel().getSBModel()) {
                    this.rootNode = root;
                    hit = true;
                    break;
                }
                ++i;
            }
            if (!hit) {
                this.rootNode = new DefaultMutableTreeNode(LAYER);
                MyTreeLeafObject obj2 = new MyTreeLeafObject(MainWindow.getLastInstance().getCurrentModel().getSBModel(), LAYER);
                this.rootNode.setUserObject(obj2);
                int i2 = 0;
                while (i2 < g.getLayers().size()) {
                    LayerManager m = (LayerManager)g.getLayers().get(i2);
                    if (!m.getName().equals("LayerForTag")) {
                        DefaultMutableTreeNode node = new DefaultMutableTreeNode(m.getName());
                        this.rootNode.add(node);
                        MyTreeLeafObject obj = new MyTreeLeafObject(m, m.getName());
                        node.setUserObject(obj);
                    }
                    ++i2;
                }
                this.baseNode = new DefaultMutableTreeNode(BASE);
                this.rootNode.add(this.baseNode);
                this.listOfRootNode.addElement(this.rootNode);
            }
            this.setModel(new DefaultTreeModel(this.rootNode));
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            model.reload();
            if (((MyTreeLeafObject)this.rootNode.getUserObject()).selectedRow != -1) {
                this.setSelectionRow(((MyTreeLeafObject)this.rootNode.getUserObject()).selectedRow);
            }
        }
        this.eventontree = true;
        this.fromListEvent = false;
    }

    public void addSelectedNode() {
        int[] selected = this.getSelectionRows();
        if (selected != null) {
            try {
                ((MyTreeLeafObject)this.rootNode.getUserObject()).selectedRow = selected[0];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Vector getSelectedNode(TreePath path) {
        Vector<Object> rtnval = new Vector<Object>();
        int pathnum = path.getPathCount();
        if (pathnum < 2) {
            return rtnval;
        }
        String type = path.getPathComponent(pathnum - 2).toString();
        if (type == null) {
            return rtnval;
        }
        String name = path.getLastPathComponent().toString();
        int noderow = this.getRowForPath(path);
        int titlerow = 0;
        int totalcount = 0;
        if (type.compareTo(SPECIES) == 0) {
            titlerow = this.getRowForPath(this.speciesPath);
            totalcount = this.speciesNode.getChildCount();
        } else if (type.compareTo(COMPARTMENT) == 0) {
            titlerow = this.getRowForPath(this.compartmentPath);
            totalcount = this.compartmentNode.getChildCount();
        } else if (type.compareTo(REACTION) == 0) {
            titlerow = this.getRowForPath(this.reactionPath);
            totalcount = this.reactionNode.getChildCount();
        } else {
            return rtnval;
        }
        rtnval.add(type);
        rtnval.add(new Integer(noderow - titlerow - 1));
        rtnval.add(new Integer(titlerow));
        rtnval.add(new Integer(totalcount));
        return rtnval;
    }

    public static final Vector getSystemReservedLayerNames() {
        Vector<String> rtn = new Vector<String>();
        rtn.add(LAYER);
        rtn.add(COMPARTMENT);
        rtn.add(SPECIES);
        rtn.add(REACTION);
        rtn.add(BASE);
        rtn.add("LayerForTag");
        return rtn;
    }

    class MyTreeCellRenderer1
    extends DefaultTreeCellRenderer {
        MyTreeCellRenderer1() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Object object = ((DefaultMutableTreeNode)value).getUserObject();
            if (LayerTreePanel.this.sbmlPanelLists == null || !(object instanceof MyTreeLeafObject)) {
                this.setToolTipText(null);
                return this;
            }
            MyTreeLeafObject obj = (MyTreeLeafObject)object;
            this.setToolTipText(this.getToolTip(obj.base));
            return this;
        }

        private String getToolTip(SBase base) {
            Notes notes = (Notes)LibSBMLUtil.getNotes(base, new SpecInfo());
            if (notes != null && !notes.getText().equals("")) {
                String text = notes.getText();
                return "<html><body>" + text + "</body></html>";
            }
            return null;
        }
    }

    class MyTreeLeafObject {
        private String type = "";
        private String id = "";
        private String name = "";
        private SBase base;
        private Object obj;
        private int selectedRow = -1;

        public MyTreeLeafObject(Object obj, String name) {
            this(null, null, name, null, obj);
        }

        public MyTreeLeafObject(String type, String id, String name) {
            this(type, id, name, null, null);
        }

        public MyTreeLeafObject(String type, String id, String name, SBase base, Object obj) {
            this.type = type;
            this.id = id;
            this.name = name;
            this.base = base;
            this.obj = obj;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public SBase getBase() {
            return this.base;
        }

        public String toString() {
            if (this.obj instanceof LayerManager) {
                LayerManager m = (LayerManager)this.obj;
                if (m.isLock() && !m.isVisible()) {
                    return String.valueOf(this.name) + " (locked,invisible)";
                }
                if (m.isLock() && m.isVisible()) {
                    return String.valueOf(this.name) + " (locked)";
                }
                if (!m.isLock() && !m.isVisible()) {
                    return String.valueOf(this.name) + " (invisible)";
                }
            }
            return this.name;
        }

        static /* synthetic */ String access$2(MyTreeLeafObject myTreeLeafObject) {
            return myTreeLeafObject.name;
        }
    }
}

