/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.layer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesAlias;

public class LayerTextInputDialog
extends JDialog {
    private LayerSpeciesAlias target;
    private JTextArea text;
    private JButton buttonOK;
    private JButton buttonCancel;
    private boolean isCancel;

    public LayerTextInputDialog(Object inputObj) {
        String oldInputString = "";
        if (inputObj == null) {
            return;
        }
        if (inputObj instanceof LayerSpeciesAlias) {
            this.target = (LayerSpeciesAlias)inputObj;
            oldInputString = this.target.getText();
        } else if (inputObj instanceof String) {
            oldInputString = (String)inputObj;
        } else {
            return;
        }
        this.setSize(200, 200);
        this.setTitle("Input text");
        this.getContentPane().setLayout(new BorderLayout());
        JScrollPane centerPanel = new JScrollPane();
        this.text = new JTextArea();
        this.text.setText(oldInputString);
        centerPanel.getViewport().add(this.text);
        this.getContentPane().add((Component)centerPanel, "Center");
        JPanel bottomPanel = new JPanel();
        this.buttonOK = new JButton("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (LayerTextInputDialog.this.text.getText().equals("")) {
                    JOptionPane.showMessageDialog(null, "Please input text.", "Warning", 1);
                    return;
                }
                LayerTextInputDialog.this.setVisible(false);
            }
        });
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LayerTextInputDialog.this.isCancel = true;
                LayerTextInputDialog.this.setVisible(false);
            }
        });
        bottomPanel.add(this.buttonOK);
        bottomPanel.add(this.buttonCancel);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.setResizable(true);
        this.setModal(true);
        this.setCenterLocation();
    }

    public boolean isCanceled() {
        return this.isCancel;
    }

    public String getText() {
        return this.text.getText();
    }

    private void setCenterLocation() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension thisSize = this.getSize();
        if (thisSize.height > screenSize.height) {
            thisSize.height = screenSize.height;
        }
        if (thisSize.width > screenSize.width) {
            thisSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - thisSize.width) / 2, (screenSize.height - thisSize.height) / 2);
    }
}

