/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.layer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LayerTagNameInputDialog
extends JDialog {
    private JTextField text;
    private JButton buttonOK;
    private JButton buttonCancel;
    private boolean isCancel;

    public LayerTagNameInputDialog(String name) {
        this.setSize(300, 100);
        this.setTitle("TagName");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        JLabel label = new JLabel("Name    ");
        centerPanel.add(label);
        this.text = new JTextField(name);
        this.text.setPreferredSize(new Dimension(200, 20));
        centerPanel.add(this.text);
        this.getContentPane().add((Component)centerPanel, "Center");
        JPanel bottomPanel = new JPanel();
        this.buttonOK = new JButton("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (LayerTagNameInputDialog.this.text.getText().trim().equals("")) {
                    JOptionPane.showMessageDialog(null, "Please input name.", "Warning", 1);
                    return;
                }
                LayerTagNameInputDialog.this.setVisible(false);
            }
        });
        this.rootPane.setDefaultButton(this.buttonOK);
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LayerTagNameInputDialog.this.isCancel = true;
                LayerTagNameInputDialog.this.setVisible(false);
            }
        });
        bottomPanel.add(this.buttonOK);
        bottomPanel.add(this.buttonCancel);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.setResizable(false);
        this.setModal(true);
        this.setCenterLocation();
    }

    public boolean isCanceled() {
        return this.isCancel;
    }

    public String getText() {
        return this.text.getText();
    }

    private void setCenterLocation() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension thisSize = this.getSize();
        if (thisSize.height > screenSize.height) {
            thisSize.height = screenSize.height;
        }
        if (thisSize.width > screenSize.width) {
            thisSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - thisSize.width) / 2, (screenSize.height - thisSize.height) / 2);
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.isCancel = true;
            this.setVisible(false);
            return;
        }
        super.processWindowEvent(e);
    }
}

