/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.layer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sbi.celldesigner.layer.LayerManager;
import jp.sbi.celldesigner.layer.swing.LayerTreePanel;

public class LayerNameInputDialog
extends JDialog {
    private JTextField text;
    private JButton buttonOK;
    private JButton buttonCancel;
    private boolean isCancel;
    private Vector layerNames = LayerTreePanel.getSystemReservedLayerNames();

    public LayerNameInputDialog(Vector layers, String name) {
        if (layers != null && layers.size() > 0) {
            int i = 0;
            while (i < layers.size()) {
                try {
                    LayerManager lm = (LayerManager)layers.get(i);
                    if (lm.getName() != null) {
                        this.layerNames.add(lm.getName());
                    }
                }
                catch (Exception lm) {
                    // empty catch block
                }
                ++i;
            }
        }
        this.setSize(300, 100);
        this.setTitle("LayerNameInputDialog");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        JLabel label = new JLabel("Layer Name");
        centerPanel.add(label);
        this.text = new JTextField(name);
        this.text.setPreferredSize(new Dimension(200, 20));
        centerPanel.add(this.text);
        this.getContentPane().add((Component)centerPanel, "Center");
        JPanel bottomPanel = new JPanel();
        this.buttonOK = new JButton("Add Layer");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (LayerNameInputDialog.this.text.getText().trim().equals("")) {
                    JOptionPane.showMessageDialog(null, "Please input layer name.", "Warning", 1);
                    return;
                }
                if (LayerNameInputDialog.this.layerNames.contains(LayerNameInputDialog.this.text.getText())) {
                    JOptionPane.showMessageDialog(null, "This name already exists. Use another name.", "Warning", 1);
                    return;
                }
                LayerNameInputDialog.this.setVisible(false);
            }
        });
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LayerNameInputDialog.this.isCancel = true;
                LayerNameInputDialog.this.setVisible(false);
            }
        });
        bottomPanel.add(this.buttonOK);
        bottomPanel.add(this.buttonCancel);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.setResizable(false);
        this.setModal(true);
        this.setCenterLocation();
    }

    public boolean isCanceled() {
        return this.isCancel;
    }

    public String getText() {
        return this.text.getText();
    }

    private void setCenterLocation() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension thisSize = this.getSize();
        if (thisSize.height > screenSize.height) {
            thisSize.height = screenSize.height;
        }
        if (thisSize.width > screenSize.width) {
            thisSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - thisSize.width) / 2, (screenSize.height - thisSize.height) / 2);
    }
}

