/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.layer.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import jp.sbi.celldesigner.NameImage;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerTagSymbol;

public class ExtendedNameImage
extends NameImage {
    private boolean isTurn;
    private LayerSpeciesSymbol symbol;
    private int rowCount;
    private double columnWidth;
    private int rowLength;
    private int thisRow;
    private int px;
    private int py;
    private int iTextSpacePx = 2;

    public Dimension draw(Graphics2D g2, int px, int py, boolean isRealDraw) {
        RenderingHints backup = g2.getRenderingHints();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.px = px;
        this.py = py;
        if (this.isTurn) {
            return new Dimension(0, 0);
        }
        int w = 0;
        int h = 0;
        Color originalcolor = g2.getColor();
        g2.setColor(this.symbol.getFontColor());
        Font fontOld = g2.getFont();
        Font fontNew = new Font(fontOld.getName(), fontOld.getStyle(), this.getLayerTextFontSize());
        g2.setFont(fontNew);
        this.rowCount = (int)((this.symbol.getSymbolBounds().height - (double)this.iTextSpacePx) / (double)(this.getLayerTextFontSize() + this.iTextSpacePx));
        this.thisRow = 0;
        if (this.symbol instanceof LayerTagSymbol) {
            this.rowCount = (int)((((LayerTagSymbol)this.symbol).getTextBounds().height - (double)this.iTextSpacePx) / (double)(this.getLayerTextFontSize() + this.iTextSpacePx));
            this.columnWidth = ((LayerTagSymbol)this.symbol).getTextBounds().width;
        } else {
            this.columnWidth = this.symbol.getSymbolBounds().width;
        }
        String[] items = this.getString().split("\n");
        int i = 0;
        while (i < items.length) {
            String data = items[i];
            char[] array = data.toCharArray();
            if (data.equals("")) {
                ++this.thisRow;
            } else {
                this.drawString(g2, data, array, 0);
            }
            ++i;
        }
        g2.setFont(fontOld);
        g2.setColor(originalcolor);
        g2.setRenderingHints(backup);
        return new Dimension(w, h);
    }

    private void drawString(Graphics2D g2, String data, char[] array, int startIndex) {
        double targetLength = 0.0;
        int index = startIndex;
        FontMetrics fm = g2.getFontMetrics();
        while (this.thisRow < this.rowCount && startIndex < array.length) {
            int iLeftTopY;
            int iLeftTopX;
            targetLength = 0.0;
            while (index < array.length) {
                char c = array[index];
                if (!(this.columnWidth > targetLength + (double)fm.charWidth(c) + 3.0)) break;
                targetLength += (double)fm.charWidth(c);
                ++index;
            }
            if (this.symbol instanceof LayerTagSymbol) {
                iLeftTopX = (int)((LayerTagSymbol)this.symbol).getTextBounds().getX();
                iLeftTopY = (int)((LayerTagSymbol)this.symbol).getTextBounds().getY() + this.getLayerTextFontSize();
            } else {
                iLeftTopX = (int)this.symbol.getSymbolBounds().getX();
                iLeftTopY = (int)this.symbol.getSymbolBounds().getY() + this.getLayerTextFontSize();
            }
            int iTextX = iLeftTopX + 2;
            int iTextY = iLeftTopY + 2 + this.thisRow * (this.getLayerTextFontSize() + this.iTextSpacePx);
            g2.drawString(data.substring(startIndex, index), iTextX, iTextY);
            startIndex = index;
            ++this.thisRow;
        }
    }

    public void setSymbol(LayerSpeciesSymbol symbol) {
        this.symbol = symbol;
    }
}

