/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.layer;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Vector;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GElementImpl;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerClosedCompartmentAlias;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerCompartmentAlias;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerReactionLink;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesAlias;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayerManager {
    private int id;
    private String name;
    private boolean isVisible;
    private boolean isLock;
    private ArrayList listOfTexts;
    private ArrayList listOfFreeLines;
    private ArrayList listOfSquares;
    private static int LAYER_ID_COUNT = 0;
    private static int LAYER_SYMBOL_ID_COUNT = 0;

    public LayerManager() {
        this.listOfTexts = new ArrayList();
        this.listOfFreeLines = new ArrayList();
        this.listOfSquares = new ArrayList();
    }

    public LayerManager(String name, int id) {
        this.name = name;
        this.id = id;
        ++LAYER_ID_COUNT;
        this.listOfTexts = new ArrayList();
        this.listOfFreeLines = new ArrayList();
        this.listOfSquares = new ArrayList();
        this.isVisible = true;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isLock() {
        return this.isLock;
    }

    public void setLock(boolean isLock) {
        this.isLock = isLock;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public ArrayList getListOfFreeLines() {
        if (this.listOfFreeLines == null) {
            this.listOfFreeLines = new ArrayList();
        }
        return this.listOfFreeLines;
    }

    public void setListOfFreeLines(ArrayList listOfFreeLines) {
        this.listOfFreeLines = listOfFreeLines;
    }

    public void addFreeLines(GElement line) {
        this.listOfFreeLines.add(line);
    }

    public void removeFreeLines(GElement line) {
        this.listOfFreeLines.remove(line);
    }

    public ArrayList getListOfSquares() {
        return this.listOfSquares;
    }

    public void setListOfSquares(ArrayList listOfSquares) {
        this.listOfSquares = listOfSquares;
    }

    public void addSquares(GElement square) {
        this.listOfSquares.add(square);
    }

    public void removeSquares(GElement square) {
        this.listOfSquares.remove(square);
    }

    public ArrayList getListOfTexts() {
        if (this.listOfTexts == null) {
            this.listOfTexts = new ArrayList();
        }
        return this.listOfTexts;
    }

    public void setListOfTexts(ArrayList listOfTexts) {
        this.listOfTexts = listOfTexts;
    }

    public void addTexts(GElement t) {
        this.listOfTexts.add(t);
    }

    public void removeTexts(GElement t) {
        this.listOfTexts.remove(t);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static LayerManager getSelectedLayerManager(Vector list, String name) {
        int i = 0;
        while (i < list.size()) {
            LayerManager m = (LayerManager)list.get(i);
            if (m.getName().equals(name)) {
                return m;
            }
            ++i;
        }
        return null;
    }

    public static LayerManager getSelectedLayerManager(Vector list, int id) {
        int i = 0;
        while (i < list.size()) {
            LayerManager m = (LayerManager)list.get(i);
            if (m.getId() == id) {
                return m;
            }
            ++i;
        }
        return null;
    }

    public static Vector getLayerSymbol(Vector listOfLayers, Object element) {
        Vector<LayerSpeciesAlias> returnVector = new Vector<LayerSpeciesAlias>();
        int i = 0;
        while (i < listOfLayers.size()) {
            Object s;
            LayerSpeciesAlias alias;
            int k;
            Object target;
            LayerManager m = (LayerManager)listOfLayers.get(i);
            ArrayList listOfTexts = m.getListOfTexts();
            if (element instanceof SpeciesAlias) {
                target = (SpeciesAlias)element;
                k = 0;
                while (k < listOfTexts.size()) {
                    alias = (LayerSpeciesAlias)listOfTexts.get(k);
                    if (alias.getTargetAlias() instanceof SpeciesAlias && (s = (SpeciesAlias)alias.getTargetAlias()).getName().equals(target.getName())) {
                        returnVector.addElement(alias);
                    }
                    ++k;
                }
            } else if (element instanceof CompartmentAlias) {
                target = (CompartmentAlias)element;
                k = 0;
                while (k < listOfTexts.size()) {
                    alias = (LayerSpeciesAlias)listOfTexts.get(k);
                    if (alias.getTargetAlias() instanceof CompartmentAlias && (s = (CompartmentAlias)alias.getTargetAlias()).getCompartmentName().equals(target.getCompartmentName())) {
                        returnVector.addElement(alias);
                    }
                    ++k;
                }
            } else if (element instanceof ReactionLink) {
                target = (ReactionLink)element;
                k = 0;
                while (k < listOfTexts.size()) {
                    alias = (LayerSpeciesAlias)listOfTexts.get(k);
                    if (alias.getTargetAlias() instanceof ReactionLink && ((GLink)(s = (ReactionLink)alias.getTargetAlias())).getName().equals(((GLink)target).getName())) {
                        returnVector.addElement(alias);
                    }
                    ++k;
                }
            }
            ++i;
        }
        return returnVector;
    }

    public String toSBML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<celldesigner:layer id=\"" + this.id + "\" name=\"" + StringTool.toEscape(this.name) + "\" locked=\"" + this.isLock + "\" visible=\"" + this.isVisible + "\"");
        if (this.listOfTexts.size() == 0 && this.listOfSquares.size() == 0 && this.listOfFreeLines.size() == 0) {
            buf.append("/>\n");
        } else {
            int i;
            buf.append(">\n");
            if (this.listOfTexts.size() > 0) {
                buf.append("<celldesigner:listOfTexts>\n");
                i = 0;
                while (i < this.listOfTexts.size()) {
                    LayerSpeciesAlias text = (LayerSpeciesAlias)this.listOfTexts.get(i);
                    buf.append(text.toSBML());
                    ++i;
                }
                buf.append("</celldesigner:listOfTexts>\n");
            }
            if (this.listOfSquares.size() > 0) {
                buf.append("<celldesigner:listOfSquares>\n");
                i = 0;
                while (i < this.listOfSquares.size()) {
                    LayerCompartmentAlias com = (LayerCompartmentAlias)this.listOfSquares.get(i);
                    buf.append(com.toSBML());
                    ++i;
                }
                buf.append("</celldesigner:listOfSquares>\n");
            }
            if (this.listOfFreeLines.size() > 0) {
                buf.append("<celldesigner:listOfFreeLines>\n");
                i = 0;
                while (i < this.listOfFreeLines.size()) {
                    LayerReactionLink link = (LayerReactionLink)this.listOfFreeLines.get(i);
                    buf.append(link.toSBML());
                    ++i;
                }
                buf.append("</celldesigner:listOfFreeLines>\n");
            }
            buf.append("</celldesigner:layer>\n");
        }
        return buf.toString();
    }

    public void readDOMTree(Element element, GStructure gStructure) {
        if (element == null) {
            return;
        }
        if (!element.hasChildNodes()) {
            return;
        }
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        int i = 0;
        while (i < childsize) {
            Node node = childlist.item(i);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                GElementImpl alias;
                Element elem2;
                Node node2;
                int k;
                int childsizetexts;
                NodeList childlistTexts;
                Element elem = (Element)node;
                String tag = elem.getLocalName();
                if (tag.equals("listOfTexts")) {
                    childlistTexts = node.getChildNodes();
                    childsizetexts = childlistTexts.getLength();
                    k = 0;
                    while (k < childsizetexts) {
                        node2 = childlistTexts.item(k);
                        if (node2.getNodeType() == 1 && node2.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && (elem2 = (Element)childlistTexts.item(k)).getLocalName().equals("layerSpeciesAlias")) {
                            alias = new LayerSpeciesAlias();
                            ((LayerSpeciesAlias)alias).readDOMTree(elem2, gStructure);
                            this.addTexts(alias);
                            ((LayerSpeciesAlias)alias).setBelong_layer_id(this.id);
                            ((LayerSpeciesAlias)alias).update();
                        }
                        ++k;
                    }
                } else if (tag.equals("listOfSquares")) {
                    childlistTexts = node.getChildNodes();
                    childsizetexts = childlistTexts.getLength();
                    k = 0;
                    while (k < childsizetexts) {
                        node2 = childlistTexts.item(k);
                        if (node2.getNodeType() == 1 && node2.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && (elem2 = (Element)childlistTexts.item(k)).getLocalName().equals("layerCompartmentAlias")) {
                            alias = new LayerClosedCompartmentAlias();
                            ((LayerClosedCompartmentAlias)alias).readDOMTree(elem2);
                            this.addSquares(alias);
                            ((LayerClosedCompartmentAlias)alias).setBelong_layer_id(this.id);
                        }
                        ++k;
                    }
                } else if (tag.equals("listOfFreeLines")) {
                    childlistTexts = node.getChildNodes();
                    childsizetexts = childlistTexts.getLength();
                    k = 0;
                    while (k < childsizetexts) {
                        node2 = childlistTexts.item(k);
                        if (node2.getNodeType() == 1 && node2.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && (elem2 = (Element)childlistTexts.item(k)).getLocalName().equals("layerFreeLine")) {
                            LayerReactionLink link = new LayerReactionLink(1, 1);
                            link.readDOMTree(elem2);
                            this.addFreeLines(link);
                            link.setBelong_layer_id(this.id);
                        }
                        ++k;
                    }
                }
            }
            ++i;
        }
    }

    public static final Rectangle2D updateLayerSymbolLinkPostion(Vector listOfLayers, Object element) {
        Rectangle2D.Double rtn = null;
        try {
            Vector obj = LayerManager.getLayerSymbol(listOfLayers, element);
            if (obj.size() > 0) {
                LayerSpeciesAlias target = (LayerSpeciesAlias)obj.get(0);
                rtn = GUtil.union(rtn, target.updateLink());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rtn;
    }
}

