/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.database;

import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.eml.sdbv.sabioclient.GetGeneralReactionEquation;
import org.eml.sdbv.sabioclient.GetKinLawIDs;
import org.eml.sdbv.sabioclient.GetReactionIDFromEC;
import org.eml.sdbv.sabioclient.GetReactionInstanceIDs;
import org.eml.sdbv.sabioclient.Sabiork;
import org.eml.sdbv.sabioclient.SabiorkServiceLocator;
import org.eml.sdbv.sabioclient.SearchEnzymesByName;

public class SabioTest {
    public static void main(String[] args) {
        String ec = "2.7.1.2";
        SabiorkServiceLocator service = new SabiorkServiceLocator();
        try {
            Sabiork port = service.getsabiorkPort();
            String[] enzymeNames = port.searchEnzymesByName(new SearchEnzymesByName("Fumarate"));
            System.out.println(enzymeNames.length);
            int i = 0;
            while (i < enzymeNames.length) {
                System.out.println(String.valueOf(i) + ": " + enzymeNames[i]);
                ++i;
            }
            System.exit(0);
            GetReactionIDFromEC griec = new GetReactionIDFromEC("2.7.1.2");
            int[] rids = port.getReactionIDFromEC(griec);
            String name = "Glucokinase";
            System.out.println("rid:" + rids[0] + "  [" + port.getGeneralReactionEquation(new GetGeneralReactionEquation(rids[0])).get_return() + "]");
            long sFast = 0L;
            long sSingle = 0L;
            long sSlow = 0L;
            int[] instance = null;
            int benchTimes = 20;
            int j = 0;
            while (j < 20) {
                long start = System.currentTimeMillis();
                instance = port.getReactionInstanceIDs(new GetReactionInstanceIDs(rids[0]));
                long end = System.currentTimeMillis();
                long fast = end - start;
                sFast += fast;
                System.out.println("  getReactionInstanceIDs: " + instance.length + " instances: " + fast + " msec");
                start = System.currentTimeMillis();
                port.getKinLawIDs(new GetKinLawIDs(instance[0]));
                end = System.currentTimeMillis();
                long single = end - start;
                sSingle += single;
                System.out.println("  getKinLawIDs: 1 instance: " + single + " msec");
                start = System.currentTimeMillis();
                int i2 = 0;
                while (i2 < instance.length) {
                    port.getKinLawIDs(new GetKinLawIDs(instance[i2]));
                    ++i2;
                }
                end = System.currentTimeMillis();
                long slow = end - start;
                sSlow += slow;
                System.out.println("  getKinLawIDs: " + instance.length + " instances: " + slow + " msec");
                System.out.println();
                ++j;
            }
            System.out.println("Result: ");
            System.out.println(" Array        " + sFast / 20L + " msec");
            System.out.println(" 1 instance   " + sSingle / 20L + " msec");
            System.out.println(" iteration  " + sSlow / 20L + " msec");
            System.exit(0);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }
}

