/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.database;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableModel;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import jp.co.mki.celldesigner.simulation.util.MyProgressBar;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.NameTranslator;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.util.ColumnResizer;
import jp.sbi.celldesigner.util.IncrementalComboKeyHandler;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.SBMLPanelLists;
import jp.sbi.sbml.util.SBaseListPanel;
import net.miginfocom.swing.MigLayout;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.FunctionDefinition;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.ListOfFunctionDefinitions;
import org.sbml.libsbml.ListOfParameters;
import org.sbml.libsbml.ListOfReactions;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.ListOfSpeciesReferences;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.ModifierSpeciesReference;
import org.sbml.libsbml.OStream;
import org.sbml.libsbml.OStringStream;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLReader;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesReference;
import org.sbml.libsbml.UnitDefinition;
import org.sbml.libsbml.libsbml;

public class SabioRKRestful
extends JDialog
implements ActionListener,
HyperlinkListener {
    private static final long serialVersionUID = 6403624846626471049L;
    private boolean isOffline = false;
    private final String TITLE = "Import kineticLaw from SABIO-RK";
    private static SabioRKRestful singletonInstance = null;
    private final boolean enableDebugMappingMath = false;
    private static final String URL_BASE = "http://sabio.h-its.org/sabioRestWebServices/";
    private static final String URL_SEARCH = "http://sabio.h-its.org/sabioRestWebServices/searchKineticLaws/sbml/";
    private static final String URL_SUGGEST = "http://sabio.h-its.org/sabioRestWebServices/suggestions/";
    private static final String URL_KINETICLAW = "http://sabio.h-its.org/sabioRestWebServices/kineticLaws/";
    private static final String URL_SABIOWEB = "http://sabiork.h-its.org/kindatadirectiframe.jsp?newinterface=true&kinlawid=";
    String postStr = "q=liver glucose homo sapiens hasKineticData:true";
    private static final String prefDirPath = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".celldesigner";
    private static final String fileTissuesList = String.valueOf(prefDirPath) + System.getProperty("file.separator") + "tissueList" + ".ser";
    private static final String fileOrganismsList = String.valueOf(prefDirPath) + System.getProperty("file.separator") + "organismList" + ".ser";
    private SBModelFrame currentSBFrame;
    private static ArrayList<SabioReaction> reactionsList;
    private static ArrayList<String> organismsList;
    private static ArrayList<String> tissuesList;
    private JPanel reactionPanel;
    private JComboBox cmbTissue;
    private JComboBox cmbOrganism;
    private JTextField txtFieldTissue;
    private JTextField txtFieldOrganism;
    private JTable reactionsTable;
    private DefaultTableModel tblModelReactions;
    private JTextField textEnzymeSearch;
    private JButton btnEnzymeSearchByName;
    private JButton btnImportKineticLaw;
    private JButton btnClose;
    private JScrollPane reactionScrollpane;
    private JEditorPane htmlPane;
    private JScrollPane htmlTableScrollpane;
    private SBMLDocument sabioSBML;
    private static MyProgressBar progressBar;
    private static ProgressBarTask progressBarTask;
    private static Thread progressBarThread;
    private JPanel progressBarPanel;
    Thread handlerThread = null;

    static {
        progressBar = new MyProgressBar(0, 100);
    }

    public static synchronized SabioRKRestful createInstance(SBModelFrame currentSBFrame) {
        if (singletonInstance == null) {
            singletonInstance = new SabioRKRestful(currentSBFrame);
        }
        return singletonInstance;
    }

    public synchronized void setCurrentSBFrame(SBModelFrame currentSBFrame) {
        this.currentSBFrame = currentSBFrame;
    }

    protected SabioRKRestful(SBModelFrame currentSBFrame) {
        super(MainWindow.getLastInstance());
        this.postConstructor();
        this.currentSBFrame = currentSBFrame;
        this.setBounds(10, 10, 650, 600);
    }

    public SabioRKRestful() {
        this.postConstructor();
    }

    private void postConstructor() {
        this.setTitle("Import kineticLaw from SABIO-RK");
        reactionsList = new ArrayList();
        organismsList = new ArrayList();
        tissuesList = new ArrayList();
    }

    public void init(JFrame frame) {
        if (this.createDialog()) {
            this.showDialog(frame);
        } else {
            this.showErrorDialog(frame);
        }
    }

    public String getSabioRKKineticRecord(Reaction r) {
        KineticLaw kl = r.getKineticLaw();
        long i = 0L;
        while (i < kl.getCVTerms().getSize()) {
            long j = 0L;
            while (j < (long)kl.getCVTerm(i).getResources().getLength()) {
                String uri = kl.getCVTerm(i).getResourceURI(j);
                if (uri.startsWith("urn:miriam:sabiork.kineticrecord")) {
                    String[] strArray = uri.split(":");
                    String rtn = strArray[strArray.length - 1];
                    return rtn;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private void removeReactionsExceptOne(Reaction r) {
        ListOfReactions lr = this.sabioSBML.getModel().getListOfReactions();
        long i = lr.size() - 1L;
        while (i >= 0L) {
            Reaction r2 = lr.get(i);
            if (!r.getId().equals(r2.getId())) {
                lr.remove(i);
            }
            --i;
        }
    }

    private void generateSBMLFromSelectedReaction() {
        block5: {
            int row = this.reactionsTable.getSelectedRow();
            if (row != -1) {
                try {
                    SabioReaction sr = reactionsList.get(row);
                    this.removeReactionsExceptOne(sr.getReaction());
                    this.removeUnusedSBaseFromSBML(this.sabioSBML);
                    SabioRKRestful.startProgressBarTask("Downloading");
                    String sbml = this.getXmlStringBySendRequest(URL_KINETICLAW + sr.getSabioId(), "level=2&version=4");
                    SabioRKRestful.stopProgressBarTask();
                    if (sbml.startsWith("No result")) {
                        this.currentSBFrame.showErrorMessage(sbml);
                        break block5;
                    }
                    this.addSBMLInfoToModel(sbml);
                }
                catch (Exception e) {
                    StringWriter stw = new StringWriter();
                    PrintWriter pw = new PrintWriter(stw);
                    e.printStackTrace(pw);
                    String errMsg = e.getMessage();
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, errMsg, "Error", 0);
                }
            } else {
                return;
            }
        }
    }

    private void addSBMLInfoToModel(String sbmlString) throws Exception {
        SBaseListPanel spPanelOfReaction;
        KineticLaw curKl;
        Object[] options;
        String title;
        int selected;
        ListOfFunctionDefinitions lof;
        ArrayList<UnitDefinition> addedUnitDefinitions;
        ArrayList<FunctionDefinition> addedFunctionDefinitions;
        Model curModel;
        SBMLPanelLists sbmlPanelLists;
        Reaction reacSelected;
        KineticLaw mappedKineticLaw;
        Reaction reacSabio;
        Model m;
        boolean editFlag;
        block49: {
            editFlag = false;
            SBMLReader r = new SBMLReader();
            SBMLDocument d = r.readSBMLFromString(sbmlString);
            if (d.getNumErrors() > 0L) {
                OStringStream oss = new OStringStream();
                d.printErrors((OStream)oss);
                throw new Exception("SABIO's SBML file is invalid" + oss.str());
            }
            m = d.getModel();
            reacSabio = null;
            int i = 0;
            while ((long)i < m.getNumReactions()) {
                if (m.getReaction((long)i).isSetKineticLaw()) {
                    reacSabio = m.getReaction((long)i);
                    break;
                }
                ++i;
            }
            if (reacSabio == null) {
                throw new Exception("No reaction returned by SABIO.");
            }
            if (reacSabio.getKineticLaw() == null) {
                throw new Exception("No KineticLaw in a reaction returned by SABIO.");
            }
            if (reacSabio.getKineticLaw().getMath() == null) {
                throw new Exception("No math of KineticLaw in a reaction returned by SABIO.");
            }
            System.err.println(String.valueOf(d.getLevel()) + " " + d.getVersion() + " " + d.getModel().getName());
            System.err.println("Species #: " + d.getModel().getNumSpecies());
            System.err.println("Reactions #: " + d.getModel().getNumReactions());
            System.err.println("Global Parameters #: " + d.getModel().getNumParameters());
            System.err.println("Local Parameters #: " + reacSabio.getKineticLaw().getNumParameters());
            System.err.println("Functions #: " + d.getModel().getNumFunctionDefinitions());
            System.err.println("UnitDefinitions #: " + d.getModel().getNumUnitDefinitions());
            mappedKineticLaw = null;
            reacSelected = null;
            if (this.currentSBFrame == null) {
                throw new Exception("No model is opened.");
            }
            Object obj = this.currentSBFrame.getSelectedObject();
            if (obj == null) {
                throw new Exception("No reaction selected in the current model.");
            }
            if (obj instanceof ReactionLink) {
                reacSelected = ((ReactionLink)obj).getParentReaction();
                if (reacSelected == null) {
                    throw new Exception("Null selected reaction.");
                }
                mappedKineticLaw = this.getMappedKineticLaw(reacSabio, reacSelected);
                if (mappedKineticLaw == null) {
                    return;
                }
                ASTNode importKlMath = mappedKineticLaw.getMath();
                HashMap<String, String> kinArg = new HashMap<String, String>();
                int indexReact = 0;
                int i2 = 0;
                while ((long)i2 < importKlMath.getNumChildren()) {
                    SpeciesReference sprReact;
                    String argId;
                    SpeciesReference sprProd;
                    ASTNode argMath = importKlMath.getChild((long)i2);
                    if (argMath != null && (sprProd = reacSelected.getProduct(argId = argMath.getName())) != null && (sprReact = reacSelected.getReactant((long)indexReact++)) != null) {
                        kinArg.put(sprProd.getSpecies(), sprReact.getSpecies());
                    }
                    ++i2;
                }
                for (Map.Entry ent : kinArg.entrySet()) {
                    String prodId = (String)ent.getKey();
                    String reactId = (String)ent.getValue();
                    LibSBMLUtil.changeASTNodeName(importKlMath, prodId, reactId, 0);
                }
            } else {
                throw new Exception("No reaction selected in the current model.");
            }
            SBModel sbModel = this.currentSBFrame.getSBModel();
            if (sbModel == null) {
                throw new Exception("[FATAL] Null SBModel");
            }
            sbmlPanelLists = sbModel.getSBMLPanelLists();
            if (sbmlPanelLists == null) {
                throw new Exception("[FATAL] Null SBMLPanelLists");
            }
            curModel = this.currentSBFrame.getSBModel().getModel();
            addedFunctionDefinitions = new ArrayList<FunctionDefinition>();
            addedUnitDefinitions = new ArrayList<UnitDefinition>();
            if (m.getNumFunctionDefinitions() <= 0L) break block49;
            lof = m.getListOfFunctionDefinitions();
            int i3 = 0;
            while ((long)i3 < lof.size()) {
                block51: {
                    FunctionDefinition fd;
                    block50: {
                        fd = (FunctionDefinition)lof.get((long)i3);
                        FunctionDefinition existingFD = curModel.getFunctionDefinition(fd.getId());
                        if (existingFD == null) break block50;
                        String existingMathStr = libsbml.formulaToString((ASTNode)existingFD.getMath());
                        String newMathStr = libsbml.formulaToString((ASTNode)fd.getMath());
                        if (newMathStr.equals(existingMathStr)) break block51;
                        String oldId = fd.getId();
                        StringBuffer newUSId = new StringBuffer(String.valueOf(oldId) + "_x");
                        while (curModel.getFunctionDefinition(newUSId.toString()) != null) {
                            newUSId.append("x");
                        }
                        String newId = newUSId.toString();
                        fd.setId(newId);
                        ASTNode newMath = mappedKineticLaw.getMath();
                        LibSBMLUtil.changeASTNodeName(newMath, oldId, newId, 4);
                    }
                    addedFunctionDefinitions.add(fd);
                }
                ++i3;
            }
        }
        if (m.getNumUnitDefinitions() > 0L) {
            lof = m.getListOfUnitDefinitions();
            int i = 0;
            while ((long)i < lof.size()) {
                UnitDefinition ud = lof.get((long)i);
                UnitDefinition existingUD = curModel.getUnitDefinition(ud.getId());
                if (existingUD != null) {
                    if (!UnitDefinition.areEquivalent((UnitDefinition)existingUD, (UnitDefinition)ud)) {
                        String oldId = ud.getId();
                        StringBuffer newUSId = new StringBuffer(String.valueOf(oldId) + "_x");
                        while (curModel.getUnitDefinition(newUSId.toString()) != null) {
                            newUSId.append("x");
                        }
                        String newId = newUSId.toString();
                        ud.setId(newId);
                        ListOfParameters lop = mappedKineticLaw.getListOfParameters();
                        int k = 0;
                        while ((long)k < lop.size()) {
                            Parameter lp = lop.get((long)k);
                            if (lp.getUnits().equals(oldId)) {
                                lp.setUnits(newId);
                            }
                            ++k;
                        }
                    }
                } else {
                    addedUnitDefinitions.add(ud);
                }
                ++i;
            }
        }
        if ((selected = SabioRKRestful.showConfirmationDialogForKineticLaw(title = "Confirmation Dialog", reacSelected, mappedKineticLaw, addedFunctionDefinitions, addedUnitDefinitions, 2, this, options = new String[]{"Cancel", "OK"})) != 1) {
            return;
        }
        if (addedFunctionDefinitions.size() > 0 || addedUnitDefinitions.size() > 0) {
            editFlag = true;
        }
        for (FunctionDefinition fd : addedFunctionDefinitions) {
            this.currentSBFrame.getSBModel().getModel().addFunctionDefinition(fd);
        }
        for (UnitDefinition ud : addedUnitDefinitions) {
            this.currentSBFrame.getSBModel().getModel().addUnitDefinition(ud);
        }
        SBaseListPanel spPanelOfFunctionDefinition = sbmlPanelLists.getSBaseListPanel(0);
        if (spPanelOfFunctionDefinition == null) {
            throw new Exception("[FATAL] SBaseListPanel of FunctionDefinition is null.");
        }
        spPanelOfFunctionDefinition.updateDialog();
        SBaseListPanel spPanelOfUnitDefinition = sbmlPanelLists.getSBaseListPanel(1);
        if (spPanelOfUnitDefinition == null) {
            throw new Exception("[FATAL] SBaseListPanel of UnitDefinition is null.");
        }
        spPanelOfUnitDefinition.updateDialog();
        String metaIdKl = mappedKineticLaw.getMetaId();
        if (!metaIdKl.equals("") && ((curKl = reacSelected.getKineticLaw()) == null || curKl != null && !curKl.getMetaId().equals(metaIdKl))) {
            String newMetaId = mappedKineticLaw.getMetaId();
            if (LibSBMLUtil.checkDuplicatedMetaId(newMetaId, curModel)) {
                StringBuffer modMetaId = new StringBuffer(String.valueOf(newMetaId) + "_x");
                while (LibSBMLUtil.checkDuplicatedMetaId(modMetaId.toString(), curModel)) {
                    modMetaId.append("x");
                }
                newMetaId = modMetaId.toString();
            }
            mappedKineticLaw.setMetaId(newMetaId);
        }
        reacSelected.setKineticLaw(mappedKineticLaw);
        if (reacSabio.getAnnotation() != null) {
            if (!reacSabio.getMetaId().equals("")) {
                String newMetaId = reacSabio.getMetaId();
                if (!reacSelected.getMetaId().equals(newMetaId)) {
                    if (LibSBMLUtil.checkDuplicatedMetaId(newMetaId, curModel)) {
                        StringBuffer modMetaId = new StringBuffer(String.valueOf(newMetaId) + "_x");
                        while (LibSBMLUtil.checkDuplicatedMetaId(modMetaId.toString(), curModel)) {
                            modMetaId.append("x");
                        }
                        newMetaId = modMetaId.toString();
                    }
                    reacSelected.setMetaId(newMetaId);
                }
            }
            reacSelected.setAnnotation(reacSabio.getAnnotation());
        }
        if ((spPanelOfReaction = sbmlPanelLists.getSBaseListPanel(6)) == null) {
            throw new Exception("[FATAL] SBaseListPanel of Reaction is null.");
        }
        spPanelOfReaction.updateDialog();
        SBaseListPanel spPanelOfParameter = sbmlPanelLists.getSBaseListPanel(4);
        if (spPanelOfParameter != null) {
            ListOfParameters lop = reacSelected.getKineticLaw().getListOfParameters();
            String parentReactionId = reacSelected.getId();
            int i = 0;
            while ((long)i < lop.size()) {
                Parameter localParameter = lop.get((long)i);
                localParameter.setAnnotation(LibSBMLUtil.addEnclosedAnnotationTags(parentReactionId));
                ++i;
            }
        } else {
            throw new Exception("[FATAL] SBaseListPanel of Parameter is null.");
        }
        spPanelOfParameter.updateDialog();
        JOptionPane.showMessageDialog(null, "Kinetic information is successfully imported.", "Result", 1);
        this.currentSBFrame.getSBModel().setChanged(editFlag);
    }

    private KineticLaw getMappedKineticLaw(Reaction reacFrom, Reaction reacTo) throws Exception {
        KineticLaw mappedKineticLaw = reacFrom.getKineticLaw();
        String errMsgHeader = "Selected SABIO-RK's kineticlaw can't be imported to the selected Reaction (" + reacTo.getId() + ") in CellDesigner.\n";
        if (mappedKineticLaw == null) {
            throw new Exception(String.valueOf(errMsgHeader) + "The SABIO-RK's kineticlaw is null.");
        }
        if (mappedKineticLaw.getMath() == null) {
            throw new Exception(String.valueOf(errMsgHeader) + "A math of the SABIO-RK's kineticlaw is null.");
        }
        ASTNode math = mappedKineticLaw.getMath();
        String title = "Mapping SpeciesReferences ID";
        boolean isModal = true;
        MappingSpeciesReferenceIdDialog dialog = new MappingSpeciesReferenceIdDialog(this, title, isModal, reacFrom, reacTo);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        mappedKineticLaw = dialog.getMappedKineticLaw();
        return mappedKineticLaw;
    }

    private void setEnabledSearchGUI(boolean b) {
        this.btnEnzymeSearchByName.setEnabled(b);
        this.textEnzymeSearch.setEditable(b);
        this.cmbOrganism.setEnabled(b);
        this.cmbTissue.setEnabled(b);
    }

    private void removeAllElements(DefaultTableModel dataModel) {
        int i = dataModel.getRowCount() - 1;
        while (i >= 0) {
            dataModel.removeRow(i);
            --i;
        }
    }

    public SBMLDocument parseResultSBML(String sbml, SBMLDocument d) throws Exception {
        Reaction reacSelected = null;
        if (this.currentSBFrame == null) {
            throw new Exception("No model is opened.");
        }
        Object obj = this.currentSBFrame.getSelectedObject();
        if (obj == null) {
            throw new Exception("No reaction selected in the current model.");
        }
        if (obj instanceof ReactionLink && (reacSelected = ((ReactionLink)obj).getParentReaction()) == null) {
            throw new Exception("Null selected reaction.");
        }
        long numProd = reacSelected.getNumProducts();
        long numReac = reacSelected.getNumReactants();
        long numMod = reacSelected.getNumModifiers();
        d = libsbml.readSBMLFromString((String)sbml);
        ListOfReactions lr = d.getModel().getListOfReactions();
        long orgNumReac = lr.size();
        long i = lr.size() - 1L;
        while (i >= 0L) {
            Reaction reacSabio = lr.get(i);
            if (reacSabio.getNumReactants() != numReac || reacSabio.getNumProducts() != numProd || reacSabio.getNumModifiers() != numMod) {
                lr.remove(i);
            } else {
                String sid;
                String equation = "";
                long j = 0L;
                while (j < reacSabio.getNumReactants()) {
                    sid = reacSabio.getReactant(j).getSpecies();
                    if (j != 0L) {
                        equation = String.valueOf(equation) + " + ";
                    }
                    equation = String.valueOf(equation) + d.getModel().getSpecies(sid).getName();
                    ++j;
                }
                equation = reacSabio.getReversible() ? String.valueOf(equation) + "  <-->  " : String.valueOf(equation) + "  --->  ";
                j = 0L;
                while (j < reacSabio.getNumProducts()) {
                    sid = reacSabio.getProduct(j).getSpecies();
                    if (j != 0L) {
                        equation = String.valueOf(equation) + " + ";
                    }
                    equation = String.valueOf(equation) + d.getModel().getSpecies(sid).getName();
                    ++j;
                }
                SabioReaction sr = new SabioReaction(this.getSabioRKKineticRecord(reacSabio), equation, reacSabio);
                reactionsList.add(sr);
            }
            --i;
        }
        Collections.sort(reactionsList, new SabioReactionComparator());
        if (lr.size() != orgNumReac) {
            d = this.removeUnusedSBaseFromSBML(d);
        }
        this.createReactionTable();
        return d;
    }

    private SBMLDocument removeUnusedSBaseFromSBML(SBMLDocument d) {
        ListOfReactions lr = d.getModel().getListOfReactions();
        HashSet<String> speciesRefSet = new HashSet<String>();
        long i = lr.size() - 1L;
        while (i >= 0L) {
            String sid;
            Reaction r = lr.get(i);
            long j = 0L;
            while (j < r.getNumReactants()) {
                sid = r.getReactant(j).getSpecies();
                speciesRefSet.add(sid);
                ++j;
            }
            j = 0L;
            while (j < r.getNumProducts()) {
                sid = r.getProduct(j).getSpecies();
                speciesRefSet.add(sid);
                ++j;
            }
            j = 0L;
            while (j < r.getNumModifiers()) {
                sid = r.getModifier(j).getSpecies();
                speciesRefSet.add(sid);
                ++j;
            }
            --i;
        }
        ListOfSpecies ls = d.getModel().getListOfSpecies();
        long i2 = ls.size() - 1L;
        while (i2 >= 0L) {
            String id = ls.get(i2).getId();
            if (!speciesRefSet.contains(id)) {
                ls.remove(i2);
            }
            --i2;
        }
        return d;
    }

    public synchronized boolean createHandlerThread(ActionEvent ev) {
        if (this.handlerThread == null) {
            SabioRequestHandler handler = new SabioRequestHandler(ev);
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String msg;
        int answer;
        this.currentSBFrame = MainWindow.getLastInstance().getCurrentModel();
        if ((ev.getSource() == this.btnEnzymeSearchByName || ev.getSource() == this.textEnzymeSearch) && this.txtFieldOrganism.getText().trim().equals("") && this.txtFieldTissue.getText().trim().equals("") && (answer = JOptionPane.showConfirmDialog(null, msg = "You haven't specified Organism nor Tissue.\nThis might take a while to obtain the result.\nDo you wish to proceed the search?", "Confirmation", 1, 2)) != 0) {
            return;
        }
        if (!this.createHandlerThread(ev)) {
            return;
        }
    }

    private void createProgressBar() {
        progressBarTask = new ProgressBarTask(this);
        this.progressBarPanel = new JPanel(new BorderLayout());
        this.progressBarPanel.setPreferredSize(new Dimension(this.getSize().width, 20));
        this.progressBarPanel.add((Component)progressBar, "East");
        this.getContentPane().add((Component)this.progressBarPanel, "South");
    }

    public boolean createDialog() {
        if (!this.connectToSabio()) {
            return false;
        }
        MainWindow.startProgressBarTask("Preparing for SABIO-RK");
        this.createReactionPanel();
        this.getContentPane().add((Component)this.reactionPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.createProgressBar();
        this.pack();
        MainWindow.stopProgressBarTask();
        return true;
    }

    private void createReactionPanel() {
        String objName = this.convertSBEditStrToSNameStr(this.getSelectedObjectName());
        if (objName == null) {
            objName = "Enzyme Name";
        }
        this.textEnzymeSearch = new JTextField(objName);
        this.textEnzymeSearch.setToolTipText("Type in Enzyme name");
        this.textEnzymeSearch.addActionListener(this);
        this.cmbTissue = new JComboBox<Object>(tissuesList.toArray());
        this.cmbTissue.setEditable(true);
        this.cmbTissue.setSelectedIndex(-1);
        this.txtFieldTissue = (JTextField)this.cmbTissue.getEditor().getEditorComponent();
        this.txtFieldTissue.setText("");
        this.txtFieldTissue.addKeyListener(new IncrementalComboKeyHandler(this.cmbTissue));
        this.cmbOrganism = new JComboBox<Object>(organismsList.toArray());
        this.cmbOrganism.setEditable(true);
        this.cmbOrganism.setSelectedIndex(-1);
        this.txtFieldOrganism = (JTextField)this.cmbOrganism.getEditor().getEditorComponent();
        this.txtFieldOrganism.setText("");
        this.txtFieldOrganism.addKeyListener(new IncrementalComboKeyHandler(this.cmbOrganism));
        this.reactionPanel = new JPanel((LayoutManager)new MigLayout("", "[][grow,fill]", "[][][][][c, grow 25, fill][c, grow 75, fill][]"));
        this.reactionPanel.add(new JLabel("Search query"));
        this.reactionPanel.add((Component)this.textEnzymeSearch, "grow, wrap");
        this.reactionPanel.add(new JLabel("Organism"));
        this.reactionPanel.add((Component)this.cmbOrganism, "grow, wrap");
        this.reactionPanel.add(new JLabel("Tissue"));
        this.reactionPanel.add((Component)this.cmbTissue, "grow, wrap");
        this.btnEnzymeSearchByName = new JButton("Search");
        this.btnEnzymeSearchByName.addActionListener(this);
        this.reactionPanel.add((Component)this.btnEnzymeSearchByName, "wrap");
        this.tblModelReactions = this.createTableModelReactions();
        this.reactionsTable = new JTable(this.tblModelReactions){
            private static final long serialVersionUID = -6060087153395712925L;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                SabioRKRestful.this.btnImportKineticLaw.setEnabled(true);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.reactionScrollpane = new JScrollPane(this.reactionsTable, 20, 30);
        this.reactionScrollpane.setPreferredSize(new Dimension(620, 120));
        this.reactionPanel.add((Component)this.reactionScrollpane, "span, grow, wrap");
        this.htmlPane = new JEditorPane();
        this.htmlPane.setContentType("text/html");
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(this);
        this.htmlTableScrollpane = new JScrollPane(this.htmlPane, 20, 30);
        this.htmlTableScrollpane.setPreferredSize(new Dimension(620, 250));
        this.reactionPanel.add((Component)this.htmlTableScrollpane, "span, grow, wrap");
        this.reactionsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = SabioRKRestful.this.reactionsTable.getSelectedRow();
                SabioReaction sr = (SabioReaction)reactionsList.get(row);
                try {
                    SabioRKRestful.startProgressBarTask("Loading kinetic data");
                    SabioRKRestful.this.htmlPane.setPage(SabioRKRestful.URL_SABIOWEB + sr.getSabioId());
                    SabioRKRestful.stopProgressBarTask();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        });
        this.btnImportKineticLaw = new JButton("Import KineticLaw");
        this.btnImportKineticLaw.addActionListener(this);
        this.btnImportKineticLaw.setEnabled(false);
        this.btnClose = new JButton("Close");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SabioRKRestful.this.confirmExit();
            }
        });
        this.reactionPanel.add((Component)this.btnImportKineticLaw, "left");
        this.reactionPanel.add((Component)this.btnClose, "right, grow 0");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SabioRKRestful.this.confirmExit();
            }
        });
    }

    private void createReactionTable() {
        Object[] row = new String[2];
        for (SabioReaction sr : reactionsList) {
            row[0] = String.valueOf(sr.getSabioId());
            row[1] = sr.getEquation();
            this.tblModelReactions.addRow(row);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColumnResizer.adjustColumnPreferredWidthsWithHeader(SabioRKRestful.this.reactionsTable);
                SabioRKRestful.this.reactionsTable.revalidate();
            }
        });
    }

    void confirmExit() {
        String msg = "Are you sure you want to close SABIO-RK dialog?";
        int answer = JOptionPane.showConfirmDialog(this, msg, "Confirm Exit", 0);
        if (answer == 0) {
            this.postProcess();
        }
    }

    void postProcess() {
        if (this.handlerThread != null) {
            this.handlerThread.stop();
            this.handlerThread = null;
        }
        SabioRKRestful.stopProgressBarTask();
        this.setEnabledSearchGUI(true);
        this.dispose();
    }

    void gridBagAddComponent(GridBagLayout gb, JPanel panel, Component cmp, int x, int y, int w, int h) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gb.setConstraints(cmp, gbc);
        panel.add(cmp);
    }

    public static void paintImmediately() {
        progressBar.paintImmediately(progressBar.getVisibleRect());
    }

    public static void startProgressBarTask(String s) {
        progressBarThread = new Thread(progressBarTask);
        final String str = s;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressBar.setDrawString(str);
                progressBar.setActive(true);
            }
        });
        progressBarThread.start();
    }

    public static void stopProgressBarTask() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressBar.setDrawString("");
                progressBar.setActive(false);
                progressBar.setDrawStart(0);
                SabioRKRestful.paintImmediately();
            }
        });
        progressBarThread = null;
    }

    public void resetReactionPanel() {
        String defaultEnzyme = "";
        String objName = this.convertSBEditStrToSNameStr(this.getSelectedObjectName());
        if (objName == null) {
            objName = defaultEnzyme;
        }
        this.textEnzymeSearch.setText(objName);
        this.tblModelReactions = this.createTableModelReactions();
        this.reactionsTable.setModel(this.tblModelReactions);
        this.htmlPane.setText("");
    }

    private String convertSBEditStrToSNameStr(String objName) {
        if (objName == null) {
            return objName;
        }
        String objSBName = NameTranslator.sname2sbedit(objName);
        if (objSBName != null && objSBName.contains("~")) {
            objName = objSBName.replace("~", " ");
        }
        return objName;
    }

    private String getSelectedObjectName() {
        String name = null;
        if (this.currentSBFrame != null) {
            Reaction reaction;
            ListOfSpeciesReferences lom;
            Object obj = this.currentSBFrame.getSelectedObject();
            if (obj instanceof SpeciesAlias) {
                SpeciesAlias sa = (SpeciesAlias)obj;
                Species species = sa.getOriginalSpecies();
                name = species.getName();
            } else if (obj instanceof CompartmentAlias) {
                Compartment compartment = ((CompartmentAlias)obj).getOriginalCompartment();
                name = compartment.getName();
            } else if (obj instanceof ReactionLink && (lom = (reaction = ((ReactionLink)obj).getParentReaction()).getListOfModifiers()).size() > 0L) {
                String sid = ((ModifierSpeciesReference)lom.get(0L)).getSpecies();
                name = this.currentSBFrame.getSBModel().getModel().getSpecies(sid).getName();
            }
        }
        return name;
    }

    public boolean isSabioUp() {
        if (this.getXmlStringBySendRequest("http://sabio.h-its.org/sabioRestWebServices/status", "").equals("UP")) {
            this.isOffline = false;
            return true;
        }
        this.isOffline = true;
        return false;
    }

    private DefaultTableModel createTableModelReactions() {
        DefaultTableModel tm = new DefaultTableModel();
        tm.addColumn("id");
        tm.addColumn("Equation");
        return tm;
    }

    private boolean connectToSabio() {
        if (this.isOffline) {
            return true;
        }
        try {
            if (!this.isSabioUp()) {
                this.showErrorDialog(MainWindow.getLastInstance());
            }
            tissuesList = this.getListOfTissues();
            organismsList = this.getListOfOrganisms();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public InputStream sendRequest(String urlString, String postString) {
        InputStream is = null;
        try {
            URL url = new URL(urlString);
            URLConnection uc = url.openConnection();
            uc.setDoOutput(true);
            uc.setRequestProperty("User-Agent", "CellDesigner4.3.0");
            uc.setRequestProperty("Accept-Language", "en");
            OutputStream os = uc.getOutputStream();
            PrintStream ps = new PrintStream(os);
            ps.print(postString);
            ps.close();
            is = uc.getInputStream();
        }
        catch (MalformedURLException e) {
            System.err.println("Invalid URL format: " + urlString);
        }
        catch (IOException e) {
            System.err.println("Can't connect to " + urlString);
        }
        return is;
    }

    public String getXmlStringBySendRequest(String urlString, String postString) {
        String xmlString = null;
        try {
            xmlString = this.convertStreamToString(this.sendRequest(urlString, postString));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return xmlString;
    }

    public String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    public ArrayList<String> getListOfGeneric(String arg) throws Exception {
        String filename;
        ArrayList alist;
        if (arg.equals("Tissue")) {
            alist = tissuesList;
            filename = fileTissuesList;
        } else if (arg.equals("Organism")) {
            alist = organismsList;
            filename = fileOrganismsList;
        } else {
            return null;
        }
        File file = new File(filename);
        if (file.canRead()) {
            FileInputStream inFile = new FileInputStream(file);
            ObjectInputStream inObject = new ObjectInputStream(inFile);
            alist = (ArrayList)inObject.readObject();
            inObject.close();
            inFile.close();
        } else {
            MainWindow.startProgressBarTask("Downloading from SABIO-RK");
            InputStream in = this.sendRequest(URL_SUGGEST + arg + "s", "");
            this.generateListFromXMLStream(in, alist, arg);
            this.serializeListToFile(alist, filename);
            MainWindow.stopProgressBarTask();
        }
        return alist;
    }

    private void serializeListToFile(List<String> list, String file) throws Exception {
        FileOutputStream outFile = new FileOutputStream(file);
        ObjectOutputStream outObject = new ObjectOutputStream(outFile);
        outObject.writeObject(list);
        outObject.close();
        outFile.close();
    }

    public ArrayList<String> getListOfTissues() throws Exception {
        return this.getListOfGeneric("Tissue");
    }

    public ArrayList<String> getListOfOrganisms() throws Exception {
        return this.getListOfGeneric("Organism");
    }

    public ArrayList<String> generateListFromXMLStream(InputStream in, ArrayList<String> lo, String target) {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
            while (eventReader.hasNext()) {
                StartElement startElement;
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement() || !(startElement = event.asStartElement()).getName().getLocalPart().equals(target)) continue;
                lo.add(eventReader.getElementText());
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return lo;
    }

    public void showDialog(JFrame frame) {
        this.setVisible(true);
    }

    public void showErrorDialog(JFrame frame) {
        JOptionPane.showMessageDialog(frame, "Can't connect to SABIO-RK web service.", "Import kineticLaw from SABIO-RK", 1);
    }

    public static String getUnitNameFromId(String id, ArrayList<UnitDefinition> udList) {
        for (UnitDefinition ud : udList) {
            if (!ud.getId().equals(id)) continue;
            return ud.getName();
        }
        return id;
    }

    public static int showConfirmationDialogForKineticLaw(String title, Reaction reacSelected, KineticLaw mappedKineticLaw, ArrayList<FunctionDefinition> fdList, ArrayList<UnitDefinition> udList, int mtype, Component parent, Object[] options) {
        Object[] row;
        boolean textBased = false;
        int xsize = 640;
        int ysize = 320;
        JTextArea tareaKineticLawMath = null;
        JTextArea tareaKineticLawParameter = null;
        JTextArea tareaFunctionDefinition = null;
        JTextArea tareaUnitDefinition = null;
        JScrollPane scrpKineticLawMath = null;
        JScrollPane scrpKineticLawParameter = null;
        JScrollPane scrpFunctionDefinition = null;
        JScrollPane scrpUnitDefinition = null;
        JTabbedPane jtabRoot = new JTabbedPane();
        JPanel jtabKineticLaw = new JPanel();
        jtabKineticLaw.setLayout(new BoxLayout(jtabKineticLaw, 1));
        JTextField mathLabel = new JTextField("Math");
        mathLabel.setEditable(false);
        jtabKineticLaw.add(mathLabel);
        String kineticLawMathString = mappedKineticLaw.getFormula();
        tareaKineticLawMath = new JTextArea("\n  " + kineticLawMathString + "\n");
        tareaKineticLawMath.setLineWrap(true);
        tareaKineticLawMath.setWrapStyleWord(true);
        tareaKineticLawMath.setEditable(false);
        scrpKineticLawMath = new JScrollPane(20, 31);
        scrpKineticLawMath.getViewport().add(tareaKineticLawMath);
        scrpKineticLawMath.setPreferredSize(new Dimension(640, 320));
        jtabKineticLaw.add(scrpKineticLawMath);
        JTextField paraLabel = new JTextField("Local Parameters");
        paraLabel.setEditable(false);
        jtabKineticLaw.add(paraLabel);
        if (mappedKineticLaw.getNumParameters() > 0L) {
            Parameter para;
            scrpKineticLawParameter = new JScrollPane(20, 31);
            if (textBased) {
                StringBuffer textParameters = new StringBuffer();
                int i = 0;
                while ((long)i < mappedKineticLaw.getNumParameters()) {
                    para = mappedKineticLaw.getParameter((long)i);
                    textParameters.append(String.valueOf(para.getId()) + " ");
                    textParameters.append(String.valueOf(para.getName()) + " ");
                    textParameters.append(String.valueOf(para.getValue()) + " ");
                    textParameters.append(String.valueOf(para.getUnits()) + " ");
                    textParameters.append(para.getConstant());
                    textParameters.append("\n");
                    ++i;
                }
                tareaKineticLawParameter = new JTextArea(textParameters.toString());
                tareaKineticLawParameter.setLineWrap(true);
                tareaKineticLawParameter.setWrapStyleWord(true);
                tareaKineticLawParameter.setEditable(false);
                scrpKineticLawParameter.getViewport().add(tareaKineticLawParameter);
            } else {
                DefaultTableModel tblParameters = new DefaultTableModel();
                tblParameters.addColumn("id");
                tblParameters.addColumn("name");
                tblParameters.addColumn("value");
                tblParameters.addColumn("units");
                tblParameters.addColumn("constant");
                int i = 0;
                while ((long)i < mappedKineticLaw.getNumParameters()) {
                    para = mappedKineticLaw.getParameter((long)i);
                    Object[] row2 = new String[]{para.getId(), para.getName(), String.valueOf(para.getValue()), SabioRKRestful.getUnitNameFromId(para.getUnits(), udList), String.valueOf(para.getConstant())};
                    tblParameters.addRow(row2);
                    ++i;
                }
                final JTable parameterTable = new JTable(tblParameters){
                    private static final long serialVersionUID = 7165876606021128791L;

                    @Override
                    public boolean isCellEditable(int row, int col) {
                        return false;
                    }
                };
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ColumnResizer.adjustColumnPreferredWidthsWithHeader(parameterTable);
                        parameterTable.revalidate();
                    }
                });
                scrpKineticLawParameter.getViewport().add(parameterTable);
            }
            scrpKineticLawParameter.setPreferredSize(new Dimension(640, 320));
            jtabKineticLaw.add(scrpKineticLawParameter);
        }
        int tabNum = 0;
        jtabRoot.add(jtabKineticLaw);
        jtabRoot.setTitleAt(tabNum++, "KineticLaw");
        if (fdList.size() > 0) {
            scrpFunctionDefinition = new JScrollPane(20, 31);
            if (textBased) {
                StringBuffer textFunctionDefinitions = new StringBuffer();
                for (FunctionDefinition fd : fdList) {
                    StringBuffer arguments = new StringBuffer();
                    int i = 0;
                    while ((long)i < fd.getNumArguments()) {
                        arguments.append(fd.getArgument((long)i).getName());
                        if ((long)i != fd.getNumArguments() - 1L) {
                            arguments.append(",");
                        }
                        ++i;
                    }
                    textFunctionDefinitions.append(String.valueOf(fd.getId()) + " ");
                    textFunctionDefinitions.append(String.valueOf(arguments.toString()) + " ");
                    textFunctionDefinitions.append(String.valueOf(libsbml.formulaToString((ASTNode)fd.getBody())) + " ");
                    textFunctionDefinitions.append("\n");
                }
                tareaFunctionDefinition = new JTextArea(textFunctionDefinitions.toString());
                tareaFunctionDefinition.setLineWrap(true);
                tareaFunctionDefinition.setWrapStyleWord(true);
                tareaFunctionDefinition.setEditable(false);
                scrpFunctionDefinition.getViewport().add(tareaFunctionDefinition);
            } else {
                DefaultTableModel tblFunctionDefinitions = new DefaultTableModel();
                tblFunctionDefinitions.addColumn("id");
                tblFunctionDefinitions.addColumn("arguments");
                tblFunctionDefinitions.addColumn("math");
                for (FunctionDefinition fd : fdList) {
                    row = new String[3];
                    StringBuffer arguments = new StringBuffer();
                    int i = 0;
                    while ((long)i < fd.getNumArguments()) {
                        arguments.append(fd.getArgument((long)i).getName());
                        if ((long)i != fd.getNumArguments() - 1L) {
                            arguments.append(",");
                        }
                        ++i;
                    }
                    row[0] = fd.getId();
                    row[1] = arguments.toString();
                    row[2] = libsbml.formulaToString((ASTNode)fd.getBody());
                    tblFunctionDefinitions.addRow(row);
                }
                final JTable fdTable = new JTable(tblFunctionDefinitions){
                    private static final long serialVersionUID = -8189097012462241995L;

                    @Override
                    public boolean isCellEditable(int row, int col) {
                        return false;
                    }
                };
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ColumnResizer.adjustColumnPreferredWidthsWithHeader(fdTable);
                        fdTable.revalidate();
                    }
                });
                scrpFunctionDefinition.getViewport().add(fdTable);
            }
            scrpFunctionDefinition.setPreferredSize(new Dimension(640, 320));
            jtabRoot.add(scrpFunctionDefinition);
            jtabRoot.setTitleAt(tabNum++, "FunctionDefinition");
        }
        if (udList.size() > 0) {
            scrpUnitDefinition = new JScrollPane(20, 31);
            if (textBased) {
                StringBuffer textUnitDefinitions = new StringBuffer();
                for (UnitDefinition ud : udList) {
                    textUnitDefinitions.append(String.valueOf(ud.getId()) + " ");
                    textUnitDefinitions.append(String.valueOf(ud.getName()) + " ");
                    textUnitDefinitions.append(UnitDefinition.printUnits((UnitDefinition)ud));
                    textUnitDefinitions.append("\n");
                }
                tareaUnitDefinition = new JTextArea(textUnitDefinitions.toString());
                tareaUnitDefinition.setLineWrap(true);
                tareaUnitDefinition.setWrapStyleWord(true);
                tareaUnitDefinition.setEditable(false);
                scrpUnitDefinition.getViewport().add(tareaUnitDefinition);
            } else {
                DefaultTableModel tblUnitDefinitions = new DefaultTableModel();
                tblUnitDefinitions.addColumn("id");
                tblUnitDefinitions.addColumn("name");
                tblUnitDefinitions.addColumn("units");
                for (UnitDefinition ud : udList) {
                    row = new String[]{ud.getId(), ud.getName(), UnitDefinition.printUnits((UnitDefinition)ud, (boolean)true)};
                    tblUnitDefinitions.addRow(row);
                }
                final JTable udTable = new JTable(tblUnitDefinitions){
                    private static final long serialVersionUID = 8466851484558399256L;

                    @Override
                    public boolean isCellEditable(int row, int col) {
                        return false;
                    }
                };
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ColumnResizer.adjustColumnPreferredWidthsWithHeader(udTable);
                        udTable.revalidate();
                    }
                });
                scrpUnitDefinition.getViewport().add(udTable);
            }
            scrpUnitDefinition.setPreferredSize(new Dimension(640, 320));
            jtabRoot.add(scrpUnitDefinition);
            jtabRoot.setTitleAt(tabNum++, "UnitDefinition");
        }
        jtabRoot.setPreferredSize(new Dimension(640, 320));
        jtabRoot.setVisible(true);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JTextArea tareaMessage = new JTextArea();
        tareaMessage.append("\n\n  The following KineticLaw (in Reaction \"" + reacSelected.getId() + "\") and its dependent elements (if any)\n" + "  will be imported by clicking \"OK\" button below.\n\n");
        tareaMessage.setEditable(false);
        panel.add(tareaMessage);
        panel.add(jtabRoot);
        JOptionPane jpane = new JOptionPane(panel, mtype);
        jpane.setOptions(options);
        JDialog dialog = jpane.createDialog(parent, title);
        dialog.setResizable(true);
        dialog.setVisible(true);
        Object selectedValue = jpane.getValue();
        int selected = 0;
        int i = 0;
        while (i < options.length) {
            if (options[i].equals(selectedValue)) {
                selected = i;
                break;
            }
            ++i;
        }
        return selected;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent arg0) {
    }

    public static void main(String[] args) {
        SabioRKRestful sabio = new SabioRKRestful();
        sabio.init(null);
    }

    class MappingSpeciesReferenceIdDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 4893558705711643572L;
        private JPanel mainPanel;
        private JPanel mainPanelRev;
        private JPanel currentMainPanel;
        private Reaction reacFrom;
        private Reaction reacTo;
        private HashMap<String, ArrayList<String>> reactIdMap;
        private HashMap<String, ArrayList<String>> productIdMap;
        private HashMap<String, ArrayList<String>> reactIdRevMap;
        private HashMap<String, ArrayList<String>> productIdRevMap;
        private HashMap<String, ArrayList<String>> modifierIdMap;
        private HashMap<String, ArrayList<String>> modifierIdRevMap;
        private KineticLaw mappedKineticLaw;
        private boolean isCanceled;
        private ArrayList<JComboBox> reactCBList;
        private ArrayList<JComboBox> productCBList;
        private ArrayList<JComboBox> reactRevCBList;
        private ArrayList<JComboBox> productRevCBList;
        private ArrayList<JComboBox> modifierCBList;
        private ArrayList<JComboBox> modifierRevCBList;
        boolean enableSwap;

        private ArrayList<SpeciesListItem> getSelectedSPListArray(ArrayList<JComboBox> arrayJCB) {
            ArrayList<SpeciesListItem> array = new ArrayList<SpeciesListItem>();
            for (JComboBox cb : arrayJCB) {
                array.add((SpeciesListItem)cb.getSelectedItem());
            }
            return array;
        }

        public void mergeKineticLaw(boolean isRev) {
            this.mappedKineticLaw = this.reacFrom.getKineticLaw();
            if (!isRev) {
                this.changeSpeciesIDInASTNode(this.reactCBList);
                this.changeSpeciesIDInASTNode(this.productCBList);
                this.changeSpeciesIDInASTNode(this.modifierCBList);
            } else {
                this.changeSpeciesIDInASTNode(this.reactRevCBList);
                this.changeSpeciesIDInASTNode(this.productRevCBList);
                this.changeSpeciesIDInASTNode(this.modifierRevCBList);
            }
        }

        private void changeSpeciesIDInASTNode(ArrayList<JComboBox> cbList) {
            if (this.mappedKineticLaw == null) {
                return;
            }
            ASTNode math = this.mappedKineticLaw.getMath();
            for (SpeciesListItem sl : this.getSelectedSPListArray(cbList)) {
                String fromId = sl.getSpeciesFrom().getId();
                String toId = sl.getSpeciesTo().getId();
                LibSBMLUtil.changeASTNodeName(math, toId, fromId, 0);
            }
        }

        public void postProcess(boolean isSuccess, boolean isRev) {
            if (isSuccess) {
                this.isCanceled = false;
                this.mergeKineticLaw(isRev);
            } else {
                this.isCanceled = true;
                this.mappedKineticLaw = null;
            }
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public KineticLaw getMappedKineticLaw() {
            return this.mappedKineticLaw;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (ev.getSource() instanceof JComboBox) {
                int i;
                ArrayList<JComboBox> cblist;
                JComboBox selectedCmb = (JComboBox)ev.getSource();
                Reaction targetReaction = this.reacFrom;
                LinkedList<String> tmpSprefList = new LinkedList<String>();
                if (this.reactCBList.contains(selectedCmb)) {
                    cblist = this.reactCBList;
                    i = 0;
                    while ((long)i < targetReaction.getNumReactants()) {
                        tmpSprefList.add(targetReaction.getReactant((long)i).getSpecies());
                        ++i;
                    }
                } else if (this.productCBList.contains(selectedCmb)) {
                    cblist = this.productCBList;
                    i = 0;
                    while ((long)i < targetReaction.getNumProducts()) {
                        tmpSprefList.add(targetReaction.getProduct((long)i).getSpecies());
                        ++i;
                    }
                } else if (this.modifierCBList.contains(selectedCmb)) {
                    cblist = this.modifierCBList;
                    i = 0;
                    while ((long)i < targetReaction.getNumModifiers()) {
                        tmpSprefList.add(targetReaction.getModifier((long)i).getSpecies());
                        ++i;
                    }
                } else if (this.reactRevCBList.contains(selectedCmb)) {
                    cblist = this.reactRevCBList;
                    i = 0;
                    while ((long)i < targetReaction.getNumProducts()) {
                        tmpSprefList.add(targetReaction.getProduct((long)i).getSpecies());
                        ++i;
                    }
                } else if (this.productRevCBList.contains(selectedCmb)) {
                    cblist = this.productRevCBList;
                    i = 0;
                    while ((long)i < targetReaction.getNumReactants()) {
                        tmpSprefList.add(targetReaction.getReactant((long)i).getSpecies());
                        ++i;
                    }
                } else if (this.modifierCBList.contains(selectedCmb)) {
                    cblist = this.modifierCBList;
                    i = 0;
                    while ((long)i < targetReaction.getNumModifiers()) {
                        tmpSprefList.add(targetReaction.getModifier((long)i).getSpecies());
                        ++i;
                    }
                } else {
                    return;
                }
                String sid = ((SpeciesListItem)selectedCmb.getSelectedItem()).getSpeciesTo().getId();
                tmpSprefList.remove(sid);
                int i2 = 0;
                while (i2 < cblist.size()) {
                    JComboBox cmb = cblist.get(i2);
                    if (selectedCmb != cmb) {
                        SpeciesListItem cursplist = (SpeciesListItem)cmb.getSelectedItem();
                        String curspid = cursplist.getSpeciesTo().getId();
                        if (tmpSprefList.contains(curspid)) {
                            tmpSprefList.remove(curspid);
                        } else {
                            int sindex = 0;
                            int j = 0;
                            while (j < cmb.getItemCount()) {
                                SpeciesListItem splist = (SpeciesListItem)cmb.getItemAt(j);
                                String id = splist.getSpeciesTo().getId();
                                if (tmpSprefList.contains(id)) {
                                    tmpSprefList.remove(id);
                                    sindex = j;
                                    break;
                                }
                                ++j;
                            }
                            cmb.setSelectedIndex(sindex);
                        }
                    }
                    ++i2;
                }
            }
        }

        public void addComponent(GridBagLayout gb, JPanel panel, Component cmp, int x, int y, int w, int h) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = x;
            gbc.gridy = y;
            gbc.gridwidth = w;
            gbc.gridheight = h;
            gb.setConstraints(cmp, gbc);
            panel.add(cmp);
        }

        private void swapPanel() {
            this.getContentPane().remove(this.currentMainPanel);
            this.pack();
            this.currentMainPanel = this.currentMainPanel == this.mainPanel ? this.mainPanelRev : this.mainPanel;
            this.getContentPane().add(this.currentMainPanel);
            this.pack();
        }

        private JPanel createMainPanel(HashMap<String, ArrayList<String>> idMapR, HashMap<String, ArrayList<String>> idMapP, HashMap<String, ArrayList<String>> idMapM, ArrayList<JComboBox> cbListR, ArrayList<JComboBox> cbListP, ArrayList<JComboBox> cbListM, boolean isRev) {
            JPanel btnPanel;
            JComboBox combobox;
            String id;
            boolean flag;
            int sindex;
            DefaultComboBoxModel<SpeciesListItem> model;
            JTextField spLabel;
            Species sp;
            SpeciesReference spr;
            ArrayList<String> candidates;
            String sid;
            Map.Entry<String, ArrayList<String>> entry;
            LinkedList<String> tmpRefList;
            Iterator<Map.Entry<String, ArrayList<String>>> iterator;
            JLabel celldSpLabel;
            JLabel sabioSpLabel;
            JPanel mPanel = new JPanel();
            GridBagLayout gbLayout = new GridBagLayout();
            mPanel.setLayout(gbLayout);
            int y = 0;
            if (idMapR.size() > 0) {
                JLabel reactLabel = new JLabel("Reactants ID/Name Mapping");
                sabioSpLabel = new JLabel("Species id(name) [SABIO-RK]");
                celldSpLabel = new JLabel("Species id(name) [CellDesigner]");
                this.addComponent(gbLayout, mPanel, reactLabel, 0, y++, 1, 1);
                this.addComponent(gbLayout, mPanel, new JSeparator(), 0, y++, 2, 1);
                this.addComponent(gbLayout, mPanel, celldSpLabel, 0, y, 1, 1);
                this.addComponent(gbLayout, mPanel, sabioSpLabel, 1, y++, 1, 1);
                iterator = idMapR.entrySet().iterator();
                tmpRefList = new LinkedList<String>();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    sid = entry.getKey();
                    candidates = entry.getValue();
                    spr = this.reacTo.getReactant(sid);
                    sp = this.reacTo.getModel().getSpecies(spr.getSpecies());
                    spLabel = new JTextField(String.valueOf(sp.getId()) + " (" + sp.getName() + ")");
                    spLabel.setEditable(false);
                    this.addComponent(gbLayout, mPanel, spLabel, 0, y, 1, 1);
                    model = new DefaultComboBoxModel();
                    sindex = 0;
                    flag = false;
                    int i = 0;
                    while (i < candidates.size()) {
                        id = candidates.get(i);
                        model.addElement(new SpeciesListItem(sp, this.reacFrom.getModel().getSpecies(id)));
                        if (!flag && !tmpRefList.contains(id)) {
                            flag = true;
                            sindex = i;
                            tmpRefList.add(id);
                        }
                        ++i;
                    }
                    combobox = new JComboBox(model);
                    combobox.setSelectedIndex(sindex);
                    combobox.addActionListener(this);
                    cbListR.add(combobox);
                    this.addComponent(gbLayout, mPanel, combobox, 1, y, 1, 1);
                    ++y;
                }
                this.addComponent(gbLayout, mPanel, new JSeparator(), 0, y++, 2, 1);
            }
            if (idMapP.size() > 0) {
                JLabel productLabel = new JLabel("Products ID/Name Mapping");
                sabioSpLabel = new JLabel("Species id(name) [SABIO-RK]");
                celldSpLabel = new JLabel("Species id(name) [CellDesigner]");
                this.addComponent(gbLayout, mPanel, productLabel, 0, y++, 1, 1);
                this.addComponent(gbLayout, mPanel, new JSeparator(), 0, y++, 2, 1);
                this.addComponent(gbLayout, mPanel, celldSpLabel, 0, y, 1, 1);
                this.addComponent(gbLayout, mPanel, sabioSpLabel, 1, y++, 1, 1);
                iterator = idMapP.entrySet().iterator();
                tmpRefList = new LinkedList();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    sid = entry.getKey();
                    candidates = entry.getValue();
                    spr = this.reacTo.getProduct(sid);
                    sp = this.reacTo.getModel().getSpecies(spr.getSpecies());
                    spLabel = new JTextField(String.valueOf(sp.getId()) + " (" + sp.getName() + ")");
                    spLabel.setEditable(false);
                    model = new DefaultComboBoxModel<SpeciesListItem>();
                    sindex = 0;
                    flag = false;
                    int i = 0;
                    while (i < candidates.size()) {
                        id = candidates.get(i);
                        model.addElement(new SpeciesListItem(sp, this.reacFrom.getModel().getSpecies(id)));
                        if (!flag && !tmpRefList.contains(id)) {
                            flag = true;
                            sindex = i;
                            tmpRefList.add(id);
                        }
                        ++i;
                    }
                    combobox = new JComboBox(model);
                    combobox.setSelectedIndex(sindex);
                    combobox.addActionListener(this);
                    cbListP.add(combobox);
                    this.addComponent(gbLayout, mPanel, spLabel, 0, y, 1, 1);
                    this.addComponent(gbLayout, mPanel, combobox, 1, y, 1, 1);
                    ++y;
                }
                this.addComponent(gbLayout, mPanel, new JSeparator(), 0, y++, 2, 1);
            }
            if (idMapM.size() > 0) {
                JLabel modifierLabel = new JLabel("Modifiers ID/Name Mapping");
                sabioSpLabel = new JLabel("Species id(name) [SABIO-RK]");
                celldSpLabel = new JLabel("Species id(name) [CellDesigner]");
                this.addComponent(gbLayout, mPanel, modifierLabel, 0, y++, 1, 1);
                this.addComponent(gbLayout, mPanel, new JSeparator(), 0, y++, 2, 1);
                this.addComponent(gbLayout, mPanel, celldSpLabel, 0, y, 1, 1);
                this.addComponent(gbLayout, mPanel, sabioSpLabel, 1, y++, 1, 1);
                iterator = idMapM.entrySet().iterator();
                tmpRefList = new LinkedList();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    sid = entry.getKey();
                    candidates = entry.getValue();
                    ModifierSpeciesReference mspr = this.reacTo.getModifier(sid);
                    sp = this.reacTo.getModel().getSpecies(mspr.getSpecies());
                    spLabel = new JTextField(String.valueOf(sp.getId()) + " (" + sp.getName() + ")");
                    spLabel.setEditable(false);
                    model = new DefaultComboBoxModel();
                    sindex = 0;
                    flag = false;
                    int i = 0;
                    while (i < candidates.size()) {
                        id = candidates.get(i);
                        model.addElement(new SpeciesListItem(sp, this.reacFrom.getModel().getSpecies(id)));
                        if (!flag && !tmpRefList.contains(id)) {
                            flag = true;
                            sindex = i;
                            tmpRefList.add(id);
                        }
                        ++i;
                    }
                    combobox = new JComboBox(model);
                    combobox.setSelectedIndex(sindex);
                    combobox.addActionListener(this);
                    cbListM.add(combobox);
                    this.addComponent(gbLayout, mPanel, spLabel, 0, y, 1, 1);
                    this.addComponent(gbLayout, mPanel, combobox, 1, y, 1, 1);
                    ++y;
                }
                this.addComponent(gbLayout, mPanel, new JSeparator(), 0, y++, 2, 1);
            }
            final MappingSpeciesReferenceIdDialog myself = this;
            final boolean isRevF = isRev;
            if (this.enableSwap) {
                btnPanel = new JPanel();
                btnPanel.setLayout(new BoxLayout(btnPanel, 0));
                JButton swapBtn = new JButton("Swap Reactants/Products");
                swapBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        myself.swapPanel();
                    }
                });
                btnPanel.add(swapBtn);
                this.addComponent(gbLayout, mPanel, btnPanel, 0, y++, 1, 1);
            }
            btnPanel = new JPanel();
            btnPanel.setLayout(new BoxLayout(btnPanel, 0));
            JButton okBtn = new JButton("Apply");
            JButton cancelBtn = new JButton("Cancel");
            okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    myself.postProcess(true, isRevF);
                    myself.dispose();
                }
            });
            cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    myself.postProcess(false, isRevF);
                    myself.dispose();
                }
            });
            btnPanel.add(okBtn);
            btnPanel.add(cancelBtn);
            this.addComponent(gbLayout, mPanel, btnPanel, 1, y, 1, 1);
            return mPanel;
        }

        public MappingSpeciesReferenceIdDialog(Dialog owner, String title, boolean isModal, Reaction rFrom, Reaction rTo) throws Exception {
            super(owner, title, isModal);
            this.mappedKineticLaw = null;
            this.isCanceled = false;
            this.enableSwap = false;
            this.reacFrom = rFrom;
            this.reacTo = rTo;
            boolean isMapped = false;
            boolean isRevMapped = false;
            this.reactIdMap = this.mappingSpeciesReferenceIDs(this.reacFrom.getListOfReactants(), this.reacTo.getListOfReactants());
            this.productIdMap = this.mappingSpeciesReferenceIDs(this.reacFrom.getListOfProducts(), this.reacTo.getListOfProducts());
            this.reactIdRevMap = this.mappingSpeciesReferenceIDs(this.reacFrom.getListOfProducts(), this.reacTo.getListOfReactants());
            this.productIdRevMap = this.mappingSpeciesReferenceIDs(this.reacFrom.getListOfReactants(), this.reacTo.getListOfProducts());
            this.modifierIdMap = this.mappingModifierSpeciesReferenceIDs(this.reacFrom.getListOfModifiers(), this.reacTo.getListOfModifiers());
            this.modifierIdRevMap = this.mappingModifierSpeciesReferenceIDs(this.reacFrom.getListOfModifiers(), this.reacTo.getListOfModifiers());
            if (this.reactIdMap != null && this.productIdMap != null) {
                isMapped = true;
            }
            if (this.reactIdRevMap != null && this.productIdRevMap != null) {
                isRevMapped = true;
            }
            if (!isMapped && !isRevMapped) {
                String errMsgHeader = "Selected SABIO-RK's kineticlaw can't be imported to the selected Reaction (" + this.reacTo.getId() + ") in CellDesigner.\n";
                String errMsg = "The number of reactants/products and modifiers are mismatched\n[SABIO-RK]   (reactant/product) " + this.reacFrom.getNumReactants() + "/" + this.reacFrom.getNumProducts() + " (modifier) " + this.reacFrom.getNumModifiers() + "\n" + "[CellDesigner] (reactant/product) " + this.reacTo.getNumReactants() + "/" + this.reacTo.getNumProducts() + " (modifier) " + this.reacTo.getNumModifiers() + "\n";
                throw new Exception(String.valueOf(errMsgHeader) + errMsg);
            }
            if (isMapped && isRevMapped) {
                this.enableSwap = true;
            }
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            if (isMapped) {
                this.reactCBList = new ArrayList();
                this.productCBList = new ArrayList();
                this.modifierCBList = new ArrayList();
                this.currentMainPanel = this.mainPanel = this.createMainPanel(this.reactIdMap, this.productIdMap, this.modifierIdMap, this.reactCBList, this.productCBList, this.modifierCBList, false);
            }
            if (isRevMapped) {
                this.reactRevCBList = new ArrayList();
                this.productRevCBList = new ArrayList();
                this.modifierRevCBList = new ArrayList();
                this.mainPanelRev = this.createMainPanel(this.reactIdRevMap, this.productIdRevMap, this.modifierIdRevMap, this.reactRevCBList, this.productRevCBList, this.modifierRevCBList, true);
                if (this.currentMainPanel == null) {
                    this.currentMainPanel = this.mainPanelRev;
                }
            }
            this.getContentPane().add(this.currentMainPanel);
            this.pack();
        }

        private HashMap<String, ArrayList<String>> mappingSpeciesReferenceIDs(ListOfSpeciesReferences fromList, ListOfSpeciesReferences toList) {
            if (fromList.size() != toList.size()) {
                return null;
            }
            HashMap<String, ArrayList<String>> idMap = new HashMap<String, ArrayList<String>>();
            int i = 0;
            while ((long)i < toList.size()) {
                SpeciesReference srTo = (SpeciesReference)toList.get((long)i);
                String toReactId = srTo.getSpecies();
                double toSMath = srTo.getStoichiometry();
                ArrayList<String> sidCandidates = new ArrayList<String>();
                boolean match = false;
                int j = 0;
                while ((long)j < fromList.size()) {
                    SpeciesReference srFrom = (SpeciesReference)fromList.get((long)j);
                    String fromReactId = srFrom.getSpecies();
                    double fromSMath = srFrom.getStoichiometry();
                    if (toSMath == fromSMath) {
                        sidCandidates.add(fromReactId);
                        match = true;
                    }
                    ++j;
                }
                if (!match) {
                    return null;
                }
                idMap.put(toReactId, sidCandidates);
                ++i;
            }
            System.err.println("Candidates for SpeciesReferences : ");
            Iterator iter = idMap.entrySet().iterator();
            int c = 0;
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String toId = (String)entry.getKey();
                ArrayList fromIdList = (ArrayList)entry.getValue();
                System.err.println("[" + c + "] " + "(" + toId + ")");
                int j = 0;
                while (j < fromIdList.size()) {
                    System.err.println("   [" + j + "] " + (String)fromIdList.get(j));
                    ++j;
                }
                ++c;
            }
            return idMap;
        }

        private HashMap<String, ArrayList<String>> mappingModifierSpeciesReferenceIDs(ListOfSpeciesReferences fromList, ListOfSpeciesReferences toList) {
            if (fromList.size() != toList.size()) {
                return null;
            }
            HashMap<String, ArrayList<String>> idMap = new HashMap<String, ArrayList<String>>();
            int i = 0;
            while ((long)i < toList.size()) {
                ModifierSpeciesReference msrTo = (ModifierSpeciesReference)toList.get((long)i);
                String toReactId = msrTo.getSpecies();
                ArrayList<String> sidCandidates = new ArrayList<String>();
                int j = 0;
                while ((long)j < toList.size()) {
                    ModifierSpeciesReference msrFrom = (ModifierSpeciesReference)fromList.get((long)j);
                    String fromReactId = msrFrom.getSpecies();
                    sidCandidates.add(fromReactId);
                    ++j;
                }
                idMap.put(toReactId, sidCandidates);
                ++i;
            }
            System.err.println("Candidates for ModifierSpeciesReferences : ");
            Iterator iter = idMap.entrySet().iterator();
            int c = 0;
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String toId = (String)entry.getKey();
                ArrayList fromIdList = (ArrayList)entry.getValue();
                System.err.println("[" + c + "] " + "(" + toId + ")");
                int j = 0;
                while (j < fromIdList.size()) {
                    System.err.println("   [" + j + "] " + (String)fromIdList.get(j));
                    ++j;
                }
                ++c;
            }
            return idMap;
        }
    }

    class ProgressBarTask
    implements Runnable {
        public ProgressBarTask(SabioRKRestful parent) {
        }

        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            while (currentThread == progressBarThread) {
                try {
                    SabioRKRestful.paintImmediately();
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public class SabioReaction {
        private String sabioId;
        private String equation;
        private Reaction reaction;

        public Reaction getReaction() {
            return this.reaction;
        }

        public void setReaction(Reaction reaction) {
            this.reaction = reaction;
        }

        public SabioReaction() {
        }

        public SabioReaction(String sabioId, String equation, Reaction reaction) {
            this.sabioId = sabioId;
            this.equation = equation;
            this.reaction = reaction;
        }

        public int compare(SabioReaction arg0, SabioReaction arg1) {
            int id0 = Integer.parseInt(arg0.getSabioId());
            int id1 = Integer.parseInt(arg1.getSabioId());
            return id0 - id1;
        }

        public String getEquation() {
            return this.equation;
        }

        public String getSabioId() {
            return this.sabioId;
        }

        public void setSabioId(String id) {
            this.sabioId = id;
        }
    }

    class SabioReactionComparator
    implements Comparator<Object> {
        public static final int ASC = 1;
        public static final int DESC = -1;
        private int sort = 1;

        public SabioReactionComparator() {
        }

        public SabioReactionComparator(int sort) {
            this.sort = sort;
        }

        @Override
        public int compare(Object arg0, Object arg1) {
            if (arg0 == null && arg1 == null) {
                return 0;
            }
            if (arg0 == null) {
                return 1 * this.sort;
            }
            if (arg1 == null) {
                return -1 * this.sort;
            }
            return (Integer.parseInt(((SabioReaction)arg0).getSabioId()) - Integer.parseInt(((SabioReaction)arg1).getSabioId())) * this.sort;
        }
    }

    class SabioRequestHandler
    implements Runnable {
        Object srcObject;

        public SabioRequestHandler(ActionEvent ev) {
            this.srcObject = ev.getSource();
            SabioRKRestful.this.handlerThread = new Thread(this);
            SabioRKRestful.this.handlerThread.start();
        }

        public String doSearch() {
            SabioRKRestful.this.removeAllElements(SabioRKRestful.this.tblModelReactions);
            if (reactionsList != null) {
                reactionsList = null;
                reactionsList = new ArrayList();
            }
            SabioRKRestful.this.htmlPane.setText("");
            String query = "level=2&version=4&q=";
            query = String.valueOf(query) + SabioRKRestful.this.textEnzymeSearch.getText() + " hasKineticData:true";
            if (!SabioRKRestful.this.txtFieldOrganism.getText().trim().equals("")) {
                query = String.valueOf(query) + " Organism:\"" + SabioRKRestful.this.txtFieldOrganism.getText() + "\"";
            }
            if (!SabioRKRestful.this.txtFieldTissue.getText().trim().equals("")) {
                query = String.valueOf(query) + " Tissue:\"" + SabioRKRestful.this.txtFieldTissue.getText() + "\"";
            }
            System.out.println("[" + query + "]");
            String sbml = SabioRKRestful.this.getXmlStringBySendRequest(SabioRKRestful.URL_SEARCH, query);
            if (sbml.startsWith("No result")) {
                SabioRKRestful.stopProgressBarTask();
                SabioRKRestful.this.currentSBFrame.showErrorMessage(sbml);
                return null;
            }
            return sbml;
        }

        @Override
        public void run() {
            block9: {
                try {
                    try {
                        SabioRKRestful.startProgressBarTask("Searching");
                        if (this.srcObject == SabioRKRestful.this.btnImportKineticLaw) {
                            SabioRKRestful.this.generateSBMLFromSelectedReaction();
                        } else if (this.srcObject == SabioRKRestful.this.btnEnzymeSearchByName || this.srcObject == SabioRKRestful.this.textEnzymeSearch) {
                            SabioRKRestful.this.setEnabledSearchGUI(false);
                            String sbml = this.doSearch();
                            SabioRKRestful.startProgressBarTask("Parsing results");
                            if (sbml != null) {
                                SabioRKRestful.this.sabioSBML = SabioRKRestful.this.parseResultSBML(sbml, SabioRKRestful.this.sabioSBML);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        SabioRKRestful.this.handlerThread = null;
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    SabioRKRestful.this.handlerThread = null;
                    throw throwable;
                }
                SabioRKRestful.this.handlerThread = null;
            }
            SabioRKRestful.this.setEnabledSearchGUI(true);
            SabioRKRestful.stopProgressBarTask();
        }
    }

    class SpeciesListItem {
        private Species speciesFrom;
        private Species speciesTo;

        public SpeciesListItem(Species spFrom, Species spTo) {
            this.speciesFrom = spFrom;
            this.speciesTo = spTo;
        }

        public Species getSpeciesFrom() {
            return this.speciesFrom;
        }

        public Species getSpeciesTo() {
            return this.speciesTo;
        }

        public String toString() {
            String spTo = String.valueOf(this.speciesTo.getId()) + "(" + this.speciesTo.getName() + ")";
            return new String(spTo);
        }
    }
}

