/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.database;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.xml.namespace.QName;
import jp.co.mki.celldesigner.simulation.util.MyProgressBar;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.NameTranslator;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.util.ColumnResizer;
import jp.sbi.celldesigner.util.OpenURLThread;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.SBMLPanelLists;
import jp.sbi.sbml.util.SBaseListPanel;
import org.apache.axis.client.Call;
import org.eml.sdbv.sabioclient.GetGeneralReactionEquation;
import org.eml.sdbv.sabioclient.GetKinLawIDs;
import org.eml.sdbv.sabioclient.GetKinLawIDsNotNull;
import org.eml.sdbv.sabioclient.GetKineticLaw;
import org.eml.sdbv.sabioclient.GetOrganismFromKLID;
import org.eml.sdbv.sabioclient.GetParametersXML;
import org.eml.sdbv.sabioclient.GetPathwayNames;
import org.eml.sdbv.sabioclient.GetPubmed;
import org.eml.sdbv.sabioclient.GetReactionIDFromCompound;
import org.eml.sdbv.sabioclient.GetReactionIDFromEnzyme;
import org.eml.sdbv.sabioclient.GetReactionIDs;
import org.eml.sdbv.sabioclient.GetReactionInstanceIDs;
import org.eml.sdbv.sabioclient.GetTissue;
import org.eml.sdbv.sabioclient.Sabiork;
import org.eml.sdbv.sabioclient.SabiorkService;
import org.eml.sdbv.sabioclient.SabiorkServiceLocator;
import org.eml.sdbv.sabioclient.SearchCompounds;
import org.eml.sdbv.sabioclient.SearchEnzymesByECNumber;
import org.eml.sdbv.sabioclient.SearchEnzymesByName;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.FunctionDefinition;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.ListOfFunctionDefinitions;
import org.sbml.libsbml.ListOfParameters;
import org.sbml.libsbml.ListOfSpeciesReferences;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.ModifierSpeciesReference;
import org.sbml.libsbml.OStream;
import org.sbml.libsbml.OStringStream;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLReader;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesReference;
import org.sbml.libsbml.UnitDefinition;
import org.sbml.libsbml.libsbml;

public class SabioRK
extends JDialog
implements ActionListener,
HyperlinkListener {
    private static SabioRK singletonInstance = null;
    private static final long serialVersionUID = -8437445990830803268L;
    private final boolean isOffline = false;
    private final String TITLE = "SABIO Reaction Kinetics Database";
    private final boolean enableDebugMappingMath = true;
    private SabiorkService service;
    private Sabiork port;
    private SBModelFrame currentSBFrame;
    private static ArrayList<Object> pathwaysList;
    private static ArrayList<SabioReaction> reactionsList;
    private JTabbedPane tabpane;
    private JPanel pathwayPanel;
    private JPanel reactionPanel;
    private String[] allEnzymeNames;
    private JComboBox cmbPathways;
    private JComboBox cmbEnzyme;
    private JComboBox cmbCompound;
    private DefaultComboBoxModel cmbModelPathways;
    private DefaultComboBoxModel cmbModelEnzyme;
    private DefaultComboBoxModel cmbModelCompound;
    private JTable pathwaysTable;
    private JTable reactionsTable;
    private DefaultTableModel tblModelReactions;
    private DefaultTableModel tblModelReactions2;
    private JCheckBox checkEnzyme;
    private JCheckBox checkCompound;
    private JRadioButton rbtnEnzyme;
    private JRadioButton rbtnCompound;
    private ButtonGroup rSearchRbtnGroup;
    private JLabel eSearchLabel1;
    private JLabel eSearchLabel2;
    private JTextField eSearchLabel3;
    private JLabel cSearchLabel1;
    private JLabel cSearchLabel2;
    private JTextField cSearchLabel3;
    private JLabel rSearchLabel;
    private JTextField rSearchTextField;
    private JLabel pSearchLabel;
    private JTextField textPathwaySearch;
    private JTextField textEnzymeSearch;
    private JTextField textCompoundSearch;
    private JButton btnEnzymeSearchByName;
    private JButton btnEnzymeSearchByECNumber;
    private JButton btnCompoundSearch;
    private JButton btnPathwaySearch;
    private JButton btnReactionSearch;
    private JButton btnKineticLawGet;
    private JButton btnSeeReaction;
    private JButton btnImportKineticLaw;
    private JButton btnGenerateSBML2;
    private JButton btnClose;
    private Call call;
    private JTabbedPane kineticTabPane;
    private JTabbedPane kineticTabPane2;
    private JScrollPane reactionScrollpane;
    private JScrollPane rScrollPane;
    private SabioReaction selectedModel;
    private String prevPathwayName = "";
    private static MyProgressBar progressBar;
    private static ProgressBarTask progressBarTask;
    private static Thread progressBarThread;
    private JPanel progressBarPanel;
    Thread handlerThread = null;

    static {
        progressBar = new MyProgressBar(0, 100);
    }

    public static synchronized SabioRK createInstance(SBModelFrame currentSBFrame) {
        if (singletonInstance == null) {
            singletonInstance = new SabioRK(currentSBFrame);
        }
        return singletonInstance;
    }

    public synchronized void setCurrentSBFrame(SBModelFrame currentSBFrame) {
        this.currentSBFrame = currentSBFrame;
    }

    protected SabioRK(SBModelFrame currentSBFrame) {
        super(MainWindow.getLastInstance());
        this.setTitle("SABIO Reaction Kinetics Database");
        this.currentSBFrame = currentSBFrame;
        pathwaysList = new ArrayList();
        reactionsList = new ArrayList();
        this.setBounds(10, 10, 600, 600);
    }

    public void init(JFrame frame) {
        if (this.createDialog()) {
            this.showDialog(frame);
        } else {
            this.showErrorDialog(frame);
        }
    }

    public synchronized boolean createHandlerThread(ActionEvent ev) {
        if (this.handlerThread == null) {
            SabioRequestHandler handler = new SabioRequestHandler(ev);
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.currentSBFrame = MainWindow.getLastInstance().getCurrentModel();
        if (!this.createHandlerThread(ev)) {
            return;
        }
    }

    private void searchReactionByName() {
        try {
            Object query_obj = null;
            if (this.rbtnEnzyme.isSelected()) {
                query_obj = this.cmbModelEnzyme.getSelectedItem();
            } else if (this.rbtnCompound.isSelected()) {
                query_obj = this.cmbModelCompound.getSelectedItem();
            }
            String query = "";
            if (query_obj != null) {
                query = query_obj.toString();
            }
            if (query.equals("")) {
                String errMsg = "";
                if (this.rbtnEnzyme.isSelected()) {
                    errMsg = "No Enzyme selected.";
                } else if (this.rbtnCompound.isSelected()) {
                    errMsg = "No Compound selected.";
                }
                JOptionPane.showMessageDialog(null, errMsg, "Error", 0);
                return;
            }
            System.err.println("Search String: " + query);
            int[] rid = this.rbtnEnzyme.isSelected() ? this.getReactionIDFromEnzyme(query) : (this.rbtnCompound.isSelected() ? this.getReactionIDFromCompound(query) : this.getReactionIDFromEnzyme(query));
            System.err.println(rid.length);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SabioRK.this.removeAllElements(SabioRK.this.tblModelReactions);
                }
            });
            if (reactionsList != null) {
                reactionsList = null;
                reactionsList = new ArrayList();
            }
            if (rid.length == 0) {
                final String fquery = query;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SabioRK.this.rSearchTextField.setText("[" + fquery + "] : No match");
                    }
                });
            } else {
                int numrid = 0;
                int i = 0;
                while (i < rid.length) {
                    SabioReaction sr;
                    SabioRK.startProgressBarTask(String.valueOf(i + 1) + "/" + rid.length);
                    int[] rInsIDs = this.getReactionInstanceIDs(rid[i]);
                    if (rInsIDs != null && rInsIDs.length > 0 && (sr = new SabioReaction(rid[i])).getReactionInsIDs() != null) {
                        ++numrid;
                        reactionsList.add(sr);
                        System.out.println("[" + i + "] " + rid[i] + ": " + sr.getEquation());
                    }
                    ++i;
                }
                final int fnumrid = numrid;
                final String fquery = query;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SabioRK.this.rSearchTextField.setText("[" + fquery + "] : " + fnumrid + " reactions");
                        SabioRK.this.createReactionTable();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createReactionTable() {
        Object[] row = new String[3];
        for (SabioReaction sr : reactionsList) {
            row[0] = String.valueOf(sr.getId());
            row[2] = sr.getEquation();
            this.tblModelReactions.addRow(row);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColumnResizer.adjustColumnPreferredWidthsWithHeader(SabioRK.this.reactionsTable);
                SabioRK.this.reactionsTable.revalidate();
            }
        });
    }

    private void setKineticLawTab() {
        int row = this.reactionsTable.getSelectedRow();
        if (row != -1) {
            this.createKineticLawPane(reactionsList.get(row), this.kineticTabPane);
        }
    }

    public String convertStreamToString(BufferedReader br) throws IOException {
        String lineSep = System.getProperty("line.separator");
        String nextLine = "";
        StringBuffer sb = new StringBuffer();
        while ((nextLine = br.readLine()) != null) {
            sb.append(nextLine);
            sb.append(lineSep);
        }
        return sb.toString();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            OpenURLThread ourlt = new OpenURLThread(event.getURL().toString());
            Thread t = new Thread(ourlt);
            t.start();
        }
    }

    private void createKineticLawPane(SabioReaction sr, JTabbedPane tabPane) {
        if (sr.getSabioKineticLawsHash() == null) {
            sr.createSabioKineticLawsHash();
            int[] reactionInsIDs = sr.getReactionInsIDs();
            int loopmax = 10;
            int i = 0;
            while (i < reactionInsIDs.length && i < loopmax) {
                int last = Math.min(reactionInsIDs.length, loopmax);
                SabioRK.startProgressBarTask(String.valueOf(i + 1) + "/" + last);
                int[] kineticLawIDsNotNull = null;
                try {
                    kineticLawIDsNotNull = this.getKineticLawIDsNotNull(reactionInsIDs[i]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (kineticLawIDsNotNull != null) {
                    Integer klid = new Integer(kineticLawIDsNotNull[0]);
                    if (!sr.getSabioKineticLawsHash().containsKey(klid)) {
                        SabioKineticLaw skl = new SabioKineticLaw(klid);
                        sr.getSabioKineticLawsHash().put(klid, skl);
                    }
                }
                ++i;
            }
            int row = this.reactionsTable.getSelectedRow();
            this.tblModelReactions.setValueAt(sr.getSabioKineticLawsHash().size(), row, 1);
        }
        Iterator<Integer> it = sr.getSabioKineticLawsHash().keySet().iterator();
        tabPane.removeAll();
        SabioRK.startProgressBarTask("Rendering tables");
        if (sr.getSabioKineticLawsHash().size() > 0) {
            tabPane.removeAll();
            while (it.hasNext()) {
                SabioKineticLaw skl = sr.getSabioKineticLawsHash().get(it.next());
                String URLstr = "http://sabiork.h-its.org/kindatadirectiframe.jsp?kinlawid=" + skl.getId() + "&viewSingleKineticLawEntry=true&viewData=true";
                JEditorPane htmlTbl = new JEditorPane();
                htmlTbl.setContentType("text/html");
                htmlTbl.setEditable(false);
                htmlTbl.addHyperlinkListener(this);
                try {
                    htmlTbl.setPage(URLstr);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                JScrollPane jsp = new JScrollPane(htmlTbl, 20, 30);
                String title = "unknown".equals(skl.getTissue()) || skl.getTissue() == null ? skl.getOrganism() : String.valueOf(skl.getOrganism()) + ":" + skl.getTissue();
                tabPane.add(title, jsp);
            }
            this.btnImportKineticLaw.setEnabled(true);
        } else {
            JPanel panelKl = new JPanel();
            panelKl.add((Component)new JLabel("Kinetic Law"), "Center");
            tabPane.add("Organism", panelKl);
            this.btnImportKineticLaw.setEnabled(false);
        }
    }

    private void searchPathwayByName() {
        try {
            String query = this.textPathwaySearch.getText();
            final String[] result = this.getPathwayNames(query);
            System.err.println(query);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SabioRK.this.cmbModelPathways.removeAllElements();
                    if (result.length == 0) {
                        System.err.println("No match.");
                    } else {
                        int i = 0;
                        while (i < result.length) {
                            SabioRK.this.cmbModelPathways.addElement(result[i]);
                            System.out.println("Got result : " + result[i]);
                            ++i;
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void seeReactionFromPathway() {
        int row = this.pathwaysTable.getSelectedRow();
        if (row != -1) {
            String rid = (String)this.tblModelReactions2.getValueAt(row, 0);
            String equation = (String)this.tblModelReactions2.getValueAt(row, 2);
            SabioReaction sr = new SabioReaction(Integer.parseInt(rid));
            this.createKineticLawPane(sr, this.kineticTabPane2);
            System.out.println(String.valueOf(rid) + equation);
            System.out.println(String.valueOf(sr.getId()) + sr.getEquation());
        }
    }

    private void getListOfReactionsFromPathwayName() {
        String pathwayName = this.cmbModelPathways.getSelectedItem().toString();
        if (pathwayName.equals(this.prevPathwayName)) {
            System.err.println("Same pathway name, so do nothing.");
            return;
        }
        this.removeAllElements(this.tblModelReactions2);
        this.prevPathwayName = pathwayName.toString();
        try {
            int[] rid = this.getReactionIDs(pathwayName);
            System.err.println(String.valueOf(rid[0]));
            System.err.println(String.valueOf(this.getKineticLawIDsNotNull(rid[0]).length));
            int i = 0;
            while (i < rid.length) {
                Object[] row = new String[]{String.valueOf(rid[i]), String.valueOf(this.getKineticLawIDsNotNull(rid[i]).length), this.getGeneralReactionEquation(rid[i])};
                this.tblModelReactions2.addRow(row);
                ++i;
            }
            this.pSearchLabel.setText("Search Results: " + rid.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeAllElements(DefaultTableModel dataModel) {
        int i = dataModel.getRowCount() - 1;
        while (i >= 0) {
            dataModel.removeRow(i);
            --i;
        }
    }

    private void removeAllElements(JTabbedPane kineticTabPane) {
        int i = kineticTabPane.getTabCount() - 1;
        while (i >= 0) {
            kineticTabPane.remove(i);
            --i;
        }
    }

    private boolean connectToSabio() {
        this.service = new SabiorkServiceLocator();
        try {
            this.port = this.service.getsabiorkPort();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private DefaultTableModel createTableModelReactions() {
        DefaultTableModel tm = new DefaultTableModel();
        tm.addColumn("rid");
        tm.addColumn("num of kl");
        tm.addColumn("Equation");
        return tm;
    }

    private void createPathwayPanel() {
        this.pathwayPanel = new JPanel();
        this.textPathwaySearch = new JTextField(20);
        this.textPathwaySearch.addActionListener(this);
        this.btnPathwaySearch = new JButton("Search");
        this.btnPathwaySearch.addActionListener(this);
        this.btnSeeReaction = new JButton("See Reaction info.");
        this.btnSeeReaction.addActionListener(this);
        this.cmbModelPathways = new DefaultComboBoxModel();
        this.cmbPathways = new JComboBox(this.cmbModelPathways);
        this.cmbPathways.addActionListener(this);
        this.tblModelReactions2 = this.createTableModelReactions();
        this.pathwaysTable = new JTable(this.tblModelReactions2);
        JScrollPane scrollpane = new JScrollPane(this.pathwaysTable);
        this.pSearchLabel = new JLabel("Search Results: ");
        this.kineticTabPane2 = new JTabbedPane();
        JPanel panelKl2 = new JPanel();
        panelKl2.add((Component)new JLabel("Kinetic Law"), "Center");
        this.kineticTabPane2.setPreferredSize(new Dimension(300, 100));
        this.kineticTabPane2.add("Organism", panelKl2);
        JPanel nPanel = new JPanel();
        JPanel cPanel = new JPanel();
        JPanel sPanel = new JPanel();
        nPanel.add((Component)this.textPathwaySearch, "Center");
        nPanel.add((Component)this.btnPathwaySearch, "East");
        nPanel.add((Component)this.cmbPathways, "South");
        cPanel.add((Component)scrollpane, "Center");
        cPanel.add((Component)this.pSearchLabel, "South");
        cPanel.add((Component)this.btnSeeReaction, "South");
        sPanel.add((Component)this.kineticTabPane2, "Center");
        this.pathwayPanel.add((Component)nPanel, "North");
        this.pathwayPanel.add((Component)cPanel, "Center");
        this.pathwayPanel.add((Component)sPanel, "South");
    }

    private void createCmbModel(DefaultComboBoxModel cmbModel, String str, int method) {
        try {
            String[] list = null;
            if (cmbModel == this.cmbModelEnzyme) {
                if (this.cmbModelEnzyme.getSize() != 0) {
                    this.cmbModelEnzyme.removeAllElements();
                }
                if ((list = method == 0 ? this.searchEnzymesByName(str) : this.searchEnzymesByECNumber(str)) != null) {
                    this.eSearchLabel3.setText(String.valueOf(list.length) + " Enzyme found");
                    this.rbtnEnzyme.setSelected(true);
                } else {
                    this.eSearchLabel3.setText("0 Enzyme found");
                }
                if (list != null) {
                    int i = 0;
                    while (i < list.length) {
                        this.cmbModelEnzyme.addElement(list[i]);
                        ++i;
                    }
                }
            } else if (cmbModel == this.cmbModelCompound) {
                if (this.cmbModelCompound.getSize() != 0) {
                    this.cmbModelCompound.removeAllElements();
                }
                if ((list = this.searchCompounds(str)) != null) {
                    this.cSearchLabel3.setText(String.valueOf(list.length) + " Compound found");
                    this.rbtnCompound.setSelected(true);
                } else {
                    this.cSearchLabel3.setText("0 Compound found");
                }
                if (list != null) {
                    int i = 0;
                    while (i < list.length) {
                        this.cmbModelCompound.addElement(list[i]);
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getSelectedObjectName() {
        String name = null;
        if (this.currentSBFrame != null) {
            Reaction reaction;
            ListOfSpeciesReferences lom;
            Object obj = this.currentSBFrame.getSelectedObject();
            if (obj instanceof SpeciesAlias) {
                SpeciesAlias sa = (SpeciesAlias)obj;
                Species species = sa.getOriginalSpecies();
                name = species.getName();
            } else if (obj instanceof CompartmentAlias) {
                Compartment compartment = ((CompartmentAlias)obj).getOriginalCompartment();
                name = compartment.getName();
            } else if (obj instanceof ReactionLink && (lom = (reaction = ((ReactionLink)obj).getParentReaction()).getListOfModifiers()).size() > 0L) {
                String sid = ((ModifierSpeciesReference)lom.get(0L)).getSpecies();
                name = this.currentSBFrame.getSBModel().getModel().getSpecies(sid).getName();
            }
        }
        return name;
    }

    public void resetReactionPanel() {
        String defaultEnzyme = "";
        String defaultCompound = "";
        String objName = this.convertSBEditStrToSNameStr(this.getSelectedObjectName());
        if (objName == null) {
            objName = defaultEnzyme;
        }
        this.textEnzymeSearch.setText(objName);
        this.textCompoundSearch.setText(defaultCompound);
        this.rSearchTextField.setText("");
        this.rbtnEnzyme.setEnabled(true);
        this.rbtnCompound.setEnabled(false);
        this.cmbModelEnzyme = new DefaultComboBoxModel();
        this.cmbModelCompound = new DefaultComboBoxModel();
        this.cmbEnzyme.setModel(this.cmbModelEnzyme);
        this.cmbCompound.setModel(this.cmbModelCompound);
        this.eSearchLabel3.setText("0 Enzyme found");
        this.cSearchLabel3.setText("0 Compound found");
        this.tblModelReactions = this.createTableModelReactions();
        this.reactionsTable.setModel(this.tblModelReactions);
        this.kineticTabPane.removeAll();
    }

    private String convertSBEditStrToSNameStr(String objName) {
        if (objName == null) {
            return objName;
        }
        String objSBName = NameTranslator.sname2sbedit(objName);
        if (objSBName != null && objSBName.contains("~")) {
            objName = objSBName.replace("~", " ");
        }
        return objName;
    }

    private void createReactionPanel() {
        String defaultEnzyme = "";
        String defaultCompound = "";
        String objName = this.convertSBEditStrToSNameStr(this.getSelectedObjectName());
        if (objName == null) {
            objName = defaultEnzyme;
        }
        this.reactionPanel = new JPanel();
        this.textEnzymeSearch = new JTextField(objName);
        this.textEnzymeSearch.setToolTipText("Type in Enzyme name or EC number");
        this.textEnzymeSearch.addActionListener(this);
        this.textCompoundSearch = new JTextField(defaultCompound);
        this.textCompoundSearch.setToolTipText("Type in Compond name or C number");
        this.textCompoundSearch.addActionListener(this);
        this.rbtnEnzyme = new JRadioButton("Enzyme", true);
        this.rbtnCompound = new JRadioButton("Compound", false);
        this.rSearchRbtnGroup = new ButtonGroup();
        this.rSearchRbtnGroup.add(this.rbtnCompound);
        this.rSearchRbtnGroup.add(this.rbtnEnzyme);
        this.cmbModelEnzyme = new DefaultComboBoxModel();
        this.cmbModelCompound = new DefaultComboBoxModel();
        this.cmbEnzyme = new JComboBox(this.cmbModelEnzyme);
        this.cmbEnzyme.setEditable(false);
        this.cmbEnzyme.addActionListener(this);
        this.cmbCompound = new JComboBox(this.cmbModelCompound);
        this.cmbCompound.setEditable(false);
        this.btnEnzymeSearchByName = new JButton("Search by name");
        this.btnEnzymeSearchByName.addActionListener(this);
        this.btnEnzymeSearchByECNumber = new JButton("Search by EC");
        this.btnEnzymeSearchByECNumber.addActionListener(this);
        this.eSearchLabel1 = new JLabel("Search Enzyme");
        this.eSearchLabel2 = new JLabel("Selected Enzyme");
        this.eSearchLabel3 = new JTextField("0 Enzyme found");
        this.eSearchLabel3.setEditable(false);
        this.btnCompoundSearch = new JButton("Search");
        this.btnCompoundSearch.addActionListener(this);
        this.cSearchLabel1 = new JLabel("Search Compound");
        this.cSearchLabel2 = new JLabel("Selected Compound");
        this.cSearchLabel3 = new JTextField("0 Compound found");
        this.cSearchLabel3.setEditable(false);
        this.btnReactionSearch = new JButton("Search Reaction");
        this.btnReactionSearch.addActionListener(this);
        this.btnKineticLawGet = new JButton("Get KineticLaw");
        this.btnKineticLawGet.addActionListener(this);
        this.btnKineticLawGet.setEnabled(false);
        this.rSearchLabel = new JLabel("Search Reaction Results");
        this.rSearchTextField = new JTextField("");
        this.rSearchTextField.setEnabled(false);
        this.tblModelReactions = this.createTableModelReactions();
        this.reactionsTable = new JTable(this.tblModelReactions){
            private static final long serialVersionUID = -6060087153395712925L;

            @Override
            public Component prepareRenderer(TableCellRenderer tcr, int row, int column) {
                Component c = super.prepareRenderer(tcr, row, column);
                if (column == 1) {
                    if (((SabioReaction)reactionsList.get(row)).getSabioKineticLawsHash() != null) {
                        c.setBackground(Color.GREEN);
                    }
                } else {
                    c.setForeground(this.getForeground());
                    c.setBackground(this.getBackground());
                }
                return c;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                SabioRK.this.btnKineticLawGet.setEnabled(true);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.btnImportKineticLaw = new JButton("Import KineticLaw");
        this.btnImportKineticLaw.addActionListener(this);
        this.btnImportKineticLaw.setEnabled(false);
        this.reactionScrollpane = new JScrollPane(this.reactionsTable, 22, 32);
        this.reactionScrollpane.setPreferredSize(new Dimension(300, 150));
        JPanel panelKl = new JPanel();
        panelKl.add((Component)new JLabel("<html><table border=\"0\"><tr><td>             </td><td>             </td></tr><tr><td>             </td><td>             </td></tr></table></html>"), "Center");
        this.kineticTabPane = new JTabbedPane();
        this.kineticTabPane.setPreferredSize(new Dimension(300, 200));
        this.kineticTabPane.add("Organism", panelKl);
        this.btnClose = new JButton("Close");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SabioRK.this.confirmExit();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SabioRK.this.confirmExit();
            }
        });
        this.gridBagLayoutReactionPanel();
    }

    void confirmExit() {
        String msg = "Are you sure you want to close SABIO-RK dialog?";
        int answer = JOptionPane.showConfirmDialog(this, msg, "Confirm Exit", 0);
        if (answer == 0) {
            this.postProcess();
        }
    }

    void postProcess() {
        this.dispose();
    }

    void gridBagAddComponent(GridBagLayout gb, JPanel panel, Component cmp, int x, int y, int w, int h) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gb.setConstraints(cmp, gbc);
        panel.add(cmp);
    }

    private void gridBagLayoutReactionPanel() {
        GridBagLayout gb = new GridBagLayout();
        this.reactionPanel.setLayout(gb);
        GridBagConstraints c1 = new GridBagConstraints();
        GridBagConstraints c2 = new GridBagConstraints();
        c1.insets = new Insets(4, 4, 4, 4);
        c2.insets = new Insets(4, 4, 4, 4);
        c1.anchor = 17;
        c2.anchor = 17;
        this.gridBagAddComponent(gb, this.reactionPanel, this.eSearchLabel1, 1, 1, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.textEnzymeSearch, 2, 1, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.btnEnzymeSearchByName, 3, 1, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.btnEnzymeSearchByECNumber, 4, 1, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.eSearchLabel3, 5, 1, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.eSearchLabel2, 0, 0, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.cmbEnzyme, 1, 0, 5, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.cSearchLabel1, 1, 3, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.textCompoundSearch, 2, 3, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.btnCompoundSearch, 3, 3, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.cSearchLabel3, 4, 3, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.cSearchLabel2, 0, 2, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.cmbCompound, 1, 2, 5, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.btnReactionSearch, 0, 4, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.rbtnEnzyme, 1, 4, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.rbtnCompound, 2, 4, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.rSearchLabel, 0, 5, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.rSearchTextField, 1, 5, 5, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.reactionScrollpane, 0, 6, 6, 3);
        this.gridBagAddComponent(gb, this.reactionPanel, this.btnKineticLawGet, 0, 9, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.kineticTabPane, 0, 10, 6, 3);
        this.gridBagAddComponent(gb, this.reactionPanel, this.btnImportKineticLaw, 0, 13, 1, 1);
        this.gridBagAddComponent(gb, this.reactionPanel, this.btnClose, 5, 13, 1, 1);
    }

    private void createTabPane() {
        this.tabpane = new JTabbedPane();
        this.rScrollPane = new JScrollPane(this.reactionPanel);
        this.tabpane.add("Reaction", this.rScrollPane);
    }

    private void createProgressBar() {
        progressBarTask = new ProgressBarTask(this);
        this.progressBarPanel = new JPanel(new BorderLayout());
        this.progressBarPanel.setPreferredSize(new Dimension(this.getSize().width, 20));
        this.progressBarPanel.add((Component)progressBar, "East");
        this.getContentPane().add((Component)this.progressBarPanel, "South");
    }

    public boolean createDialog() {
        if (!this.connectToSabio()) {
            return false;
        }
        this.createReactionPanel();
        this.createTabPane();
        this.getContentPane().add((Component)this.tabpane, "Center");
        this.setDefaultCloseOperation(0);
        this.createProgressBar();
        this.pack();
        return true;
    }

    public void showDialog(JFrame frame) {
        this.setVisible(true);
    }

    public void showErrorDialog(JFrame frame) {
        JOptionPane.showMessageDialog(frame, "Can't connect to SABIO-RK web service.", "SABIO Reaction Kinetics Database", 1);
    }

    public String[] getPathwayNames(String arg) throws Exception {
        String[] pathwayNames = this.port.getPathwayNames(new GetPathwayNames(arg));
        return pathwayNames;
    }

    public int[] getReactionIDs(String pathwayName) throws Exception {
        int[] reactionIDs = this.port.getReactionIDs(new GetReactionIDs(pathwayName));
        return reactionIDs;
    }

    public String getGeneralReactionEquation(int reactionID) throws Exception {
        String reactionEquation = this.port.getGeneralReactionEquation(new GetGeneralReactionEquation(reactionID)).get_return();
        return reactionEquation;
    }

    public int[] getKineticLawIDsNotNull(int reactionID) throws Exception {
        int[] kineticLawIDs = this.port.getKinLawIDsNotNull(new GetKinLawIDsNotNull(reactionID));
        return kineticLawIDs;
    }

    public int[] getReactionInstanceIDs(int reactionID) throws Exception {
        int[] reactionInstanceIDs = this.port.getReactionInstanceIDs(new GetReactionInstanceIDs(reactionID));
        return reactionInstanceIDs;
    }

    public int[] getKineticLawIDs(int reactionID) throws Exception {
        int[] kineticLawIDs = this.port.getKinLawIDs(new GetKinLawIDs(reactionID));
        return kineticLawIDs;
    }

    public String getKineticLaw(int kineticLawID) throws Exception {
        String kineticLaw = this.port.getKineticLaw(new GetKineticLaw(kineticLawID)).get_return();
        return kineticLaw;
    }

    public String[] getSubstrates(int reactionID) throws Exception {
        this.call.setOperationName(new QName("getSubstrates"));
        String[] substrates = (String[])this.call.invoke(new Object[]{reactionID});
        return substrates;
    }

    public String[] getProducts(int reactionID) throws Exception {
        this.call.setOperationName(new QName("getProducts"));
        String[] products = (String[])this.call.invoke(new Object[]{reactionID});
        return products;
    }

    public int getPubmed(int kineticLawID) throws Exception {
        int pubmedID = this.port.getPubmed(new GetPubmed(kineticLawID)).get_return();
        return pubmedID;
    }

    public String[] getParameters(int kineticLawID) throws Exception {
        this.call.setOperationName(new QName("getParameters"));
        String[] parameters = (String[])this.call.invoke(new Object[]{kineticLawID});
        return parameters;
    }

    public String getParametersXML(int kineticLawID) throws Exception {
        String parametersXML = this.port.getParametersXML(new GetParametersXML(kineticLawID)).get_return();
        return parametersXML;
    }

    public String[] searchCompounds(String name) throws Exception {
        String[] compoundsName = this.port.searchCompounds(new SearchCompounds(name));
        return compoundsName;
    }

    public int[] getReactionIDFromCompound(String name) throws Exception {
        int[] reactionIDs = this.port.getReactionIDFromCompound(new GetReactionIDFromCompound(name));
        return reactionIDs;
    }

    public String[] searchEnzymesByECNumber(String ecnumber) throws Exception {
        String[] enzymeNames = this.port.searchEnzymesByECNumber(new SearchEnzymesByECNumber(ecnumber));
        return enzymeNames;
    }

    public String[] getAllEnzymeNames() throws Exception {
        String[] enzymeNames = this.port.searchEnzymesByName(new SearchEnzymesByName("%"));
        return enzymeNames;
    }

    public String[] searchEnzymesByName(String name) throws Exception {
        String[] enzymeNames = this.port.searchEnzymesByName(new SearchEnzymesByName(name));
        return enzymeNames;
    }

    public int[] getReactionIDFromEnzyme(String enzymeName) throws Exception {
        int[] reactionIDs = this.port.getReactionIDFromEnzyme(new GetReactionIDFromEnzyme(enzymeName));
        int i = 0;
        while (i < reactionIDs.length) {
            System.out.println("DEBUG rid = " + reactionIDs[i]);
            ++i;
        }
        return reactionIDs;
    }

    public String getOrganismFromKLID(int klid) throws Exception {
        String organism = this.port.getOrganismFromKLID(new GetOrganismFromKLID(klid)).get_return();
        return organism;
    }

    public String getTissueFromKLID(int klid) throws Exception {
        String tissue = this.port.getTissue(new GetTissue(klid)).get_return();
        return tissue;
    }

    private void addSBMLInfoToModel(String sbmlString) throws Exception {
        KineticLaw curKl;
        Object[] options;
        String title;
        int selected;
        ListOfFunctionDefinitions lof;
        ArrayList<UnitDefinition> addedUnitDefinitions;
        ArrayList<FunctionDefinition> addedFunctionDefinitions;
        Model curModel;
        SBMLPanelLists sbmlPanelLists;
        Reaction reacSelected;
        KineticLaw mappedKineticLaw;
        Reaction reacSabio;
        Model m;
        boolean editFlag;
        block49: {
            ASTNode importKlMath;
            editFlag = false;
            SBMLReader r = new SBMLReader();
            SBMLDocument d = r.readSBMLFromString(sbmlString);
            if (d.getNumErrors() > 0L) {
                OStringStream oss = new OStringStream();
                d.printErrors((OStream)oss);
                throw new Exception("SABIO's SBML file is invalid" + oss.str());
            }
            m = d.getModel();
            reacSabio = null;
            int i = 0;
            while ((long)i < m.getNumReactions()) {
                if (m.getReaction((long)i).isSetKineticLaw()) {
                    reacSabio = m.getReaction((long)i);
                    break;
                }
                ++i;
            }
            if (reacSabio == null) {
                throw new Exception("No reaction returned by SABIO.");
            }
            if (reacSabio.getKineticLaw() == null) {
                throw new Exception("No KineticLaw in a reaction returned by SABIO.");
            }
            if (reacSabio.getKineticLaw().getMath() == null) {
                throw new Exception("No math of KineticLaw in a reaction returned by SABIO.");
            }
            System.err.println(String.valueOf(d.getLevel()) + " " + d.getVersion() + " " + d.getModel().getName());
            System.err.println("Species #: " + d.getModel().getNumSpecies());
            System.err.println("Reactions #: " + d.getModel().getNumReactions());
            System.err.println("Global Parameters #: " + d.getModel().getNumParameters());
            System.err.println("Local Parameters #: " + reacSabio.getKineticLaw().getNumParameters());
            System.err.println("Functions #: " + d.getModel().getNumFunctionDefinitions());
            System.err.println("UnitDefinitions #: " + d.getModel().getNumUnitDefinitions());
            mappedKineticLaw = null;
            reacSelected = null;
            if (this.currentSBFrame == null) {
                throw new Exception("No model is opened.");
            }
            Object obj = this.currentSBFrame.getSelectedObject();
            if (obj == null) {
                throw new Exception("No reaction selected in the current model.");
            }
            if (obj instanceof ReactionLink) {
                reacSelected = ((ReactionLink)obj).getParentReaction();
                if (reacSelected == null) {
                    throw new Exception("Null selected reaction.");
                }
                System.err.println("[DEBUG] addSBMLInfoToModel() : rid (sabio)    : " + reacSabio.getId());
                System.err.println("[DEBUG] addSBMLInfoToModel() : rid (selected) : " + reacSelected.getId());
                mappedKineticLaw = this.getMappedKineticLaw(reacSabio, reacSelected);
                if (mappedKineticLaw == null) {
                    return;
                }
                importKlMath = mappedKineticLaw.getMath();
                HashMap<String, String> kinArg = new HashMap<String, String>();
                int indexReact = 0;
                int i2 = 0;
                while ((long)i2 < importKlMath.getNumChildren()) {
                    SpeciesReference sprReact;
                    String argId;
                    SpeciesReference sprProd;
                    ASTNode argMath = importKlMath.getChild((long)i2);
                    if (argMath != null && (sprProd = reacSelected.getProduct(argId = argMath.getName())) != null && (sprReact = reacSelected.getReactant((long)indexReact++)) != null) {
                        kinArg.put(sprProd.getSpecies(), sprReact.getSpecies());
                    }
                    ++i2;
                }
                for (Map.Entry ent : kinArg.entrySet()) {
                    String prodId = (String)ent.getKey();
                    String reactId = (String)ent.getValue();
                    LibSBMLUtil.changeASTNodeName(importKlMath, prodId, reactId, 0);
                    System.err.println("[DEBUG] Adjusted argument [product Id] " + prodId + " -> [reactant Id] " + reactId);
                }
            } else {
                throw new Exception("No reaction selected in the current model.");
            }
            System.err.println("[DEBUG] Adjusted mapped KineticLaw : " + libsbml.formulaToString((ASTNode)importKlMath));
            SBModel sbModel = this.currentSBFrame.getSBModel();
            if (sbModel == null) {
                throw new Exception("[FATAL] Null SBModel");
            }
            sbmlPanelLists = sbModel.getSBMLPanelLists();
            if (sbmlPanelLists == null) {
                throw new Exception("[FATAL] Null SBMLPanelLists");
            }
            curModel = this.currentSBFrame.getSBModel().getModel();
            addedFunctionDefinitions = new ArrayList<FunctionDefinition>();
            addedUnitDefinitions = new ArrayList<UnitDefinition>();
            if (m.getNumFunctionDefinitions() <= 0L) break block49;
            lof = m.getListOfFunctionDefinitions();
            int i3 = 0;
            while ((long)i3 < lof.size()) {
                block51: {
                    FunctionDefinition fd;
                    block50: {
                        fd = (FunctionDefinition)lof.get((long)i3);
                        FunctionDefinition existingFD = curModel.getFunctionDefinition(fd.getId());
                        if (existingFD == null) break block50;
                        String existingMathStr = libsbml.formulaToString((ASTNode)existingFD.getMath());
                        String newMathStr = libsbml.formulaToString((ASTNode)fd.getMath());
                        if (newMathStr.equals(existingMathStr)) break block51;
                        String oldId = fd.getId();
                        StringBuffer newUSId = new StringBuffer(String.valueOf(oldId) + "_x");
                        while (curModel.getFunctionDefinition(newUSId.toString()) != null) {
                            newUSId.append("x");
                        }
                        String newId = newUSId.toString();
                        fd.setId(newId);
                        ASTNode newMath = mappedKineticLaw.getMath();
                        LibSBMLUtil.changeASTNodeName(newMath, oldId, newId, 4);
                    }
                    addedFunctionDefinitions.add(fd);
                }
                ++i3;
            }
        }
        if (m.getNumUnitDefinitions() > 0L) {
            lof = m.getListOfUnitDefinitions();
            int i = 0;
            while ((long)i < lof.size()) {
                UnitDefinition ud = lof.get((long)i);
                UnitDefinition existingUD = curModel.getUnitDefinition(ud.getId());
                if (existingUD != null) {
                    if (!UnitDefinition.areEquivalent((UnitDefinition)existingUD, (UnitDefinition)ud)) {
                        String oldId = ud.getId();
                        StringBuffer newUSId = new StringBuffer(String.valueOf(oldId) + "_x");
                        while (curModel.getUnitDefinition(newUSId.toString()) != null) {
                            newUSId.append("x");
                        }
                        String newId = newUSId.toString();
                        ud.setId(newId);
                        ListOfParameters lop = mappedKineticLaw.getListOfParameters();
                        int k = 0;
                        while ((long)k < lop.size()) {
                            Parameter lp = lop.get((long)k);
                            if (lp.getUnits().equals(oldId)) {
                                lp.setUnits(newId);
                            }
                            ++k;
                        }
                    }
                } else {
                    addedUnitDefinitions.add(ud);
                }
                ++i;
            }
        }
        if ((selected = SabioRK.showConfirmationDialogForKineticLaw(title = "Confirmation Dialog", reacSelected, mappedKineticLaw, addedFunctionDefinitions, addedUnitDefinitions, 2, this, options = new String[]{"Cancel", "OK"})) != 1) {
            return;
        }
        if (addedFunctionDefinitions.size() > 0 || addedUnitDefinitions.size() > 0) {
            editFlag = true;
        }
        for (FunctionDefinition fd : addedFunctionDefinitions) {
            this.currentSBFrame.getSBModel().getModel().addFunctionDefinition(fd);
        }
        for (UnitDefinition ud : addedUnitDefinitions) {
            this.currentSBFrame.getSBModel().getModel().addUnitDefinition(ud);
        }
        SBaseListPanel spPanelOfFunctionDefinition = sbmlPanelLists.getSBaseListPanel(0);
        if (spPanelOfFunctionDefinition == null) {
            throw new Exception("[FATAL] SBaseListPanel of FunctionDefinition is null.");
        }
        spPanelOfFunctionDefinition.updateDialog();
        SBaseListPanel spPanelOfUnitDefinition = sbmlPanelLists.getSBaseListPanel(1);
        if (spPanelOfUnitDefinition == null) {
            throw new Exception("[FATAL] SBaseListPanel of UnitDefinition is null.");
        }
        spPanelOfUnitDefinition.updateDialog();
        String metaIdKl = mappedKineticLaw.getMetaId();
        if (!metaIdKl.equals("") && ((curKl = reacSelected.getKineticLaw()) == null || curKl != null && !curKl.getMetaId().equals(metaIdKl))) {
            String newMetaId = mappedKineticLaw.getMetaId();
            if (LibSBMLUtil.checkDuplicatedMetaId(newMetaId, curModel)) {
                StringBuffer modMetaId = new StringBuffer(String.valueOf(newMetaId) + "_x");
                while (LibSBMLUtil.checkDuplicatedMetaId(modMetaId.toString(), curModel)) {
                    modMetaId.append("x");
                }
                newMetaId = modMetaId.toString();
            }
            mappedKineticLaw.setMetaId(newMetaId);
        }
        reacSelected.setKineticLaw(mappedKineticLaw);
        if (reacSabio.getAnnotation() != null) {
            if (!reacSabio.getMetaId().equals("")) {
                String newMetaId = reacSabio.getMetaId();
                if (!reacSelected.getMetaId().equals(newMetaId)) {
                    if (LibSBMLUtil.checkDuplicatedMetaId(newMetaId, curModel)) {
                        StringBuffer modMetaId = new StringBuffer(String.valueOf(newMetaId) + "_x");
                        while (LibSBMLUtil.checkDuplicatedMetaId(modMetaId.toString(), curModel)) {
                            modMetaId.append("x");
                        }
                        newMetaId = modMetaId.toString();
                    }
                    reacSelected.setMetaId(newMetaId);
                }
            }
            reacSelected.setAnnotation(reacSabio.getAnnotation());
        }
        System.err.println("[DEBUG] addSBMLInfoToModel() : (annotation KineticLaw) : " + reacSelected.getKineticLaw().getAnnotationString());
        SBaseListPanel spPanelOfReaction = sbmlPanelLists.getSBaseListPanel(6);
        if (spPanelOfReaction == null) {
            throw new Exception("[FATAL] SBaseListPanel of Reaction is null.");
        }
        spPanelOfReaction.updateDialog();
        SBaseListPanel spPanelOfParameter = sbmlPanelLists.getSBaseListPanel(4);
        if (spPanelOfParameter != null) {
            ListOfParameters lop = reacSelected.getKineticLaw().getListOfParameters();
            String parentReactionId = reacSelected.getId();
            int i = 0;
            while ((long)i < lop.size()) {
                Parameter localParameter = lop.get((long)i);
                localParameter.setAnnotation(LibSBMLUtil.addEnclosedAnnotationTags(parentReactionId));
                ++i;
            }
        } else {
            throw new Exception("[FATAL] SBaseListPanel of Parameter is null.");
        }
        spPanelOfParameter.updateDialog();
        this.currentSBFrame.getSBModel().setChanged(editFlag);
    }

    private KineticLaw getMappedKineticLaw(Reaction reacFrom, Reaction reacTo) throws Exception {
        KineticLaw mappedKineticLaw = reacFrom.getKineticLaw();
        String errMsgHeader = "Selected SABIO-RK's kineticlaw can't be imported to the selected Reaction (" + reacTo.getId() + ") in CellDesigner.\n";
        if (mappedKineticLaw == null) {
            throw new Exception(String.valueOf(errMsgHeader) + "The SABIO-RK's kineticlaw is null.");
        }
        if (mappedKineticLaw.getMath() == null) {
            throw new Exception(String.valueOf(errMsgHeader) + "A math of the SABIO-RK's kineticlaw is null.");
        }
        ASTNode math = mappedKineticLaw.getMath();
        System.err.println("[DEBUG] getMappedKineticLaw() : (Math before) : " + libsbml.formulaToString((ASTNode)math));
        String title = "Mapping SpeciesReferences ID";
        boolean isModal = true;
        MappingSpeciesReferenceIdDialog dialog = new MappingSpeciesReferenceIdDialog(this, title, isModal, reacFrom, reacTo);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        mappedKineticLaw = dialog.getMappedKineticLaw();
        return mappedKineticLaw;
    }

    public static void paintImmediately() {
        progressBar.paintImmediately(progressBar.getVisibleRect());
    }

    public static void startProgressBarTask(String s) {
        progressBarThread = new Thread(progressBarTask);
        final String str = s;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressBar.setDrawString(str);
                progressBar.setActive(true);
            }
        });
        progressBarThread.start();
    }

    public static void stopProgressBarTask() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressBar.setDrawString("");
                progressBar.setActive(false);
                progressBar.setDrawStart(0);
                SabioRK.paintImmediately();
            }
        });
        progressBarThread = null;
    }

    private void generateReactionSBML() {
        int row = this.reactionsTable.getSelectedRow();
        String sbmlString = null;
        if (row != -1) {
            try {
                SabioReaction sr = reactionsList.get(row);
                SabioKineticLaw skl = null;
                int count = 0;
                int index = this.kineticTabPane.getSelectedIndex();
                TreeMap<Integer, SabioKineticLaw> klhash = sr.getSabioKineticLawsHash();
                System.out.println(index);
                Iterator<Integer> it = klhash.keySet().iterator();
                while (it.hasNext()) {
                    if (count > index) break;
                    skl = sr.getSabioKineticLawsHash().get(it.next());
                    ++count;
                }
                System.out.println(String.valueOf(sr.getEquation()) + " : " + skl.getOrganism() + ":" + skl.getTissue() + " : " + skl.getKineticLawString());
                sbmlString = this.getReactionSBMLString(sr, skl);
                this.addSBMLInfoToModel(sbmlString);
            }
            catch (Exception e) {
                StringWriter stw = new StringWriter();
                PrintWriter pw = new PrintWriter(stw);
                e.printStackTrace(pw);
                String errMsg = e.getMessage();
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, errMsg, "Error", 0);
            }
        } else {
            return;
        }
    }

    private String getReactionSBMLString(SabioReaction sr, SabioKineticLaw skl) {
        Integer[] reactionIDs = new Integer[]{sr.getId()};
        Integer[] kineticLawIDs = new Integer[]{skl.getId()};
        int sbmlVersion = 4;
        int sbmlLevel = 2;
        String modelName = Integer.toString(sr.getId());
        String sbmlString = null;
        String debug_header = "[getReactionSBMLString] (" + reactionIDs[0] + ")";
        System.out.println(String.valueOf(debug_header) + " -> kineticLaw " + kineticLawIDs[0]);
        try {
            sbmlString = this.getSBML(reactionIDs, kineticLawIDs, sbmlVersion, sbmlLevel, modelName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(sbmlString);
        return sbmlString;
    }

    public String getSBML(Integer[] reactionIDs, Integer[] kineticLawIDs, int sbmlVersion, int sbmlLevel, String modelName) throws Exception {
        String BASE_URI = "http://sabiork.h-its.org/sabioRestWebServices";
        DefaultClientConfig config = new DefaultClientConfig();
        Client client = Client.create((ClientConfig)config);
        WebResource webResource = client.resource(BASE_URI).path("kineticLaws");
        String sbmlString = (String)webResource.path(MessageFormat.format("{0}", kineticLawIDs[0].toString())).accept(new String[]{"text/xml"}).get(String.class);
        return sbmlString;
    }

    public static int showConfirmationDialogForKineticLaw(String title, Reaction reacSelected, KineticLaw mappedKineticLaw, ArrayList<FunctionDefinition> fdList, ArrayList<UnitDefinition> udList, int mtype, Component parent, Object[] options) {
        Object[] row;
        boolean textBased = false;
        int xsize = 640;
        int ysize = 320;
        JTextArea tareaKineticLawMath = null;
        JTextArea tareaKineticLawParameter = null;
        JTextArea tareaFunctionDefinition = null;
        JTextArea tareaUnitDefinition = null;
        JScrollPane scrpKineticLawMath = null;
        JScrollPane scrpKineticLawParameter = null;
        JScrollPane scrpFunctionDefinition = null;
        JScrollPane scrpUnitDefinition = null;
        JTabbedPane jtabRoot = new JTabbedPane();
        JPanel jtabKineticLaw = new JPanel();
        jtabKineticLaw.setLayout(new BoxLayout(jtabKineticLaw, 1));
        JTextField mathLabel = new JTextField("Math");
        mathLabel.setEditable(false);
        jtabKineticLaw.add(mathLabel);
        String kineticLawMathString = mappedKineticLaw.getFormula();
        tareaKineticLawMath = new JTextArea("\n  " + kineticLawMathString + "\n");
        tareaKineticLawMath.setLineWrap(true);
        tareaKineticLawMath.setWrapStyleWord(true);
        tareaKineticLawMath.setEditable(false);
        scrpKineticLawMath = new JScrollPane(20, 31);
        scrpKineticLawMath.getViewport().add(tareaKineticLawMath);
        scrpKineticLawMath.setPreferredSize(new Dimension(640, 320));
        jtabKineticLaw.add(scrpKineticLawMath);
        JTextField paraLabel = new JTextField("Local Parameters");
        paraLabel.setEditable(false);
        jtabKineticLaw.add(paraLabel);
        if (mappedKineticLaw.getNumParameters() > 0L) {
            Parameter para;
            scrpKineticLawParameter = new JScrollPane(20, 31);
            if (textBased) {
                StringBuffer textParameters = new StringBuffer();
                int i = 0;
                while ((long)i < mappedKineticLaw.getNumParameters()) {
                    para = mappedKineticLaw.getParameter((long)i);
                    textParameters.append(String.valueOf(para.getId()) + " ");
                    textParameters.append(String.valueOf(para.getName()) + " ");
                    textParameters.append(String.valueOf(para.getValue()) + " ");
                    textParameters.append(String.valueOf(para.getUnits()) + " ");
                    textParameters.append(para.getConstant());
                    textParameters.append("\n");
                    ++i;
                }
                tareaKineticLawParameter = new JTextArea(textParameters.toString());
                tareaKineticLawParameter.setLineWrap(true);
                tareaKineticLawParameter.setWrapStyleWord(true);
                tareaKineticLawParameter.setEditable(false);
                scrpKineticLawParameter.getViewport().add(tareaKineticLawParameter);
            } else {
                DefaultTableModel tblParameters = new DefaultTableModel();
                tblParameters.addColumn("id");
                tblParameters.addColumn("name");
                tblParameters.addColumn("value");
                tblParameters.addColumn("units");
                tblParameters.addColumn("constant");
                int i = 0;
                while ((long)i < mappedKineticLaw.getNumParameters()) {
                    para = mappedKineticLaw.getParameter((long)i);
                    Object[] row2 = new String[]{para.getId(), para.getName(), String.valueOf(para.getValue()), para.getUnits(), String.valueOf(para.getConstant())};
                    tblParameters.addRow(row2);
                    ++i;
                }
                final JTable parameterTable = new JTable(tblParameters){
                    private static final long serialVersionUID = 7165876606021128791L;

                    @Override
                    public boolean isCellEditable(int row, int col) {
                        return false;
                    }
                };
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ColumnResizer.adjustColumnPreferredWidthsWithHeader(parameterTable);
                        parameterTable.revalidate();
                    }
                });
                scrpKineticLawParameter.getViewport().add(parameterTable);
            }
            scrpKineticLawParameter.setPreferredSize(new Dimension(640, 320));
            jtabKineticLaw.add(scrpKineticLawParameter);
        }
        int tabNum = 0;
        jtabRoot.add(jtabKineticLaw);
        jtabRoot.setTitleAt(tabNum++, "KineticLaw");
        if (fdList.size() > 0) {
            scrpFunctionDefinition = new JScrollPane(20, 31);
            if (textBased) {
                StringBuffer textFunctionDefinitions = new StringBuffer();
                for (FunctionDefinition fd : fdList) {
                    StringBuffer arguments = new StringBuffer();
                    int i = 0;
                    while ((long)i < fd.getNumArguments()) {
                        arguments.append(fd.getArgument((long)i).getName());
                        if ((long)i != fd.getNumArguments() - 1L) {
                            arguments.append(",");
                        }
                        ++i;
                    }
                    textFunctionDefinitions.append(String.valueOf(fd.getId()) + " ");
                    textFunctionDefinitions.append(String.valueOf(arguments.toString()) + " ");
                    textFunctionDefinitions.append(String.valueOf(libsbml.formulaToString((ASTNode)fd.getBody())) + " ");
                    textFunctionDefinitions.append("\n");
                }
                tareaFunctionDefinition = new JTextArea(textFunctionDefinitions.toString());
                tareaFunctionDefinition.setLineWrap(true);
                tareaFunctionDefinition.setWrapStyleWord(true);
                tareaFunctionDefinition.setEditable(false);
                scrpFunctionDefinition.getViewport().add(tareaFunctionDefinition);
            } else {
                DefaultTableModel tblFunctionDefinitions = new DefaultTableModel();
                tblFunctionDefinitions.addColumn("id");
                tblFunctionDefinitions.addColumn("arguments");
                tblFunctionDefinitions.addColumn("math");
                for (FunctionDefinition fd : fdList) {
                    row = new String[3];
                    StringBuffer arguments = new StringBuffer();
                    int i = 0;
                    while ((long)i < fd.getNumArguments()) {
                        arguments.append(fd.getArgument((long)i).getName());
                        if ((long)i != fd.getNumArguments() - 1L) {
                            arguments.append(",");
                        }
                        ++i;
                    }
                    row[0] = fd.getId();
                    row[1] = arguments.toString();
                    row[2] = libsbml.formulaToString((ASTNode)fd.getBody());
                    tblFunctionDefinitions.addRow(row);
                }
                final JTable fdTable = new JTable(tblFunctionDefinitions){
                    private static final long serialVersionUID = -8189097012462241995L;

                    @Override
                    public boolean isCellEditable(int row, int col) {
                        return false;
                    }
                };
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ColumnResizer.adjustColumnPreferredWidthsWithHeader(fdTable);
                        fdTable.revalidate();
                    }
                });
                scrpFunctionDefinition.getViewport().add(fdTable);
            }
            scrpFunctionDefinition.setPreferredSize(new Dimension(640, 320));
            jtabRoot.add(scrpFunctionDefinition);
            jtabRoot.setTitleAt(tabNum++, "FunctionDefinition");
        }
        if (udList.size() > 0) {
            scrpUnitDefinition = new JScrollPane(20, 31);
            if (textBased) {
                StringBuffer textUnitDefinitions = new StringBuffer();
                for (UnitDefinition ud : udList) {
                    textUnitDefinitions.append(String.valueOf(ud.getId()) + " ");
                    textUnitDefinitions.append(String.valueOf(ud.getName()) + " ");
                    textUnitDefinitions.append(UnitDefinition.printUnits((UnitDefinition)ud));
                    textUnitDefinitions.append("\n");
                }
                tareaUnitDefinition = new JTextArea(textUnitDefinitions.toString());
                tareaUnitDefinition.setLineWrap(true);
                tareaUnitDefinition.setWrapStyleWord(true);
                tareaUnitDefinition.setEditable(false);
                scrpUnitDefinition.getViewport().add(tareaUnitDefinition);
            } else {
                DefaultTableModel tblUnitDefinitions = new DefaultTableModel();
                tblUnitDefinitions.addColumn("id");
                tblUnitDefinitions.addColumn("name");
                tblUnitDefinitions.addColumn("units");
                for (UnitDefinition ud : udList) {
                    row = new String[]{ud.getId(), ud.getName(), UnitDefinition.printUnits((UnitDefinition)ud, (boolean)true)};
                    tblUnitDefinitions.addRow(row);
                }
                final JTable udTable = new JTable(tblUnitDefinitions){
                    private static final long serialVersionUID = 8466851484558399256L;

                    @Override
                    public boolean isCellEditable(int row, int col) {
                        return false;
                    }
                };
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ColumnResizer.adjustColumnPreferredWidthsWithHeader(udTable);
                        udTable.revalidate();
                    }
                });
                scrpUnitDefinition.getViewport().add(udTable);
            }
            scrpUnitDefinition.setPreferredSize(new Dimension(640, 320));
            jtabRoot.add(scrpUnitDefinition);
            jtabRoot.setTitleAt(tabNum++, "UnitDefinition");
        }
        jtabRoot.setPreferredSize(new Dimension(640, 320));
        jtabRoot.setVisible(true);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JTextArea tareaMessage = new JTextArea();
        tareaMessage.append("\n\n  The following KineticLaw (in Reaction \"" + reacSelected.getId() + "\") and its dependent elements (if any)\n" + "  will be imported by clicking \"OK\" button below.\n\n");
        tareaMessage.setEditable(false);
        panel.add(tareaMessage);
        panel.add(jtabRoot);
        JOptionPane jpane = new JOptionPane(panel, mtype);
        jpane.setOptions(options);
        JDialog dialog = jpane.createDialog(parent, title);
        dialog.setResizable(true);
        dialog.setVisible(true);
        Object selectedValue = jpane.getValue();
        int selected = 0;
        int i = 0;
        while (i < options.length) {
            if (options[i].equals(selectedValue)) {
                selected = i;
                break;
            }
            ++i;
        }
        return selected;
    }

    class MappingSpeciesReferenceIdDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 4893558705711643572L;
        private JPanel mainPanel;
        private JPanel mainPanelRev;
        private JPanel currentMainPanel;
        private Reaction reacFrom;
        private Reaction reacTo;
        private HashMap<String, ArrayList<String>> reactIdMap;
        private HashMap<String, ArrayList<String>> productIdMap;
        private HashMap<String, ArrayList<String>> reactIdRevMap;
        private HashMap<String, ArrayList<String>> productIdRevMap;
        private HashMap<String, ArrayList<String>> modifierIdMap;
        private HashMap<String, ArrayList<String>> modifierIdRevMap;
        private KineticLaw mappedKineticLaw;
        private boolean isCanceled;
        private ArrayList<JComboBox> reactCBList;
        private ArrayList<JComboBox> productCBList;
        private ArrayList<JComboBox> reactRevCBList;
        private ArrayList<JComboBox> productRevCBList;
        private ArrayList<JComboBox> modifierCBList;
        private ArrayList<JComboBox> modifierRevCBList;
        boolean enableSwap;

        private ArrayList<SpeciesListItem> getSelectedSPListArray(ArrayList<JComboBox> arrayJCB) {
            ArrayList<SpeciesListItem> array = new ArrayList<SpeciesListItem>();
            for (JComboBox cb : arrayJCB) {
                array.add((SpeciesListItem)cb.getSelectedItem());
            }
            return array;
        }

        public void mergeKineticLaw(boolean isRev) {
            this.mappedKineticLaw = this.reacFrom.getKineticLaw();
            if (!isRev) {
                this.changeSpeciesIDInASTNode(this.reactCBList);
                this.changeSpeciesIDInASTNode(this.productCBList);
                this.changeSpeciesIDInASTNode(this.modifierCBList);
            } else {
                this.changeSpeciesIDInASTNode(this.reactRevCBList);
                this.changeSpeciesIDInASTNode(this.productRevCBList);
                this.changeSpeciesIDInASTNode(this.modifierRevCBList);
            }
        }

        private void changeSpeciesIDInASTNode(ArrayList<JComboBox> cbList) {
            if (this.mappedKineticLaw == null) {
                return;
            }
            ASTNode math = this.mappedKineticLaw.getMath();
            for (SpeciesListItem sl : this.getSelectedSPListArray(cbList)) {
                String fromId = sl.getSpeciesFrom().getId();
                String toId = sl.getSpeciesTo().getId();
                System.err.println("[DEBUG] gerMappedKineticLaw() : (convert ID) : [from] " + fromId + " [to] " + toId);
                LibSBMLUtil.changeASTNodeName(math, toId, fromId, 0);
            }
        }

        public void postProcess(boolean isSuccess, boolean isRev) {
            if (isSuccess) {
                this.isCanceled = false;
                this.mergeKineticLaw(isRev);
            } else {
                this.isCanceled = true;
                this.mappedKineticLaw = null;
            }
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public KineticLaw getMappedKineticLaw() {
            return this.mappedKineticLaw;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (ev.getSource() instanceof JComboBox) {
                int i;
                ArrayList<JComboBox> cblist;
                JComboBox selectedCmb = (JComboBox)ev.getSource();
                Reaction targetReaction = this.reacFrom;
                LinkedList<String> tmpSprefList = new LinkedList<String>();
                if (this.reactCBList.contains(selectedCmb)) {
                    cblist = this.reactCBList;
                    i = 0;
                    while ((long)i < targetReaction.getNumReactants()) {
                        tmpSprefList.add(targetReaction.getReactant((long)i).getSpecies());
                        ++i;
                    }
                } else if (this.productCBList.contains(selectedCmb)) {
                    cblist = this.productCBList;
                    i = 0;
                    while ((long)i < targetReaction.getNumProducts()) {
                        tmpSprefList.add(targetReaction.getProduct((long)i).getSpecies());
                        ++i;
                    }
                } else if (this.modifierCBList.contains(selectedCmb)) {
                    cblist = this.modifierCBList;
                    i = 0;
                    while ((long)i < targetReaction.getNumModifiers()) {
                        tmpSprefList.add(targetReaction.getModifier((long)i).getSpecies());
                        ++i;
                    }
                } else if (this.reactRevCBList.contains(selectedCmb)) {
                    cblist = this.reactRevCBList;
                    i = 0;
                    while ((long)i < targetReaction.getNumProducts()) {
                        tmpSprefList.add(targetReaction.getProduct((long)i).getSpecies());
                        ++i;
                    }
                } else if (this.productRevCBList.contains(selectedCmb)) {
                    cblist = this.productRevCBList;
                    i = 0;
                    while ((long)i < targetReaction.getNumReactants()) {
                        tmpSprefList.add(targetReaction.getReactant((long)i).getSpecies());
                        ++i;
                    }
                } else if (this.modifierCBList.contains(selectedCmb)) {
                    cblist = this.modifierCBList;
                    i = 0;
                    while ((long)i < targetReaction.getNumModifiers()) {
                        tmpSprefList.add(targetReaction.getModifier((long)i).getSpecies());
                        ++i;
                    }
                } else {
                    return;
                }
                String sid = ((SpeciesListItem)selectedCmb.getSelectedItem()).getSpeciesTo().getId();
                tmpSprefList.remove(sid);
                int i2 = 0;
                while (i2 < cblist.size()) {
                    JComboBox cmb = cblist.get(i2);
                    if (selectedCmb != cmb) {
                        SpeciesListItem cursplist = (SpeciesListItem)cmb.getSelectedItem();
                        String curspid = cursplist.getSpeciesTo().getId();
                        if (tmpSprefList.contains(curspid)) {
                            tmpSprefList.remove(curspid);
                        } else {
                            int sindex = 0;
                            int j = 0;
                            while (j < cmb.getItemCount()) {
                                SpeciesListItem splist = (SpeciesListItem)cmb.getItemAt(j);
                                String id = splist.getSpeciesTo().getId();
                                if (tmpSprefList.contains(id)) {
                                    tmpSprefList.remove(id);
                                    sindex = j;
                                    break;
                                }
                                ++j;
                            }
                            cmb.setSelectedIndex(sindex);
                        }
                    }
                    ++i2;
                }
            }
        }

        public void addComponent(GridBagLayout gb, JPanel panel, Component cmp, int x, int y, int w, int h) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = x;
            gbc.gridy = y;
            gbc.gridwidth = w;
            gbc.gridheight = h;
            gb.setConstraints(cmp, gbc);
            panel.add(cmp);
        }

        private void swapPanel() {
            this.getContentPane().remove(this.currentMainPanel);
            this.pack();
            this.currentMainPanel = this.currentMainPanel == this.mainPanel ? this.mainPanelRev : this.mainPanel;
            this.getContentPane().add(this.currentMainPanel);
            this.pack();
        }

        private JPanel createMainPanel(HashMap<String, ArrayList<String>> idMapR, HashMap<String, ArrayList<String>> idMapP, HashMap<String, ArrayList<String>> idMapM, ArrayList<JComboBox> cbListR, ArrayList<JComboBox> cbListP, ArrayList<JComboBox> cbListM, boolean isRev) {
            JPanel btnPanel;
            JComboBox combobox;
            String id;
            boolean flag;
            int sindex;
            DefaultComboBoxModel<SpeciesListItem> model;
            JTextField spLabel;
            Species sp;
            SpeciesReference spr;
            ArrayList<String> candidates;
            String sid;
            Map.Entry<String, ArrayList<String>> entry;
            LinkedList<String> tmpRefList;
            Iterator<Map.Entry<String, ArrayList<String>>> iterator;
            JLabel celldSpLabel;
            JLabel sabioSpLabel;
            JPanel mPanel = new JPanel();
            GridBagLayout gbLayout = new GridBagLayout();
            mPanel.setLayout(gbLayout);
            int y = 0;
            if (idMapR.size() > 0) {
                JLabel reactLabel = new JLabel("Reactants ID/Name Mapping");
                sabioSpLabel = new JLabel("Species id(name) [SABIO-RK]");
                celldSpLabel = new JLabel("Species id(name) [CellDesigner]");
                this.addComponent(gbLayout, mPanel, reactLabel, 0, y++, 1, 1);
                this.addComponent(gbLayout, mPanel, new JSeparator(), 0, y++, 2, 1);
                this.addComponent(gbLayout, mPanel, celldSpLabel, 0, y, 1, 1);
                this.addComponent(gbLayout, mPanel, sabioSpLabel, 1, y++, 1, 1);
                iterator = idMapR.entrySet().iterator();
                tmpRefList = new LinkedList<String>();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    sid = entry.getKey();
                    candidates = entry.getValue();
                    spr = this.reacTo.getReactant(sid);
                    sp = this.reacTo.getModel().getSpecies(spr.getSpecies());
                    spLabel = new JTextField(String.valueOf(sp.getId()) + " (" + sp.getName() + ")");
                    spLabel.setEditable(false);
                    this.addComponent(gbLayout, mPanel, spLabel, 0, y, 1, 1);
                    model = new DefaultComboBoxModel();
                    sindex = 0;
                    flag = false;
                    int i = 0;
                    while (i < candidates.size()) {
                        id = candidates.get(i);
                        model.addElement(new SpeciesListItem(sp, this.reacFrom.getModel().getSpecies(id)));
                        if (!flag && !tmpRefList.contains(id)) {
                            flag = true;
                            sindex = i;
                            tmpRefList.add(id);
                        }
                        ++i;
                    }
                    combobox = new JComboBox(model);
                    combobox.setSelectedIndex(sindex);
                    combobox.addActionListener(this);
                    cbListR.add(combobox);
                    this.addComponent(gbLayout, mPanel, combobox, 1, y, 1, 1);
                    ++y;
                }
                this.addComponent(gbLayout, mPanel, new JSeparator(), 0, y++, 2, 1);
            }
            if (idMapP.size() > 0) {
                JLabel productLabel = new JLabel("Products ID/Name Mapping");
                sabioSpLabel = new JLabel("Species id(name) [SABIO-RK]");
                celldSpLabel = new JLabel("Species id(name) [CellDesigner]");
                this.addComponent(gbLayout, mPanel, productLabel, 0, y++, 1, 1);
                this.addComponent(gbLayout, mPanel, new JSeparator(), 0, y++, 2, 1);
                this.addComponent(gbLayout, mPanel, celldSpLabel, 0, y, 1, 1);
                this.addComponent(gbLayout, mPanel, sabioSpLabel, 1, y++, 1, 1);
                iterator = idMapP.entrySet().iterator();
                tmpRefList = new LinkedList();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    sid = entry.getKey();
                    candidates = entry.getValue();
                    spr = this.reacTo.getProduct(sid);
                    sp = this.reacTo.getModel().getSpecies(spr.getSpecies());
                    spLabel = new JTextField(String.valueOf(sp.getId()) + " (" + sp.getName() + ")");
                    spLabel.setEditable(false);
                    model = new DefaultComboBoxModel<SpeciesListItem>();
                    sindex = 0;
                    flag = false;
                    int i = 0;
                    while (i < candidates.size()) {
                        id = candidates.get(i);
                        model.addElement(new SpeciesListItem(sp, this.reacFrom.getModel().getSpecies(id)));
                        if (!flag && !tmpRefList.contains(id)) {
                            flag = true;
                            sindex = i;
                            tmpRefList.add(id);
                        }
                        ++i;
                    }
                    combobox = new JComboBox(model);
                    combobox.setSelectedIndex(sindex);
                    combobox.addActionListener(this);
                    cbListP.add(combobox);
                    this.addComponent(gbLayout, mPanel, spLabel, 0, y, 1, 1);
                    this.addComponent(gbLayout, mPanel, combobox, 1, y, 1, 1);
                    ++y;
                }
                this.addComponent(gbLayout, mPanel, new JSeparator(), 0, y++, 2, 1);
            }
            if (idMapM.size() > 0) {
                JLabel modifierLabel = new JLabel("Modifiers ID/Name Mapping");
                sabioSpLabel = new JLabel("Species id(name) [SABIO-RK]");
                celldSpLabel = new JLabel("Species id(name) [CellDesigner]");
                this.addComponent(gbLayout, mPanel, modifierLabel, 0, y++, 1, 1);
                this.addComponent(gbLayout, mPanel, new JSeparator(), 0, y++, 2, 1);
                this.addComponent(gbLayout, mPanel, celldSpLabel, 0, y, 1, 1);
                this.addComponent(gbLayout, mPanel, sabioSpLabel, 1, y++, 1, 1);
                iterator = idMapM.entrySet().iterator();
                tmpRefList = new LinkedList();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    sid = entry.getKey();
                    candidates = entry.getValue();
                    ModifierSpeciesReference mspr = this.reacTo.getModifier(sid);
                    sp = this.reacTo.getModel().getSpecies(mspr.getSpecies());
                    spLabel = new JTextField(String.valueOf(sp.getId()) + " (" + sp.getName() + ")");
                    spLabel.setEditable(false);
                    model = new DefaultComboBoxModel();
                    sindex = 0;
                    flag = false;
                    int i = 0;
                    while (i < candidates.size()) {
                        id = candidates.get(i);
                        model.addElement(new SpeciesListItem(sp, this.reacFrom.getModel().getSpecies(id)));
                        if (!flag && !tmpRefList.contains(id)) {
                            flag = true;
                            sindex = i;
                            tmpRefList.add(id);
                        }
                        ++i;
                    }
                    combobox = new JComboBox(model);
                    combobox.setSelectedIndex(sindex);
                    combobox.addActionListener(this);
                    cbListM.add(combobox);
                    this.addComponent(gbLayout, mPanel, spLabel, 0, y, 1, 1);
                    this.addComponent(gbLayout, mPanel, combobox, 1, y, 1, 1);
                    ++y;
                }
                this.addComponent(gbLayout, mPanel, new JSeparator(), 0, y++, 2, 1);
            }
            final MappingSpeciesReferenceIdDialog myself = this;
            final boolean isRevF = isRev;
            if (this.enableSwap) {
                btnPanel = new JPanel();
                btnPanel.setLayout(new BoxLayout(btnPanel, 0));
                JButton swapBtn = new JButton("Swap Reactants/Products");
                swapBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        myself.swapPanel();
                    }
                });
                btnPanel.add(swapBtn);
                this.addComponent(gbLayout, mPanel, btnPanel, 0, y++, 1, 1);
            }
            btnPanel = new JPanel();
            btnPanel.setLayout(new BoxLayout(btnPanel, 0));
            JButton okBtn = new JButton("Apply");
            JButton cancelBtn = new JButton("Cancel");
            okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    myself.postProcess(true, isRevF);
                    myself.dispose();
                }
            });
            cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    myself.postProcess(false, isRevF);
                    myself.dispose();
                }
            });
            btnPanel.add(okBtn);
            btnPanel.add(cancelBtn);
            this.addComponent(gbLayout, mPanel, btnPanel, 1, y, 1, 1);
            return mPanel;
        }

        public MappingSpeciesReferenceIdDialog(Dialog owner, String title, boolean isModal, Reaction rFrom, Reaction rTo) throws Exception {
            super(owner, title, isModal);
            this.mappedKineticLaw = null;
            this.isCanceled = false;
            this.enableSwap = false;
            this.reacFrom = rFrom;
            this.reacTo = rTo;
            boolean isMapped = false;
            boolean isRevMapped = false;
            this.reactIdMap = this.mappingSpeciesReferenceIDs(this.reacFrom.getListOfReactants(), this.reacTo.getListOfReactants());
            this.productIdMap = this.mappingSpeciesReferenceIDs(this.reacFrom.getListOfProducts(), this.reacTo.getListOfProducts());
            this.reactIdRevMap = this.mappingSpeciesReferenceIDs(this.reacFrom.getListOfProducts(), this.reacTo.getListOfReactants());
            this.productIdRevMap = this.mappingSpeciesReferenceIDs(this.reacFrom.getListOfReactants(), this.reacTo.getListOfProducts());
            this.modifierIdMap = this.mappingModifierSpeciesReferenceIDs(this.reacFrom.getListOfModifiers(), this.reacTo.getListOfModifiers());
            this.modifierIdRevMap = this.mappingModifierSpeciesReferenceIDs(this.reacFrom.getListOfModifiers(), this.reacTo.getListOfModifiers());
            if (this.reactIdMap != null && this.productIdMap != null) {
                isMapped = true;
            }
            if (this.reactIdRevMap != null && this.productIdRevMap != null) {
                isRevMapped = true;
            }
            if (!isMapped && !isRevMapped) {
                String errMsgHeader = "Selected SABIO-RK's kineticlaw can't be imported to the selected Reaction (" + this.reacTo.getId() + ") in CellDesigner.\n";
                String errMsg = "The number of reactants/products and modifiers are mismatched\n[SABIO-RK]   (reactant/product) " + this.reacFrom.getNumReactants() + "/" + this.reacFrom.getNumProducts() + " (modifier) " + this.reacFrom.getNumModifiers() + "\n" + "[CellDesigner] (reactant/product) " + this.reacTo.getNumReactants() + "/" + this.reacTo.getNumProducts() + " (modifier) " + this.reacTo.getNumModifiers() + "\n";
                throw new Exception(String.valueOf(errMsgHeader) + errMsg);
            }
            if (isMapped && isRevMapped) {
                this.enableSwap = true;
            }
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            if (isMapped) {
                this.reactCBList = new ArrayList();
                this.productCBList = new ArrayList();
                this.modifierCBList = new ArrayList();
                this.currentMainPanel = this.mainPanel = this.createMainPanel(this.reactIdMap, this.productIdMap, this.modifierIdMap, this.reactCBList, this.productCBList, this.modifierCBList, false);
            }
            if (isRevMapped) {
                this.reactRevCBList = new ArrayList();
                this.productRevCBList = new ArrayList();
                this.modifierRevCBList = new ArrayList();
                this.mainPanelRev = this.createMainPanel(this.reactIdRevMap, this.productIdRevMap, this.modifierIdRevMap, this.reactRevCBList, this.productRevCBList, this.modifierRevCBList, true);
                if (this.currentMainPanel == null) {
                    this.currentMainPanel = this.mainPanelRev;
                }
            }
            this.getContentPane().add(this.currentMainPanel);
            this.pack();
        }

        private HashMap<String, ArrayList<String>> mappingSpeciesReferenceIDs(ListOfSpeciesReferences fromList, ListOfSpeciesReferences toList) {
            if (fromList.size() != toList.size()) {
                return null;
            }
            HashMap<String, ArrayList<String>> idMap = new HashMap<String, ArrayList<String>>();
            int i = 0;
            while ((long)i < toList.size()) {
                SpeciesReference srTo = (SpeciesReference)toList.get((long)i);
                String toReactId = srTo.getSpecies();
                double toSMath = srTo.getStoichiometry();
                ArrayList<String> sidCandidates = new ArrayList<String>();
                boolean match = false;
                int j = 0;
                while ((long)j < fromList.size()) {
                    SpeciesReference srFrom = (SpeciesReference)fromList.get((long)j);
                    String fromReactId = srFrom.getSpecies();
                    double fromSMath = srFrom.getStoichiometry();
                    if (toSMath == fromSMath) {
                        sidCandidates.add(fromReactId);
                        match = true;
                    }
                    ++j;
                }
                if (!match) {
                    return null;
                }
                idMap.put(toReactId, sidCandidates);
                ++i;
            }
            System.err.println("Candidates for SpeciesReferences : ");
            Iterator iter = idMap.entrySet().iterator();
            int c = 0;
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String toId = (String)entry.getKey();
                ArrayList fromIdList = (ArrayList)entry.getValue();
                System.err.println("[" + c + "] " + "(" + toId + ")");
                int j = 0;
                while (j < fromIdList.size()) {
                    System.err.println("   [" + j + "] " + (String)fromIdList.get(j));
                    ++j;
                }
                ++c;
            }
            return idMap;
        }

        private HashMap<String, ArrayList<String>> mappingModifierSpeciesReferenceIDs(ListOfSpeciesReferences fromList, ListOfSpeciesReferences toList) {
            if (fromList.size() != toList.size()) {
                return null;
            }
            HashMap<String, ArrayList<String>> idMap = new HashMap<String, ArrayList<String>>();
            int i = 0;
            while ((long)i < toList.size()) {
                ModifierSpeciesReference msrTo = (ModifierSpeciesReference)toList.get((long)i);
                String toReactId = msrTo.getSpecies();
                ArrayList<String> sidCandidates = new ArrayList<String>();
                int j = 0;
                while ((long)j < toList.size()) {
                    ModifierSpeciesReference msrFrom = (ModifierSpeciesReference)fromList.get((long)j);
                    String fromReactId = msrFrom.getSpecies();
                    sidCandidates.add(fromReactId);
                    ++j;
                }
                idMap.put(toReactId, sidCandidates);
                ++i;
            }
            System.err.println("Candidates for ModifierSpeciesReferences : ");
            Iterator iter = idMap.entrySet().iterator();
            int c = 0;
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String toId = (String)entry.getKey();
                ArrayList fromIdList = (ArrayList)entry.getValue();
                System.err.println("[" + c + "] " + "(" + toId + ")");
                int j = 0;
                while (j < fromIdList.size()) {
                    System.err.println("   [" + j + "] " + (String)fromIdList.get(j));
                    ++j;
                }
                ++c;
            }
            return idMap;
        }
    }

    class ProgressBarTask
    implements Runnable {
        public ProgressBarTask(SabioRK parent) {
        }

        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            while (currentThread == progressBarThread) {
                try {
                    SabioRK.paintImmediately();
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public class SabioKineticLaw {
        private int id;
        private String kineticLaw;
        private String organism;
        private String tissue;

        public SabioKineticLaw() {
        }

        public SabioKineticLaw(int klid) {
            try {
                this.id = klid;
                this.kineticLaw = SabioRK.this.getKineticLaw(klid);
                this.organism = SabioRK.this.getOrganismFromKLID(klid);
                this.tissue = SabioRK.this.getTissueFromKLID(klid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public SabioKineticLaw(int id, String kineticLaw) {
            this.id = id;
            this.kineticLaw = kineticLaw;
        }

        public int getId() {
            return this.id;
        }

        public String getKineticLawString() {
            return this.kineticLaw;
        }

        public String getOrganism() {
            return this.organism;
        }

        public String getTissue() {
            return this.tissue;
        }
    }

    public class SabioReaction {
        private int id;
        private int[] reactionInsIDs;
        private TreeMap<Integer, SabioKineticLaw> sabioKineticLawsHash;
        private String equation;

        public SabioReaction() {
        }

        public SabioReaction(int id) {
            this.id = id;
            try {
                this.equation = SabioRK.this.getGeneralReactionEquation(id);
                this.reactionInsIDs = SabioRK.this.getReactionInstanceIDs(id);
                System.err.print("DEBUG funa: " + id + ": ");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public SabioReaction(int id, int[] kineticLawIDsNotNull, String equation) {
            this.id = id;
            this.sabioKineticLawsHash = new TreeMap();
            this.equation = equation;
            try {
                int i = 0;
                while (i < kineticLawIDsNotNull.length) {
                    int klid = kineticLawIDsNotNull[i];
                    SabioKineticLaw skl = new SabioKineticLaw(klid);
                    this.sabioKineticLawsHash.put(klid, skl);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String getEquation() {
            return this.equation;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int[] getReactionInsIDs() {
            return this.reactionInsIDs;
        }

        public TreeMap<Integer, SabioKineticLaw> getSabioKineticLawsHash() {
            return this.sabioKineticLawsHash;
        }

        public void createSabioKineticLawsHash() {
            this.sabioKineticLawsHash = new TreeMap();
        }
    }

    class SabioRequestHandler
    implements Runnable {
        Object srcObject;

        public SabioRequestHandler(ActionEvent ev) {
            this.srcObject = ev.getSource();
            SabioRK.this.handlerThread = new Thread(this);
            SabioRK.this.handlerThread.start();
        }

        @Override
        public void run() {
            try {
                try {
                    SabioRK.startProgressBarTask("Searching");
                    if (this.srcObject == SabioRK.this.textPathwaySearch || this.srcObject == SabioRK.this.btnPathwaySearch) {
                        SabioRK.this.searchPathwayByName();
                    } else if (this.srcObject == SabioRK.this.btnReactionSearch) {
                        SabioRK.this.searchReactionByName();
                    } else if (this.srcObject == SabioRK.this.btnImportKineticLaw) {
                        SabioRK.this.generateReactionSBML();
                    } else if (this.srcObject == SabioRK.this.btnKineticLawGet) {
                        SabioRK.this.setKineticLawTab();
                    } else if (this.srcObject == SabioRK.this.btnSeeReaction) {
                        SabioRK.this.seeReactionFromPathway();
                    } else if (this.srcObject == SabioRK.this.cmbEnzyme) {
                        System.err.println("DEBUG: ");
                    } else if (this.srcObject == SabioRK.this.cmbPathways) {
                        SabioRK.this.getListOfReactionsFromPathwayName();
                    } else if (this.srcObject == SabioRK.this.btnEnzymeSearchByName) {
                        SabioRK.this.createCmbModel(SabioRK.this.cmbModelEnzyme, SabioRK.this.textEnzymeSearch.getText(), 0);
                    } else if (this.srcObject == SabioRK.this.btnEnzymeSearchByECNumber) {
                        SabioRK.this.createCmbModel(SabioRK.this.cmbModelEnzyme, SabioRK.this.textEnzymeSearch.getText(), 1);
                    } else if (this.srcObject == SabioRK.this.btnCompoundSearch) {
                        SabioRK.this.createCmbModel(SabioRK.this.cmbModelCompound, SabioRK.this.textCompoundSearch.getText(), 0);
                    } else if (this.srcObject == SabioRK.this.textEnzymeSearch) {
                        SabioRK.this.createCmbModel(SabioRK.this.cmbModelEnzyme, SabioRK.this.textEnzymeSearch.getText(), 0);
                        System.err.println(SabioRK.this.textEnzymeSearch.getText());
                    }
                    SabioRK.stopProgressBarTask();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SabioRK.this.handlerThread = null;
                }
            }
            finally {
                SabioRK.this.handlerThread = null;
            }
        }
    }

    class SpeciesListItem {
        private Species speciesFrom;
        private Species speciesTo;

        public SpeciesListItem(Species spFrom, Species spTo) {
            this.speciesFrom = spFrom;
            this.speciesTo = spTo;
        }

        public Species getSpeciesFrom() {
            return this.speciesFrom;
        }

        public Species getSpeciesTo() {
            return this.speciesTo;
        }

        public String toString() {
            String spTo = String.valueOf(this.speciesTo.getId()) + "(" + this.speciesTo.getName() + ")";
            return new String(spTo);
        }
    }
}

