/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.database;

import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.sbmlExtension.Notes;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.util.OpenMultipleURL;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.CVTerm;
import org.sbml.libsbml.CVTermList;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class Pubmed {
    private static final String pmURL = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=pubmed&dopt=Abstract&list_uids=";
    private static final String regex = "(PMID:\\s*)(\\d+)";
    private static final String regexCV = "urn:miriam:pubmed:\\S+";
    private static Hashtable<String, String> idTable;

    private static void addMiriamIdToHash(CVTermList cvList, String regexCV) {
        if (cvList != null) {
            int i = 0;
            while ((long)i < cvList.getSize()) {
                CVTerm cv = cvList.get((long)i);
                int j = 0;
                while ((long)j < cv.getNumResources()) {
                    String resUri = cv.getResourceURI((long)j);
                    if (resUri.matches(regexCV)) {
                        String[] resArray = resUri.split(":");
                        idTable.put(resArray[3], "true");
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static void addNotesIdToHash(String notesText, String regex) {
        Pattern p = Pattern.compile(regex);
        if (!notesText.equals("")) {
            Matcher m = p.matcher(notesText);
            while (m.find()) {
                String pubmedId = m.group(2);
                if (idTable.containsKey(pubmedId)) continue;
                idTable.put(pubmedId, "true");
            }
        }
    }

    public static void openModelReferenceOnPubmed(SBModelFrame currentSBFrame) {
        idTable = new Hashtable();
        if (currentSBFrame != null) {
            Pubmed.addMiriamIdToHash(currentSBFrame.getSBModel().getModel().getModel().getCVTerms(), regexCV);
        }
        if (idTable.size() > 0) {
            OpenMultipleURL omurl = new OpenMultipleURL(idTable, pmURL);
            Thread t = new Thread(omurl);
            t.start();
        }
    }

    public static void connectToPubmed(SBModelFrame currentSBFrame) {
        String notesText = "";
        String pnotesText = "";
        CVTermList cvList = null;
        idTable = new Hashtable();
        if (currentSBFrame != null) {
            Object obj = currentSBFrame.getSelectedObject();
            if (obj instanceof SpeciesAlias) {
                MonoSpeciesShape mono;
                MonoSpeciesProperty property;
                Protein protein;
                SpeciesAlias sa = (SpeciesAlias)obj;
                Species species = sa.getOriginalSpecies();
                notesText = ((Notes)LibSBMLUtil.getNotes((SBase)species, null)).getText();
                if (sa.getSpeciesSymbol().isProtein() && !(pnotesText = ((Notes)LibSBMLUtil.getNotes((SBase)(protein = (property = (MonoSpeciesProperty)(mono = (MonoSpeciesShape)sa.getGFramedShape()).getProperty()).getProtein()), null)).getText()).equals("")) {
                    notesText = String.valueOf(notesText) + " " + pnotesText;
                }
                cvList = species.getCVTerms();
            } else if (obj instanceof CompartmentAlias) {
                Compartment compartment = ((CompartmentAlias)obj).getOriginalCompartment();
                notesText = ((Notes)LibSBMLUtil.getNotes((SBase)compartment, null)).getText();
                cvList = compartment.getCVTerms();
            } else if (obj instanceof ReactionLink) {
                Reaction reaction = ((ReactionLink)obj).getParentReaction();
                notesText = ((Notes)LibSBMLUtil.getNotes((SBase)reaction, null)).getText();
                cvList = reaction.getCVTerms();
            }
            Pubmed.addMiriamIdToHash(cvList, regexCV);
            Pubmed.addNotesIdToHash(notesText, regex);
            if (idTable.size() > 0) {
                OpenMultipleURL omurl = new OpenMultipleURL(idTable, pmURL);
                Thread t = new Thread(omurl);
                t.start();
            }
        }
    }
}

