/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.database;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MyFileManager;
import jp.sbi.celldesigner.database.PANTHER;
import jp.sbi.celldesigner.database.PathwayEntry;
import jp.sbi.celldesigner.util.ColumnResizer;
import jp.sbi.celldesigner.util.IncrementalSearch;

public class PANTHERPathway
extends JDialog
implements ActionListener,
Runnable {
    private static final long serialVersionUID = 4248015062227854111L;
    private static final String URL_BASE = "http://www.pantherdb.org";
    private static final String URL_PATHWAY_LIST = "/pathway/pathwayList.jsp";
    private final String TITLE = "pantherdb.org";
    private static final String STR_SBML_PREFIX = "<!-- Begin SBML file -->";
    private static final String STR_SBML_SUFFIX = "<!-- End SBML file-->";
    private static final String STR_PATHWAY_LIST_PREFIX = "<!--Begin Pathway Data-->";
    private static final String STR_PATHWAY_LIST_SUFFIX = "<!--End Pathway Data-->";
    private static final String STR_TOKEN_PATHWAY_LIST = "<tr>";
    private static final String STR_TOKEN_PATHWAY_NAME_PREFIX = "');\">";
    private static final String STR_TOKEN_PATHWAY_NAME_SUFFIX = "</a></td>";
    private static final String STR_TOKEN_PATHWAY_PATH_PREFIX = "<a href=";
    private static final String STR_TOKEN_PATHWAY_PATH_SUFFIX = ">View</a></td>";
    private static final String TOOLTIP_SELECT_PATHWAY = "Please select pathway and click [Import]";
    private static final String TOOLTIP_HTML_PART1 = "<html><b>Title: </b>";
    private static final String TOOLTIP_HTML_PART2 = "</html>";
    private static final String[] COLUMN_NAMES = new String[]{"Name"};
    private static final String STR_EMPTY = "";
    private static Vector<PathwayEntry> pantherModelsList;
    private Vector<PathwayEntry> pantherModelsViewList;
    private TableModel dataModel;
    private JTable table;
    private JButton btnImport;
    private JButton btnCancel;
    private JTextField searchField;
    private IncrementalSearch isearch;
    public PANTHER selectedModel;
    private MyFileManager fileManager;
    private MainWindow mainWindow;
    private static boolean isDialogOpened;
    private static boolean isThreadRunning;

    static {
        isDialogOpened = false;
        isThreadRunning = false;
    }

    public static void setDialogOpenStatus(boolean f) {
        isDialogOpened = f;
    }

    public static boolean isDialogOpened() {
        return isDialogOpened;
    }

    public PANTHERPathway(MyFileManager fm, MainWindow mw) {
        super(mw);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                PANTHERPathway.setDialogOpenStatus(false);
                PANTHERPathway.this.mainWindow.changePantherPathwayMenuEnability();
            }
        });
        this.setTitle("pantherdb.org");
        if (pantherModelsList == null) {
            pantherModelsList = new Vector();
        }
        this.pantherModelsViewList = new Vector();
        this.fileManager = fm;
        this.mainWindow = mw;
        this.toFront();
    }

    public List<PathwayEntry> getPantherModelsList() {
        return pantherModelsList;
    }

    public void init(JFrame frame) {
        if (this.createDialog()) {
            this.showDialog(frame);
        } else {
            this.showErrorDialog(frame);
            this.postProcess();
        }
    }

    private void createTableModel() {
        this.dataModel = new MyTableModel();
    }

    private void createTable() {
        this.createTableModel();
        this.table = new JTable(this.dataModel){
            private static final long serialVersionUID = -5250651357446926469L;

            @Override
            public String getToolTipText(MouseEvent e) {
                int row = this.rowAtPoint(e.getPoint());
                PANTHER pathway = (PANTHER)PANTHERPathway.this.pantherModelsViewList.elementAt(row);
                if (pathway.getName() == null) {
                    return PANTHERPathway.TOOLTIP_SELECT_PATHWAY;
                }
                StringBuffer sb = new StringBuffer(PANTHERPathway.TOOLTIP_HTML_PART1);
                sb.append(pathway.getName());
                sb.append(PANTHERPathway.TOOLTIP_HTML_PART2);
                return sb.toString();
            }
        };
        this.table.setSelectionMode(0);
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    PANTHERPathway.this.selectedModel = (PANTHER)PANTHERPathway.this.pantherModelsViewList.elementAt(selectedRow);
                    PANTHERPathway.this.btnImport.setSelected(true);
                }
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.table);
        JPanel panelSc = new JPanel();
        panelSc.add(scrollpane);
        this.getContentPane().add((Component)panelSc, "Center");
    }

    private void createButtons() {
        Box boxBtn = new Box(0);
        this.btnImport = new JButton("Import");
        this.btnImport.addActionListener(this);
        this.btnImport.setToolTipText("Import model from wwww.pantherdb.org");
        this.btnImport.setDefaultCapable(true);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(this);
        this.searchField = new JTextField();
        this.searchField.setToolTipText("Search");
        boxBtn.add(Box.createHorizontalGlue());
        boxBtn.add(this.searchField);
        boxBtn.add(this.btnImport);
        boxBtn.add(this.btnCancel);
        this.getContentPane().add((Component)boxBtn, "South");
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.btnImport && this.selectedModel != null) {
            this.importPANTHERFile(this.selectedModel);
            this.postProcess();
            this.dispose();
        } else if (ev.getSource() == this.btnCancel) {
            this.postProcess();
            this.dispose();
        }
    }

    private void importPANTHERFile(PANTHER pathway) {
        MainWindow.startProgressBarTask("Downloading SBML");
        try {
            String line;
            URL url = new URL(pathway.getUrl());
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            StringBuffer sbuf = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sbuf.append(line);
            }
            br.close();
            int startIndex = sbuf.indexOf(STR_SBML_PREFIX);
            int endIndex = sbuf.lastIndexOf(STR_SBML_SUFFIX);
            sbuf.delete(endIndex, sbuf.length());
            sbuf.delete(0, startIndex + STR_SBML_PREFIX.length());
            MainWindow.stopProgressBarTask();
            this.fileManager.getOpenCommand(sbuf, pathway.getName());
            this.mainWindow.changeCPMenuEnability();
            sbuf = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            MainWindow.stopProgressBarTask();
        }
    }

    public boolean createDialog() {
        if (pantherModelsList.size() == 0 && !this.connectPantherModels()) {
            return false;
        }
        if (this.pantherModelsViewList.size() == 0) {
            Vector clone;
            this.pantherModelsViewList = clone = (Vector)pantherModelsList.clone();
        }
        this.createTable();
        this.createButtons();
        this.isearch = new IncrementalSearch(this.table, pantherModelsList, this.pantherModelsViewList);
        this.searchField.getDocument().addDocumentListener(this.isearch);
        this.setDefaultCloseOperation(2);
        ToolTipManager tp = ToolTipManager.sharedInstance();
        tp.setInitialDelay(100);
        tp.setDismissDelay(600000);
        this.pack();
        return true;
    }

    public void showDialog(JFrame frame) {
        this.setVisible(true);
        final JTable fTable = this.table;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColumnResizer.adjustColumnPreferredWidths(fTable);
                fTable.revalidate();
            }
        });
    }

    public void showErrorDialog(JFrame frame) {
        JOptionPane.showMessageDialog(frame, "Can't connect to pantherdb.org.", "pantherdb.org", 1);
    }

    public boolean connectPantherModels() {
        Vector clone;
        MainWindow.startProgressBarTask("Connecting");
        try {
            URL url = new URL("http://www.pantherdb.org/pathway/pathwayList.jsp");
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            this.parseXHTML(br);
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MainWindow.stopProgressBarTask();
            return false;
        }
        this.pantherModelsViewList = clone = (Vector)pantherModelsList.clone();
        MainWindow.stopProgressBarTask();
        return true;
    }

    public void parseXHTML(BufferedReader br) throws IOException {
        String line;
        StringBuffer sbuf = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sbuf.append(line);
        }
        br.close();
        int startIndex = sbuf.indexOf(STR_PATHWAY_LIST_PREFIX);
        int endIndex = sbuf.lastIndexOf(STR_PATHWAY_LIST_SUFFIX);
        String pageText = sbuf.toString();
        pageText = pageText.substring(startIndex + STR_PATHWAY_LIST_PREFIX.length(), endIndex);
        pageText = pageText.trim();
        StringTokenizer st = new StringTokenizer(pageText, STR_TOKEN_PATHWAY_LIST);
        int length_name_delim = STR_TOKEN_PATHWAY_NAME_PREFIX.length();
        int length_path_delim = STR_TOKEN_PATHWAY_PATH_PREFIX.length();
        String[] rows = pageText.split(STR_TOKEN_PATHWAY_LIST);
        int sum = 0;
        int i = 0;
        while (i < rows.length) {
            String row = rows[i];
            if ((row = row.trim()).length() != 0) {
                int nameIndexStart = row.indexOf(STR_TOKEN_PATHWAY_NAME_PREFIX) + length_name_delim;
                int nameIndexEnd = row.indexOf(STR_TOKEN_PATHWAY_NAME_SUFFIX);
                int fileIndexStart = row.lastIndexOf(STR_TOKEN_PATHWAY_PATH_PREFIX) + length_path_delim;
                int fileIndexEnd = row.indexOf(STR_TOKEN_PATHWAY_PATH_SUFFIX);
                PANTHER p = new PANTHER(Integer.toString(++sum), row.substring(nameIndexStart, nameIndexEnd), URL_BASE + row.substring(fileIndexStart, fileIndexEnd));
                pantherModelsList.add(p);
            }
            ++i;
        }
    }

    public void postProcess() {
        PANTHERPathway.setDialogOpenStatus(false);
        this.mainWindow.changePantherPathwayMenuEnability();
    }

    @Override
    public void run() {
        isThreadRunning = true;
        isThreadRunning = false;
    }

    public static void main(String[] args) {
        PANTHERPathway pathway = new PANTHERPathway(null, null);
        pathway.init(null);
        if (!pathway.isThreadRunning()) {
            Thread thread = new Thread(pathway);
            thread.start();
        }
    }

    public boolean isThreadRunning() {
        return isThreadRunning;
    }

    public class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 3045269741347018965L;

        @Override
        public String getColumnName(int column) {
            if (COLUMN_NAMES == null) {
                return PANTHERPathway.STR_EMPTY;
            }
            if (column >= COLUMN_NAMES.length) {
                return PANTHERPathway.STR_EMPTY;
            }
            return COLUMN_NAMES[column];
        }

        @Override
        public int getRowCount() {
            return PANTHERPathway.this.pantherModelsViewList.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            PANTHER pathway = (PANTHER)PANTHERPathway.this.pantherModelsViewList.elementAt(row);
            if (col == 0) {
                return pathway.getName();
            }
            return null;
        }

        public void removeRow(int row) {
            if (row < 0 || row > PANTHERPathway.this.pantherModelsViewList.size()) {
                return;
            }
            PANTHERPathway.this.pantherModelsViewList.remove(row);
        }
    }
}

