/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.database;

import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.sbmlExtension.Notes;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.celldesigner.util.OpenMultipleURL;
import jp.sbi.celldesigner.util.OpenURLThread;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class MetaCyc {
    public static void connectToMetaCyc(SBModelFrame currentSBFrame) {
        String mcGeneURL = "http://www.metacyc.org/META/search-query?type=GENE&gname=";
        String mcProteinURL = "http://www.metacyc.org/META/search-query?type=GENE&pname=";
        String mcCompoundURL = "http://www.metacyc.org/META/search-query?type=COMPOUND&name=";
        String mcQuickSearchURL = "http://www.metacyc.org/META/substring-search?type=NIL&object=";
        String regex = "(GeneID:\\s*)(\\d+)";
        String notesText = "";
        String sbaseName = "";
        boolean useNotes = false;
        boolean isGene = false;
        boolean isProtein = false;
        boolean isSimpleMolecule = false;
        Pattern p = Pattern.compile("(GeneID:\\s*)(\\d+)");
        if (currentSBFrame != null) {
            Object obj = currentSBFrame.getSelectedObject();
            if (obj instanceof SpeciesAlias) {
                SpeciesAlias sa = (SpeciesAlias)obj;
                Species species = sa.getOriginalSpecies();
                SpeciesAnnotation sp = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null);
                Species sb = null;
                if (sa.isMonoProtein()) {
                    isProtein = true;
                    sb = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getProtein();
                } else if (sa.isMonoGene()) {
                    isGene = true;
                    sb = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getGene();
                } else if (sa.isMonoRNA()) {
                    isGene = true;
                    sb = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getRNA();
                } else if (sa.isMonoAntiSenseRNA()) {
                    isGene = true;
                    sb = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getAntiSenseRNA();
                } else {
                    isSimpleMolecule = true;
                    sb = sa.getOriginalSpecies();
                }
                notesText = ((Notes)LibSBMLUtil.getNotes((SBase)sb, null)).getText();
                notesText = String.valueOf(notesText) + ((Notes)LibSBMLUtil.getNotes((SBase)species, null)).getText();
            } else if (obj instanceof CompartmentAlias) {
                Compartment compartment = ((CompartmentAlias)obj).getOriginalCompartment();
                notesText = ((Notes)LibSBMLUtil.getNotes((SBase)compartment, null)).getText();
            } else if (obj instanceof ReactionLink) {
                Reaction reaction = ((ReactionLink)obj).getParentReaction();
                notesText = ((Notes)LibSBMLUtil.getNotes((SBase)reaction, null)).getText();
            }
            if (notesText != "") {
                Matcher m = p.matcher(notesText);
                Hashtable<String, String> geneidTable = new Hashtable<String, String>();
                while (m.find()) {
                    useNotes = true;
                    String metaCycId = m.group(2);
                    if (geneidTable.containsKey(metaCycId)) continue;
                    geneidTable.put(metaCycId, "true");
                }
                OpenMultipleURL omurl = new OpenMultipleURL(geneidTable, "http://www.metacyc.org/META/search-query?type=GENE&gname=");
                Thread t = new Thread(omurl);
                t.start();
            }
            if (!useNotes) {
                sbaseName = "\"" + currentSBFrame.getSelectedObjectsName() + "\"";
                String url = "";
                if (sbaseName != "") {
                    url = isGene ? "http://www.metacyc.org/META/search-query?type=GENE&gname=" : (isProtein ? "http://www.metacyc.org/META/search-query?type=GENE&pname=" : "http://www.metacyc.org/META/search-query?type=COMPOUND&name=");
                    OpenURLThread ourlt = new OpenURLThread(url, sbaseName);
                    Thread t = new Thread(ourlt);
                    t.start();
                }
            }
        }
    }
}

