/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.database;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MyFileManager;
import jp.sbi.celldesigner.database.JWSModel;
import jp.sbi.celldesigner.database.PathwayEntry;
import jp.sbi.celldesigner.util.ColumnResizer;
import jp.sbi.celldesigner.util.IncrementalSearch;
import jp.sbi.celldesigner.util.OpenURLThread;

public class JWSOnline
extends JDialog
implements ActionListener,
Runnable {
    private static final long serialVersionUID = 8509001785532981853L;
    public static final String URL_PREFIX = "http://jjj.biochem.sun.ac.za";
    public static final String URL_DOWNLOAD = "http://jjj.biochem.sun.ac.za/database/MODIFY_THIS/download.html";
    private final String URL = "http://jjj.biochem.sun.ac.za/cgi-bin/processModelSelection.py?organism=All&category=All";
    private final String URL_BASE = "http://jjj.biochem.sun.ac.za/cgi-bin/getMoreInfo.py?modeldir=";
    private final String TITLE = "JWS Online";
    private static Vector<PathwayEntry> jwsModelsList;
    private Vector<PathwayEntry> jwsModelsViewList;
    private TableModel dataModel;
    private JTable table;
    private JButton btnImport;
    private JButton btnDesc;
    private JButton btnCancel;
    private JTextField searchField;
    private IncrementalSearch isearch;
    public JWSModel selectedModel;
    private MyFileManager fileManager;
    private MainWindow mainWindow;
    private static boolean isDialogOpened;
    private static boolean isThreadRunning;
    private static boolean isPubInfoFilled;

    static {
        isDialogOpened = false;
        isThreadRunning = false;
        isPubInfoFilled = false;
    }

    public static void setDialogOpenStatus(boolean f) {
        isDialogOpened = f;
    }

    public static boolean isDialogOpened() {
        return isDialogOpened;
    }

    public JWSOnline(MyFileManager fm, MainWindow mw) {
        super(mw);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                JWSOnline.setDialogOpenStatus(false);
                JWSOnline.this.mainWindow.changeJWSOnlineMenuEnability();
            }
        });
        this.setTitle("JWS Online");
        if (jwsModelsList == null) {
            jwsModelsList = new Vector();
        }
        this.jwsModelsViewList = new Vector();
        this.fileManager = fm;
        this.mainWindow = mw;
        this.toFront();
    }

    public List<PathwayEntry> getJWSModelsList() {
        return jwsModelsList;
    }

    public void init(JFrame frame) {
        if (this.createDialog()) {
            this.showDialog(frame);
        } else {
            this.showErrorDialog(frame);
            this.postProcess();
        }
    }

    private void createTableModel() {
        this.dataModel = new MyTableModel();
    }

    private void createTable() {
        this.createTableModel();
        this.table = new JTable(this.dataModel){
            private static final long serialVersionUID = -7452201676846076425L;

            @Override
            public String getToolTipText(MouseEvent e) {
                int row = this.rowAtPoint(e.getPoint());
                JWSModel m = (JWSModel)JWSOnline.this.jwsModelsViewList.elementAt(row);
                String rtn = "Please select model and click [Import]";
                if (m.getTitle() != null) {
                    rtn = "<html><b>Title: </b>" + m.getTitle() + "<br>" + "<b>Authors: </b>" + m.getAuthors() + "<br>" + "<b>Journal: </b><i>" + m.getJournal() + "</i>" + "</html>";
                }
                return rtn;
            }
        };
        this.table.setSelectionMode(0);
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    JWSOnline.this.selectedModel = (JWSModel)JWSOnline.this.jwsModelsViewList.elementAt(selectedRow);
                    JWSOnline.this.btnImport.setSelected(true);
                }
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.table);
        JPanel panelSc = new JPanel();
        panelSc.add(scrollpane);
        this.getContentPane().add((Component)panelSc, "Center");
    }

    private void createButtons() {
        Box boxBtn = new Box(0);
        this.btnImport = new JButton("Import");
        this.btnImport.addActionListener(this);
        this.btnImport.setToolTipText("Import model from JWS Online");
        this.btnImport.setDefaultCapable(true);
        this.btnDesc = new JButton("Description");
        this.btnDesc.addActionListener(this);
        this.btnDesc.setToolTipText("Open model description (on web browser)");
        this.searchField = new JTextField();
        this.searchField.setToolTipText("Search");
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(this);
        boxBtn.add(this.btnDesc);
        boxBtn.add(Box.createHorizontalGlue());
        boxBtn.add(this.searchField);
        boxBtn.add(this.btnImport);
        boxBtn.add(this.btnCancel);
        this.getContentPane().add((Component)boxBtn, "South");
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.btnImport && this.selectedModel != null) {
            this.importJWSOnlineFile(this.selectedModel);
            this.postProcess();
            this.dispose();
        } else if (ev.getSource() == this.btnDesc && this.selectedModel != null) {
            OpenURLThread ourlt = new OpenURLThread(this.selectedModel.getUrl());
            Thread t = new Thread(ourlt);
            t.start();
        } else if (ev.getSource() == this.btnCancel) {
            this.postProcess();
            this.dispose();
        }
    }

    private void importJWSOnlineFile(JWSModel bm) {
        MainWindow.startProgressBarTask("Downloading SBML");
        try {
            String line;
            URL url = new URL(bm.getDownloadUrl());
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            StringBuffer sbuf = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sbuf.append(line);
                sbuf.append("\n");
            }
            br.close();
            MainWindow.stopProgressBarTask();
            this.fileManager.getOpenCommand(sbuf, bm.getId());
            this.mainWindow.changeCPMenuEnability();
            sbuf = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            MainWindow.stopProgressBarTask();
        }
    }

    public boolean createDialog() {
        if (jwsModelsList.size() == 0 && !this.connectJWSOnline()) {
            return false;
        }
        if (this.jwsModelsViewList.size() == 0) {
            Vector clone;
            this.jwsModelsViewList = clone = (Vector)jwsModelsList.clone();
        }
        this.createTable();
        this.createButtons();
        this.isearch = new IncrementalSearch(this.table, jwsModelsList, this.jwsModelsViewList);
        this.searchField.getDocument().addDocumentListener(this.isearch);
        this.setDefaultCloseOperation(2);
        ToolTipManager tp = ToolTipManager.sharedInstance();
        tp.setInitialDelay(100);
        tp.setDismissDelay(600000);
        this.pack();
        return true;
    }

    public void showDialog(JFrame frame) {
        this.setVisible(true);
        final JTable fTable = this.table;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColumnResizer.adjustColumnPreferredWidths(fTable);
                fTable.revalidate();
            }
        });
    }

    public void showErrorDialog(JFrame frame) {
        JOptionPane.showMessageDialog(frame, "Can't connect to JWS Online.", "JWS Online", 1);
    }

    public boolean connectJWSOnline() {
        Vector clone;
        MainWindow.startProgressBarTask("Connecting");
        try {
            String line;
            URL url = new URL("http://jjj.biochem.sun.ac.za/cgi-bin/processModelSelection.py?organism=All&category=All");
            BufferedReader br0 = new BufferedReader(new InputStreamReader(url.openStream()));
            int linenum = 0;
            while ((line = br0.readLine()) != null) {
                if (!line.matches(".*<td>(.+)</td><td>(.+)</td><td>(.+)<span class=\"tooltip\">(.+)</span>.+")) continue;
                ++linenum;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            this.parseXHTML(br, linenum);
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MainWindow.stopProgressBarTask();
            return false;
        }
        this.jwsModelsViewList = clone = (Vector)jwsModelsList.clone();
        MainWindow.stopProgressBarTask();
        return true;
    }

    public void parseXHTML(BufferedReader br, int linenum) throws IOException {
        String line;
        String id = "";
        String url = "";
        String name = "";
        String category = "";
        String regex = ".*<td>(.+)</td><td>(.+)</td><td>(.+)<span class=\"tooltip\">(.+)</span>.+";
        String regexSbml = ".*<a href=\"(.+\\.xml)\".+SBML.+</a>.*";
        Pattern p = Pattern.compile(regex);
        Pattern ps = Pattern.compile(regexSbml);
        int count = 0;
        while ((line = br.readLine()) != null) {
            Matcher m = p.matcher(line);
            while (m.find()) {
                MainWindow.startProgressBarTask(String.valueOf(++count * 100 / linenum) + "%");
                name = "[" + m.group(1) + "] " + m.group(4);
                category = m.group(2);
                id = m.group(3);
                url = String.valueOf("http://jjj.biochem.sun.ac.za/cgi-bin/getMoreInfo.py?modeldir=") + id;
                URL urld = new URL(URL_DOWNLOAD.replaceFirst("MODIFY_THIS", id));
                JWSModel bm = new JWSModel(id, name, url, url);
                try {
                    String lined;
                    BufferedReader brd = new BufferedReader(new InputStreamReader(urld.openStream()));
                    while ((lined = brd.readLine()) != null) {
                        Matcher ms = ps.matcher(lined);
                        while (ms.find()) {
                            bm.setDownloadUrl(URL_PREFIX + ms.group(1));
                            jwsModelsList.add(bm);
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public void addPublicationInfo(String urlStr, JWSModel bm) {
        try {
            String line;
            URL url = new URL(urlStr);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            String flag = "";
            String regex = ".*<p class=\"info_item\">(.+)</p>.*";
            Pattern p = Pattern.compile(regex);
            while ((line = br.readLine()) != null) {
                if (line.matches(".*<p class=\"info_title\">Title:</p>.*")) {
                    flag = "title";
                    continue;
                }
                if (line.matches(".*<p class=\"info_title\">Brief Description::</p>.*")) {
                    flag = "desc";
                    continue;
                }
                if (line.matches(".*<p class=\"info_title\">Authors:</p>.*")) {
                    flag = "author";
                    continue;
                }
                if (line.matches(".*<p class=\"info_title\">Journal:</p>.*")) {
                    flag = "journal";
                    continue;
                }
                Matcher m = p.matcher(line);
                while (m.find()) {
                    String content = m.group(1);
                    if (flag == "title") {
                        bm.setTitle(content);
                    } else if (flag == "desc") {
                        bm.setAbstractText(content);
                    } else if (flag == "author") {
                        bm.setAuthors(content);
                    } else if (flag == "journal") {
                        bm.setJournal(content);
                    }
                    flag = "";
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void postProcess() {
        JWSOnline.setDialogOpenStatus(false);
        this.mainWindow.changeJWSOnlineMenuEnability();
    }

    @Override
    public void run() {
        isThreadRunning = true;
        for (JWSModel jWSModel : jwsModelsList) {
            if (jWSModel.getPubUrl().equals("")) continue;
            this.addPublicationInfo(jWSModel.getPubUrl(), jWSModel);
        }
        isThreadRunning = false;
        isPubInfoFilled = true;
    }

    public static void main(String[] args) {
        JWSOnline bms = new JWSOnline(null, null);
        bms.init(null);
        if (!bms.isThreadRunning() && !bms.isPubInfoFilled()) {
            Thread thread = new Thread(bms);
            thread.start();
        }
    }

    public boolean isThreadRunning() {
        return isThreadRunning;
    }

    public boolean isPubInfoFilled() {
        return isPubInfoFilled;
    }

    public class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -2925803559586115874L;
        String[] columnNames = new String[]{"ID", "Name"};

        @Override
        public String getColumnName(int column) {
            if (this.columnNames[column] != null) {
                return this.columnNames[column];
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return JWSOnline.this.jwsModelsViewList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            JWSModel bm = (JWSModel)JWSOnline.this.jwsModelsViewList.elementAt(row);
            if (col == 0) {
                return bm.getId();
            }
            if (col == 1) {
                return bm.getName();
            }
            return null;
        }

        public void removeRow(int row) {
            if (row < 0 || row > JWSOnline.this.jwsModelsViewList.size()) {
                return;
            }
            JWSOnline.this.jwsModelsViewList.remove(row);
        }
    }
}

