/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.database;

import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.sbmlExtension.Notes;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.celldesigner.util.OpenMultipleURL;
import jp.sbi.celldesigner.util.OpenURLThread;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class EntrezGene {
    public static void connectToEntrezGene(SBModelFrame currentSBFrame) {
        String egURL = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=gene&dopt=full_report&list_uids=";
        String egSearchURL = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=search&db=gene&dopt=full_report&term=";
        String regex = "(GeneID:\\s*)(\\d+)";
        String notesText = "";
        boolean useNotes = false;
        Pattern p = Pattern.compile("(GeneID:\\s*)(\\d+)");
        if (currentSBFrame != null) {
            String sbaseName;
            Object obj = currentSBFrame.getSelectedObject();
            if (obj instanceof SpeciesAlias) {
                SpeciesAlias sa = (SpeciesAlias)obj;
                Species species = sa.getOriginalSpecies();
                SpeciesAnnotation sp = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null);
                Species sb = null;
                if (sa.isMonoProtein()) {
                    sb = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getProtein();
                } else if (sa.isMonoGene()) {
                    sb = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getGene();
                } else if (sa.isMonoRNA()) {
                    sb = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getRNA();
                } else if (sa.isMonoAntiSenseRNA()) {
                    sb = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getAntiSenseRNA();
                }
                notesText = ((Notes)LibSBMLUtil.getNotes((SBase)sb, null)).getText();
                notesText = String.valueOf(notesText) + ((Notes)LibSBMLUtil.getNotes((SBase)species, null)).getText();
            } else if (obj instanceof CompartmentAlias) {
                Compartment compartment = ((CompartmentAlias)obj).getOriginalCompartment();
                notesText = ((Notes)LibSBMLUtil.getNotes((SBase)compartment, null)).getText();
            } else if (obj instanceof ReactionLink) {
                Reaction reaction = ((ReactionLink)obj).getParentReaction();
                notesText = ((Notes)LibSBMLUtil.getNotes((SBase)reaction, null)).getText();
            }
            if (notesText != "") {
                Matcher m = p.matcher(notesText);
                Hashtable<String, String> geneidTable = new Hashtable<String, String>();
                while (m.find()) {
                    useNotes = true;
                    String geneId = m.group(2);
                    if (geneidTable.containsKey(geneId)) continue;
                    geneidTable.put(geneId, "true");
                }
                OpenMultipleURL omurl = new OpenMultipleURL(geneidTable, "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=gene&dopt=full_report&list_uids=");
                Thread t = new Thread(omurl);
                t.start();
            }
            if (!useNotes && (sbaseName = currentSBFrame.getSelectedObjectsName()) != "") {
                OpenURLThread ourlt = new OpenURLThread("http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=search&db=gene&dopt=full_report&term=", sbaseName);
                Thread t = new Thread(ourlt);
                t.start();
            }
        }
    }
}

