/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.database;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MyFileManager;
import jp.sbi.celldesigner.database.BioModel;
import jp.sbi.celldesigner.database.PathwayEntry;
import jp.sbi.celldesigner.util.ColumnResizer;
import jp.sbi.celldesigner.util.IncrementalSearch;
import jp.sbi.celldesigner.util.OpenURLThread;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class BioModels
extends JDialog
implements ActionListener,
Runnable {
    private static final long serialVersionUID = -7742256768378019681L;
    public static final String URL_DOWNLOAD = "http://www.ebi.ac.uk/biomodels-main/download?mid=";
    private final String URL = "http://www.ebi.ac.uk/biomodels-main/publ-models.do?cmd=MODELS:ALL#models";
    private final String URL_BASE = "http://www.ebi.ac.uk/biomodels-main/";
    private final String URL_CITEXPLORE = "http://www.ebi.ac.uk/citexplore/";
    private final String TITLE = "BioModels.net";
    private final int COLUMN_ID_WIDTH = 135;
    private static Vector<PathwayEntry> bioModelsList;
    private Vector<PathwayEntry> bioModelsViewList;
    private TableModel dataModel;
    private JTable table;
    private JButton btnImport;
    private JButton btnDesc;
    private JButton btnRef;
    private JButton btnCancel;
    private JTextField searchField;
    private IncrementalSearch isearch;
    public BioModel selectedModel;
    private MyFileManager fileManager;
    private MainWindow mainWindow;
    private static boolean isDialogOpened;
    private static boolean isThreadRunning;
    private static boolean isPubInfoFilled;

    static {
        isDialogOpened = false;
        isThreadRunning = false;
        isPubInfoFilled = false;
    }

    public static void setDialogOpenStatus(boolean f) {
        isDialogOpened = f;
    }

    public static boolean isDialogOpened() {
        return isDialogOpened;
    }

    public BioModels(MyFileManager fm, MainWindow mw) {
        super(mw);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                BioModels.setDialogOpenStatus(false);
                BioModels.this.mainWindow.changeBioModelsMenuEnability();
            }
        });
        this.setTitle("BioModels.net");
        if (bioModelsList == null) {
            bioModelsList = new Vector();
        }
        this.bioModelsViewList = new Vector();
        this.fileManager = fm;
        this.mainWindow = mw;
        this.toFront();
    }

    public List<PathwayEntry> getBioModelsList() {
        return bioModelsList;
    }

    public void init(JFrame frame) {
        if (this.createDialog()) {
            this.showDialog(frame);
        } else {
            this.showErrorDialog(frame);
            this.postProcess();
        }
    }

    private void createTableModel() {
        this.dataModel = new MyTableModel();
    }

    private void createTable() {
        this.createTableModel();
        this.table = new JTable(this.dataModel){
            private static final long serialVersionUID = 4247763030825442560L;

            @Override
            public String getToolTipText(MouseEvent e) {
                int row = this.rowAtPoint(e.getPoint());
                BioModel m = (BioModel)BioModels.this.bioModelsViewList.elementAt(row);
                String rtn = "Please select model and click [Import]";
                if (m.getTitle() != null) {
                    rtn = "<html><b>Title: </b>" + m.getTitle() + "<br>" + "<b>Authors: </b>" + m.getAuthors() + "<br>" + "<b>Journal: </b><i>" + m.getJournal() + "</i><br>" + "<b>Volume: </b>" + m.getVolume() + "(" + m.getIssue() + ")<br>" + "<b>Year: </b>" + m.getYear() + "</html>";
                }
                return rtn;
            }
        };
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setMinWidth(135);
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    BioModels.this.selectedModel = (BioModel)BioModels.this.bioModelsViewList.elementAt(selectedRow);
                    BioModels.this.btnImport.setSelected(true);
                }
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.table);
        JPanel panelSc = new JPanel();
        panelSc.add(scrollpane);
        this.getContentPane().add((Component)panelSc, "Center");
    }

    private void createButtons() {
        Box boxBtn = new Box(0);
        this.btnImport = new JButton("Import");
        this.btnImport.addActionListener(this);
        this.btnImport.setToolTipText("Import model from BioModels.net");
        this.btnImport.setDefaultCapable(true);
        this.btnDesc = new JButton("Description");
        this.btnDesc.addActionListener(this);
        this.btnDesc.setToolTipText("Open model description (on web browser)");
        this.btnRef = new JButton("Reference");
        this.btnRef.addActionListener(this);
        this.searchField = new JTextField();
        this.searchField.setToolTipText("Search");
        this.btnRef.setToolTipText("Open model reference publication (on web browser)");
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(this);
        boxBtn.add(this.btnDesc);
        boxBtn.add(this.btnRef);
        boxBtn.add(Box.createHorizontalGlue());
        boxBtn.add(this.searchField);
        boxBtn.add(this.btnImport);
        boxBtn.add(this.btnCancel);
        this.getContentPane().add((Component)boxBtn, "South");
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.btnImport && this.selectedModel != null) {
            this.importBioModelsFile(this.selectedModel);
            this.postProcess();
            this.dispose();
        } else if (ev.getSource() == this.btnDesc && this.selectedModel != null) {
            OpenURLThread ourlt = new OpenURLThread(this.selectedModel.getUrl());
            Thread t = new Thread(ourlt);
            t.start();
        } else if (ev.getSource() == this.btnRef && this.selectedModel != null) {
            OpenURLThread ourlt = new OpenURLThread(this.selectedModel.getPubUrl());
            Thread t = new Thread(ourlt);
            t.start();
        } else if (ev.getSource() == this.btnCancel) {
            this.postProcess();
            this.dispose();
        }
    }

    private void importBioModelsFile(BioModel bm) {
        MainWindow.startProgressBarTask("Downloading SBML");
        try {
            String line;
            URL url = new URL(bm.getDownloadUrl());
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            StringBuffer sbuf = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sbuf.append(line);
                sbuf.append("\n");
            }
            br.close();
            MainWindow.stopProgressBarTask();
            this.fileManager.getOpenCommand(sbuf, bm.getId());
            this.mainWindow.changeCPMenuEnability();
            sbuf = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            MainWindow.stopProgressBarTask();
        }
    }

    public boolean createDialog() {
        if (bioModelsList.size() == 0 && !this.connectBioModels()) {
            return false;
        }
        if (this.bioModelsViewList.size() == 0) {
            Vector clone;
            this.bioModelsViewList = clone = (Vector)bioModelsList.clone();
        }
        this.createTable();
        this.createButtons();
        this.isearch = new IncrementalSearch(this.table, bioModelsList, this.bioModelsViewList);
        this.searchField.getDocument().addDocumentListener(this.isearch);
        this.setDefaultCloseOperation(2);
        ToolTipManager tp = ToolTipManager.sharedInstance();
        tp.setInitialDelay(100);
        tp.setDismissDelay(600000);
        this.pack();
        return true;
    }

    public void showDialog(JFrame frame) {
        this.setVisible(true);
        final JTable fTable = this.table;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColumnResizer.adjustColumnPreferredWidths(fTable);
                fTable.revalidate();
            }
        });
    }

    public void showErrorDialog(JFrame frame) {
        JOptionPane.showMessageDialog(frame, "Can't connect to BioModels.net.", "BioModels.net", 1);
    }

    public boolean connectBioModels() {
        Vector clone;
        MainWindow.startProgressBarTask("Connecting");
        try {
            URL url = new URL("http://www.ebi.ac.uk/biomodels-main/publ-models.do?cmd=MODELS:ALL#models");
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            this.parseXHTML(br);
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MainWindow.stopProgressBarTask();
            return false;
        }
        this.bioModelsViewList = clone = (Vector)bioModelsList.clone();
        MainWindow.stopProgressBarTask();
        return true;
    }

    public void parseXHTML(BufferedReader br) throws IOException {
        String line;
        int concatLine = 0;
        String id = "";
        String url = "";
        String name = "";
        String pubUrl = "";
        while ((line = br.readLine()) != null) {
            if (line.matches(".*BIOMD\\d+.*")) {
                line = line.replaceFirst(".*href=\"", "");
                line = line.replaceFirst("\".*", "");
                url = String.valueOf("http://www.ebi.ac.uk/biomodels-main/") + line;
                id = line.replaceFirst(".*mid=", "");
                ++concatLine;
                continue;
            }
            if (concatLine == 1) {
                line = line.replaceFirst("</td>", "");
                name = line.replaceFirst(".*\">", "");
                ++concatLine;
                continue;
            }
            if (concatLine != 2) continue;
            pubUrl = line.replaceFirst(".*href=\"", "");
            pubUrl = pubUrl.replaceFirst("\".*", "");
            pubUrl = pubUrl.replaceAll("&amp;", "&");
            concatLine = 0;
            BioModel bm = new BioModel(id, name, url, pubUrl);
            bioModelsList.add(bm);
        }
    }

    public void addPublicationInfo(String urlStr, BioModel bm) {
        try {
            URL url = new URL(urlStr);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            SAXParser parser = spfactory.newSAXParser();
            PubSaxHandler psh = new PubSaxHandler();
            InputSource inputSource = new InputSource(br);
            parser.parse(inputSource, (DefaultHandler)psh);
            bm.setTitle(psh.getTitle());
            bm.setYear(psh.getYear());
            bm.setJournal(psh.getJournal());
            bm.setAbstractText(psh.getAbstractText());
            bm.setAuthors(psh.getAuthors());
            bm.setVolume(psh.getVolume());
            bm.setIssue(psh.getIssue());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXParseException e) {
            System.err.println("SAX parse error with " + bm.getId());
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void postProcess() {
        BioModels.setDialogOpenStatus(false);
        this.mainWindow.changeBioModelsMenuEnability();
    }

    @Override
    public void run() {
        isThreadRunning = true;
        for (BioModel bioModel : bioModelsList) {
            if (!bioModel.getPubUrl().contains("http://www.ebi.ac.uk/citexplore/")) continue;
            this.addPublicationInfo(bioModel.getPubUrl().replaceFirst("citationDetails", "viewXML"), bioModel);
        }
        isThreadRunning = false;
        isPubInfoFilled = true;
    }

    public static void main(String[] args) {
        BioModels bms = new BioModels(null, null);
        bms.init(null);
        if (!bms.isThreadRunning() && !bms.isPubInfoFilled()) {
            Thread thread = new Thread(bms);
            thread.start();
        }
    }

    public boolean isThreadRunning() {
        return isThreadRunning;
    }

    public boolean isPubInfoFilled() {
        return isPubInfoFilled;
    }

    public class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -2925803559586115874L;
        String[] columnNames = new String[]{"ID", "Name"};

        @Override
        public String getColumnName(int column) {
            if (this.columnNames[column] != null) {
                return this.columnNames[column];
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return BioModels.this.bioModelsViewList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            BioModel bm = (BioModel)BioModels.this.bioModelsViewList.elementAt(row);
            if (col == 0) {
                return bm.getId();
            }
            if (col == 1) {
                return bm.getName();
            }
            return null;
        }

        public void removeRow(int row) {
            if (row < 0 || row > BioModels.this.bioModelsViewList.size()) {
                return;
            }
            BioModels.this.bioModelsViewList.remove(row);
        }
    }

    public class PubSaxHandler
    extends DefaultHandler {
        private String elemName;
        private String pElemName;
        private String charStr;
        private String title;
        private String year;
        private String journal;
        private String abstractText;
        private String authors;
        private String volume;
        private String issue;

        @Override
        public void startDocument() {
            this.elemName = "";
            this.pElemName = "";
            this.charStr = "";
            this.title = "";
            this.year = "";
            this.journal = "";
            this.abstractText = "";
            this.authors = "";
            this.volume = "";
            this.issue = "";
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.pElemName = this.elemName;
            this.elemName = qName;
        }

        @Override
        public void characters(char[] ch, int offset, int length) {
            this.charStr = new String(ch, offset, length);
            if (!this.charStr.equals("")) {
                if (this.elemName.equals("Title")) {
                    this.journal = this.charStr;
                } else if (this.elemName.equals("ArticleTitle")) {
                    this.title = this.charStr;
                } else if (this.elemName.equals("AbstractText")) {
                    this.abstractText = this.charStr;
                } else if (this.elemName.equals("Year") && this.pElemName.equals("PubDate")) {
                    this.year = this.charStr;
                } else if (this.elemName.equals("LastName")) {
                    if (!this.authors.equals("")) {
                        this.authors = String.valueOf(this.authors) + " and ";
                    }
                    this.authors = String.valueOf(this.authors) + this.charStr;
                } else if (this.elemName.equals("Initials")) {
                    this.authors = String.valueOf(this.authors) + ", " + this.charStr + ".";
                } else if (this.elemName.equals("Volume")) {
                    this.volume = this.charStr;
                } else if (this.elemName.equals("Issue")) {
                    this.issue = this.charStr;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.elemName = "";
        }

        public String getTitle() {
            return this.title;
        }

        public String getYear() {
            return this.year;
        }

        public String getJournal() {
            return this.journal;
        }

        public String getAbstractText() {
            return this.abstractText;
        }

        public String getAuthors() {
            return this.authors;
        }

        public String getVolume() {
            return this.volume;
        }

        public String getIssue() {
            return this.issue;
        }
    }
}

