/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.copasi;

import java.awt.Dimension;
import org.COPASI.CModel;
import org.COPASI.CTimeSeries;
import org.COPASI.CTrajectoryTask;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class TimeSeriesPlot {
    public static final int CREATE_SPECIES_PLOT = 0;
    public static final int CREATE_PARAMETER_PLOT = 1;
    public static final int CREATE_COMPARTMENT_PLOT = 2;
    private XYSeriesCollection dataset;
    private CTrajectoryTask cTask;
    private CTimeSeries timeSeries;
    private ChartPanel chartPanel;
    private double maxSize = 0.0;

    public TimeSeriesPlot() {
    }

    public TimeSeriesPlot(CTrajectoryTask task, int target) {
        this.cTask = task;
        this.timeSeries = task.getTimeSeries();
        this.dataset = new XYSeriesCollection();
        if (target == 0) {
            this.createSpeciesDataset();
        } else if (target == 1) {
            this.createParameterDataset(task);
        } else if (target == 2) {
            this.createCompartmentDataset(task);
        } else {
            this.createSpeciesDataset();
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)this.timeSeries.getSBMLId(0L), (String)"Time", (String)"Concentration", (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        axis.setAutoRangeIncludesZero(false);
        axis.setAutoRangeMinimumSize(this.maxSize);
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.setPreferredSize(new Dimension(600, 400));
    }

    private void createSpeciesDataset() {
        this.maxSize = 0.0;
        long offset = 1L;
        long numSpecies = this.cTask.getProblem().getModel().getNumMetabs();
        long j = offset;
        while (j < numSpecies + offset) {
            XYSeries series = new XYSeries(this.timeSeries.getSBMLId(j));
            long i = 0L;
            while (i < this.timeSeries.getRecordedSteps()) {
                double val = this.timeSeries.getConcentrationData(i, j);
                if (val > this.maxSize) {
                    this.maxSize = val;
                }
                series.add(this.timeSeries.getConcentrationData(i, 0L), val);
                ++i;
            }
            this.dataset.addSeries(series);
            ++j;
        }
    }

    private void createCompartmentDataset(CTrajectoryTask task) {
        CModel model = task.getProblem().getModel();
        this.maxSize = 0.0;
        long offset = 1L;
        long numSpecies = this.cTask.getProblem().getModel().getNumMetabs();
        long numCompartments = model.getNumCompartments();
        long j = offset += numSpecies;
        while (j < numCompartments + offset) {
            if (!model.getCompartment(j - offset).isFixed()) {
                XYSeries series = new XYSeries(this.timeSeries.getSBMLId(j));
                long i = 0L;
                while (i < this.timeSeries.getRecordedSteps()) {
                    double val = this.timeSeries.getConcentrationData(i, j);
                    if (val > this.maxSize) {
                        this.maxSize = val;
                    }
                    series.add(this.timeSeries.getConcentrationData(i, 0L), val);
                    ++i;
                }
                this.dataset.addSeries(series);
            }
            ++j;
        }
    }

    private void createParameterDataset(CTrajectoryTask task) {
        CModel model = task.getProblem().getModel();
        this.maxSize = 0.0;
        long offset = 1L;
        long numSpecies = this.cTask.getProblem().getModel().getNumMetabs();
        long numCompartments = model.getNumCompartments();
        long numParameters = model.getNumModelValues();
        long j = offset += numSpecies + numCompartments;
        while (j < numParameters + offset) {
            if (!model.getModelValue(j - offset).isFixed()) {
                XYSeries series = new XYSeries(this.timeSeries.getSBMLId(j));
                long i = 0L;
                while (i < this.timeSeries.getRecordedSteps()) {
                    double val = this.timeSeries.getConcentrationData(i, j);
                    if (val > this.maxSize) {
                        this.maxSize = val;
                    }
                    series.add(this.timeSeries.getConcentrationData(i, 0L), val);
                    ++i;
                }
                this.dataset.addSeries(series);
            }
            ++j;
        }
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }
}

