/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.copasi;

import java.util.Enumeration;
import javax.swing.JOptionPane;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.sbi.celldesigner.copasi.Copasi;
import jp.sbi.celldesigner.copasi.ElaborateTaskRunEventListener;
import jp.sbi.celldesigner.simulation.ExecuteSolver;
import jp.sbi.celldesigner.soslib.SOSlib;
import jp.sbi.celldesigner.soslib.SOSlibException;
import org.COPASI.CCopasiTask;
import org.COPASI.CModel;
import org.COPASI.CTimeSeries;
import org.COPASI.gui.TaskRunEvent;
import org.COPASI.gui.TaskRunEventListener;

public class ExecuteCopasi
extends ExecuteSolver {
    private String[] args;
    private int solverType;
    public static final int NORMAL_SOLVER = 0;
    public static final int PARAMETER_SCAN1 = 1;
    public static final int PARAMETER_SCAN2 = 2;
    private Copasi copasi;
    private boolean isDebug = false;
    private boolean isCompareWithSoslib = false;

    public ExecuteCopasi(String[] args, int solverType) {
        this.solverType = solverType;
        this.args = args;
        this.copasi = new Copasi();
        this.copasi.loadModel(args[1]);
        this.copasi.getCTask().setMethodType(18);
        this.copasi.setDuration(Double.valueOf(args[2]));
        double tmp = Double.valueOf(args[3]);
        this.copasi.setStepNumber((long)tmp);
        this.copasi.setRelativeTolerance(Double.valueOf(args[4]));
        if (this.isDebug) {
            this.copasi.addTaskRunEventListener(new ElaborateTaskRunEventListener(null));
            this.debugPrint();
        }
    }

    private SBMLResults processTask() {
        CCopasiTask task = this.copasi.getCTask();
        try {
            task.process(true);
        }
        catch (Exception e) {
            String message = e.getMessage();
            JOptionPane.showMessageDialog(null, message, "Error", 0);
        }
        return new SBMLResults(task);
    }

    @Override
    public void run() {
        CCopasiTask task = this.copasi.getCTask();
        if (this.solverType == 0) {
            this.results = this.processTask();
            if (this.isDebug) {
                TaskRunEvent event = new TaskRunEvent((Object)task);
                this.processTaskRunEvent(event);
                if (this.isCompareWithSoslib) {
                    try {
                        this.results = SOSlib.solveOde2(this.args);
                    }
                    catch (SOSlibException ep) {
                        JOptionPane.showMessageDialog(null, "Simulation Failed: \n" + ep.getMessage(), "Error", 0);
                    }
                }
            }
        } else if (this.solverType == 1) {
            String rid = this.args[5];
            String id = this.args[6];
            double startVal = Double.valueOf(this.args[7]);
            double endVal = Double.valueOf(this.args[8]);
            int designPoint = Double.valueOf(this.args[9]).intValue();
            int vnum = designPoint + 1;
            SBMLResults[] newSBMLResultsArray = new SBMLResults[vnum];
            int i = 0;
            while (i < vnum) {
                SBMLResults sbmlResult;
                double val = startVal + (double)i * (endVal - startVal) / (double)designPoint;
                this.copasi.setParameterOrInitialConcentration(rid, id, val);
                newSBMLResultsArray[i] = sbmlResult = this.processTask();
                ++i;
            }
            this.listOfResults = newSBMLResultsArray;
        } else if (this.solverType == 2) {
            String rid = this.args[5];
            String id = this.args[6];
            double startVal = Double.valueOf(this.args[7]);
            double endVal = Double.valueOf(this.args[8]);
            int designPoint = Double.valueOf(this.args[9]).intValue();
            int vnum = designPoint + 1;
            String rid2 = this.args[10];
            String id2 = this.args[11];
            double startVal2 = Double.valueOf(this.args[12]);
            double endVal2 = Double.valueOf(this.args[13]);
            int designPoint2 = Double.valueOf(this.args[14]).intValue();
            int vnum2 = designPoint2 + 1;
            Object[] newSBMLResultsArrayMatrix = new Object[vnum];
            int i = 0;
            while (i < vnum) {
                SBMLResults[] newSBMLResultsArray = new SBMLResults[vnum2];
                double val = startVal + (double)i * (endVal - startVal) / (double)designPoint;
                this.copasi.setParameterOrInitialConcentration(rid, id, val);
                int j = 0;
                while (j < vnum2) {
                    SBMLResults sbmlResult;
                    double val2 = startVal2 + (double)j * (endVal2 - startVal2) / (double)designPoint2;
                    this.copasi.setParameterOrInitialConcentration(rid2, id2, val2);
                    newSBMLResultsArray[j] = sbmlResult = this.processTask();
                    ++j;
                }
                newSBMLResultsArrayMatrix[i] = newSBMLResultsArray;
                ++i;
            }
            this.listOfResults = newSBMLResultsArrayMatrix;
        }
        this.isEnd = true;
    }

    protected void processTaskRunEvent(TaskRunEvent event) {
        Enumeration<TaskRunEventListener> enu = this.copasi.mListeners.elements();
        while (enu.hasMoreElements()) {
            TaskRunEventListener listener = enu.nextElement();
            listener.taskRun(event);
        }
    }

    public void debugPrint() {
        System.err.println("Copasi!");
        System.err.println(this.copasi.getDuration());
        System.err.println(this.copasi.getStepSize());
        System.err.println(this.copasi.getStepNumber());
        System.err.println(this.copasi.getRelativeTolerance());
        this.copasi.showAllProblemParameters();
        this.copasi.showAllMethodParameters();
    }

    public void debugPrintModel() {
        String id;
        CModel m = this.copasi.getCModel();
        System.err.println("Copasi!");
        int i = 0;
        while ((long)i < m.getNumMetabs()) {
            id = m.getMetabolite((long)i).getSBMLId();
            double d = m.getMetabolite((long)i).getInitialConcentration();
            System.out.println(String.valueOf(id) + ": " + d);
            ++i;
        }
        i = 0;
        while ((long)i < m.getNumReactions()) {
            id = m.getReaction((long)i).getSBMLId();
            System.out.println(String.valueOf(id) + ": ");
            System.out.print("  " + m.getReaction((long)i).getParameters().getName(0L));
            System.out.println(": " + m.getReaction((long)i).getParameters().getParameter(0L).getDblValue());
            ++i;
        }
    }

    public void debugPrintData(CTimeSeries timeSeries) {
        System.err.println("--------");
        System.err.println(timeSeries.getConcentrationData(0L, 3L));
        System.err.println(timeSeries.getConcentrationData(1L, 3L));
        System.err.println(timeSeries.getConcentrationData(50L, 3L));
    }
}

