/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.copasi;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.sbi.celldesigner.copasi.Copasi;
import jp.sbi.celldesigner.copasi.TimeSeriesPlot;
import jp.sbi.celldesigner.util.PoliteFileDialog;
import org.COPASI.CCopasiTask;
import org.COPASI.CModel;
import org.COPASI.CTimeSeries;
import org.COPASI.CTrajectoryTask;
import org.COPASI.gui.TaskRunEvent;
import org.COPASI.gui.TaskRunEventListener;
import org.jfree.ui.RefineryUtilities;

public class ElaborateTaskRunEventListener
implements TaskRunEventListener,
ActionListener {
    CTrajectoryTask cTask;
    JFrame rootFrame = null;
    JDialog mainFrame = null;
    JButton btnSave;
    JButton btnClose;

    public ElaborateTaskRunEventListener(JFrame root) {
        this.rootFrame = root;
    }

    public void taskRun(TaskRunEvent event) {
        System.out.println("The task has been run.");
        if (event.getSource() instanceof CTrajectoryTask) {
            this.cTask = (CTrajectoryTask)event.getSource();
            CModel model = this.cTask.getProblem().getModel();
            this.mainFrame = new JDialog(this.rootFrame);
            this.mainFrame.setTitle("Time Course Result");
            JTabbedPane tabbedPaneMain = new JTabbedPane();
            JTabbedPane tabbedPanePlot = new JTabbedPane();
            JTabbedPane tabbedPaneTable = new JTabbedPane();
            int numplot = 0;
            TimeSeriesPlot plotSpecies = new TimeSeriesPlot(this.cTask, 0);
            tabbedPanePlot.add((Component)plotSpecies.getChartPanel());
            tabbedPanePlot.setTitleAt(numplot++, "Species");
            JTable tableSpecies = this.createSpeciesTable(this.cTask);
            JScrollPane scrollPaneSpecies = new JScrollPane(tableSpecies);
            tabbedPaneTable.add(scrollPaneSpecies);
            tabbedPaneTable.setTitleAt(0, "Species");
            if (Copasi.getNumNonconstParameters(model) > 0) {
                TimeSeriesPlot plotParameter = new TimeSeriesPlot(this.cTask, 1);
                tabbedPanePlot.add((Component)plotParameter.getChartPanel());
                tabbedPanePlot.setTitleAt(numplot, "Parameter");
                JTable tableParameter = this.createParameterTable(this.cTask);
                JScrollPane scrollPaneParameter = new JScrollPane(tableParameter);
                tabbedPaneTable.add(scrollPaneParameter);
                tabbedPaneTable.setTitleAt(numplot, "Parameter");
                ++numplot;
            }
            if (Copasi.getNumNonconstCompartments(model) > 0) {
                TimeSeriesPlot plotCompartment = new TimeSeriesPlot(this.cTask, 2);
                tabbedPanePlot.add((Component)plotCompartment.getChartPanel());
                tabbedPanePlot.setTitleAt(numplot, "Compartment");
                JTable tableCompartment = this.createCompartmentTable(this.cTask);
                JScrollPane scrollPaneCompartment = new JScrollPane(tableCompartment);
                tabbedPaneTable.add(scrollPaneCompartment);
                tabbedPaneTable.setTitleAt(numplot, "Compartment");
                ++numplot;
            }
            tabbedPaneMain.add(tabbedPanePlot);
            tabbedPaneMain.add(tabbedPaneTable);
            tabbedPaneMain.setTitleAt(0, "Plot");
            tabbedPaneMain.setTitleAt(1, "Table");
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(tabbedPaneMain);
            JPanel panelBtn = new JPanel();
            panelBtn.setLayout(new BoxLayout(panelBtn, 0));
            this.btnSave = new JButton("Save");
            this.btnSave.addActionListener(this);
            this.btnSave.setSelected(true);
            this.btnClose = new JButton("Close");
            this.btnClose.addActionListener(this);
            panelBtn.add(this.btnSave);
            panelBtn.add(this.btnClose);
            panel.add(panelBtn);
            this.mainFrame.getContentPane().add(panel);
            this.mainFrame.pack();
            RefineryUtilities.centerFrameOnScreen((Window)this.mainFrame);
            this.mainFrame.setVisible(true);
        }
    }

    private JTable createSpeciesTable(CTrajectoryTask task) {
        CTimeSeries timeSeries = task.getTimeSeries();
        long offset = 1L;
        long iMax = timeSeries.getRecordedSteps();
        long jMax = task.getProblem().getModel().getNumMetabs() + offset;
        Vector<String> columnNames = new Vector<String>();
        Vector data = new Vector();
        columnNames.addElement("time/name");
        long j = offset;
        while (j < jMax) {
            columnNames.addElement(timeSeries.getSBMLId(j));
            ++j;
        }
        long i = 0L;
        while (i < iMax) {
            Vector<Double> tmp = new Vector<Double>();
            tmp.addElement(new Double(timeSeries.getConcentrationData(i, 0L)));
            j = offset;
            while (j < jMax) {
                tmp.addElement(new Double(timeSeries.getConcentrationData(i, j)));
                ++j;
            }
            data.addElement(tmp);
            ++i;
        }
        JTable table = new JTable(data, columnNames);
        table.setAutoResizeMode(0);
        return table;
    }

    private JTable createCompartmentTable(CTrajectoryTask task) {
        CTimeSeries timeSeries = task.getTimeSeries();
        CModel model = task.getProblem().getModel();
        long offset = 1L;
        long iMax = timeSeries.getRecordedSteps();
        long numSpecies = model.getNumMetabs();
        long numCompartments = model.getNumCompartments();
        long jMax = (offset += numSpecies) + numCompartments;
        Vector<String> columnNames = new Vector<String>();
        Vector data = new Vector();
        columnNames.addElement("time/name");
        long j = offset;
        while (j < jMax) {
            long noffset = j - offset;
            if (!model.getCompartment(noffset).isFixed()) {
                columnNames.addElement(timeSeries.getSBMLId(j));
            }
            ++j;
        }
        long i = 0L;
        while (i < iMax) {
            Vector<Double> tmp = new Vector<Double>();
            tmp.addElement(new Double(timeSeries.getConcentrationData(i, 0L)));
            j = offset;
            while (j < jMax) {
                long noffset = j - offset;
                if (!model.getCompartment(noffset).isFixed()) {
                    tmp.addElement(new Double(timeSeries.getConcentrationData(i, j)));
                }
                ++j;
            }
            data.addElement(tmp);
            ++i;
        }
        JTable table = new JTable(data, columnNames);
        table.setAutoResizeMode(0);
        return table;
    }

    private JTable createParameterTable(CTrajectoryTask task) {
        CTimeSeries timeSeries = task.getTimeSeries();
        CModel model = task.getProblem().getModel();
        long offset = 1L;
        long iMax = timeSeries.getRecordedSteps();
        long numSpecies = model.getNumMetabs();
        long numCompartments = model.getNumCompartments();
        long numParameters = model.getNumModelValues();
        long jMax = (offset += numSpecies + numCompartments) + numParameters;
        Vector<String> columnNames = new Vector<String>();
        Vector data = new Vector();
        columnNames.addElement("time/name");
        long j = offset;
        while (j < jMax) {
            long noffset = j - offset;
            if (!model.getModelValue(noffset).isFixed()) {
                columnNames.addElement(timeSeries.getSBMLId(j));
            }
            ++j;
        }
        long i = 0L;
        while (i < iMax) {
            Vector<Double> tmp = new Vector<Double>();
            tmp.addElement(new Double(timeSeries.getConcentrationData(i, 0L)));
            j = offset;
            while (j < jMax) {
                long noffset = j - offset;
                if (!model.getModelValue(noffset).isFixed()) {
                    tmp.addElement(new Double(timeSeries.getConcentrationData(i, j)));
                }
                ++j;
            }
            data.addElement(tmp);
            ++i;
        }
        JTable table = new JTable(data, columnNames);
        table.setAutoResizeMode(0);
        return table;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnSave) {
            SBMLResults results = new SBMLResults((CCopasiTask)this.cTask);
            try {
                String path = PoliteFileDialog.getSelectedFilePath("Select file", ".txt", 1);
                if (path != null) {
                    results.outputFile(path);
                }
            }
            catch (IOException iOException) {}
        } else if (e.getSource() == this.btnClose) {
            this.mainFrame.dispose();
        }
    }
}

