/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.copasi;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jp.co.mki.celldesigner.simulation.util.SimulationProperties;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MainWindowAccess;
import jp.sbi.celldesigner.SBMLFiler;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.copasi.ElaborateTaskRunEventListener;
import jp.sbi.celldesigner.util.CelldUtil;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.SpecInfo;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.COPASI.gui.TaskRunEventListener;
import org.COPASI.gui.TrajectoryTaskWidget;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLWriter;

public class CopasiGUI
implements Runnable {
    private static boolean isRunning = false;
    private TrajectoryTaskWidget trajWidget = null;
    private JFrame copasiDialog = null;
    private MainWindowAccess Access;
    private SBModelFrame SbFrame;
    private String copasiFunc;

    public CopasiGUI(MainWindowAccess access) {
        this.setMainWindowAccess(access);
        this.setSBModelFrame(((MainWindow)access).getCurrentModel());
    }

    public CopasiGUI(MainWindowAccess access, String copasi_func) {
        this.setMainWindowAccess(access);
        this.setSBModelFrame(((MainWindow)access).getCurrentModel());
        this.copasiFunc = copasi_func;
    }

    @Override
    public void run() {
        if (!CopasiGUI.getStatus()) {
            try {
                CopasiGUI.setStatus(true);
                ((MainWindow)this.Access).setCopasiMenuItemStatus(false);
                if (this.copasiFunc.equals("TimeCourseSimulation")) {
                    this.runTimeCourseSimulation();
                }
            }
            catch (Exception e) {
                this.postProcess();
            }
        }
    }

    public void runTimeCourseSimulation() {
        String sbml_file = String.valueOf(SimulationProperties.simDirPath) + System.getProperty("file.separator") + "input" + System.getProperty("file.separator") + "copasi_input.xml";
        this.writeXML(new File(sbml_file));
        this.copasiDialog = new JFrame();
        this.trajWidget = new TrajectoryTaskWidget(true);
        this.trajWidget.addTaskRunEventListener((TaskRunEventListener)new ElaborateTaskRunEventListener(this.copasiDialog));
        this.trajWidget.loadModel(sbml_file);
        this.createSimpleGUI(new File(this.SbFrame.getFilename()).getName());
        this.copasiDialog.toFront();
    }

    public void createSimpleGUI(String title) {
        WindowAdapter winListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CopasiGUI.this.postProcess();
            }
        };
        this.copasiDialog.setTitle("Copasi Time Course Simulation [" + title + "]");
        this.copasiDialog.getContentPane().add((Component)this.trajWidget);
        this.copasiDialog.addWindowListener(winListener);
        this.copasiDialog.pack();
        this.copasiDialog.setVisible(true);
        this.copasiDialog.toFront();
    }

    public void createGUI(String title) {
        WindowAdapter winListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CopasiGUI.this.postProcess();
            }
        };
        GridBagLayout layout = new GridBagLayout();
        this.copasiDialog.setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        this.copasiDialog.setTitle("Copasi Time Course Simulation [" + title + "]");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.fill = 2;
        layout.setConstraints((Component)this.trajWidget, gbc);
        this.copasiDialog.getContentPane().add((Component)this.trajWidget);
        this.copasiDialog.addWindowListener(winListener);
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel panel = new JPanel();
        panel.setSize(600, 400);
        tabbedPane.add(panel);
        gbc.gridx = 1;
        layout.setConstraints(tabbedPane, gbc);
        this.copasiDialog.getContentPane().add(tabbedPane);
        this.copasiDialog.pack();
        this.copasiDialog.setVisible(true);
        this.copasiDialog.toFront();
    }

    public synchronized void postProcess() {
        CopasiGUI.setStatus(false);
        ((MainWindow)this.Access).setCopasiMenuItemStatus(true);
    }

    public static synchronized boolean getStatus() {
        return isRunning;
    }

    public static synchronized void setStatus(boolean status) {
        isRunning = status;
    }

    public synchronized void setMainWindowAccess(MainWindowAccess a) {
        this.Access = a;
    }

    public synchronized void setSBModelFrame(SBModelFrame s) {
        this.SbFrame = s;
    }

    private void writeSBMLFile(SBMLDocument sbmlDocument, String saveFilePath) {
        SBMLWriter writer = new SBMLWriter();
        writer.writeSBML(sbmlDocument, saveFilePath);
        writer.delete();
    }

    private void writeXML(File resultFileName) {
        try {
            ((MainWindow)this.Access).setSelectedModelTab(this.SbFrame);
            SBMLDocument sbmlDocument = new SBMLDocument();
            sbmlDocument = this.SbFrame.getSBModel().getSBMLDocument();
            SpecInfo spec = new SpecInfo((int)sbmlDocument.getLevel(), (int)sbmlDocument.getVersion());
            sbmlDocument.setLevelAndVersion((long)spec.getLevel(), (long)spec.getVersion());
            this.SbFrame.getSBModel().prepareSave();
            if (spec.getLevel() == 1) {
                this.SbFrame.getSBModel().prepareSaveForLevel1();
            }
            sbmlDocument = LibSBMLUtil.getNotEnableAnnotationDocument(sbmlDocument, spec);
            sbmlDocument = LibSBMLUtil.updateNotesAndAnnotation(sbmlDocument, this.SbFrame.getSBModel());
            this.SbFrame.getSBModel().setSBOTerm(sbmlDocument.getModel());
            CelldUtil.resetMetaidAndAnnotationOfMiriam(this.SbFrame.getSBModel());
            if (!SBMLFiler.isAllowedFileName(resultFileName.getAbsolutePath())) {
                try {
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(resultFileName.getAbsolutePath()), "UTF-8");
                    SBMLWriter writer = new SBMLWriter();
                    out.write(writer.writeToString(sbmlDocument));
                    out.close();
                }
                catch (Exception out) {}
            } else {
                SBMLWriter writer = new SBMLWriter();
                writer.writeSBML(sbmlDocument, resultFileName.getAbsolutePath());
                writer.delete();
            }
        }
        catch (SIdFormatException sIdFormatException) {
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

