/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.copasi;

import java.util.Vector;
import org.COPASI.CCopasiDataModel;
import org.COPASI.CCopasiMessage;
import org.COPASI.CCopasiMethod;
import org.COPASI.CCopasiObjectName;
import org.COPASI.CCopasiParameter;
import org.COPASI.CCopasiProblem;
import org.COPASI.CCopasiTask;
import org.COPASI.CMetab;
import org.COPASI.CModel;
import org.COPASI.CReaction;
import org.COPASI.ObjectStdVector;
import org.COPASI.gui.TaskRunEventListener;

public class Copasi {
    private CCopasiTask cTask = null;
    protected Vector<TaskRunEventListener> mListeners;

    public boolean loadModel(String fileName) {
        CCopasiMessage.clearDeque();
        try {
            CCopasiDataModel.getGlobal().importSBML(fileName);
        }
        catch (Exception e) {
            if (CCopasiDataModel.getGlobal().getModel() == null) {
                this.resetTask();
            }
            return false;
        }
        if (CCopasiMessage.getHighestSeverity() == 4 || CCopasiMessage.getHighestSeverity() == 5) {
            return false;
        }
        this.resetTask();
        return true;
    }

    private void resetTask() {
        CCopasiDataModel m = CCopasiDataModel.getGlobal();
        CCopasiTask t = null;
        if (m != null) {
            long size = m.getTaskList().size();
            long i = 0L;
            while (t == null && i < size) {
                if (m.getTask(i).getType() == 1) {
                    t = m.getTask(i);
                }
                ++i;
            }
            if (t != null) {
                this.setTask(t);
            }
        }
    }

    private void setTask(CCopasiTask task) {
        if (task != this.cTask) {
            this.cTask = task;
        }
    }

    public CModel getCModel() {
        return CCopasiDataModel.getGlobal().getModel();
    }

    public CMetab getMetabolite(String sid) {
        CModel m = this.getCModel();
        int i = 0;
        while ((long)i < m.getNumMetabs()) {
            CMetab metab = m.getMetabolite((long)i);
            if (sid.equals(metab.getSBMLId())) {
                return metab;
            }
            ++i;
        }
        return null;
    }

    public boolean setInitialConcentration(String sid, double value) {
        ObjectStdVector container = new ObjectStdVector();
        CMetab m = this.getMetabolite(sid);
        if (m != null) {
            m.setInitialConcentration(value);
            container.add(m.getObject(new CCopasiObjectName("Reference=InitialConcentration")));
            this.getCModel().updateInitialValues(container);
            return true;
        }
        return false;
    }

    public CReaction getReaction(String sid) {
        CModel m = this.getCModel();
        int i = 0;
        while ((long)i < m.getNumReactions()) {
            CReaction r = m.getReaction((long)i);
            if (sid.equals(r.getSBMLId())) {
                return r;
            }
            ++i;
        }
        return null;
    }

    public CCopasiParameter getParameter(String rid, String pid) {
        CReaction r = this.getReaction(rid);
        if (r != null) {
            int i = 0;
            while ((long)i < r.getParameters().size()) {
                if (pid.equals(r.getParameters().getName((long)i))) {
                    return r.getParameters().getParameter((long)i);
                }
                ++i;
            }
        }
        return null;
    }

    public boolean setParameterValue(String rid, String id, double value) {
        CCopasiParameter p = this.getParameter(rid, id);
        if (p != null) {
            p.setDblValue(value);
            return true;
        }
        return false;
    }

    public boolean setParameterOrInitialConcentration(String rid, String id, double value) {
        if (rid.equals("")) {
            return this.setInitialConcentration(id, value);
        }
        return this.setParameterValue(rid, id, value);
    }

    public double getDuration() {
        CCopasiParameter p = this.cTask.getProblem().getParameter("Duration");
        return p.getDblValue();
    }

    public void setDuration(double duration) {
        CCopasiParameter p = this.cTask.getProblem().getParameter("Duration");
        if (p != null) {
            p.setDblValue(duration);
        }
        this.setStepSize();
    }

    public long getStepNumber() {
        CCopasiParameter p = this.cTask.getProblem().getParameter("StepNumber");
        return p.getUIntValue();
    }

    public void setStepNumber(long stepNum) {
        CCopasiParameter p = this.cTask.getProblem().getParameter("StepNumber");
        if (p != null) {
            p.setUIntValue(stepNum);
        }
        this.setStepSize();
    }

    public double getStepSize() {
        CCopasiParameter p = this.cTask.getProblem().getParameter("StepSize");
        return p.getDblValue();
    }

    private void setStepSize() {
        double v = this.getDuration() / (double)this.getStepNumber();
        CCopasiParameter p = this.cTask.getProblem().getParameter("StepSize");
        p.setDblValue(v);
    }

    public double getRelativeTolerance() {
        CCopasiMethod m = this.cTask.getMethod();
        if (m.getSubType() == 18) {
            CCopasiParameter p = m.getParameter("Relative Tolerance");
            return p.getDblValue();
        }
        return -1.0;
    }

    public void setRelativeTolerance(double rt) {
        CCopasiMethod m = this.cTask.getMethod();
        if (m.getSubType() == 18) {
            CCopasiParameter p = m.getParameter("Relative Tolerance");
            p.setDblValue(rt);
        }
    }

    public void showAllProblemParameters() {
        CCopasiProblem pr = this.cTask.getProblem();
        System.err.println("# Problem Parameters: " + pr.size());
        int i = 0;
        while ((long)i < pr.size()) {
            CCopasiParameter p = pr.getParameter((long)i);
            System.err.println(this.getParameterNameAndValueString(p));
            ++i;
        }
    }

    public void showAllMethodParameters() {
        CCopasiMethod m = this.cTask.getMethod();
        String methodName = CCopasiMethod.getSubTypeName((int)this.cTask.getValidMethods().get(0));
        System.err.println("# Method Parameters: " + m.size());
        System.err.println("Method Name [" + m.getSubType() + "]: " + methodName);
        System.err.println("Method Type for LSODA: 18");
        int i = 0;
        while ((long)i < m.size()) {
            CCopasiParameter p = m.getParameter((long)i);
            System.err.println(this.getParameterNameAndValueString(p));
            ++i;
        }
    }

    private String getParameterNameAndValueString(CCopasiParameter p) {
        String msg = null;
        if (p != null) {
            msg = String.valueOf(p.getObjectName()) + ": ";
            switch (p.getType()) {
                case 4: {
                    Boolean b = new Boolean(p.getBoolValue());
                    msg = String.valueOf(msg) + b;
                    break;
                }
                case 7: {
                    String cn = new String(p.getCNValue().getString());
                    msg = String.valueOf(msg) + cn;
                    break;
                }
                case 8: {
                    String key = new String(p.getCNValue().getString());
                    msg = String.valueOf(msg) + key;
                    break;
                }
                case 6: {
                    String s = new String(p.getStringValue());
                    msg = String.valueOf(msg) + s;
                    break;
                }
                case 9: {
                    String f = new String(p.getFileValue());
                    msg = String.valueOf(msg) + f;
                    break;
                }
                case 0: {
                    Double d = new Double(p.getDblValue());
                    msg = String.valueOf(msg) + d;
                    break;
                }
                case 1: {
                    Double ud = new Double(p.getUDblValue());
                    msg = String.valueOf(msg) + ud;
                    break;
                }
                case 2: {
                    Long in = new Long(p.getIntValue());
                    msg = String.valueOf(msg) + in;
                    break;
                }
                case 3: {
                    Long uin = new Long(p.getUIntValue());
                    msg = String.valueOf(msg) + uin;
                    break;
                }
            }
        }
        return msg;
    }

    public void addTaskRunEventListener(TaskRunEventListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new Vector();
        }
        this.mListeners.addElement(listener);
    }

    public CCopasiTask getCTask() {
        return this.cTask;
    }

    public static int getNumNonconstCompartments(CModel model) {
        int num = 0;
        int i = 0;
        while ((long)i < model.getNumCompartments()) {
            if (!model.getCompartment((long)i).isFixed()) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public static int getNumNonconstParameters(CModel model) {
        int num = 0;
        int i = 0;
        while ((long)i < model.getNumModelValues()) {
            if (!model.getModelValue((long)i).isFixed()) {
                ++num;
            }
            ++i;
        }
        return num;
    }
}

