/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.table;

import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import jp.sbi.celldesigner.ComplexProperty;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.SpeciesShape;
import jp.sbi.celldesigner.blockDiagram.table.ComparableProteinSet;
import jp.sbi.celldesigner.blockDiagram.table.ModificationWrapper;
import jp.sbi.celldesigner.blockDiagram.table.ModifierTableValue;
import jp.sbi.celldesigner.blockDiagram.table.ProteinActivity;
import jp.sbi.celldesigner.blockDiagram.table.ProteinHolder;
import jp.sbi.celldesigner.blockDiagram.table.ProteinInstanceState;
import jp.sbi.celldesigner.blockDiagram.table.ProteinState;
import jp.sbi.celldesigner.blockDiagram.table.ProteinWrapper;
import jp.sbi.celldesigner.blockDiagram.table.ReactionWrapper;
import jp.sbi.celldesigner.blockDiagram.table.ResidueState;
import jp.sbi.celldesigner.blockDiagram.table.SpeciesWrapper;
import jp.sbi.celldesigner.blockDiagram.table.TableColumnValue;
import jp.sbi.celldesigner.blockDiagram.table.TableValues;
import jp.sbi.celldesigner.sbmlExtension.Modification;
import jp.sbi.celldesigner.sbmlExtension.ModificationResidue;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.ReactionAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfSpeciesReferences;
import org.sbml.libsbml.ModifierSpeciesReference;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesReference;

public class TableValuesFactory {
    private TableValuesFactory() {
    }

    private static void addResidueData(Protein p, MonoSpeciesProperty mp, ProteinInstanceState pis) {
        String pid = p.getId();
        TreeMap<String, Modification> map = new TreeMap<String, Modification>();
        Vector v1 = mp.getModifications();
        int j = 0;
        while (j < v1.size()) {
            Modification m1 = (Modification)v1.elementAt(j);
            map.put(m1.getResidue(), m1);
            ++j;
        }
        Vector mrl = p.getListOfModificationResidues();
        int n = mrl.size();
        int i = 0;
        while (i < n) {
            ModificationResidue mr = (ModificationResidue)mrl.get(i);
            Modification m1 = (Modification)map.get(mr.getId());
            ResidueState rs = new ResidueState(pid, mr, m1);
            pis.addResidueState(rs);
            ++i;
        }
    }

    private static TableColumnValue createTableColumnValue(Protein p, SpeciesAlias sa) {
        Species s = sa.getOriginalSpecies();
        TableColumnValue tcv = new TableColumnValue(s);
        SpeciesShape shape = (SpeciesShape)((Object)sa.getGFramedShape());
        if (sa instanceof ElementSpeciesAlias) {
            MonoSpeciesProperty mp = (MonoSpeciesProperty)shape.getProperty();
            ProteinState ps = new ProteinState(p);
            tcv.addProteinState(ps);
            ProteinInstanceState pis = new ProteinInstanceState(p, mp.getHomodimer());
            ps.addProteinInstanceState(pis);
            TableValuesFactory.addResidueData(p, mp, pis);
        } else if (sa instanceof ComplexSpeciesAlias) {
            ComplexProperty cp = (ComplexProperty)shape.getProperty();
            Vector monoProps = cp.getMonoProperties();
            int j = 0;
            while (j < monoProps.size()) {
                ProteinState ps;
                MonoSpeciesProperty mp1 = (MonoSpeciesProperty)monoProps.elementAt(j);
                Protein p1 = mp1.getProtein();
                if (p1 == null) {
                    String name = mp1.getName();
                    p1 = new ProteinHolder(name);
                }
                if ((ps = tcv.getProteinStateByProtein(p1)) == null) {
                    ps = new ProteinState(p1);
                    tcv.addProteinState(ps);
                }
                ProteinInstanceState pis = new ProteinInstanceState(p1, mp1.getHomodimer());
                ps.addProteinInstanceState(pis);
                TableValuesFactory.addResidueData(p1, mp1, pis);
                ++j;
            }
        }
        return tcv;
    }

    private static Set createSpeciesIdSet(Protein p) {
        Vector v = p.getReferences();
        TreeSet<String> set = new TreeSet<String>();
        int i = 0;
        while (i < v.size()) {
            SpeciesAlias sa = (SpeciesAlias)v.elementAt(i);
            if (sa.getContainer() instanceof ComplexSpeciesAlias) {
                sa = (SpeciesAlias)((Object)sa.getContainer());
            }
            Species s = sa.getOriginalSpecies();
            set.add(s.getId());
            ++i;
        }
        return set;
    }

    private static void createTableValuesForReaction(Protein p, TableValues tv, ListOf rl, ListOf sl, Map proteinIdMapBySpeciesId) {
        Set degradedSpeciesIdSet = TableValuesFactory.createDegradedSpeciesSet(sl);
        Set speciesIdSet = TableValuesFactory.createSpeciesIdSet(p);
        int i = 0;
        while ((long)i < rl.size()) {
            Reaction r = (Reaction)rl.get((long)i);
            if (TableValuesFactory.isUsedInTheReaction(speciesIdSet, r, degradedSpeciesIdSet)) {
                ReactionAnnotation ra = (ReactionAnnotation)LibSBMLUtil.getAnnotation((SBase)r, null);
                List ml = ra.getModificationLinks();
                for (ReactionLink rl1 : ml) {
                    Vector ss = rl1.getSources();
                    int j = 0;
                    while (j < ss.size()) {
                        String sid;
                        TableColumnValue tcv;
                        SpeciesAlias sa1 = (SpeciesAlias)ss.elementAt(j);
                        if (sa1.getContainer() instanceof ComplexSpeciesAlias) {
                            sa1 = (SpeciesAlias)((Object)sa1.getContainer());
                        }
                        if ((tcv = tv.getTalbeColumnValue(sid = sa1.getOriginalSpecies().getId())) != null) {
                            String reactionType = rl1.getSymbol().getCode();
                            Set[] targetProteinSet = reactionType.equals("DEGRADED") ? new Set[]{null, null} : TableValuesFactory.getTargetProteinSet(r, proteinIdMapBySpeciesId);
                            tcv.addProteinActivity(sid, r, reactionType, targetProteinSet[0], targetProteinSet[1]);
                        }
                        ++j;
                    }
                }
                boolean usedAsProduct = TableValuesFactory.isInProducts(speciesIdSet, r);
                if (!usedAsProduct) {
                    ListOfSpeciesReferences sbl1 = r.getListOfReactants();
                    int j = 0;
                    while ((long)j < sbl1.size()) {
                        SpeciesReference sr = (SpeciesReference)sbl1.get((long)j);
                        String sid = sr.getSpecies();
                        TableColumnValue tcv = tv.getTalbeColumnValue(sid);
                        if (tcv != null) {
                            tcv.addProteinActivity(sid, r, "DEGRADED", null, null);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        try {
            Set sset = tv.getSpeciesIdSet();
            Set rset = tv.getReactionWrapperSet();
            for (String sid : sset) {
                TableColumnValue tcv = tv.getTalbeColumnValue(sid);
                for (ReactionWrapper rr : rset) {
                    Reaction r = rr.getReaction();
                    ProteinActivity pa = tcv.getProteinActivity(r.getId());
                    if (pa != null) continue;
                    tcv.addEmptyProteinActivity(sid, r);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Protein getProtein(Hashtable hashProtein, Protein p1) {
        Protein protein = (Protein)hashProtein.get(p1.getId());
        if (protein != null && protein.getId().equals(p1.getId()) && protein.getAnnotationString().equals(p1.getAnnotationString())) {
            return protein;
        }
        hashProtein.put(p1.getId(), p1);
        return p1;
    }

    private static Map createProteinIdMapBySpeciesId(ListOf sl, SBModel sbModel) {
        TreeMap map = new TreeMap();
        Hashtable hashProtein = new Hashtable();
        int i = 0;
        while ((long)i < sl.size()) {
            Species s = (Species)sl.get((long)i);
            SpeciesAnnotation ano = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)s, null);
            SpeciesProperty prop = ano.getSpeciesProperty();
            if (!(prop instanceof ComplexProperty)) {
                Protein p1;
                MonoSpeciesProperty mp = (MonoSpeciesProperty)prop;
                String type = mp.getType();
                if (type.equals("PROTEIN")) {
                    p1 = mp.getProtein();
                    TreeSet<ProteinWrapper> set = new TreeSet<ProteinWrapper>();
                    set.add(new ProteinWrapper(p1));
                    map.put(s.getId(), set);
                } else {
                    p1 = new ProteinHolder(mp.getName());
                    TreeSet<ProteinWrapper> set = new TreeSet<ProteinWrapper>();
                    set.add(new ProteinWrapper(p1));
                    map.put(s.getId(), set);
                }
            } else {
                ComplexProperty cp = (ComplexProperty)prop;
                Vector monoProps = cp.getMonoProperties();
                TreeSet<ProteinWrapper> set = new TreeSet<ProteinWrapper>();
                int j = 0;
                while (j < monoProps.size()) {
                    Protein p1;
                    MonoSpeciesProperty mp1 = (MonoSpeciesProperty)monoProps.elementAt(j);
                    if (mp1.getType().equals("PROTEIN")) {
                        p1 = mp1.getProtein();
                        set.add(new ProteinWrapper(p1));
                    } else {
                        p1 = new ProteinHolder(mp1.getName());
                        set.add(new ProteinWrapper(p1));
                        map.put(s.getId(), set);
                    }
                    ++j;
                }
                if (set.size() > 0) {
                    map.put(s.getId(), set);
                }
            }
            ++i;
        }
        return map;
    }

    private static Set[] getTargetProteinSet(Reaction r, Map proteinIdMapBySpeciesId) {
        Set[] sets = new Set[2];
        TreeSet set1 = new TreeSet();
        TreeSet set2 = new TreeSet();
        ListOfSpeciesReferences sbl1 = r.getListOfReactants();
        int k = 0;
        while ((long)k < sbl1.size()) {
            SpeciesReference sr = (SpeciesReference)sbl1.get((long)k);
            Set set = (Set)proteinIdMapBySpeciesId.get(sr.getSpecies());
            if (set != null) {
                set1.addAll(set);
            }
            ++k;
        }
        ListOfSpeciesReferences sbl2 = r.getListOfProducts();
        int k2 = 0;
        while ((long)k2 < sbl2.size()) {
            SpeciesReference sr = (SpeciesReference)sbl2.get((long)k2);
            Set set = (Set)proteinIdMapBySpeciesId.get(sr.getSpecies());
            if (set != null) {
                set2.addAll(set);
            }
            ++k2;
        }
        if (set1.equals(set2)) {
            sets[0] = null;
            sets[1] = set2;
            return sets;
        }
        Set seti = TableValuesFactory.getIntersection(set1, set2);
        if (!seti.isEmpty()) {
            Set seti1;
            Set set;
            SpeciesReference sr;
            set1 = new TreeSet();
            set2 = new TreeSet();
            int k3 = 0;
            while ((long)k3 < sbl1.size()) {
                sr = (SpeciesReference)sbl1.get((long)k3);
                set = (Set)proteinIdMapBySpeciesId.get(sr.getSpecies());
                if (set != null && !(seti1 = TableValuesFactory.getIntersection(seti, set)).isEmpty()) {
                    set1.addAll(set);
                }
                ++k3;
            }
            k3 = 0;
            while ((long)k3 < sbl2.size()) {
                sr = (SpeciesReference)sbl2.get((long)k3);
                set = (Set)proteinIdMapBySpeciesId.get(sr.getSpecies());
                if (set != null && !(seti1 = TableValuesFactory.getIntersection(seti, set)).isEmpty()) {
                    set2.addAll(set);
                }
                ++k3;
            }
            if (set1.equals(set2) && !set1.isEmpty()) {
                sets[0] = null;
                sets[1] = set2;
                return sets;
            }
        }
        sets[0] = set1;
        sets[1] = set2;
        return sets;
    }

    private static Set getIntersection(Set set1, Set set2) {
        TreeSet set = new TreeSet();
        for (Object obj : set1) {
            if (!set2.contains(obj)) continue;
            set.add(obj);
        }
        return set;
    }

    public static TableValues createTableValues(SBase sb, ListOf rl, ListOf sl, SBModel sbModel) {
        if (sb instanceof Protein) {
            Protein p = (Protein)sb;
            TableValues tv = new TableValues((SBase)p);
            TreeMap monoSpeciesSetMapBySpeciesId = new TreeMap();
            int i = 0;
            while ((long)i < sl.size()) {
                Species s = (Species)sl.get((long)i);
                SpeciesAnnotation sa = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)s, null);
                SpeciesProperty obj = sa.getSpeciesProperty();
                if (obj instanceof ComplexProperty) {
                    ComplexProperty csp = (ComplexProperty)obj;
                    Vector complexaliases = sa.getReferingAliases();
                    Vector v = ((ComplexSpeciesAlias)complexaliases.elementAt(0)).getTargets();
                    TreeSet<SpeciesWrapper> set = new TreeSet<SpeciesWrapper>();
                    int j = 0;
                    while (j < v.size()) {
                        SpeciesAlias sa1 = (SpeciesAlias)v.elementAt(j);
                        Species s1 = sa1.getOriginalSpecies();
                        set.add(new SpeciesWrapper(s1));
                        ++j;
                    }
                    monoSpeciesSetMapBySpeciesId.put(s.getId(), set);
                } else {
                    TreeSet<SpeciesWrapper> set = new TreeSet<SpeciesWrapper>();
                    set.add(new SpeciesWrapper(s));
                    monoSpeciesSetMapBySpeciesId.put(s.getId(), set);
                }
                ++i;
            }
            Vector v = p.getReferences();
            TreeSet<String> speciesNameSet = new TreeSet<String>();
            int i2 = 0;
            while (i2 < v.size()) {
                Species origSpecies;
                String origSId;
                SpeciesAlias sa = (SpeciesAlias)v.elementAt(i2);
                if (sa.getContainer() instanceof ComplexSpeciesAlias) {
                    sa = (SpeciesAlias)((Object)sa.getContainer());
                }
                if (!speciesNameSet.contains(origSId = (origSpecies = sa.getOriginalSpecies()).getId())) {
                    speciesNameSet.add(origSId);
                    TableColumnValue tcv = TableValuesFactory.createTableColumnValue(p, sa);
                    tv.addTableColumnValue(tcv);
                }
                ++i2;
            }
            Map proteinIdMapBySpeciesId = TableValuesFactory.createProteinIdMapBySpeciesId(sl, sbModel);
            TableValuesFactory.createTableValuesForReaction(p, tv, rl, sl, proteinIdMapBySpeciesId);
            Map mtvMapByMpset = TableValuesFactory.createModifierTableValues(sb, rl, proteinIdMapBySpeciesId, monoSpeciesSetMapBySpeciesId);
            tv.setMtvMapByMpset(mtvMapByMpset);
            return tv;
        }
        return null;
    }

    private static Map createModifierTableValues(SBase sb, ListOf rl, Map proteinIdMapBySpeciesId, Map monoSpeciesSetMapBySpeciesId) {
        TreeMap<ComparableProteinSet, ModifierTableValue> mtvMapByMpset = new TreeMap<ComparableProteinSet, ModifierTableValue>();
        ProteinWrapper pw = new ProteinWrapper((Protein)sb);
        int i = 0;
        while ((long)i < rl.size()) {
            List[] v;
            Object sa1;
            Reaction r = (Reaction)rl.get((long)i);
            TreeSet<SpeciesWrapper> setReactantSpeciesSet = new TreeSet<SpeciesWrapper>();
            TreeSet<SpeciesWrapper> setProductSpeciesSet = new TreeSet<SpeciesWrapper>();
            ListOfSpeciesReferences sbl1 = r.getListOfReactants();
            int k = 0;
            while ((long)k < sbl1.size()) {
                SpeciesReference sr = (SpeciesReference)sbl1.get((long)k);
                Set set = (Set)proteinIdMapBySpeciesId.get(sr.getSpecies());
                if (set != null && set.contains(pw)) {
                    Set set1 = (Set)monoSpeciesSetMapBySpeciesId.get(sr.getSpecies());
                    for (SpeciesWrapper sw : set1) {
                        Protein p1;
                        Species s1 = sw.getSpecies();
                        SpeciesAnnotation sa12 = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)s1, null);
                        MonoSpeciesProperty msp = (MonoSpeciesProperty)sa12.getSpeciesProperty();
                        if (!msp.getType().equals("PROTEIN") || !(p1 = msp.getProtein()).getId().equals(((Protein)sb).getId())) continue;
                        setReactantSpeciesSet.add(sw);
                    }
                }
                ++k;
            }
            ListOfSpeciesReferences sbl2 = r.getListOfProducts();
            int k2 = 0;
            while ((long)k2 < sbl2.size()) {
                SpeciesReference sr = (SpeciesReference)sbl2.get((long)k2);
                Set set = (Set)proteinIdMapBySpeciesId.get(sr.getSpecies());
                if (set != null && set.contains(pw)) {
                    Set set1 = (Set)monoSpeciesSetMapBySpeciesId.get(sr.getSpecies());
                    for (SpeciesWrapper sw : set1) {
                        Protein p1;
                        Species s1 = sw.getSpecies();
                        sa1 = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)s1, null);
                        MonoSpeciesProperty msp = (MonoSpeciesProperty)((SpeciesAnnotation)sa1).getSpeciesProperty();
                        if (!msp.getType().equals("PROTEIN") || (p1 = msp.getProtein()) == null || !p1.getId().equals(((Protein)sb).getId())) continue;
                        setProductSpeciesSet.add(sw);
                    }
                }
                ++k2;
            }
            if (!setReactantSpeciesSet.isEmpty() && !setProductSpeciesSet.isEmpty() && (v = TableValuesFactory.decidePairOfReactantsAndProducts(setReactantSpeciesSet, setProductSpeciesSet)) != null) {
                ReactionAnnotation ra = (ReactionAnnotation)LibSBMLUtil.getAnnotation((SBase)r, null);
                List ml = ra.getModificationLinks();
                for (ReactionLink rl1 : ml) {
                    Vector ss = rl1.getSources();
                    int j = 0;
                    while (j < ss.size()) {
                        String sid;
                        Set set1;
                        sa1 = (SpeciesAlias)ss.elementAt(j);
                        if (sa1.getContainer() instanceof ComplexSpeciesAlias) {
                            sa1 = (SpeciesAlias)((Object)sa1.getContainer());
                        }
                        if ((set1 = (Set)proteinIdMapBySpeciesId.get(sid = sa1.getOriginalSpecies().getId())) != null) {
                            String type;
                            ComparableProteinSet mpset = new ComparableProteinSet((Collection)set1);
                            ModifierTableValue mtv = (ModifierTableValue)mtvMapByMpset.get(mpset);
                            if (mtv == null) {
                                mtv = new ModifierTableValue(mpset);
                                mtvMapByMpset.put(mpset, mtv);
                            }
                            if ((type = rl1.getSymbol().getCode()).equals("CATALYSIS")) {
                                int itype = 1;
                                mtv.append(v[0], v[1], itype);
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return mtvMapByMpset;
    }

    private static List[] decidePairOfReactantsAndProducts(Set setReactantSpeciesSet, Set setProductSpeciesSet) {
        List[] lists = new LinkedList[2];
        if (setReactantSpeciesSet.size() == 1 && setProductSpeciesSet.size() == 1) {
            lists[0] = new LinkedList();
            lists[1] = new LinkedList();
            SpeciesWrapper sw = (SpeciesWrapper)setReactantSpeciesSet.iterator().next();
            Species s1 = sw.getSpecies();
            SpeciesAnnotation sa1 = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)s1, null);
            MonoSpeciesProperty msp = (MonoSpeciesProperty)sa1.getSpeciesProperty();
            Vector v1 = msp.getModifications();
            sw = (SpeciesWrapper)setProductSpeciesSet.iterator().next();
            s1 = sw.getSpecies();
            sa1 = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)s1, null);
            msp = (MonoSpeciesProperty)sa1.getSpeciesProperty();
            Vector v2 = msp.getModifications();
            Set intersection = TableValuesFactory.getIntersectionOf(v1, v2);
            boolean empty = true;
            Vector v = TableValuesFactory.getNotSharedElement(intersection, v1);
            if (v.size() > 0) {
                empty = false;
            }
            lists[0].add(v);
            v = TableValuesFactory.getNotSharedElement(intersection, v2);
            if (v.size() > 0) {
                empty = false;
            }
            lists[1].add(v);
            if (empty) {
                return null;
            }
        } else {
            return null;
        }
        return lists;
    }

    private static Vector getNotSharedElement(Set set, Vector v) {
        Vector<Modification> vec = new Vector<Modification>();
        int i = 0;
        while (i < v.size()) {
            Modification m = (Modification)v.elementAt(i);
            ModificationWrapper mw = new ModificationWrapper(m);
            if (!set.contains(mw)) {
                vec.addElement(m);
            }
            ++i;
        }
        return vec;
    }

    private static Set getIntersectionOf(Vector v1, Vector v2) {
        ModificationWrapper mw;
        Modification m;
        TreeSet<ModificationWrapper> set1 = new TreeSet<ModificationWrapper>();
        TreeSet<ModificationWrapper> set = new TreeSet<ModificationWrapper>();
        int i = 0;
        while (i < v1.size()) {
            m = (Modification)v1.elementAt(i);
            mw = new ModificationWrapper(m);
            set1.add(mw);
            ++i;
        }
        i = 0;
        while (i < v2.size()) {
            m = (Modification)v2.elementAt(i);
            mw = new ModificationWrapper(m);
            if (set1.contains(mw)) {
                set.add(mw);
            }
            ++i;
        }
        return set;
    }

    private static Set createDegradedSpeciesSet(ListOf sl) {
        TreeSet<String> set = new TreeSet<String>();
        int n = (int)sl.size();
        int i = 0;
        while (i < n) {
            MonoSpeciesProperty msp;
            Species s = (Species)sl.get((long)i);
            SpeciesAnnotation sa = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)s, null);
            SpeciesProperty sp = sa.getSpeciesProperty();
            if (sp instanceof MonoSpeciesProperty && (msp = (MonoSpeciesProperty)sp).getType().equals("DEGRADED")) {
                set.add(s.getId());
            }
            ++i;
        }
        return set;
    }

    private static boolean isUsedInTheReaction(Set set, Reaction r, Set degradedSpeciesSet) {
        SpeciesReference sr;
        ListOfSpeciesReferences sbl1 = r.getListOfModifiers();
        int j = 0;
        while ((long)j < sbl1.size()) {
            ModifierSpeciesReference msr = (ModifierSpeciesReference)sbl1.get((long)j);
            if (set.contains(msr.getSpecies())) {
                return true;
            }
            ++j;
        }
        boolean findDegraded = false;
        ListOfSpeciesReferences sbl12 = r.getListOfProducts();
        int j2 = 0;
        while ((long)j2 < sbl12.size()) {
            sr = (SpeciesReference)sbl12.get((long)j2);
            if (set.contains(sr.getSpecies())) {
                return false;
            }
            if (degradedSpeciesSet.contains(sr.getSpecies())) {
                findDegraded = true;
            }
            ++j2;
        }
        if (findDegraded) {
            sbl12 = r.getListOfReactants();
            j2 = 0;
            while ((long)j2 < sbl12.size()) {
                sr = (SpeciesReference)sbl12.get((long)j2);
                if (set.contains(sr.getSpecies())) {
                    return true;
                }
                ++j2;
            }
        }
        return false;
    }

    private static boolean isInProducts(Set set, Reaction r) {
        ListOfSpeciesReferences sbl1 = r.getListOfProducts();
        int j = 0;
        while ((long)j < sbl1.size()) {
            SpeciesReference sr = (SpeciesReference)sbl1.get((long)j);
            if (set.contains(sr.getSpecies())) {
                return true;
            }
            ++j;
        }
        return false;
    }
}

