/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.table;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jp.sbi.celldesigner.blockDiagram.table.ProteinActivity;
import jp.sbi.celldesigner.blockDiagram.table.ProteinInstanceState;
import jp.sbi.celldesigner.blockDiagram.table.ProteinState;
import jp.sbi.celldesigner.blockDiagram.table.ReactionWrapper;
import jp.sbi.celldesigner.blockDiagram.table.ResidueState;
import jp.sbi.celldesigner.blockDiagram.table.TableCellValueActivity;
import jp.sbi.celldesigner.blockDiagram.table.TableCellValueState;
import jp.sbi.celldesigner.blockDiagram.table.TableColumnValue;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.Event;
import org.sbml.libsbml.FunctionDefinition;
import org.sbml.libsbml.ListOfSpeciesReferences;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesReference;
import org.sbml.libsbml.UnitDefinition;

public class TableValues
extends AbstractTableModel {
    private static String NL = System.getProperty("line.separator");
    public static final String NMER = "N-mer";
    private SBase sbase;
    private Map tableColumnValueMap;
    private Vector tableColumnValues;
    private Map tableColumnIndexMap;
    private Map tableRowIndexMapForReaction;
    private Set proteinIdSet;
    private Set reactionIdSet;
    private Map stateMap;
    private Map activityMap;
    private Map mtvMapByMpset;
    private boolean modified;
    private IndexTableEntry[] indexTable;
    public static final String ROWTITLE = "rowtitle";
    public static final String NORMAL = "normal";
    public static final String TABLE = "table";

    public TableValues(SBase sb) {
        if (sb == null) {
            throw new IllegalArgumentException("sb must be non null.");
        }
        if (!(sb instanceof Protein)) {
            throw new IllegalArgumentException("sb must be Protein. but " + sb.getClass().getName());
        }
        this.sbase = sb;
        this.tableColumnValues = new Vector();
        this.tableColumnValueMap = new TreeMap();
        this.tableColumnIndexMap = new TreeMap();
        this.tableRowIndexMapForReaction = new TreeMap();
        this.modified = true;
        this.stateMap = new TreeMap();
        this.activityMap = new TreeMap();
        this.proteinIdSet = null;
        this.reactionIdSet = null;
        this.mtvMapByMpset = null;
    }

    @Override
    public int getColumnCount() {
        return this.tableColumnValues.size() + 1;
    }

    @Override
    public int getRowCount() {
        if (this.modified) {
            this.update();
        }
        return this.indexTable.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.modified) {
            this.update();
        }
        Object obj = this.indexTable[row].getValueAt(row, column);
        return obj;
    }

    public String getTitle() {
        if (this.sbase instanceof Protein) {
            return "Protein:" + this.getBlockName();
        }
        if (this.sbase instanceof Species) {
            return ((Species)this.sbase).getId();
        }
        if (this.sbase instanceof Reaction) {
            return ((Reaction)this.sbase).getId();
        }
        if (this.sbase instanceof Compartment) {
            return ((Compartment)this.sbase).getId();
        }
        if (this.sbase instanceof Event) {
            return ((Event)this.sbase).getId();
        }
        if (this.sbase instanceof UnitDefinition) {
            return ((UnitDefinition)this.sbase).getId();
        }
        if (this.sbase instanceof FunctionDefinition) {
            return ((FunctionDefinition)this.sbase).getId();
        }
        if (this.sbase instanceof Parameter) {
            return ((Parameter)this.sbase).getId();
        }
        return "";
    }

    public String getBlockName() {
        if (this.sbase instanceof Protein) {
            Protein p = (Protein)this.sbase;
            String name = p.getName();
            if (name != null && name.length() > 0) {
                return name;
            }
            return p.getId();
        }
        if (this.sbase instanceof Species) {
            return ((Species)this.sbase).getId();
        }
        if (this.sbase instanceof Reaction) {
            return ((Reaction)this.sbase).getId();
        }
        if (this.sbase instanceof Compartment) {
            return ((Compartment)this.sbase).getId();
        }
        if (this.sbase instanceof Event) {
            return ((Event)this.sbase).getId();
        }
        if (this.sbase instanceof UnitDefinition) {
            return ((UnitDefinition)this.sbase).getId();
        }
        if (this.sbase instanceof FunctionDefinition) {
            return ((FunctionDefinition)this.sbase).getId();
        }
        if (this.sbase instanceof Parameter) {
            return ((Parameter)this.sbase).getId();
        }
        return "";
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return ROWTITLE;
        }
        TableColumnValue tcv = (TableColumnValue)this.tableColumnValues.elementAt(column - 1);
        return tcv.getSpecies().getId();
    }

    private void update() {
        if (this.modified) {
            this.modified = false;
            int count = 0;
            this.proteinIdSet = new TreeSet();
            this.reactionIdSet = new TreeSet();
            TreeMap<String, Reaction> reactionMapById = new TreeMap<String, Reaction>();
            for (TableColumnValue tcv : this.tableColumnValues) {
                Map map = tcv.getProteinStateMap();
                for (String key : map.keySet()) {
                    this.proteinIdSet.add(key);
                }
                map = tcv.getProteinActivityMap();
                for (String key : map.keySet()) {
                    this.reactionIdSet.add(key);
                    ProteinActivity pa = (ProteinActivity)map.get(key);
                    reactionMapById.put(key, pa.getReaction());
                }
            }
            Vector<IndexTableEntry> v = new Vector<IndexTableEntry>();
            int nthProtein = 0;
            String ownerPid = "";
            if (this.sbase instanceof Species) {
                ownerPid = ((Species)this.sbase).getId();
            } else if (this.sbase instanceof Reaction) {
                ownerPid = ((Reaction)this.sbase).getId();
            } else if (this.sbase instanceof Compartment) {
                ownerPid = ((Compartment)this.sbase).getId();
            } else if (this.sbase instanceof Event) {
                ownerPid = ((Event)this.sbase).getId();
            } else if (this.sbase instanceof UnitDefinition) {
                ownerPid = ((UnitDefinition)this.sbase).getId();
            } else if (this.sbase instanceof FunctionDefinition) {
                ownerPid = ((FunctionDefinition)this.sbase).getId();
            } else if (this.sbase instanceof Parameter) {
                ownerPid = ((Parameter)this.sbase).getId();
            }
            ProteinState ps = this.getMaximumInstanceOwner(ownerPid);
            StateIndexTableForProteinEntry entry = new StateIndexTableForProteinEntry(ownerPid, ps, nthProtein);
            v.addElement(entry);
            int n = ps.getRowCount();
            StateIndexTableEntry entry2 = new StateIndexTableEntry(ownerPid, ps, ++count, nthProtein);
            int i = 0;
            while (i < n) {
                v.addElement(entry2);
                ++i;
            }
            count += n;
            ++nthProtein;
            for (String proteinId : this.proteinIdSet) {
                if (proteinId.equals(ownerPid)) continue;
                ProteinState ps2 = this.getMaximumInstanceOwner(proteinId);
                StateIndexTableForProteinEntry entry3 = new StateIndexTableForProteinEntry(ownerPid, ps2, nthProtein);
                v.addElement(entry3);
                int n2 = ps2.getRowCount();
                StateIndexTableEntry entry4 = new StateIndexTableEntry(proteinId, ps2, ++count, nthProtein);
                int i2 = 0;
                while (i2 < n2) {
                    v.addElement(entry4);
                    ++i2;
                }
                count += n2;
                ++nthProtein;
            }
            int index = v.size();
            for (String reactionId : this.reactionIdSet) {
                this.tableRowIndexMapForReaction.put(reactionId, new Integer(index));
                ++index;
                ActivityIndexTableEntry entry5 = new ActivityIndexTableEntry(reactionId, (Reaction)reactionMapById.get(reactionId));
                v.addElement(entry5);
            }
            this.indexTable = v.toArray(new IndexTableEntry[v.size()]);
        }
    }

    public int getTableRowIndexForReaction(String reactionId) {
        return (Integer)this.tableRowIndexMapForReaction.get(reactionId);
    }

    public List getProteinStateListForBinding() {
        this.update();
        LinkedList<ProteinState> list = new LinkedList<ProteinState>();
        boolean nmer = false;
        String ownerPid = "";
        if (this.sbase instanceof Species) {
            ownerPid = ((Species)this.sbase).getId();
        } else if (this.sbase instanceof Reaction) {
            ownerPid = ((Reaction)this.sbase).getId();
        } else if (this.sbase instanceof Compartment) {
            ownerPid = ((Compartment)this.sbase).getId();
        } else if (this.sbase instanceof Event) {
            ownerPid = ((Event)this.sbase).getId();
        } else if (this.sbase instanceof UnitDefinition) {
            ownerPid = ((UnitDefinition)this.sbase).getId();
        } else if (this.sbase instanceof FunctionDefinition) {
            ownerPid = ((FunctionDefinition)this.sbase).getId();
        } else if (this.sbase instanceof Parameter) {
            ownerPid = ((Parameter)this.sbase).getId();
        }
        ProteinState ps = this.getMaximumInstanceOwner(ownerPid);
        for (ProteinInstanceState pis : ps.getProteinInstanceStateList()) {
            if (pis.getNmer() <= 1) continue;
            nmer = true;
            break;
        }
        for (String proteinId : this.proteinIdSet) {
            if (!nmer && proteinId.equals(ownerPid)) continue;
            list.addLast(this.getMaximumInstanceOwner(proteinId));
        }
        return list;
    }

    public List getProteinActivityListForEffectSite() {
        this.update();
        LinkedList<ProteinActivity> list = new LinkedList<ProteinActivity>();
        for (TableColumnValue tcv : this.tableColumnValues) {
            Map map = tcv.getProteinActivityMap();
            for (String key : map.keySet()) {
                ProteinActivity pa = (ProteinActivity)map.get(key);
                if (pa.isDegradedType() || pa.isEmpty()) continue;
                list.addLast(pa);
            }
        }
        return list;
    }

    public List getProteinActivityListForDegraded() {
        this.update();
        LinkedList<ProteinActivity> list = new LinkedList<ProteinActivity>();
        for (TableColumnValue tcv : this.tableColumnValues) {
            Map map = tcv.getProteinActivityMap();
            for (String key : map.keySet()) {
                ProteinActivity pa = (ProteinActivity)map.get(key);
                if (!pa.isDegradedType()) continue;
                list.addLast(pa);
            }
        }
        return list;
    }

    public Map getResidueStateMapForResidueSite() {
        this.update();
        TreeMap<String, TreeSet<ResidueState>> map = new TreeMap<String, TreeSet<ResidueState>>();
        String ownerPid = "";
        if (this.sbase instanceof Species) {
            ownerPid = ((Species)this.sbase).getId();
        } else if (this.sbase instanceof Reaction) {
            ownerPid = ((Reaction)this.sbase).getId();
        } else if (this.sbase instanceof Compartment) {
            ownerPid = ((Compartment)this.sbase).getId();
        } else if (this.sbase instanceof Event) {
            ownerPid = ((Event)this.sbase).getId();
        } else if (this.sbase instanceof UnitDefinition) {
            ownerPid = ((UnitDefinition)this.sbase).getId();
        } else if (this.sbase instanceof FunctionDefinition) {
            ownerPid = ((FunctionDefinition)this.sbase).getId();
        } else if (this.sbase instanceof Parameter) {
            ownerPid = ((Parameter)this.sbase).getId();
        }
        for (TableColumnValue tcv : this.tableColumnValues) {
            ProteinState ps = tcv.getProteinState(ownerPid);
            if (ps == null) continue;
            for (ProteinInstanceState pis : ps.getProteinInstanceStateList()) {
                for (ResidueState rs : pis.getResidueStateList()) {
                    String residueId = rs.getResidueId();
                    TreeSet<ResidueState> set = (TreeSet<ResidueState>)map.get(residueId);
                    if (set == null) {
                        set = new TreeSet<ResidueState>();
                        map.put(residueId, set);
                    }
                    set.add(rs);
                }
            }
        }
        return map;
    }

    private ProteinState getMaximumInstanceOwner(String proteinId) {
        ProteinState ps1 = null;
        int n = 0;
        for (TableColumnValue tcv : this.tableColumnValues) {
            int n1;
            ProteinState ps = tcv.getProteinState(proteinId);
            if (ps == null || (n1 = ps.getRowCount()) <= n) continue;
            n = n1;
            ps1 = ps;
        }
        return ps1;
    }

    public void addTableColumnValue(TableColumnValue tcv) {
        int index = this.tableColumnValues.size();
        this.tableColumnValues.addElement(tcv);
        this.tableColumnValueMap.put(tcv.getSpecies().getId(), tcv);
        this.tableColumnIndexMap.put(tcv.getSpecies().getId(), new Integer(index));
    }

    public String getSBaseId() {
        if (this.sbase instanceof Species) {
            return ((Species)this.sbase).getId();
        }
        if (this.sbase instanceof Reaction) {
            return ((Reaction)this.sbase).getId();
        }
        if (this.sbase instanceof Compartment) {
            return ((Compartment)this.sbase).getId();
        }
        if (this.sbase instanceof Event) {
            return ((Event)this.sbase).getId();
        }
        if (this.sbase instanceof UnitDefinition) {
            return ((UnitDefinition)this.sbase).getId();
        }
        if (this.sbase instanceof FunctionDefinition) {
            return ((FunctionDefinition)this.sbase).getId();
        }
        if (this.sbase instanceof Parameter) {
            return ((Parameter)this.sbase).getId();
        }
        return "";
    }

    public SBase getSBase() {
        return this.sbase;
    }

    public Set getSpeciesIdSet() {
        return Collections.unmodifiableSet(this.tableColumnValueMap.keySet());
    }

    public Set getReactionWrapperSet() {
        this.update();
        TreeSet<ReactionWrapper> set = new TreeSet<ReactionWrapper>();
        for (TableColumnValue tcv : this.tableColumnValues) {
            Map map = tcv.getProteinActivityMap();
            for (String key : map.keySet()) {
                ProteinActivity pa = (ProteinActivity)map.get(key);
                set.add(new ReactionWrapper(pa.getReaction()));
            }
        }
        return set;
    }

    public TableColumnValue getTalbeColumnValue(String sid) {
        return (TableColumnValue)this.tableColumnValueMap.get(sid);
    }

    public int getTableColumnIndex(String sid) {
        return (Integer)this.tableColumnIndexMap.get(sid);
    }

    protected void toString(StringBuffer buf) {
        buf.append("[table:");
        for (TableColumnValue tcv : this.tableColumnValues) {
            buf.append('\n');
            tcv.toString(buf);
        }
        buf.append(']');
    }

    public String toString() {
        return this.toString(NORMAL);
    }

    public String toString(String format) {
        StringBuffer buf = new StringBuffer();
        this.toString(buf, format);
        return buf.toString();
    }

    protected void toString(StringBuffer buf, String format) {
        if (format.equals(TABLE)) {
            this.toStringTableFormat(buf);
        } else {
            this.toString(buf);
        }
    }

    protected void toStringTableFormat(StringBuffer buf) {
        int nRow = this.getRowCount();
        int nCol = this.getColumnCount();
        buf.append("nRow,nCol=");
        buf.append(nRow);
        buf.append(',');
        buf.append(nCol);
        buf.append(NL);
        int i = 0;
        while (i < nCol) {
            String obj = this.getColumnName(i);
            if (i > 0) {
                buf.append(',');
            }
            buf.append((Object)obj);
            ++i;
        }
        buf.append(NL);
        int j = 0;
        while (j < nRow) {
            int i2 = 0;
            while (i2 < nCol) {
                Object obj = this.getValueAt(j, i2);
                if (i2 > 0) {
                    buf.append(',');
                }
                buf.append(obj);
                ++i2;
            }
            buf.append(NL);
            ++j;
        }
    }

    public Map getMtvMapByMpset() {
        return this.mtvMapByMpset;
    }

    public void setMtvMapByMpset(Map map) {
        this.mtvMapByMpset = map;
    }

    class ActivityIndexTableEntry
    extends IndexTableEntry {
        private String reactionId;
        private Reaction reaction;

        ActivityIndexTableEntry(String rid, Reaction r) {
            this.reactionId = rid;
            this.reaction = r;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return new TableCellValueActivity(this.getLabelString());
            }
            TableColumnValue tcv = (TableColumnValue)TableValues.this.tableColumnValues.get(column - 1);
            Map map = tcv.getProteinActivityMap();
            ProteinActivity pa = (ProteinActivity)map.get(this.reactionId);
            String value = pa != null ? pa.getValue() : "";
            int validity = pa != null ? pa.getTableCellErrorLevel() : 0;
            return new TableCellValueActivity(value, validity);
        }

        private String getLabelString() {
            String sid;
            SpeciesReference sr;
            StringBuffer buf = new StringBuffer();
            buf.append(this.reactionId);
            buf.append('(');
            ListOfSpeciesReferences sbl = this.reaction.getListOfReactants();
            int i = 0;
            while ((long)i < sbl.size()) {
                sr = (SpeciesReference)sbl.get((long)i);
                sid = sr.getSpecies();
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(sid);
                ++i;
            }
            buf.append('|');
            sbl = this.reaction.getListOfProducts();
            i = 0;
            while ((long)i < sbl.size()) {
                sr = (SpeciesReference)sbl.get((long)i);
                sid = sr.getSpecies();
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(sid);
                ++i;
            }
            buf.append(')');
            return buf.toString();
        }
    }

    abstract class IndexTableEntry {
        IndexTableEntry() {
        }

        public abstract Object getValueAt(int var1, int var2);
    }

    class StateIndexTableEntry
    extends IndexTableEntry {
        private String proteinId;
        private ProteinState proteinStateForRowHeader;
        private int rowOffset;
        private int nth;

        StateIndexTableEntry(String pid, ProteinState ps, int rowOffset, int nth) {
            this.proteinId = pid;
            this.proteinStateForRowHeader = ps;
            this.rowOffset = rowOffset;
            this.nth = nth;
        }

        private ProteinInstanceState decidePis(int row, int column) {
            ProteinState ps;
            if (column == 0) {
                ps = this.proteinStateForRowHeader;
            } else {
                TableColumnValue tcv = (TableColumnValue)TableValues.this.tableColumnValues.get(column - 1);
                ps = tcv.getProteinState(this.proteinId);
                if (ps == null) {
                    return null;
                }
            }
            int rowCount = ps.getRowCount();
            if (row < rowCount) {
                List list = ps.getProteinInstanceStateList();
                int n = list.size();
                int n1 = rowCount / n;
                int index1 = row / n1;
                return (ProteinInstanceState)list.get(index1);
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int column) {
            ProteinInstanceState pis = this.decidePis(row -= this.rowOffset, column);
            if (pis == null || pis.getRowCount() == 0) {
                return new TableCellValueState("", this.nth);
            }
            if ((row %= pis.getRowCount()) == 0) {
                if (column == 0) {
                    return new TableCellValueState("  N-mer", this.nth);
                }
                return new TableCellValueState("" + pis.getNmer(), this.nth);
            }
            ResidueState rs = pis.getResidueState(--row);
            if (column == 0) {
                return new TableCellValueState("  " + rs.getTitle(), this.nth);
            }
            return new TableCellValueState(rs.getState(), this.nth);
        }
    }

    class StateIndexTableForProteinEntry
    extends IndexTableEntry {
        private String proteinId;
        private String title;
        private int nth;

        StateIndexTableForProteinEntry(String pid, ProteinState ps, int nth) {
            this.proteinId = pid;
            this.nth = nth;
            Protein p = ps.getProtein();
            this.title = p.getName();
            if (this.title == null || this.title.equals("")) {
                this.title = p.getId();
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return new TableCellValueState(this.title, this.nth);
            }
            TableColumnValue tcv = (TableColumnValue)TableValues.this.tableColumnValues.get(column - 1);
            ProteinState ps = tcv.getProteinState(this.proteinId);
            if (ps == null) {
                return new TableCellValueState("", this.nth);
            }
            List list = ps.getProteinInstanceStateList();
            return new TableCellValueState("" + list.size(), this.nth);
        }
    }
}

