/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.table;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.sbi.celldesigner.blockDiagram.table.ProteinActivity;
import jp.sbi.celldesigner.blockDiagram.table.ProteinState;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.Species;

public class TableColumnValue {
    private Species species;
    private Map proteinStateMap;
    private Map proteinActivityMap;

    public TableColumnValue(Species s) {
        this.species = s;
        this.proteinStateMap = new TreeMap();
        this.proteinActivityMap = new TreeMap();
    }

    public void addProteinState(ProteinState ps) {
        this.proteinStateMap.put(ps.getProtein().getId(), ps);
    }

    public ProteinState getProteinState(String pid) {
        return (ProteinState)this.proteinStateMap.get(pid);
    }

    public ProteinState getProteinStateByProtein(Protein p) {
        if (this.proteinStateMap == null) {
            System.out.println("null!!");
        }
        if (p == null) {
            System.out.println("p is null!!");
        }
        return (ProteinState)this.proteinStateMap.get(p.getId());
    }

    public Map getProteinStateMap() {
        return Collections.unmodifiableMap(this.proteinStateMap);
    }

    public Map getProteinActivityMap() {
        return Collections.unmodifiableMap(this.proteinActivityMap);
    }

    public Species getSpecies() {
        return this.species;
    }

    private void addProteinActivity(ProteinActivity pa) {
        this.proteinActivityMap.put(pa.getReactionId(), pa);
    }

    public void addProteinActivity(String speciesId, Reaction r, String type, Set targetProteinSet1, Set targetProteinSet2) {
        ProteinActivity pa = this.getProteinActivity(r.getId());
        if (pa == null) {
            pa = new ProteinActivity(speciesId, r);
            this.addProteinActivity(pa);
        }
        pa.addType(type, targetProteinSet1, targetProteinSet2);
    }

    public void addEmptyProteinActivity(String speciesId, Reaction r) {
        ProteinActivity pa = this.getProteinActivity(r.getId());
        if (pa == null) {
            pa = new ProteinActivity(speciesId, r, true);
            this.addProteinActivity(pa);
        }
    }

    public ProteinActivity getProteinActivity(String rid) {
        return (ProteinActivity)this.proteinActivityMap.get(rid);
    }

    protected void toString(StringBuffer buf) {
        buf.append("[TableColumnValue:speciesId=");
        buf.append(this.species.getId());
        buf.append(", name=");
        buf.append(this.species.getName());
        for (String pname : this.proteinStateMap.keySet()) {
            ProteinState ps = (ProteinState)this.proteinStateMap.get(pname);
            buf.append('\n');
            ps.toString(buf);
        }
        buf.append("],[");
        for (String rid : this.proteinActivityMap.keySet()) {
            ProteinActivity pa = (ProteinActivity)this.proteinActivityMap.get(rid);
            buf.append('\n');
            pa.toString(buf);
        }
        buf.append(']');
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.toString(buf);
        return buf.toString();
    }
}

