/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.table;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jp.sbi.celldesigner.blockDiagram.table.RowHeaderCellRenderer;
import jp.sbi.celldesigner.blockDiagram.table.TableCellValueActivity;
import jp.sbi.celldesigner.blockDiagram.table.TableCellValueState;

public class RowHeaderTable
extends JTable {
    private RowHeaderCellRenderer renderrer;
    private boolean preferredScrollableViewportSizeSetted;

    public RowHeaderTable(AbstractTableModel model) {
        super(model);
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        TableColumnModel originalTcm = this.getColumnModel();
        TableColumn tc = originalTcm.getColumn(0);
        tcm.addColumn(tc);
        this.setColumnModel(tcm);
        boolean supportedLookAndFeel = false;
        LookAndFeel obj = UIManager.getLookAndFeel();
        if (obj instanceof MetalLookAndFeel) {
            supportedLookAndFeel = true;
        } else if (obj instanceof WindowsLookAndFeel) {
            tcm.setColumnMargin(4);
            supportedLookAndFeel = true;
        }
        this.renderrer = new RowHeaderCellRenderer();
        tc.setCellRenderer(this.renderrer);
        this.setRowSelectionAllowed(false);
        JComponent renderer = (JComponent)((Object)this.getDefaultRenderer(Object.class));
        LookAndFeel.installColorsAndFont(renderer, "TableHeader.background", "TableHeader.forground", "TableHeader.font");
        if (supportedLookAndFeel) {
            LookAndFeel.installBorder(this, "TableHeader.cellBorder");
        }
        this.setRowSelectionAllowed(false);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int row = this.rowAtPoint(e.getPoint());
        Object value = this.getValueAt(row, 0);
        if (value instanceof TableCellValueState) {
            return "<html>state</html>";
        }
        if (value instanceof TableCellValueActivity) {
            return "<html>activity<br>+ means Catalysis.<br>- means Inhibition</html>";
        }
        return null;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Graphics g = this.getGraphics();
        if (!this.preferredScrollableViewportSizeSetted && g != null) {
            this.preferredScrollableViewportSizeSetted = true;
            int n = this.getRowCount();
            int w = 5;
            FontMetrics fm = g.getFontMetrics();
            int i = 0;
            while (i < n) {
                String str = this.getModel().getValueAt(i, 0).toString();
                int fw = fm.stringWidth(str);
                if (fw > w) {
                    w = fw;
                }
                ++i;
            }
            Dimension dim = super.getPreferredScrollableViewportSize();
            this.setPreferredScrollableViewportSize(new Dimension(w += 10, dim.height));
        }
        Dimension dim = super.getPreferredScrollableViewportSize();
        return dim;
    }
}

