/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.table;

import jp.sbi.celldesigner.sbmlExtension.Modification;
import jp.sbi.celldesigner.sbmlExtension.ModificationResidue;

public class ResidueState
implements Comparable {
    private String proteinId;
    private ModificationResidue residue;
    private Modification modification;
    private String residueName;
    private String residueId;
    private String state;

    public ResidueState(String proteinId, ModificationResidue mr, Modification m) {
        this.proteinId = proteinId;
        this.residue = mr;
        this.modification = m;
        this.residueId = mr.getId();
        this.residueName = mr.getName();
        this.state = m != null ? m.getState() : "";
    }

    public String getTitle() {
        return !"".equals(this.residueName) ? this.residueName : this.residueId;
    }

    public String getResidueId() {
        return this.residueId;
    }

    public String getState() {
        return this.modification != null ? this.modification.getLabel() : "";
    }

    public String getModificationState() {
        return this.modification != null ? this.modification.getState() : "";
    }

    public int getResidueType() {
        if (this.modification != null) {
            String state = this.modification.getState();
            if (state.equals("phosphorylated")) {
                return 1;
            }
            if (state.equals("acetylated")) {
                return 2;
            }
            if (state.equals("ubiquitinated")) {
                return 3;
            }
            if (state.equals("methylated")) {
                return 4;
            }
            if (state.equals("hydroxylated")) {
                return 5;
            }
            if (state.equals("empty")) {
                return 6;
            }
            if (state.equals("don't care")) {
                return 7;
            }
            if (state.equals("unknown")) {
                return 8;
            }
        }
        return 6;
    }

    public boolean isEmptyResidue() {
        if (this.modification == null) {
            return true;
        }
        return this.modification.getLabel().equals("");
    }

    protected void toString(StringBuffer buf) {
        buf.append('[');
        buf.append(this.residueId);
        buf.append(',');
        buf.append(this.residueName);
        buf.append(',');
        buf.append(this.state);
        buf.append(']');
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.toString(buf);
        return buf.toString();
    }

    public int compareTo(Object obj) {
        return this.toString().compareTo(obj.toString());
    }

    public String getResidueName() {
        return this.residueName;
    }

    public String getProteinId() {
        return this.proteinId;
    }
}

