/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.table;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jp.sbi.celldesigner.blockDiagram.table.ProteinInstanceState;
import jp.sbi.celldesigner.sbmlExtension.Protein;

public class ProteinState {
    private Protein protein;
    private List proteinInstanceStateList;

    public ProteinState(Protein p) {
        this.protein = p;
        this.proteinInstanceStateList = new LinkedList();
    }

    public void addProteinInstanceState(ProteinInstanceState pis) {
        this.proteinInstanceStateList.add(pis);
    }

    public int getRowCount() {
        int count = 0;
        for (ProteinInstanceState pis : this.proteinInstanceStateList) {
            count += pis.getRowCount();
        }
        return count;
    }

    public Protein getProtein() {
        return this.protein;
    }

    protected void toString(StringBuffer buf) {
        buf.append("[proteinState:id=");
        buf.append(this.protein.getId());
        buf.append(", name=");
        buf.append(this.protein.getName());
        for (ProteinInstanceState pis : this.proteinInstanceStateList) {
            buf.append('\n');
            pis.toString(buf);
        }
        buf.append(']');
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.toString(buf);
        return buf.toString();
    }

    public List getProteinInstanceStateList() {
        return Collections.unmodifiableList(this.proteinInstanceStateList);
    }
}

