/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.table;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jp.sbi.celldesigner.blockDiagram.table.ResidueState;
import jp.sbi.celldesigner.sbmlExtension.Protein;

public class ProteinInstanceState {
    private Protein protein;
    private List residueStateList;
    private int nmer;

    public ProteinInstanceState(Protein p, int nmer) {
        this.protein = p;
        this.residueStateList = new LinkedList();
        this.nmer = nmer;
    }

    public void addResidueState(ResidueState rs) {
        this.residueStateList.add(rs);
    }

    public int getRowCount() {
        return this.residueStateList.size() + 1;
    }

    public int getResidueCount() {
        return this.residueStateList.size();
    }

    public ResidueState getResidueState(int index) {
        return (ResidueState)this.residueStateList.get(index);
    }

    protected void toString(StringBuffer buf) {
        buf.append("[proteinInstanceState:nmer=");
        buf.append(this.nmer);
        for (ResidueState rs : this.residueStateList) {
            buf.append('\n');
            rs.toString(buf);
        }
        buf.append(']');
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.toString(buf);
        return buf.toString();
    }

    public int getNmer() {
        return this.nmer;
    }

    public List getResidueStateList() {
        return Collections.unmodifiableList(this.residueStateList);
    }
}

