/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.table;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.sbi.celldesigner.blockDiagram.table.ProteinWrapper;
import org.sbml.libsbml.Reaction;

public class ProteinActivity
implements Comparable {
    private boolean empty;
    private String speciesId;
    private Reaction reaction;
    private Set typeSet;
    private Map targetProteinSet1MapByType;
    private Map targetProteinSet2MapByType;
    private int tableCellErrorLevel = 0;

    public ProteinActivity(String speciesId, Reaction r) {
        this.empty = false;
        this.speciesId = speciesId;
        this.reaction = r;
        this.typeSet = new TreeSet();
        this.targetProteinSet1MapByType = new TreeMap();
        this.targetProteinSet2MapByType = new TreeMap();
    }

    public ProteinActivity(String speciesId, Reaction r, boolean empty) {
        this.empty = empty;
        this.speciesId = speciesId;
        this.reaction = r;
        this.typeSet = new TreeSet();
        this.targetProteinSet1MapByType = new TreeMap();
        this.targetProteinSet2MapByType = new TreeMap();
    }

    public void addType(String type, Set targetProteinSet1, Set targetProteinSet2) {
        this.typeSet.add(type);
        this.targetProteinSet1MapByType.put(type, targetProteinSet1);
        this.targetProteinSet2MapByType.put(type, targetProteinSet2);
    }

    public Set getTypeSet() {
        return Collections.unmodifiableSet(this.typeSet);
    }

    public Set getTargetProteinSet1ByType(String type) {
        return Collections.unmodifiableSet((Set)this.targetProteinSet1MapByType.get(type));
    }

    public Set getTargetProteinSet2ByType(String type) {
        return Collections.unmodifiableSet((Set)this.targetProteinSet2MapByType.get(type));
    }

    public String getReactionId() {
        return this.reaction.getId();
    }

    protected Reaction getReaction() {
        return this.reaction;
    }

    public String getTitle() {
        return this.reaction.getId();
    }

    public String getValue() {
        if (this.typeSet.isEmpty()) {
            return "N/A";
        }
        if (this.typeSet.size() == 1) {
            String str = (String)this.typeSet.iterator().next();
            if (str.equals("CATALYSIS")) {
                return this.getValueWithTargetProteinNames("+");
            }
            if (str.equals("INHIBITION")) {
                return this.getValueWithTargetProteinNames("-");
            }
            return str;
        }
        return "+-";
    }

    public String getLabel() {
        if (this.typeSet.isEmpty()) {
            return "";
        }
        if (this.typeSet.size() == 1) {
            String str = (String)this.typeSet.iterator().next();
            if (str.equals("CATALYSIS")) {
                return this.getValueWithTargetProteinNames(null);
            }
            if (str.equals("INHIBITION")) {
                return this.getValueWithTargetProteinNames(null);
            }
            return str;
        }
        return this.typeSet.toString();
    }

    public boolean isDegradedType() {
        if (this.typeSet.isEmpty()) {
            return false;
        }
        if (this.typeSet.size() == 1) {
            String str = (String)this.typeSet.iterator().next();
            return str.equals("DEGRADED");
        }
        return false;
    }

    public boolean isEmpty() {
        return this.typeSet.isEmpty();
    }

    private String getValueWithTargetProteinNames(String template) {
        boolean hasName;
        if (this.typeSet.isEmpty() || this.typeSet.size() != 1) {
            return template;
        }
        String type = (String)this.typeSet.iterator().next();
        Set targetProteinSet1 = (Set)this.targetProteinSet1MapByType.get(type);
        Set targetProteinSet2 = (Set)this.targetProteinSet2MapByType.get(type);
        StringBuffer buf = new StringBuffer();
        if (template != null) {
            buf.append(template);
        }
        boolean hasName1 = targetProteinSet1 != null && !targetProteinSet1.isEmpty();
        boolean hasName2 = targetProteinSet2 != null && !targetProteinSet2.isEmpty();
        boolean bl = hasName = hasName1 && hasName2;
        if (template != null && hasName) {
            buf.append('(');
        }
        this.toStringTargetProteinSet(buf, targetProteinSet1);
        if (hasName1) {
            buf.append('|');
        }
        this.toStringTargetProteinSet(buf, targetProteinSet2);
        if (template != null && hasName) {
            buf.append(')');
        }
        return buf.toString();
    }

    private void toStringTargetProteinSet(StringBuffer buf, Set targetProteinSet) {
        int count = 0;
        if (targetProteinSet != null) {
            for (ProteinWrapper pw : targetProteinSet) {
                if (count > 0) {
                    buf.append('/');
                }
                buf.append(pw.getAvailableName());
                ++count;
            }
        }
    }

    public int compareTo(Object obj) {
        ProteinActivity another = (ProteinActivity)obj;
        return this.toStringForCompareTo().compareTo(another.toStringForCompareTo());
    }

    private String toStringForCompareTo() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getSpeciesId());
        buf.append(':');
        buf.append(this.getReactionId());
        return buf.toString();
    }

    protected void toString(StringBuffer buf) {
        buf.append("[");
        buf.append(this.reaction.getId());
        buf.append(',');
        buf.append(this.typeSet.toString());
        buf.append(']');
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.toString(buf);
        return buf.toString();
    }

    public boolean getExpectedBooleanValue() {
        if (this.typeSet.isEmpty()) {
            return false;
        }
        if (this.typeSet.size() == 1) {
            String str = (String)this.typeSet.iterator().next();
            if (str.equals("DEGRADED")) {
                return true;
            }
            if (str.equals("CATALYSIS")) {
                return true;
            }
            return !str.equals("INHIBITION");
        }
        return true;
    }

    public String getSpeciesId() {
        return this.speciesId;
    }

    public int getTableCellErrorLevel() {
        return this.tableCellErrorLevel;
    }

    public void setTableCellErrorLevel(int i) {
        this.tableCellErrorLevel = i;
    }
}

