/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.table;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import jp.sbi.celldesigner.blockDiagram.table.ModificationWrapper;
import jp.sbi.celldesigner.blockDiagram.table.ProteinWrapper;
import jp.sbi.celldesigner.sbmlExtension.Modification;

public class ModifierTableValue {
    private Set modifiers;
    private Set activateResidueSet;
    private Set deactivateResidueSet;
    public static final int ACTIVATION = 1;
    private static final String newline = System.getProperty("line.separator");

    public ModifierTableValue(Set modifiers) {
        this.modifiers = modifiers;
        this.activateResidueSet = new TreeSet();
        this.deactivateResidueSet = new TreeSet();
    }

    public void append(List reactants, List products, int itype) {
        int i = 0;
        while (i < reactants.size()) {
            Vector vr = (Vector)reactants.get(i);
            Vector vp = (Vector)products.get(i);
            this.appendOnePair(vr, vp);
            ++i;
        }
    }

    private void appendOnePair(Vector vr, Vector vp) {
        TreeMap stateSetMapForReactantbyResidueId = new TreeMap();
        TreeMap stateSetMapForProductbyResidueId = new TreeMap();
        TreeMap stateSetMapbyResidueId = new TreeMap();
        this.setupStateSetMap(vr, stateSetMapForReactantbyResidueId, true);
        this.setupStateSetMap(vp, stateSetMapForProductbyResidueId, true);
        this.setupStateSetMap(vr, stateSetMapbyResidueId, false);
        this.setupStateSetMap(vp, stateSetMapbyResidueId, false);
        for (String rid : stateSetMapbyResidueId.keySet()) {
            Set setr = (Set)stateSetMapForReactantbyResidueId.get(rid);
            Set setp = (Set)stateSetMapForProductbyResidueId.get(rid);
            if (setr != null) {
                this.deactivateResidueSet.addAll(setr);
            }
            if (setp == null) continue;
            this.activateResidueSet.addAll(setp);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.toString(buf);
        return buf.toString();
    }

    public String getModifiersProteinName() {
        StringBuffer buf = new StringBuffer();
        this.toStringModifiers(buf);
        return buf.toString();
    }

    public Set getDeactivateResidueSet() {
        return Collections.unmodifiableSet(this.deactivateResidueSet);
    }

    public Set getActivateResidueSet() {
        return Collections.unmodifiableSet(this.activateResidueSet);
    }

    private void toStringModifiers(StringBuffer buf) {
        int count = 0;
        for (ProteinWrapper pw : this.modifiers) {
            if (count > 0) {
                buf.append('/');
            }
            buf.append(pw.getAvailableName());
            ++count;
        }
    }

    private void toString(StringBuffer buf) {
        buf.append("modifiers:");
        buf.append('[');
        this.toStringModifiers(buf);
        buf.append(']');
        buf.append(newline);
        buf.append("  deactivateResidueSet:");
        buf.append(this.deactivateResidueSet.toString());
        buf.append(newline);
        buf.append("  activateResidueSet:");
        buf.append(this.activateResidueSet.toString());
    }

    private void setupStateSetMap(Vector v, Map map, boolean wrap) {
        int j = 0;
        while (j < v.size()) {
            Modification mo = (Modification)v.get(j);
            String rid = mo.getResidue();
            TreeSet<Object> set = (TreeSet<Object>)map.get(rid);
            if (set == null) {
                set = new TreeSet<Object>();
                map.put(rid, set);
            }
            if (wrap) {
                set.add(new ModificationWrapper(mo));
            } else {
                set.add(mo.getState());
            }
            ++j;
        }
    }

    public String getModifiersProteinId() {
        StringBuffer buf = new StringBuffer();
        this.toStringModifiersId(buf);
        return buf.toString();
    }

    private void toStringModifiersId(StringBuffer buf) {
        int count = 0;
        for (ProteinWrapper pw : this.modifiers) {
            if (count > 0) {
                buf.append('/');
            }
            buf.append(pw.getProtein().getId());
            ++count;
        }
    }

    public Set getModifiers() {
        return this.modifiers;
    }

    public void appendActivateResidue(ModificationWrapper mw) {
        this.activateResidueSet.add(mw);
    }

    public void appendDeactivateResidue(ModificationWrapper mw) {
        this.deactivateResidueSet.add(mw);
    }
}

