/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.table;

import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jp.sbi.celldesigner.blockDiagram.table.CenterRenderer;
import jp.sbi.celldesigner.blockDiagram.table.TableCellValueActivity;

public class MainTable
extends JTable {
    protected static final int MINWIDTH = 50;
    private int minWidth;

    public MainTable(AbstractTableModel model) {
        super(model);
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        TableColumnModel originalTcm = this.getColumnModel();
        int n = model.getColumnCount();
        this.minWidth = 0;
        int i = 1;
        while (i < n) {
            TableColumn tc = originalTcm.getColumn(i);
            tcm.addColumn(tc);
            tc.setMinWidth(50);
            tc.setPreferredWidth(50);
            this.minWidth += 50;
            tc.setCellRenderer(new CenterRenderer());
            ++i;
        }
        this.setColumnModel(tcm);
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int row = this.rowAtPoint(e.getPoint());
        if (row == -1) {
            return null;
        }
        int col = this.columnAtPoint(e.getPoint());
        if (col == -1) {
            return null;
        }
        Object value = this.getValueAt(row, col);
        if (value == null || !(value instanceof TableCellValueActivity)) {
            return null;
        }
        TableCellValueActivity cv = (TableCellValueActivity)value;
        return cv.getToolTipText();
    }
}

