/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueNameModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResiduePlacer;

public class ResidueNameDialog
extends JDialog {
    private ResidueModel rm;
    private ResidueNameModel rnm;
    private ResiduePlacer placer;
    private JButton jButtonOK = new JButton();
    private JTextField jTextField1 = new JTextField();
    private JButton jButtonCancel = new JButton();
    private String initialStr = "";

    public ResidueNameDialog(Dialog d, ResiduePlacer placer, ResidueModel rm, ResidueNameModel rnm) throws HeadlessException {
        super(d);
        this.placer = placer;
        this.rm = rm;
        this.rnm = rnm;
        this.myInit();
    }

    public ResidueNameDialog(Frame f, ResiduePlacer placer, ResidueModel rm, ResidueNameModel rnm) throws HeadlessException {
        super(f);
        this.placer = placer;
        this.rm = rm;
        this.rnm = rnm;
        this.myInit();
    }

    private void myInit() {
        this.setupPane();
        this.pack();
    }

    private void setupPane() {
        JPanel panel1 = new JPanel();
        GridBagLayout gridBagLayout1 = new GridBagLayout();
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        panel1.setLayout(gridBagLayout1);
        jPanel1.setLayout(gridBagLayout3);
        if (this.rnm != null) {
            this.initialStr = this.rnm.getName();
            this.jTextField1.setText(this.initialStr);
            this.jTextField1.setSelectionStart(0);
            this.jTextField1.setSelectionEnd(this.initialStr.length());
        } else {
            this.jTextField1.setText("");
        }
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResidueNameDialog.this.jTextField1_actionPerformed(e);
            }
        });
        this.jTextField1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ResidueNameDialog.this.jButtonOK.setEnabled(ResidueNameDialog.this.jTextField1CheckValue());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ResidueNameDialog.this.jButtonOK.setEnabled(ResidueNameDialog.this.jTextField1CheckValue());
            }
        });
        jPanel2.setLayout(gridBagLayout2);
        this.jButtonOK.setText("ok");
        if (this.rnm != null) {
            this.jButtonOK.setEnabled(false);
        }
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResidueNameDialog.this.jButtonOK_actionPerformed(e);
            }
        });
        this.jButtonCancel.setText("cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResidueNameDialog.this.jButtonCancel_actionPerformed(e);
            }
        });
        panel1.setBorder(new TitledBorder(new EtchedBorder(0, Color.white, new Color(148, 145, 140)), "Specify Operator Value"));
        this.getContentPane().add(panel1);
        panel1.add((Component)jPanel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel1.add((Component)this.jTextField1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel1.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.jButtonOK, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this.jButtonCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void jTextField1_actionPerformed(ActionEvent e) {
        boolean check = this.jTextField1CheckValue();
        if (check) {
            this.ok();
        }
    }

    private void jButtonOK_actionPerformed(ActionEvent e) {
        this.ok();
    }

    private void jButtonCancel_actionPerformed(ActionEvent e) {
        this.cancel();
    }

    private boolean jTextField1CheckValue() {
        Document doc = this.jTextField1.getDocument();
        try {
            int n = doc.getLength();
            String str = doc.getText(0, n);
            boolean check = this.rm.checkValue(str);
            return check && !str.equals(this.initialStr);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void ok() {
        Document doc = this.jTextField1.getDocument();
        try {
            int n = doc.getLength();
            String str = doc.getText(0, n);
            if (this.rnm == null) {
                this.rnm = this.placer.createResidueNameModel(this.rm, str);
            } else {
                this.rnm.setName(str);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.dispose();
    }

    private void cancel() {
        this.rm.checkValue(this.initialStr);
        this.dispose();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.cancel();
        }
    }
}

