/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import jp.co.fujiric.star.gui.gef.swing.DxDy;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.SimpleMoverImpl;

public class RestrictedInShapeMover
extends SimpleMoverImpl {
    private ShapeModelImpl shapem;
    private int direction;

    public RestrictedInShapeMover(ShapeModelImpl shapem, int direction) {
        if (direction != 1 && direction != 2) {
            throw new IllegalArgumentException("invalid direction: " + direction);
        }
        this.shapem = shapem;
        this.direction = direction;
    }

    @Override
    public void restrictDxDyForDrag(ShapeVCImpl vc, DxDy dxdy) {
        if (this.direction == 1) {
            dxdy.dy = 0;
            int cx = ((ShapeModelImpl)vc.getModel()).getCenterX();
            int newcx = cx + dxdy.dx;
            if (newcx < this.shapem.getX()) {
                newcx = this.shapem.getX();
            } else if (newcx > this.shapem.getX() + this.shapem.getWidth()) {
                newcx = this.shapem.getX() + this.shapem.getWidth();
            }
            dxdy.dx = newcx - cx;
        } else if (this.direction == 2) {
            dxdy.dx = 0;
            int cy = ((ShapeModelImpl)vc.getModel()).getCenterY();
            int newcy = cy + dxdy.dy;
            if (newcy < this.shapem.getY()) {
                newcy = this.shapem.getY();
            } else if (newcy > this.shapem.getY() + this.shapem.getHeight()) {
                newcy = this.shapem.getY() + this.shapem.getHeight();
            }
            dxdy.dy = newcy - cy;
        }
    }
}

