/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import jp.co.fujiric.star.gui.gef.swing.CircleVC;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteVC;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperationalVC;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResiduePlacer;
import jp.sbi.celldesigner.blockDiagram.dialog.ResidueNameDialogThread;

public class ResidueVC
extends CircleVC
implements InternalOperationalVC {
    private ResiduePlacer placer;
    private boolean hilited = false;

    @Override
    protected Class getExpectedModelClass() {
        return ResidueModel.class;
    }

    @Override
    protected int getNameOffsetX() {
        return 1;
    }

    @Override
    public boolean canBeAEndPoint() {
        return true;
    }

    @Override
    public boolean canBeAStartPoint() {
        return true;
    }

    public void setPlacer(ResiduePlacer placer) {
        this.placer = placer;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.showDialog(false);
        }
    }

    protected void showDialog(boolean removeWhenCancel) {
        JComponent jc = this.getGuiComponent();
        Container top = jc.getTopLevelAncestor();
        ResidueModel rm = (ResidueModel)this.getModel();
        new ResidueNameDialogThread(top, rm, this.placer).start();
    }

    public void setHilited(boolean b) {
        this.hilited = b;
        this.visualUpdate();
    }

    @Override
    protected Color getForeColorBySelectStatus(int selectStatus) {
        Color c = super.getForeColorBySelectStatus(selectStatus);
        if (this.hilited) {
            c = BindingSiteVC.getForeColorConsideringHilited(this.hilited, c, this);
        }
        return c;
    }
}

