/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import jp.co.fujiric.star.gui.gef.swing.AnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.AnchoredShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.CanvasVCImpl;
import jp.co.fujiric.star.gui.gef.swing.EmptyAnchoredShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.EmptyAnchoredShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapePlacerByClick;
import jp.co.fujiric.star.gui.gef.swing.ShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.SimpleAnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.SwingVCImpl;
import jp.co.fujiric.star.gui.gef.swing.XYAnchorImpl;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockVC;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasModel;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasVC;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloModel;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloVC;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueModelAcetylated;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueModelDontCare;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueModelEmpty;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueModelHydroxylated;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueModelMethylated;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueModelPhosphorylated;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueModelUbiquitinated;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueModelUnknown;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueNameModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueNameVC;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueTailModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueTailVC;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueVC;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueWithTailModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueWithTailVC;
import jp.sbi.celldesigner.blockDiagram.diagram.RestrictedInShapeMover;
import jp.sbi.celldesigner.blockDiagram.table.ResidueState;

public class ResiduePlacer
extends ShapePlacerByClick {
    private int type;
    public static final int MARGINOFLINECONTAINGRECT = 6;

    public ResiduePlacer(CanvasVCImpl canvasvc, int type) {
        super(canvasvc);
        this.type = type;
    }

    @Override
    protected boolean isCreateShape(MouseEvent e, SwingVCImpl sourcevc, int canvasx, int canvasy) {
        BlockVC blockvc = ((CanvasVC)this.canvasvc).getBlockvc();
        return blockvc.isOnTheEdge(canvasx, canvasy, 1, 6, 6);
    }

    @Override
    protected boolean isCreateShapeWithAnchoring(MouseEvent e, SwingVCImpl sourcevc, int canvasx, int canvasy) {
        return true;
    }

    @Override
    protected ShapeModelImpl anchorToTheTarget(ShapeModelImpl shape, SwingVCImpl sourcevc) {
        return this.anchorToTheTarget(shape, null, false, 0.0, null, 0.0, 0.0);
    }

    protected ShapeModelImpl anchorToTheTarget(ShapeModelImpl shape, ResidueState rs, boolean loaded, double offsetX, String name, double nameOffsetX, double nameOffsetY) {
        BlockVC blockvc = ((CanvasVC)this.canvasvc).getBlockvc();
        BlockModel blockm = (BlockModel)blockvc.getModel();
        HaloVC halovc = ((CanvasVC)this.canvasvc).getHalovc();
        HaloModel halom = (HaloModel)halovc.getModel();
        if (!(shape instanceof ResidueModel)) {
            return null;
        }
        ResidueModel residuem = (ResidueModel)shape;
        residuem.setEditableForName(rs == null);
        ResidueVC rvc = (ResidueVC)this.canvasvc.getFromShapeVCByModel(residuem);
        rvc.setPlacer(this);
        if (rs != null) {
            residuem.setResidueState(rs);
            CanvasModel cm = (CanvasModel)this.canvasvc.getModel();
            residuem.setCanvasModel(cm);
        }
        EmptyAnchoredShapeModelImpl tailbasem = new EmptyAnchoredShapeModelImpl();
        tailbasem.initialize(this.canvasm);
        this.canvasm.addLast(tailbasem);
        int cx = residuem.getCenterX();
        int cy = residuem.getCenterY();
        int x1 = ResiduePlacer.calcTheNearestXCoordOnTheBlock(((CanvasVC)this.canvasvc).getBlockvc(), cx);
        if (cx != x1 || cy != blockm.getY()) {
            int dx = x1 - cx;
            int dy = blockm.getY() - cy;
            residuem.move(dx, dy);
            cx = x1;
            cy = blockm.getY();
        }
        int targetCx = blockm.getCenterX();
        double dx = loaded ? offsetX : (double)(cx - targetCx);
        double dy = 0.0;
        SimpleAnchorImpl anchor = new SimpleAnchorImpl(1, 10, dx, dy);
        ((AnchorImpl)anchor).initialize(blockm);
        residuem.addLastAnchor(anchor);
        if (loaded) {
            residuem.setLocationByShape(blockm);
            cx = residuem.getCenterX();
        }
        this.createResidueNameModel(residuem, name, rs, loaded, true, nameOffsetX, nameOffsetY);
        int dx2 = 0;
        boolean dy2 = false;
        SimpleAnchorImpl xAnchor = new SimpleAnchorImpl(1, 10, dx2, (double)dy2);
        xAnchor.initialize(residuem);
        dx2 = cx - halom.getCenterX();
        dy2 = false;
        SimpleAnchorImpl yAnchor = new SimpleAnchorImpl(1, 10, dx2, (double)dy2);
        yAnchor.initialize(halom);
        XYAnchorImpl xyAnchor = new XYAnchorImpl(xAnchor, yAnchor);
        tailbasem.addLastAnchor(xyAnchor);
        ResidueTailModel tailm = new ResidueTailModel();
        tailm.setHeadless(true);
        int x = residuem.getCenterX();
        int y = halom.getY();
        int w = 0;
        int h = blockm.getY() - y - residuem.getHeight() / 2;
        tailm.initialize(this.canvasm, x, y, w, h, false);
        tailm.addLastShape(tailbasem, new SimpleAnchorImpl(0, 11));
        tailm.addLastShape(residuem, new SimpleAnchorImpl(1, 11));
        this.canvasm.addLast(tailm);
        ResidueWithTailModel rtm = new ResidueWithTailModel();
        rtm.initialize(this.canvasm);
        LinkedList<AnchoredShapeModelImpl> shapes = new LinkedList<AnchoredShapeModelImpl>();
        shapes.addLast(residuem);
        shapes.addLast(tailm);
        rtm.add(shapes);
        tailm.setResidueModel(residuem);
        residuem.setRelatedModels(rtm, tailm, tailbasem);
        if (rs != null) {
            residuem.setRemovable(false);
        }
        return blockm;
    }

    @Override
    public ShapeModelImpl createShape() {
        return this.createShape(null);
    }

    public ShapeModelImpl createShape(ResidueModel residuem) {
        BlockVC blockvc = ((CanvasVC)this.canvasvc).getBlockvc();
        BlockModel blockm = (BlockModel)blockvc.getModel();
        if (residuem == null) {
            residuem = (ResidueModel)super.createShape();
        }
        ShapeVCImpl vc = this.canvasvc.getFromShapeVCByModel(residuem);
        vc.setMover(new RestrictedInShapeMover(blockm, 1));
        return residuem;
    }

    protected static int calcTheNearestXCoordOnTheBlock(ShapeVCImpl blockvc, int x) {
        BlockModel blockm = (BlockModel)blockvc.getModel();
        int xb = blockm.getX();
        int wb = blockm.getWidth();
        if (x < xb) {
            x = xb;
        } else if (x > xb + wb - 1) {
            x = xb + wb - 1;
        }
        return x;
    }

    @Override
    public String getMainShapeModelClassName() {
        String mcname;
        switch (this.type) {
            case 1: {
                mcname = ResidueModelPhosphorylated.class.getName();
                break;
            }
            case 2: {
                mcname = ResidueModelAcetylated.class.getName();
                break;
            }
            case 3: {
                mcname = ResidueModelUbiquitinated.class.getName();
                break;
            }
            case 4: {
                mcname = ResidueModelMethylated.class.getName();
                break;
            }
            case 5: {
                mcname = ResidueModelHydroxylated.class.getName();
                break;
            }
            case 6: {
                mcname = ResidueModelEmpty.class.getName();
                break;
            }
            case 7: {
                mcname = ResidueModelDontCare.class.getName();
                break;
            }
            default: {
                mcname = ResidueModelUnknown.class.getName();
            }
        }
        return mcname;
    }

    @Override
    public Map getShapeMVCClassNamesMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.getMainShapeModelClassName(), ResidueVC.class.getName());
        map.put(ResidueTailModel.class.getName(), ResidueTailVC.class.getName());
        map.put(ResidueWithTailModel.class.getName(), ResidueWithTailVC.class.getName());
        map.put(EmptyAnchoredShapeModelImpl.class.getName(), EmptyAnchoredShapeVCImpl.class.getName());
        map.put(ResidueNameModel.class.getName(), ResidueNameVC.class.getName());
        return map;
    }

    public ResidueModel createResidueModel(int x, int y, int type) {
        ResidueModel rm;
        switch (type) {
            case 1: {
                rm = new ResidueModelPhosphorylated();
                break;
            }
            case 2: {
                rm = new ResidueModelAcetylated();
                break;
            }
            case 3: {
                rm = new ResidueModelUbiquitinated();
                break;
            }
            case 4: {
                rm = new ResidueModelMethylated();
                break;
            }
            case 5: {
                rm = new ResidueModelHydroxylated();
                break;
            }
            case 6: {
                rm = new ResidueModelEmpty();
                break;
            }
            case 7: {
                rm = new ResidueModelDontCare();
                break;
            }
            default: {
                rm = new ResidueModelUnknown();
            }
        }
        rm.initialize(this.canvasm, x, y);
        this.canvasm.addLast(rm);
        return rm;
    }

    public ResidueNameModel createResidueNameModel(ResidueModel residuem, String value) {
        TreeMap<String, String> tempMap = new TreeMap<String, String>();
        tempMap.put(ResidueNameModel.class.getName(), ResidueNameVC.class.getName());
        Map mapMVC = this.canvasvc.getShapeMVCMap();
        this.canvasvc.setShapeMVCMap(tempMap);
        ResidueNameModel namem = this.createResidueNameModel(residuem, value, null, false, false, 0.0, 0.0);
        this.canvasvc.setShapeMVCMap(mapMVC);
        return namem;
    }

    private ResidueNameModel createResidueNameModel(ResidueModel residuem, String value, ResidueState rs, boolean loaded, boolean needToSetNameInitially, double nameOffsetX, double nameOffsetY) {
        ResidueNameModel namem = new ResidueNameModel(rs != null, loaded);
        if (!needToSetNameInitially) {
            namem.setNeedToSetNameInitially(needToSetNameInitially);
        }
        int x = residuem.getCenterX();
        int y = residuem.getCenterY() + 5;
        int w = 50;
        int h = 14;
        if (value != null) {
            namem.initialize(this.canvasm, x, y, w, h);
            this.canvasm.addLast(namem);
            namem.setName(value);
        } else if (rs != null) {
            String str = rs.getResidueName();
            if (str != null && str.length() > 0) {
                namem.initialize(this.canvasm, x, y, w, h);
                this.canvasm.addLast(namem);
                namem.setName(str);
            } else {
                namem = null;
            }
        } else {
            namem.initialize(this.canvasm, x, y, w, h);
            this.canvasm.addLast(namem);
            String defaultName = "res1";
            namem.setDefaultName(defaultName);
        }
        if (namem != null) {
            double dx = loaded ? nameOffsetX : (double)(namem.getCenterX() - residuem.getCenterX());
            double dy = loaded ? nameOffsetY : (double)(namem.getCenterY() - residuem.getCenterY());
            SimpleAnchorImpl a = new SimpleAnchorImpl(0, 10, dx, dy);
            namem.addLastShape(residuem, a);
            namem.setResidueModel(residuem);
            if (loaded) {
                namem.setLocationByShape(residuem);
            }
            ResidueNameVC rnvc = (ResidueNameVC)this.canvasvc.getFromShapeVCByModel(namem);
            rnvc.setPlacer(this);
            residuem.setNameModel(namem);
        }
        return namem;
    }
}

