/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import jp.co.fujiric.star.gui.gef.ModelImpl;
import jp.co.fujiric.star.gui.gef.swing.AnchoredShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.CanvasModelImpl;
import jp.co.fujiric.star.gui.gef.swing.CircleModel;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperation;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperationalException;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperationalModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperatorTraceStack;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueNameModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueTailModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueWithTailModel;
import jp.sbi.celldesigner.blockDiagram.table.ProteinInstanceState;
import jp.sbi.celldesigner.blockDiagram.table.ProteinState;
import jp.sbi.celldesigner.blockDiagram.table.ResidueState;
import jp.sbi.celldesigner.blockDiagram.table.TableColumnValue;

public abstract class ResidueModel
extends CircleModel
implements InternalOperationalModel {
    public static final int PHOSPHORYLATED = 1;
    public static final int ACETYLATED = 2;
    public static final int UBIQUITINATED = 3;
    public static final int METHYLATED = 4;
    public static final int HYDROXYLATED = 5;
    public static final int EMPTY = 6;
    public static final int DONTCARE = 7;
    public static final int UNKNOWN = 8;
    private int type;
    private ResidueWithTailModel rtm;
    private ResidueTailModel tailm;
    private AnchoredShapeModelImpl tailbasem;
    private ResidueNameModel nameModel;
    private ResidueState residueState;
    private CanvasModel canvasModel;
    private Set outputLinkSet;
    private Set inputLinkSet;
    private boolean editableForName = false;
    private static final int DEFAULT_WIDTH = 16;
    private static final int DEFAULT_HEIGHT = 16;
    private static String STR_PHOSPHORYLATED = "phosphorylated";
    private static String STR_ACETYLATED = "acetylated";
    private static String STR_UBIQUITINATED = "ubiquitinated";
    private static String STR_METHYLATED = "methylated";
    private static String STR_HYDROXYLATED = "hydroxylated";
    private static String STR_EMPTY = "empty";
    private static String STR_DONTCARE = "dontcare";

    public ResidueModel() {
        this.name = "P";
        this.outputLinkSet = new HashSet();
        this.inputLinkSet = new HashSet();
    }

    @Override
    public void addOutputLink(InternalLinkModel linkm) {
        this.outputLinkSet.add(linkm);
    }

    @Override
    public void removeOutputLink(InternalLinkModel linkm) {
        this.outputLinkSet.remove(linkm);
    }

    @Override
    public void addInputLink(InternalLinkModel linkm) {
        this.inputLinkSet.add(linkm);
    }

    @Override
    public void removeInputLink(InternalLinkModel linkm) {
        this.inputLinkSet.remove(linkm);
    }

    @Override
    public Set getInputLinkSet() {
        return Collections.unmodifiableSet(this.inputLinkSet);
    }

    @Override
    public Set getOutputLinkSet() {
        return Collections.unmodifiableSet(this.outputLinkSet);
    }

    @Override
    protected int getDefaultHeight() {
        return ResidueModel.getDefaultHeightStatic();
    }

    @Override
    protected int getDefaultWidth() {
        return ResidueModel.getDefaultWidthStatic();
    }

    protected static int getDefaultWidthStatic() {
        return 16;
    }

    protected static int getDefaultHeightStatic() {
        return 16;
    }

    public void setRelatedModels(ResidueWithTailModel rtm, ResidueTailModel tailm, AnchoredShapeModelImpl tailbasem) {
        this.rtm = rtm;
        this.tailm = tailm;
        this.tailbasem = tailbasem;
    }

    public void setNameModel(ResidueNameModel namem) {
        this.nameModel = namem;
        namem.addObserver(this);
    }

    protected void setRemovable(boolean flag) {
        this.setDirectRemovable(flag);
        this.rtm.setDirectRemovable(flag);
        this.tailm.setDirectRemovable(flag);
        this.tailbasem.setDirectRemovable(flag);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int i) {
        ResidueModel.checkType(i);
        this.type = i;
        switch (i) {
            case 1: {
                this.name = "P";
                break;
            }
            case 2: {
                this.name = "Ac";
                break;
            }
            case 3: {
                this.name = "Ub";
                break;
            }
            case 4: {
                this.name = "Me";
                break;
            }
            case 5: {
                this.name = "OH";
                break;
            }
            case 6: {
                this.name = "";
                break;
            }
            case 7: {
                this.name = "*";
                break;
            }
            default: {
                this.name = "?";
            }
        }
    }

    public static void checkType(int type) {
        if (type != 1 && type != 2 && type != 3 && type != 4 && type != 5 && type != 6 && type != 7 && type != 8) {
            throw new IllegalArgumentException("unknown type:" + type);
        }
    }

    public void setResidueState(ResidueState rs) {
        this.residueState = rs;
    }

    public void setCanvasModel(CanvasModel cm) {
        this.canvasModel = cm;
    }

    @Override
    public double getOperatedValue(InternalOperatorTraceStack parent) throws InternalOperationalException {
        ProteinInstanceState pis;
        List list;
        String sid = parent.getSpeciesId();
        TableColumnValue tcv = this.canvasModel.getTableValues().getTalbeColumnValue(sid);
        String pid = this.residueState.getProteinId();
        ProteinState ps = tcv.getProteinState(pid);
        double initialValue = 0.0;
        if (ps != null && !(list = ps.getProteinInstanceStateList()).isEmpty() && (pis = (ProteinInstanceState)list.iterator().next()).getNmer() > 0) {
            List rslist = pis.getResidueStateList();
            boolean find = false;
            for (ResidueState rs : rslist) {
                int cmp = rs.compareTo(this.residueState);
                if (cmp != 0) continue;
                find = true;
                break;
            }
            if (find) {
                initialValue = 1.0;
            }
        }
        double outputValue = 1.0;
        return InternalOperation.getOperatedValueOrWithInitialValue(this, parent, initialValue, outputValue);
    }

    public ResidueState getResidueState() {
        return this.residueState;
    }

    public ResidueNameModel getNameModel() {
        return this.nameModel;
    }

    public void clearNameModel() {
        this.nameModel = null;
    }

    public String getTypeString() {
        switch (this.type) {
            case 1: {
                return STR_PHOSPHORYLATED;
            }
            case 2: {
                return STR_ACETYLATED;
            }
            case 3: {
                return STR_UBIQUITINATED;
            }
            case 4: {
                return STR_METHYLATED;
            }
            case 5: {
                return STR_HYDROXYLATED;
            }
            case 6: {
                return STR_EMPTY;
            }
            case 7: {
                return STR_DONTCARE;
            }
        }
        return "unknown";
    }

    public static int getTypeFromString(String str) {
        if (str.equals(STR_PHOSPHORYLATED)) {
            return 1;
        }
        if (str.equals(STR_ACETYLATED)) {
            return 2;
        }
        if (str.equals(STR_UBIQUITINATED)) {
            return 3;
        }
        if (str.equals(STR_METHYLATED)) {
            return 4;
        }
        if (str.equals(STR_HYDROXYLATED)) {
            return 5;
        }
        if (str.equals(STR_EMPTY)) {
            return 6;
        }
        if (str.equals(STR_DONTCARE)) {
            return 7;
        }
        return 8;
    }

    public ResidueTailModel getTailModel() {
        return this.tailm;
    }

    @Override
    public void initialize(CanvasModelImpl canvas, int x, int y, int w, int h, boolean forDrag) {
        super.initialize(canvas, x, y, w, h, forDrag);
        if (!this.forDrag) {
            ((CanvasModel)this.canvas).setEdited();
        }
    }

    @Override
    public void move(int dx, int dy, int aspect) {
        super.move(dx, dy, aspect);
        if (!this.forDrag) {
            ((CanvasModel)this.canvas).setEdited();
        }
    }

    @Override
    public void remove() {
        if (!this.forDrag) {
            ((CanvasModel)this.canvas).setEdited();
        }
        super.remove();
    }

    public boolean checkValue(String str) {
        return str != null && str.length() > 0;
    }

    @Override
    public void update(Observable observable, Object aspect) {
        if (this.nameModel == observable) {
            switch (((ModelImpl.AspectWrapper)aspect).getAspectInt()) {
                case 3: {
                    this.nameModel = null;
                    return;
                }
            }
        } else {
            super.update(observable, aspect);
        }
    }

    public void setEditableForName(boolean editable) {
        this.editableForName = editable;
    }

    public boolean isEditableForName() {
        return this.editableForName;
    }

    public boolean isPredefined() {
        return this.residueState != null;
    }
}

