/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperation;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperationalException;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperatorTraceStack;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorModel;

public class OperatorThresholdModel
extends OperatorModel {
    public static final String STR_GREATER_OR_EQUAL = "ge";
    public static final String STR_GREATER_THAN = "gt";
    public static final String STR_LESS_OR_EQUAL = "le";
    public static final String STR_LESS_THAN = "lt";
    public static final int GREATER_OR_EQUAL = 1;
    public static final int GREATER_THAN = 2;
    public static final int LESS_OR_EQUAL = 3;
    public static final int LESS_THAN = 4;
    protected int relationalOperator;
    private static final String GE_OP_STRING = ">=";
    private static final String LE_OP_STRING = "<=";
    private static final String GT_OP_STRING = ">";
    private static final String LT_OP_STRING = "<";

    public OperatorThresholdModel() {
        this.setType(5);
    }

    @Override
    public double getOperatedValue(InternalOperatorTraceStack parent) throws InternalOperationalException {
        double value1 = InternalOperation.getOperatedValueAdd(this, parent);
        if (Double.isNaN(value1)) {
            return value1;
        }
        switch (this.relationalOperator) {
            case 1: {
                if (!(value1 >= this.getDoubleValue())) break;
                return value1;
            }
            case 2: {
                if (!(value1 > this.getDoubleValue())) break;
                return value1;
            }
            case 3: {
                if (!(value1 <= this.getDoubleValue())) break;
                return value1;
            }
            case 4: {
                if (!(value1 < this.getDoubleValue())) break;
                return value1;
            }
        }
        return 0.0;
    }

    @Override
    public boolean checkValue(String value) {
        String valueWithoutOperator = null;
        String v = value.trim();
        int len = v.length();
        if (len <= 0) {
            return false;
        }
        boolean next = false;
        if (len >= 2) {
            String v2 = v.substring(0, 2);
            if (v2.equals(GE_OP_STRING)) {
                this.relationalOperator = 1;
                valueWithoutOperator = v.substring(2);
                next = true;
            } else if (v2.equals(LE_OP_STRING)) {
                this.relationalOperator = 3;
                valueWithoutOperator = v.substring(2);
                next = true;
            }
        }
        if (!next && len >= 1) {
            String v1 = v.substring(0, 1);
            if (v1.equals(GT_OP_STRING)) {
                this.relationalOperator = 2;
                valueWithoutOperator = v.substring(1);
                next = true;
            } else if (v1.equals(LT_OP_STRING)) {
                this.relationalOperator = 4;
                valueWithoutOperator = v.substring(1);
                next = true;
            }
        }
        if (!next) {
            return false;
        }
        return super.checkValue(valueWithoutOperator);
    }

    @Override
    public String getDefaultValueString() {
        return ">=1.0";
    }

    public int getRelationalOperator() {
        return this.relationalOperator;
    }

    public static String getRelationalOperatorString(int ro) {
        switch (ro) {
            case 1: {
                return GE_OP_STRING;
            }
            case 2: {
                return GT_OP_STRING;
            }
            case 3: {
                return LE_OP_STRING;
            }
        }
        return LT_OP_STRING;
    }

    @Override
    public String getTypeString() {
        return "threshold";
    }

    public String getRelationalOperatorTypeString() {
        switch (this.relationalOperator) {
            case 1: {
                return STR_GREATER_OR_EQUAL;
            }
            case 2: {
                return STR_GREATER_THAN;
            }
            case 3: {
                return STR_LESS_OR_EQUAL;
            }
        }
        return STR_LESS_THAN;
    }

    public static int getRelationalOperatorTypeStringFromString(String str) {
        if (str.equals(STR_GREATER_OR_EQUAL)) {
            return 1;
        }
        if (str.equals(STR_GREATER_THAN)) {
            return 2;
        }
        if (str.equals(STR_LESS_OR_EQUAL)) {
            return 3;
        }
        if (str.equals(STR_LESS_THAN)) {
            return 4;
        }
        throw new IllegalArgumentException("unknown type:" + str);
    }
}

