/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import jp.co.fujiric.star.gui.gef.swing.AnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.CanvasVCImpl;
import jp.co.fujiric.star.gui.gef.swing.DxDy;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapePlacerByClick;
import jp.co.fujiric.star.gui.gef.swing.ShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.SimpleAnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.SimpleMoverImpl;
import jp.co.fujiric.star.gui.gef.swing.SwingVCImpl;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockVC;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasVC;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorAddModel;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorAddVC;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorAndModel;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorAndVC;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorAssignModel;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorAssignVC;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorAutoActivateModel;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorAutoActivateVC;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorModel;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorMultiplyModel;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorMultiplyVC;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorOrModel;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorOrVC;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorThresholdModel;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorThresholdVC;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorVC;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorValueModel;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorValueVC;

public class OperatorPlacer
extends ShapePlacerByClick {
    private int type;

    public OperatorPlacer(CanvasVCImpl canvasvc, int type) {
        super(canvasvc);
        this.type = type;
    }

    @Override
    protected boolean isCreateShape(MouseEvent e, SwingVCImpl sourcevc, int canvasx, int canvasy) {
        JComponent c;
        return sourcevc == ((CanvasVC)this.canvasvc).getBlockvc() && (c = ((BlockVC)sourcevc).getGuiComponent()).contains(canvasx - c.getX(), canvasy - c.getY());
    }

    @Override
    public ShapeModelImpl createShape() {
        return this.createShape(null);
    }

    public ShapeModelImpl createShape(OperatorModel om) {
        if (om == null) {
            om = (OperatorModel)super.createShape();
        }
        BlockVC blockvc = ((CanvasVC)this.canvasvc).getBlockvc();
        BlockModel blockm = (BlockModel)blockvc.getModel();
        ShapeVCImpl vc = this.canvasvc.getFromShapeVCByModel(om);
        vc.setMover(new OperatorMover(blockm));
        return om;
    }

    @Override
    public String getMainShapeModelClassName() {
        String mcname;
        switch (this.type) {
            case 1: {
                mcname = OperatorAndModel.class.getName();
                break;
            }
            case 2: {
                mcname = OperatorOrModel.class.getName();
                break;
            }
            case 3: {
                mcname = OperatorAddModel.class.getName();
                break;
            }
            case 4: {
                mcname = OperatorMultiplyModel.class.getName();
                break;
            }
            case 5: {
                mcname = OperatorThresholdModel.class.getName();
                break;
            }
            case 6: {
                mcname = OperatorAutoActivateModel.class.getName();
                break;
            }
            default: {
                mcname = OperatorAssignModel.class.getName();
            }
        }
        return mcname;
    }

    @Override
    public Map getShapeMVCClassNamesMap() {
        String vccname;
        HashMap<String, String> map = new HashMap<String, String>();
        String mcname = this.getMainShapeModelClassName();
        switch (this.type) {
            case 1: {
                vccname = OperatorAndVC.class.getName();
                break;
            }
            case 2: {
                vccname = OperatorOrVC.class.getName();
                break;
            }
            case 3: {
                vccname = OperatorAddVC.class.getName();
                break;
            }
            case 4: {
                vccname = OperatorMultiplyVC.class.getName();
                break;
            }
            case 5: {
                vccname = OperatorThresholdVC.class.getName();
                break;
            }
            case 6: {
                vccname = OperatorAutoActivateVC.class.getName();
                break;
            }
            default: {
                vccname = OperatorAssignVC.class.getName();
            }
        }
        map.put(mcname, vccname);
        map.put(OperatorValueModel.class.getName(), OperatorValueVC.class.getName());
        return map;
    }

    public OperatorModel createOperatorModel(int x, int y) {
        String mcname = this.getMainShapeModelClassName();
        try {
            Class<?> clazz = Class.forName(mcname);
            OperatorModel model = (OperatorModel)clazz.newInstance();
            model.initialize(this.canvasm, x, y);
            this.canvasm.addLast(model);
            return model;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected ShapeModelImpl anchorToTheTarget(ShapeModelImpl shape, SwingVCImpl sourcevc) {
        return this.anchorToTheTarget(shape, false, 0.0, 0.0, null, 0.0, 0.0, 0);
    }

    protected ShapeModelImpl anchorToTheTarget(ShapeModelImpl shape, boolean loaded, double offsetX, double offsetY, String value, double valueOffsetX, double valueOffsetY, int subType) {
        BlockVC blockvc = ((CanvasVC)this.canvasvc).getBlockvc();
        BlockModel blockm = (BlockModel)blockvc.getModel();
        OperatorModel om = (OperatorModel)shape;
        OperatorVC ovc = (OperatorVC)this.canvasvc.getFromShapeVCByModel(om);
        ovc.setPlacer(this);
        int cx = om.getCenterX();
        int cy = om.getCenterY();
        int targetCx = blockm.getCenterX();
        int targetCy = blockm.getCenterY();
        double dx = loaded ? offsetX : (double)(cx - targetCx);
        double dy = loaded ? offsetY : (double)(cy - targetCy);
        SimpleAnchorImpl anchor = new SimpleAnchorImpl(0, 10, dx, dy);
        ((AnchorImpl)anchor).initialize(blockm);
        om.addLastAnchor(anchor);
        if (loaded) {
            om.setLocationByShape(blockm);
        }
        if (this.type != 7 && this.type != 5) {
            om.setPlaced();
        }
        if (this.type == 7 || this.type == 5 || loaded && value != null) {
            this.createOperatorValueModel(om, value, loaded, true, subType, valueOffsetX, valueOffsetY);
        }
        return blockm;
    }

    public OperatorValueModel createOperatorValueModel(OperatorModel om, String value) {
        boolean loaded = false;
        TreeMap<String, String> tempMap = new TreeMap<String, String>();
        tempMap.put(OperatorValueModel.class.getName(), OperatorValueVC.class.getName());
        Map mapMVC = this.canvasvc.getShapeMVCMap();
        this.canvasvc.setShapeMVCMap(tempMap);
        OperatorValueModel ovm = this.createOperatorValueModel(om, value, loaded, false, 0, 0.0, 0.0);
        this.canvasvc.setShapeMVCMap(mapMVC);
        ovm.setName(value);
        return ovm;
    }

    private OperatorValueModel createOperatorValueModel(OperatorModel om, String value, boolean loaded, boolean needToSetNameInitially, int subType, double valueOffsetX, double valueOffsetY) {
        boolean predefined = false;
        OperatorValueModel ovm = new OperatorValueModel(om, predefined, loaded);
        if (!needToSetNameInitially) {
            ovm.setNeedToSetNameInitially(needToSetNameInitially);
        }
        int x = om.getCenterX();
        int y = om.getCenterY() + 5;
        int w = 50;
        int h = 14;
        ovm.initialize(this.canvasm, x, y, w, h);
        this.canvasm.addLast(ovm);
        if (loaded) {
            if (om instanceof OperatorThresholdModel) {
                value = String.valueOf(OperatorThresholdModel.getRelationalOperatorString(subType)) + value;
            }
            ovm.setName(value);
        } else {
            String defaultName = om.getDefaultValueString();
            ovm.setDefaultName(defaultName);
        }
        double dx = loaded ? valueOffsetX : (double)(ovm.getCenterX() - om.getCenterX());
        double dy = loaded ? valueOffsetY : (double)(ovm.getCenterY() - om.getCenterY());
        SimpleAnchorImpl a = new SimpleAnchorImpl(0, 10, dx, dy);
        ovm.addLastShape(om, a);
        if (loaded) {
            ovm.setLocationByShape(om);
        }
        om.setValueModel(ovm);
        OperatorValueVC ovvc = (OperatorValueVC)this.canvasvc.getFromShapeVCByModel(ovm);
        ovvc.setPlacer(this);
        return ovm;
    }

    class OperatorMover
    extends SimpleMoverImpl {
        private BlockModel blockm;

        OperatorMover(BlockModel blockm) {
            this.blockm = blockm;
        }

        @Override
        public void restrictDxDyForDrag(ShapeVCImpl vc, DxDy dxdy) {
            int cx = ((ShapeModelImpl)vc.getModel()).getCenterX();
            int newcx = cx + dxdy.dx;
            if (newcx < this.blockm.getX()) {
                newcx = this.blockm.getX();
            } else if (newcx > this.blockm.getX() + this.blockm.getWidth()) {
                newcx = this.blockm.getX() + this.blockm.getWidth();
            }
            dxdy.dx = newcx - cx;
            int cy = ((ShapeModelImpl)vc.getModel()).getCenterY();
            int newcy = cy + dxdy.dy;
            if (newcy < this.blockm.getY()) {
                newcy = this.blockm.getY();
            } else if (newcy > this.blockm.getY() + this.blockm.getHeight()) {
                newcy = this.blockm.getY() + this.blockm.getHeight();
            }
            dxdy.dy = newcy - cy;
        }
    }
}

