/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import java.util.Collections;
import java.util.HashSet;
import java.util.Observable;
import java.util.Set;
import jp.co.fujiric.star.gui.gef.ModelImpl;
import jp.co.fujiric.star.gui.gef.swing.CircleModel;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperationalModel;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorValueModel;

public abstract class OperatorModel
extends CircleModel
implements InternalOperationalModel {
    public static final String STR_OPERATOR_AND = "and";
    public static final String STR_OPERATOR_OR = "or";
    public static final String STR_OPERATOR_ADD = "add";
    public static final String STR_OPERATOR_MULTIPLY = "multiply";
    public static final String STR_OPERATOR_THRESHOLD = "threshold";
    public static final String STR_OPERATOR_AUTOACTIVATE = "autoActivate";
    public static final String STR_OPERATOR_ASSIGN = "assign";
    public static final int OPERATOR_AND = 1;
    public static final int OPERATOR_OR = 2;
    public static final int OPERATOR_ADD = 3;
    public static final int OPERATOR_MULTIPLY = 4;
    public static final int OPERATOR_THRESHOLD = 5;
    public static final int OPERATOR_AUTOACTIVATE = 6;
    public static final int OPERATOR_ASSIGN = 7;
    private int type;
    private Set outputLinkSet = new HashSet();
    private Set inputLinkSet = new HashSet();
    protected OperatorValueModel valueModel;
    private boolean placed = false;
    private static final int DEFAULT_WIDTH = 16;
    private static final int DEFAULT_HEIGHT = 16;
    protected double doubleValue;
    protected String doubleValueString;

    @Override
    public void addOutputLink(InternalLinkModel linkm) {
        this.outputLinkSet.add(linkm);
    }

    @Override
    public void removeOutputLink(InternalLinkModel linkm) {
        this.outputLinkSet.remove(linkm);
    }

    @Override
    public void addInputLink(InternalLinkModel linkm) {
        this.inputLinkSet.add(linkm);
    }

    @Override
    public void removeInputLink(InternalLinkModel linkm) {
        this.inputLinkSet.remove(linkm);
    }

    @Override
    public Set getInputLinkSet() {
        return Collections.unmodifiableSet(this.inputLinkSet);
    }

    @Override
    public Set getOutputLinkSet() {
        return Collections.unmodifiableSet(this.outputLinkSet);
    }

    @Override
    protected int getDefaultHeight() {
        return OperatorModel.getDefaultHeightStatic();
    }

    @Override
    protected int getDefaultWidth() {
        return OperatorModel.getDefaultWidthStatic();
    }

    protected static int getDefaultWidthStatic() {
        return 16;
    }

    protected static int getDefaultHeightStatic() {
        return 16;
    }

    public static void checkType(int type) {
        if (type != 1 && type != 2 && type != 3 && type != 4 && type != 5 && type != 6 && type != 7) {
            throw new IllegalArgumentException("unknown type:" + type);
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        OperatorModel.checkType(type);
        this.type = type;
        switch (type) {
            case 1: {
                this.name = "&";
                break;
            }
            case 3: {
                this.name = "+";
                break;
            }
            case 4: {
                this.name = "*";
            }
        }
    }

    public boolean checkValue(String value) {
        double d;
        block3: {
            try {
                d = Double.parseDouble(value);
                if (!(d < 0.0)) break block3;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        this.doubleValue = d;
        this.doubleValueString = value;
        return true;
    }

    public String getDefaultValueString() {
        return "1.0";
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public abstract String getTypeString();

    public OperatorValueModel getValueModel() {
        return this.valueModel;
    }

    public void setValueModel(OperatorValueModel model) {
        this.valueModel = model;
        model.addObserver(this);
    }

    public String getDoubleValueString() {
        return this.doubleValueString;
    }

    public static int getTypeFromString(String str) {
        if (str.equals(STR_OPERATOR_AND)) {
            return 1;
        }
        if (str.equals(STR_OPERATOR_OR)) {
            return 2;
        }
        if (str.equals(STR_OPERATOR_ADD)) {
            return 3;
        }
        if (str.equals(STR_OPERATOR_MULTIPLY)) {
            return 4;
        }
        if (str.equals(STR_OPERATOR_THRESHOLD)) {
            return 5;
        }
        if (str.equals(STR_OPERATOR_AUTOACTIVATE)) {
            return 6;
        }
        if (str.equals(STR_OPERATOR_ASSIGN)) {
            return 7;
        }
        throw new IllegalArgumentException("unknown type:" + str);
    }

    public static String getTypeFromInt(int str) {
        if (str == 1) {
            return STR_OPERATOR_AND;
        }
        if (str == 2) {
            return STR_OPERATOR_OR;
        }
        if (str == 3) {
            return STR_OPERATOR_ADD;
        }
        if (str == 4) {
            return STR_OPERATOR_MULTIPLY;
        }
        if (str == 5) {
            return STR_OPERATOR_THRESHOLD;
        }
        if (str == 6) {
            return STR_OPERATOR_AUTOACTIVATE;
        }
        if (str == 7) {
            return STR_OPERATOR_ASSIGN;
        }
        throw new IllegalArgumentException("unknown type:" + str);
    }

    @Override
    public void move(int dx, int dy, int aspect) {
        super.move(dx, dy, aspect);
        if (this.placed) {
            ((CanvasModel)this.canvas).setEdited();
        }
    }

    @Override
    public void remove() {
        if (this.placed) {
            ((CanvasModel)this.canvas).setEdited();
        }
        super.remove();
    }

    public void setPlaced() {
        this.placed = true;
        ((CanvasModel)this.canvas).setEdited();
    }

    @Override
    public void update(Observable observable, Object aspect) {
        if (this.valueModel == observable) {
            switch (((ModelImpl.AspectWrapper)aspect).getAspectInt()) {
                case 3: {
                    if (this.type == 7 || this.type == 5) {
                        this.remove();
                        break;
                    }
                    this.valueModel = null;
                }
            }
        } else {
            super.update(observable, aspect);
        }
    }
}

