/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import jp.sbi.celldesigner.blockDiagram.diagram.InternalLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperationalException;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperationalModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperatorTraceStack;

public class InternalOperation {
    private static void checkInput(InternalOperationalModel iom, InternalOperatorTraceStack parent, boolean checkInputSize) throws InternalOperationalException {
        if (parent != null && parent.contains(iom)) {
            throw new InternalOperationalException("internal operation loop detected.:iom=" + iom);
        }
        if (checkInputSize && iom.getInputLinkSet().size() <= 0) {
            throw new InternalOperationalException("undefined value because of no input.: iom=" + iom);
        }
    }

    private static double getOperatedValueAdd(double initialValue, InternalOperationalModel iom, InternalOperatorTraceStack parent, boolean checkInputSize) throws InternalOperationalException {
        InternalOperation.checkInput(iom, parent, checkInputSize);
        InternalOperatorTraceStack st = new InternalOperatorTraceStack(parent, iom);
        double activationValue = initialValue;
        boolean inhibited = false;
        block3: for (InternalLinkModel ilm : iom.getInputLinkSet()) {
            double value1 = ilm.getOperatedValue(st);
            switch (ilm.getType()) {
                case 1: 
                case 2: {
                    activationValue += value1;
                    break;
                }
                default: {
                    if (!(value1 > 0.0)) continue block3;
                    inhibited = true;
                }
            }
        }
        if (inhibited) {
            return 0.0;
        }
        if (Double.isNaN(activationValue) || activationValue > 0.0) {
            return activationValue;
        }
        return 0.0;
    }

    public static double getOperatedValueAdd(InternalOperationalModel iom, InternalOperatorTraceStack parent) throws InternalOperationalException {
        boolean checkInputSize = true;
        return InternalOperation.getOperatedValueAdd(0.0, iom, parent, checkInputSize);
    }

    public static double getOperatedValueAddWithInitialValue(InternalOperationalModel iom, InternalOperatorTraceStack parent, double initialValue) throws InternalOperationalException {
        boolean checkInputSize = false;
        return InternalOperation.getOperatedValueAdd(initialValue, iom, parent, checkInputSize);
    }

    public static double getOperatedValueOr(InternalOperationalModel iom, InternalOperatorTraceStack parent, double valueForOutput) throws InternalOperationalException {
        double value = InternalOperation.getOperatedValueAdd(iom, parent);
        if (value > 0.0) {
            return valueForOutput;
        }
        if (Double.isNaN(value)) {
            return value;
        }
        return 0.0;
    }

    public static double getOperatedValueOrWithInitialValue(InternalOperationalModel iom, InternalOperatorTraceStack parent, double initialValue, double valueForOutput) throws InternalOperationalException {
        boolean checkInputSize = false;
        double value = InternalOperation.getOperatedValueAdd(initialValue, iom, parent, checkInputSize);
        if (value > 0.0) {
            return valueForOutput;
        }
        if (Double.isNaN(value)) {
            return value;
        }
        return 0.0;
    }

    public static double getOperatedValueMultiply(InternalOperationalModel iom, InternalOperatorTraceStack parent) throws InternalOperationalException {
        boolean checkInputSize = true;
        InternalOperation.checkInput(iom, parent, checkInputSize);
        InternalOperatorTraceStack st = new InternalOperatorTraceStack(parent, iom);
        double activationValue = 1.0;
        boolean inhibited = false;
        block3: for (InternalLinkModel ilm : iom.getInputLinkSet()) {
            double value1 = ilm.getOperatedValue(st);
            switch (ilm.getType()) {
                case 1: 
                case 2: {
                    activationValue *= value1;
                    break;
                }
                default: {
                    if (!(value1 > 0.0)) continue block3;
                    inhibited = true;
                }
            }
        }
        if (inhibited) {
            return 0.0;
        }
        if (Double.isNaN(activationValue) || activationValue > 0.0) {
            return activationValue;
        }
        return 0.0;
    }

    public static double getOperatedValueAnd(InternalOperationalModel iom, InternalOperatorTraceStack parent, double valueForOutput) throws InternalOperationalException {
        double value = InternalOperation.getOperatedValueMultiply(iom, parent);
        if (value > 0.0) {
            return valueForOutput;
        }
        if (Double.isNaN(value)) {
            return value;
        }
        return 0.0;
    }
}

