/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalLinkVC;

public class InternalLinkVCInhibition
extends InternalLinkVC {
    private static final double HEADSIZE = 4.0;

    @Override
    protected Class getExpectedModelClass() {
        return InternalLinkModel.class;
    }

    @Override
    protected int getLinkageGap() {
        return 5;
    }

    @Override
    protected void drawArrowHead(Graphics2D g2, double x0, double y0, double x1, double y1) {
        double[] xy = InternalLinkVCInhibition.getInhibitHeadShapeCoords(x0, y0, x1, y1);
        if (xy == null) {
            return;
        }
        GeneralPath gp = new GeneralPath();
        gp.moveTo((float)(x1 + xy[0]), (float)(y1 + xy[1]));
        gp.lineTo((float)(x1 + xy[2]), (float)(y1 + xy[3]));
        g2.draw(gp);
    }

    public static double[] getInhibitHeadShapeCoords(double x0, double y0, double x1, double y1) {
        double angle;
        double eps = 1.0E-6;
        double dx = x1 - x0;
        double dy = y1 - y0;
        if (Math.abs(dx) < 1.0E-6 && Math.abs(dy) < 1.0E-6) {
            return null;
        }
        if (dx == 0.0 && dy == 0.0) {
            return null;
        }
        double angle2 = angle = -Math.atan2(dx, dy);
        double angle3 = angle - Math.PI;
        double[] xy = new double[]{Math.cos(angle2) * 4.0, Math.sin(angle2) * 4.0, Math.cos(angle3) * 4.0, Math.sin(angle3) * 4.0};
        return xy;
    }
}

