/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jp.co.fujiric.star.gui.gef.swing.CanvasModelImpl;
import jp.co.fujiric.star.gui.gef.swing.LinkModelImpl;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperation;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperationalException;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperationalModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperatorTraceStack;

public class InternalLinkModel
extends LinkModelImpl
implements InternalOperationalModel {
    private static final String STR_ACTIVATION = "activation";
    private static final String STR_ABSOLUTE_ACTIVATION = "absoluteActivation";
    private static final String STR_INHIBITION = "inhibition";
    private static final String STR_ABSOLUTE_INHIBITION = "absoluteInhibition";
    public static final int ACTIVATION = 1;
    public static final int ABSOLUTE_ACTIVATION = 2;
    public static final int INHIBITION = 3;
    public static final int ABSOLUTE_INHIBITION = 4;
    protected InternalOperationalModel fromModel;
    protected InternalOperationalModel toModel;
    private int type;
    private Set outputLinkSet = new HashSet();
    private Set inputLinkSet = new HashSet();

    @Override
    public void addOutputLink(InternalLinkModel linkm) {
        this.outputLinkSet.add(linkm);
    }

    @Override
    public void removeOutputLink(InternalLinkModel linkm) {
        this.outputLinkSet.remove(linkm);
    }

    @Override
    public void addInputLink(InternalLinkModel linkm) {
        this.inputLinkSet.add(linkm);
    }

    @Override
    public void removeInputLink(InternalLinkModel linkm) {
        this.inputLinkSet.remove(linkm);
    }

    @Override
    public Set getInputLinkSet() {
        return Collections.unmodifiableSet(this.inputLinkSet);
    }

    @Override
    public Set getOutputLinkSet() {
        return Collections.unmodifiableSet(this.outputLinkSet);
    }

    public static void checkType(int type) {
        if (type != 1 && type != 2 && type != 3 && type != 4) {
            throw new IllegalArgumentException("unknown type:" + type);
        }
    }

    public String getTypeString() {
        switch (this.type) {
            case 1: {
                return STR_ACTIVATION;
            }
            case 2: {
                return STR_ABSOLUTE_ACTIVATION;
            }
            case 3: {
                return STR_INHIBITION;
            }
        }
        return STR_ABSOLUTE_INHIBITION;
    }

    public static int getTypeFromString(String str) {
        if (str.equals(STR_ACTIVATION)) {
            return 1;
        }
        if (str.equals(STR_ABSOLUTE_ACTIVATION)) {
            return 2;
        }
        if (str.equals(STR_INHIBITION)) {
            return 3;
        }
        if (str.equals(STR_ABSOLUTE_INHIBITION)) {
            return 4;
        }
        throw new IllegalArgumentException("unknown type:" + str);
    }

    public static String getTypeFromInt(int str) {
        if (str == 1) {
            return STR_ACTIVATION;
        }
        if (str == 2) {
            return STR_ABSOLUTE_ACTIVATION;
        }
        if (str == 3) {
            return STR_INHIBITION;
        }
        if (str == 4) {
            return STR_ABSOLUTE_INHIBITION;
        }
        throw new IllegalArgumentException("unknown type:" + str);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        InternalLinkModel.checkType(type);
        this.type = type;
    }

    public InternalOperationalModel getFromModel() {
        return this.fromModel;
    }

    public InternalOperationalModel getToModel() {
        return this.toModel;
    }

    public void setFromModel(InternalOperationalModel model) {
        this.fromModel = model;
    }

    public void setToModel(InternalOperationalModel model) {
        this.toModel = model;
    }

    @Override
    protected void removeInParent() {
        if (this.fromModel != null) {
            this.fromModel.removeOutputLink(this);
        }
        if (this.toModel != null) {
            this.toModel.removeInputLink(this);
        }
        super.removeInParent();
    }

    @Override
    public double getOperatedValue(InternalOperatorTraceStack parent) throws InternalOperationalException {
        InternalOperatorTraceStack st = new InternalOperatorTraceStack(parent, this);
        double value = this.fromModel.getOperatedValue(st);
        return InternalOperation.getOperatedValueAddWithInitialValue(this, parent, value);
    }

    @Override
    public void move(int dx, int dy, int aspect) {
        super.move(dx, dy, aspect);
        if (!this.forDrag) {
            ((CanvasModel)this.canvas).setEdited();
        }
    }

    @Override
    public void initialize(CanvasModelImpl canvas, int x, int y, int w, int h, boolean forDrag) {
        super.initialize(canvas, x, y, w, h, forDrag);
        if (!this.forDrag) {
            ((CanvasModel)this.canvas).setEdited();
        }
    }

    @Override
    public void remove() {
        if (!this.forDrag) {
            ((CanvasModel)this.canvas).setEdited();
        }
        super.remove();
    }

    @Override
    public void resizeByHandle(int type, int dx, int dy) {
        super.resizeByHandle(type, dx, dy);
        if (!this.forDrag) {
            ((CanvasModel)this.canvas).setEdited();
        }
    }
}

