/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import jp.co.fujiric.star.gui.gef.swing.DxDy;
import jp.co.fujiric.star.gui.gef.swing.ShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.SimpleMoverImpl;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockModel;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloModel;

public class HaloBlockMover
extends SimpleMoverImpl {
    private int handleIndex;
    private HaloModel haloModel;
    private BlockModel blockModel;
    private boolean forBlock;
    protected static final int MARGIN_LEFT = 12;
    protected static final int MARGIN_RIGHT = 12;
    protected static final int MARGIN_TOP = 12;
    protected static final int MARGIN_BOTTOM = 12;

    public HaloBlockMover(boolean forBlock, HaloModel haloModel, BlockModel blockModel, int handleIndex) {
        this.forBlock = forBlock;
        this.haloModel = haloModel;
        this.blockModel = blockModel;
        this.handleIndex = handleIndex;
    }

    @Override
    public void restrictDxDyForDrag(ShapeVCImpl vc, DxDy dxdy) {
        int haloy;
        int blocky;
        int halox;
        int blockx;
        if (this.handleIndex < 0 && this.haloModel.isSelected() && this.blockModel.isSelected()) {
            return;
        }
        int rel = this.forBlock ? 1 : -1;
        int dx = dxdy.dx * rel;
        int dy = dxdy.dy * rel;
        if (dx < 0 && (this.handleIndex < 0 || this.handleIndex == 0 || this.handleIndex == 3)) {
            blockx = this.blockModel.getX() + dx;
            if (blockx <= (halox = this.haloModel.getX()) + 12) {
                blockx = halox + 1 + 12;
                dxdy.dx = (blockx - this.blockModel.getX()) * rel;
            }
        } else if (dx > 0 && (this.handleIndex < 0 || this.handleIndex == 2 || this.handleIndex == 1) && (blockx = this.blockModel.getX() + this.blockModel.getWidth() + dx) >= (halox = this.haloModel.getX() + this.haloModel.getWidth()) - 12) {
            blockx = halox - 1 - 12;
            dxdy.dx = (blockx - (this.blockModel.getX() + this.blockModel.getWidth())) * rel;
        }
        if (dy < 0 && (this.handleIndex < 0 || this.handleIndex == 0 || this.handleIndex == 2)) {
            blocky = this.blockModel.getY() + dy;
            if (blocky <= (haloy = this.haloModel.getY()) + 12) {
                blocky = haloy + 1 + 12;
                dxdy.dy = (blocky - this.blockModel.getY()) * rel;
            }
        } else if (dy > 0 && (this.handleIndex < 0 || this.handleIndex == 3 || this.handleIndex == 1) && (blocky = this.blockModel.getY() + this.blockModel.getHeight() + dy) >= (haloy = this.haloModel.getY() + this.haloModel.getHeight()) - 12) {
            blocky = haloy - 1 - 12;
            dxdy.dy = (blocky - (this.blockModel.getY() + this.blockModel.getHeight())) * rel;
        }
    }
}

